/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.tomcat.logging.LogDaemon;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.util.Queue;

public class TomcatLogger
extends Logger {
    static LogDaemon logDaemon = null;
    static Queue logQueue = null;

    public TomcatLogger() {
        if (logDaemon == null || logQueue == null) {
            logQueue = new Queue();
            logDaemon = new LogDaemon(logQueue);
            logDaemon.start();
        }
    }

    protected void realLog(String string) {
        logQueue.put(new LogEntry(string, null));
    }

    protected void realLog(String string, Throwable throwable) {
        logQueue.put(new LogEntry(string, throwable));
    }

    public void flush() {
        logDaemon.flush();
    }

    class LogEntry {
        String logName;
        long date;
        String message;
        Throwable t;

        LogEntry(String string, Throwable throwable) {
            if (TomcatLogger.this.timeStamp) {
                this.date = System.currentTimeMillis();
            }
            this.message = string;
            this.t = throwable;
        }

        Writer getWriter() {
            return TomcatLogger.this.sink;
        }

        private String _$43292(Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (throwable != null) {
                throwable.printStackTrace(printWriter);
            }
            return stringWriter.toString();
        }

        public String toString() {
            if (TomcatLogger.this.custom) {
                return this.t == null ? this.message : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.message))).append(" ").append(this._$43292(this.t))));
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.print(String.valueOf(String.valueOf(new StringBuffer("<").append(TomcatLogger.this.getName()).append("> "))));
            if (TomcatLogger.this.timeStamp) {
                printWriter.print(new Date(this.date).toString());
            }
            printWriter.print(' ');
            if (this.message != null) {
                printWriter.print(this.message);
            }
            if (this.t != null) {
                this.t.printStackTrace(printWriter);
            }
            printWriter.println(String.valueOf(String.valueOf(new StringBuffer("</").append(TomcatLogger.this.getName()).append("> "))));
            return stringWriter.toString();
        }
    }
}

