/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Logger {
    public static final int FATAL = Integer.MIN_VALUE;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int INFORMATION = 3;
    public static final int DEBUG = 4;
    protected boolean custom;
    protected Writer sink = defaultSink;
    String path;
    protected String name;
    protected static Writer defaultSink = new PrintWriter(System.err);
    protected static Hashtable loggers = new Hashtable(5);
    private int _$165804 = 2;
    protected boolean timeStamp = true;

    public boolean isOpen() {
        return this.sink != null;
    }

    public static void log(String string, String string2, int n) {
        Logger logger = Logger.getLogger(string);
        if (logger != null) {
            logger.log(string2, n);
        }
    }

    public static void log(String string, String string2) {
        Logger logger = Logger.getLogger(string);
        if (logger != null) {
            logger.log(string2);
        }
    }

    public final void log(String string, int n) {
        if (this.matchVerbosityLevel(n)) {
            this.realLog(string);
        }
    }

    public final void log(String string) {
        this.log(string, 3);
    }

    public final void log(String string, Throwable throwable, int n) {
        if (this.matchVerbosityLevel(n)) {
            this.realLog(string, throwable);
        }
    }

    public boolean matchVerbosityLevel(int n) {
        return n <= this.getVerbosityLevel();
    }

    protected abstract void realLog(String var1);

    protected abstract void realLog(String var1, Throwable var2);

    public abstract void flush();

    public synchronized void close() {
        this.sink = null;
        loggers.remove(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        Logger.putLogger(this);
    }

    public void setPath(String string) {
        if (File.separatorChar == '/') {
            this.path = string.replace('\\', '/');
        } else if (File.separatorChar == '\\') {
            this.path = string.replace('/', '\\');
        }
    }

    public String getPath() {
        return this.path;
    }

    public void open() {
        if (this.path == null) {
            return;
        }
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                new File(file.getParent()).mkdirs();
            }
            this.sink = new FileWriter(this.path);
        }
        catch (IOException iOException) {
            System.err.print(String.valueOf(String.valueOf(new StringBuffer("Unable to open log file: ").append(this.path).append("! "))));
            System.err.println(" Using stderr as the default.");
            this.sink = defaultSink;
        }
    }

    public void setVerbosityLevel(String string) {
        if ("warning".equalsIgnoreCase(string)) {
            this._$165804 = 2;
        } else if ("fatal".equalsIgnoreCase(string)) {
            this._$165804 = Integer.MIN_VALUE;
        } else if ("error".equalsIgnoreCase(string)) {
            this._$165804 = 1;
        } else if ("information".equalsIgnoreCase(string)) {
            this._$165804 = 3;
        } else if ("debug".equalsIgnoreCase(string)) {
            this._$165804 = 4;
        }
    }

    public void setVerbosityLevel(int n) {
        this._$165804 = n;
    }

    public int getVerbosityLevel() {
        return this._$165804;
    }

    public void setTimestamp(String string) {
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            this.timeStamp = true;
        } else if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            this.timeStamp = false;
        }
    }

    public boolean isTimestamp() {
        return this.timeStamp;
    }

    public static void setDefaultSink(Writer writer) {
        defaultSink = writer;
    }

    public static Logger getLogger(String string) {
        return (Logger)loggers.get(string);
    }

    public static Enumeration getLoggerNames() {
        return loggers.keys();
    }

    public static void putLogger(Logger logger) {
        loggers.put(logger.getName(), logger);
    }

    public static void removeLogger(Logger logger) {
        loggers.remove(logger.getName());
    }

    public void setCustomOutput(String string) {
        if ("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string)) {
            this.custom = true;
        } else if ("false".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string)) {
            this.custom = false;
        }
    }
}

