/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.Iterator;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDropTargetProtocol;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XPropertyEvent;

final class XDropTargetEventProcessor {
    private static final XDropTargetEventProcessor theInstance = new XDropTargetEventProcessor();
    private static boolean active = false;
    private XDropTargetProtocol protocol = null;

    private XDropTargetEventProcessor() {
    }

    private boolean doProcessEvent(IXAnyEvent iXAnyEvent) {
        XPropertyEvent xPropertyEvent;
        if (iXAnyEvent.get_type() == 17 && this.protocol != null && iXAnyEvent.get_window() == this.protocol.getSourceWindow()) {
            this.protocol.cleanup();
            this.protocol = null;
            return false;
        }
        if (iXAnyEvent.get_type() == 28 && (xPropertyEvent = (XPropertyEvent)iXAnyEvent).get_atom() == MotifDnDConstants.XA_MOTIF_DRAG_RECEIVER_INFO.getAtom()) {
            XDropTargetRegistry.getRegistry().updateEmbedderDropSite(xPropertyEvent.get_window());
        }
        if (iXAnyEvent.get_type() != 33) {
            return false;
        }
        boolean bl = false;
        XClientMessageEvent xClientMessageEvent = (XClientMessageEvent)iXAnyEvent;
        XDropTargetProtocol xDropTargetProtocol = this.protocol;
        if (this.protocol != null) {
            if (this.protocol.getMessageType(xClientMessageEvent) != 0) {
                bl = this.protocol.processClientMessage(xClientMessageEvent);
            } else {
                this.protocol = null;
            }
        }
        if (this.protocol == null) {
            Iterator iterator = XDragAndDropProtocols.getDropTargetProtocols();
            while (iterator.hasNext()) {
                XDropTargetProtocol xDropTargetProtocol2 = (XDropTargetProtocol)iterator.next();
                if (xDropTargetProtocol2 == xDropTargetProtocol || xDropTargetProtocol2.getMessageType(xClientMessageEvent) == 0) continue;
                this.protocol = xDropTargetProtocol2;
                bl = this.protocol.processClientMessage(xClientMessageEvent);
                break;
            }
        }
        return bl;
    }

    static void reset() {
        XDropTargetEventProcessor.theInstance.protocol = null;
    }

    static void activate() {
        active = true;
    }

    static boolean processEvent(IXAnyEvent iXAnyEvent) {
        return active ? theInstance.doProcessEvent(iXAnyEvent) : false;
    }
}

