/*
 * Decompiled with CFR 0.152.
 */
package stec.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;

public class XmlWriter {
    private static final String VERSION = "1.0";
    private static final String ENCODING = "utf-8";
    private Writer writer;
    private int indent = 0;
    private boolean start_element;
    Stack elements = new Stack();
    public String indent_string = null;

    public XmlWriter(String path) throws IOException {
        this(new FileOutputStream(path));
    }

    public XmlWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public XmlWriter(OutputStream os) {
        this(new OutputStreamWriter(os));
    }

    public XmlWriter(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeHeader() throws IOException {
        this.writeHeader(null, null, true);
    }

    public void writeHeader(boolean standalone_document) throws IOException {
        this.writeHeader(null, null, standalone_document);
    }

    public void writeHeader(String version, String encoding, boolean standalone_document) throws IOException {
        if (this.elements.size() > 0) {
            throw new IllegalStateException();
        }
        if (version == null) {
            version = VERSION;
        } else if (version.trim().length() == 0) {
            version = VERSION;
        }
        if (encoding == null) {
            encoding = ENCODING;
        } else if (encoding.trim().length() == 0) {
            encoding = ENCODING;
        }
        this.writer.write("<?xml version=\"");
        this.writer.write(this.encode(version));
        this.writer.write("\" encoding=\"");
        this.writer.write(this.encode(encoding));
        this.writer.write("\" standalone=\"");
        this.writer.write(standalone_document ? "yes" : "no");
        this.writer.write("\"?>\n");
    }

    public void writeDoctype(String name, String public_id, String system_id) throws IOException {
        if (this.elements.size() > 0) {
            throw new IllegalStateException();
        }
        this.writer.write("<!DOCTYPE ");
        this.writer.write(this.encode(name));
        this.writer.write(" PUBLIC \"");
        this.writer.write(this.encode(public_id));
        this.writer.write("\" \"");
        this.writer.write(this.encode(system_id));
        this.writer.write("\">\n");
    }

    public void writeComment(String comment) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write("<!--");
        this.writer.write(this.encode(comment));
        this.writer.write("-->\n");
    }

    public void writeStartElement(String name) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        ++this.indent;
        name = this.encode(name);
        this.writer.write("<");
        this.writer.write(name);
        this.start_element = true;
        this.elements.push(name);
    }

    public void writeEndElement() throws IOException {
        this.completeStartElementProcessing();
        if (this.elements.size() == 0) {
            throw new IllegalStateException();
        }
        --this.indent;
        this.indent();
        this.writer.write("</");
        this.writer.write((String)this.elements.pop());
        this.writer.write(">\n");
    }

    public void writeAttribute(String name, String value) throws IOException {
        this.writer.write(" \"");
        this.writer.write(this.encode(name));
        this.writer.write("\"=\"");
        this.writer.write(this.encode(value));
        this.writer.write("\"\n");
    }

    public void writeProperty(String name, String value) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        name = this.encode(name);
        this.writer.write("<");
        this.writer.write(name);
        this.writer.write(">");
        this.writer.write(this.encode(value));
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(">\n");
    }

    public void writeCData(String string) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write("<![CDATA[");
        this.writer.write(string);
        this.writer.write("]]>");
    }

    public void writeString(String string) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(this.encode(string));
    }

    public void writeChars(char[] chars, int offset, int length) throws IOException {
        this.writeString(new String(chars, offset, length));
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.writeString(new String(bytes, offset, length));
    }

    public void writeByte(byte byt) throws IOException {
        this.writeString(String.valueOf((char)byt));
    }

    public void writeChar(char chr) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(this.encode(String.valueOf(chr)));
    }

    public void writeRawString(String string) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(this.encode(string));
    }

    public void writeRawChars(char[] chars, int offset, int length) throws IOException {
        this.writeRawString(new String(chars, offset, length));
    }

    public void writeRawBytes(byte[] bytes, int offset, int length) throws IOException {
        this.writeRawString(new String(bytes, offset, length));
    }

    public void writeRawByte(byte byt) throws IOException {
        this.writeRawString(String.valueOf((char)byt));
    }

    public void writeRawChar(char chr) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(String.valueOf(chr));
    }

    public void writeShort(short s) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(String.valueOf(s));
    }

    public void writeInt(int i) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(String.valueOf(i));
    }

    public void writeLong(long l) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(String.valueOf(l));
    }

    public void writeFloat(float f) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(String.valueOf(f));
    }

    public void writeDouble(double d) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(String.valueOf(d));
    }

    public void writeLine(String line) throws IOException {
        this.writeString(line);
        this.writer.write(10);
    }

    public void writeRawLine(String line) throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(line);
        this.writer.write(10);
    }

    public void writeLine() throws IOException {
        this.completeStartElementProcessing();
        this.indent();
        this.writer.write(10);
    }

    private final void indent() throws IOException {
        if (this.indent_string != null && this.indent_string.length() > 0) {
            int i = 0;
            while (i < this.indent) {
                this.writer.write(this.indent_string);
                ++i;
            }
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private String encode(String string) {
        StringBuffer sb = new StringBuffer();
        int length = string.length();
        int i = 0;
        while (i < length) {
            char chr = string.charAt(i);
            switch (chr) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    sb.append(chr);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private final void completeStartElementProcessing() throws IOException {
        if (this.start_element) {
            this.writer.write(">\n");
            this.start_element = false;
        }
    }
}

