/*
 * Decompiled with CFR 0.152.
 */
package stec.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LinkedList
implements Cloneable,
Serializable {
    private static final int MASK = Integer.MAX_VALUE;
    private static final int INITIAL_CAPACITY = 11;
    private static final float LOAD_FACTOR = 0.75f;
    private transient Entry[] hm_table;
    private transient Entry ll_header;
    private transient int size = 0;
    private int threshold;

    public LinkedList() {
        this.ll_header.ll_next = this.ll_header.ll_previous = (this.ll_header = new Entry(null, null, null));
        this.hm_table = new Entry[11];
        this.threshold = 8;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("LinkedList is empty.");
        }
        return this.ll_header.ll_next.item;
    }

    public Object getLast() throws NoSuchElementException {
        if (this.size == 0) {
            throw new NoSuchElementException("LinkedList is empty.");
        }
        return this.ll_header.ll_previous.item;
    }

    private final void hm_rehash() {
        int ocapacity = this.hm_table.length;
        Entry[] otable = this.hm_table;
        int ncapacity = ocapacity * 2 + 1;
        Entry[] ntable = new Entry[ncapacity];
        this.threshold = (int)((float)ncapacity * 0.75f);
        this.hm_table = ntable;
        int i = ocapacity - 1;
        while (i >= 0) {
            Entry oentry = otable[i];
            while (oentry != null) {
                Entry entry = oentry;
                oentry = oentry.hm_next;
                int index = (entry.hash & Integer.MAX_VALUE) % ncapacity;
                entry.hm_next = ntable[index];
                ntable[index] = entry;
            }
            --i;
        }
    }

    private final Object hm_get(Object item) {
        int hash = item.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.hm_table.length;
        Entry entry = this.hm_table[index];
        while (entry != null) {
            if (entry.hash == hash && item.equals(entry.item)) {
                return entry;
            }
            entry = entry.hm_next;
        }
        return null;
    }

    private final void hm_put(Object item, Entry entry) {
        int hash = 0;
        int index = 0;
        hash = item.hashCode();
        index = (hash & Integer.MAX_VALUE) % this.hm_table.length;
        Entry tentry = this.hm_table[index];
        while (tentry != null) {
            if (tentry.hash == hash && item.equals(tentry.item)) {
                return;
            }
            tentry = tentry.hm_next;
        }
        if (this.size >= this.threshold) {
            this.hm_rehash();
            index = (hash & Integer.MAX_VALUE) % this.hm_table.length;
        }
        entry.hash = hash;
        entry.hm_next = this.hm_table[index];
        this.hm_table[index] = entry;
    }

    private final void hm_remove(Object item) {
        int hash = item.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.hm_table.length;
        Entry oentry = null;
        Entry entry = this.hm_table[index];
        while (entry != null) {
            if (entry.hash == hash && item.equals(entry.item)) {
                if (oentry != null) {
                    oentry.hm_next = entry.hm_next;
                } else {
                    this.hm_table[index] = entry.hm_next;
                }
            }
            oentry = entry;
            entry = entry.hm_next;
        }
    }

    private final void remove(Entry entry) throws NoSuchElementException {
        if (entry == this.ll_header) {
            throw new NoSuchElementException("LinkedList is empty.");
        }
        entry.ll_previous.ll_next = entry.ll_next;
        entry.ll_next.ll_previous = entry.ll_previous;
        this.hm_remove(entry.item);
        --this.size;
    }

    public Object removeFirst() throws NoSuchElementException {
        Object item = this.ll_header.ll_next.item;
        this.remove(this.ll_header.ll_next);
        return item;
    }

    public Object removeLast() throws NoSuchElementException {
        Object item = this.ll_header.ll_previous.item;
        this.remove(this.ll_header.ll_previous);
        return item;
    }

    private final Entry addBefore(Object item, Entry entry) throws IllegalArgumentException {
        Entry tentry;
        this.check(item);
        tentry.ll_previous.ll_next = tentry = new Entry(item, entry, entry.ll_previous);
        tentry.ll_next.ll_previous = tentry;
        this.hm_put(item, tentry);
        ++this.size;
        return tentry;
    }

    public void addFirst(Object item) throws IllegalArgumentException {
        this.addBefore(item, this.ll_header.ll_next);
    }

    public void addLast(Object item) throws IllegalArgumentException {
        this.addBefore(item, this.ll_header);
    }

    public boolean contains(Object item) throws IllegalArgumentException {
        this.check(item);
        int hash = item.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.hm_table.length;
        Entry entry = this.hm_table[index];
        while (entry != null) {
            if (entry.hash == hash && item.equals(entry.item)) {
                return true;
            }
            entry = entry.hm_next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(Object item) throws IllegalArgumentException {
        this.addBefore(item, this.ll_header);
    }

    public boolean remove(Object item) throws IllegalArgumentException {
        this.check(item);
        Object obj = this.hm_get(item);
        if (obj == null) {
            return false;
        }
        this.remove((Entry)obj);
        return true;
    }

    public void clear() {
        this.ll_header.ll_next = this.ll_header.ll_previous = this.ll_header;
        this.size = 0;
        int index = this.hm_table.length - 1;
        while (index >= 0) {
            this.hm_table[index] = null;
            --index;
        }
    }

    public Object get(int index) throws IndexOutOfBoundsException {
        return this._get((int)index).item;
    }

    private final Entry _get(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
        }
        Entry entry = this.ll_header;
        if (index < this.size / 2) {
            int i = 0;
            while (i <= index) {
                entry = entry.ll_next;
                ++i;
            }
        } else {
            int i = this.size;
            while (i > index) {
                entry = entry.ll_previous;
                --i;
            }
        }
        return entry;
    }

    public Object set(int index, Object item) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.check(item);
        Entry entry = this._get(index);
        this.hm_remove(entry.item);
        Object titem = entry.item;
        entry.item = item;
        this.hm_put(item, entry);
        return titem;
    }

    public void add(int index, Object item) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.addBefore(item, index == this.size ? this.ll_header : this._get(index));
    }

    public Object remove(int index) throws IndexOutOfBoundsException {
        Entry entry = this._get(index);
        this.remove(entry);
        return entry.item;
    }

    public int indexOf(Object item) throws IllegalArgumentException {
        this.check(item);
        int index = 0;
        if (item == null) {
            Entry entry = this.ll_header.ll_next;
            while (entry != this.ll_header) {
                if (entry.item == null) {
                    return index;
                }
                ++index;
                entry = entry.ll_next;
            }
        } else {
            Entry entry = this.ll_header.ll_next;
            while (entry != this.ll_header) {
                if (item.equals(entry.item)) {
                    return index;
                }
                ++index;
                entry = entry.ll_next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object item) throws IllegalArgumentException {
        this.check(item);
        int index = this.size;
        if (item == null) {
            Entry entry = this.ll_header.ll_previous;
            while (entry != this.ll_header) {
                --index;
                if (entry.item == null) {
                    return index;
                }
                entry = entry.ll_previous;
            }
        } else {
            Entry entry = this.ll_header.ll_previous;
            while (entry != this.ll_header) {
                --index;
                if (item.equals(entry.item)) {
                    return index;
                }
                entry = entry.ll_previous;
            }
        }
        return -1;
    }

    public Object clone() {
        LinkedList tlist = new LinkedList();
        Entry entry = this.ll_header.ll_next;
        while (entry != this.ll_header) {
            tlist.add(entry.item);
            entry = entry.ll_next;
        }
        return tlist;
    }

    public Object[] toArray() {
        Object[] items = new Object[this.size];
        int i = 0;
        Entry entry = this.ll_header.ll_next;
        while (entry != this.ll_header) {
            items[i++] = entry.item;
            entry = entry.ll_next;
        }
        return items;
    }

    public Object[] toArray(Object[] objects) {
        int length;
        if (objects == null) {
            objects = new Object[this.size];
            length = this.size;
        } else {
            length = objects.length;
            if (length < this.size) {
                objects = new Object[this.size];
                length = this.size;
            }
        }
        int i = 0;
        Entry entry = this.ll_header.ll_next;
        while (entry != this.ll_header) {
            objects[i++] = entry.item;
            entry = entry.ll_next;
        }
        while (i < length) {
            objects[i] = null;
            ++i;
        }
        return objects;
    }

    public boolean moveFirst(Object item) throws IllegalArgumentException {
        this.check(item);
        Object obj = this.hm_get(item);
        if (obj == null) {
            return false;
        }
        Entry entry = (Entry)obj;
        if (entry == this.ll_header) {
            return false;
        }
        entry.ll_previous.ll_next = entry.ll_next;
        entry.ll_next.ll_previous = entry.ll_previous;
        entry.ll_next = this.ll_header.ll_next;
        entry.ll_previous = this.ll_header.ll_next.ll_previous;
        entry.ll_previous.ll_next = entry;
        entry.ll_next.ll_previous = entry;
        return true;
    }

    public boolean moveLast(Object item) throws IllegalArgumentException {
        this.check(item);
        Object obj = this.hm_get(item);
        if (obj == null) {
            return false;
        }
        Entry entry = (Entry)obj;
        if (entry == this.ll_header) {
            return false;
        }
        entry.ll_previous.ll_next = entry.ll_next;
        entry.ll_next.ll_previous = entry.ll_previous;
        entry.ll_next = this.ll_header;
        entry.ll_previous = this.ll_header.ll_previous;
        entry.ll_previous.ll_next = entry;
        entry.ll_next.ll_previous = entry;
        return true;
    }

    public Enumeration elements() {
        return new LinkedListEnumeration(this.ll_header);
    }

    private final void check(Object item) throws IllegalArgumentException {
        if (item == null) {
            throw new NullPointerException("Item cannot be null.");
        }
    }

    class LinkedListEnumeration
    implements Enumeration {
        Entry header;
        Entry entry;

        LinkedListEnumeration(Entry header) {
            this.header = header;
            this.entry = header.ll_next;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != this.header;
        }

        public Object nextElement() {
            if (this.entry == this.header) {
                throw new NoSuchElementException("ArrayListEnumerator");
            }
            Object item = this.entry.item;
            this.entry = this.entry.ll_next;
            return item;
        }
    }

    class Entry {
        int hash;
        Entry hm_next;
        Object item;
        Entry ll_next;
        Entry ll_previous;

        Entry(Object item, Entry ll_next, Entry ll_previous) {
            this.item = item;
            this.ll_next = ll_next;
            this.ll_previous = ll_previous;
        }
    }
}

