/*
 * Decompiled with CFR 0.152.
 */
package stec.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HashMap
implements Cloneable,
Serializable {
    private static final int MASK = Integer.MAX_VALUE;
    private transient Entry[] table;
    protected transient int count;
    private float load_factor;
    private int threshold;

    public HashMap(int initial_capacity, float load_factor) throws IllegalArgumentException {
        if (initial_capacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initial_capacity);
        }
        if (load_factor <= 0.0f || Float.isNaN(load_factor)) {
            throw new IllegalArgumentException("Illegal Load Factor: " + load_factor);
        }
        if (initial_capacity == 0) {
            initial_capacity = 1;
        }
        this.table = new Entry[initial_capacity];
        this.load_factor = load_factor;
        this.threshold = (int)((float)initial_capacity * load_factor);
    }

    public HashMap(int initial_capacity) throws IllegalArgumentException {
        this(initial_capacity, 0.75f);
    }

    public HashMap() {
        this(11, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object value) throws NullPointerException {
        this.check_value(value);
        int i = this.table.length - 1;
        while (i >= 0) {
            Entry entry = this.table[i];
            while (entry != null) {
                if (value.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
            --i;
        }
        return false;
    }

    public boolean containsKey(Object key) throws NullPointerException {
        this.check_key(key);
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && key.equals(entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(Object key) throws NullPointerException {
        this.check_key(key);
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && key.equals(entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private final void rehash() {
        int ocapacity = this.table.length;
        Entry[] otable = this.table;
        int ncapacity = ocapacity * 2 + 1;
        Entry[] ntable = new Entry[ncapacity];
        this.threshold = (int)((float)ncapacity * this.load_factor);
        this.table = ntable;
        int i = ocapacity - 1;
        while (i >= 0) {
            Entry oentry = otable[i];
            while (oentry != null) {
                Entry entry = oentry;
                oentry = oentry.next;
                int index = (entry.hash & Integer.MAX_VALUE) % ncapacity;
                entry.next = ntable[index];
                ntable[index] = entry;
            }
            --i;
        }
    }

    public Object put(Object key, Object value) throws NullPointerException {
        this.check_key(key);
        this.check_value(value);
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && key.equals(entry.key)) {
                Object ovalue = entry.value;
                entry.value = value;
                return ovalue;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            index = (hash & Integer.MAX_VALUE) % this.table.length;
        }
        this.table[index] = entry = new Entry(hash, key, value, this.table[index]);
        ++this.count;
        return null;
    }

    public Object remove(Object key) throws NullPointerException {
        this.check_key(key);
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        Entry oentry = null;
        Entry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && key.equals(entry.key)) {
                if (oentry != null) {
                    oentry.next = entry.next;
                } else {
                    this.table[index] = entry.next;
                }
                --this.count;
                Object ovalue = entry.value;
                entry.value = null;
                return ovalue;
            }
            oentry = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        int index = this.table.length - 1;
        while (index >= 0) {
            this.table[index] = null;
            --index;
        }
        this.count = 0;
    }

    public Object clone() {
        HashMap ttable = new HashMap(this.table.length, this.load_factor);
        ttable.count = this.count;
        int i = this.table.length - 1;
        while (i >= 0) {
            ttable.table[i] = this.table[i] == null ? null : (Entry)this.table[i].clone();
            --i;
        }
        return ttable;
    }

    public Enumeration keys() {
        return new HashMapEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new HashMapEnumerator(this.table, false);
    }

    private final void check_key(Object key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
    }

    private final void check_value(Object value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
    }

    class Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        protected Entry(int hash, Object key, Object value, Entry entry) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }
    }

    class HashMapEnumerator
    implements Enumeration {
        Entry[] table;
        boolean return_keys;
        int index;
        Entry entry;

        HashMapEnumerator(Entry[] table, boolean return_keys) {
            this.table = table;
            this.return_keys = return_keys;
            this.index = table.length;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasMoreElements() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.index-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
                if (this.entry == null) {
                    throw new NoSuchElementException("HashMapEnumerator");
                }
            }
            Object obj = this.return_keys ? this.entry.key : this.entry.value;
            this.entry = this.entry.next;
            return obj;
        }
    }
}

