/*
 * Decompiled with CFR 0.152.
 */
package stec.sql;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;
import stec.sql.ConnectionPool;

public final class Connection {
    protected java.sql.Connection connection;
    private ConnectionPool pool;
    protected long timeout;
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;

    protected Connection(ConnectionPool _pool, java.sql.Connection _connection) {
        this.pool = _pool;
        this.connection = _connection;
        if (this.pool.timeout > 0L) {
            this.timeout = System.currentTimeMillis() + this.pool.timeout;
        }
    }

    public final void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public final void close() throws SQLException {
        this.pool.putConnection(this);
    }

    public final void commit() throws SQLException {
        this.connection.commit();
    }

    public final Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public final String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public final boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public final boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public final String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public final void rollback() throws SQLException {
        this.connection.rollback();
    }

    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public final void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    public final void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    public final void finalize() throws SQLException {
        if (this.connection != null) {
            this.close();
        }
    }

    protected final void kill() throws SQLException {
        this.connection.close();
    }

    public final Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }
}

