/*
 * Decompiled with CFR 0.152.
 */
package stec.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import stec.lang.DString;
import stec.net.Message;

public final class Mailer {
    private static final int SMTP_PORT = 25;
    private static final String START = "220";
    private static final String HELLO = "HELO ";
    private static final String RESET = "RSET";
    private static final String FROM = "MAIL FROM: ";
    private static final String TO = "RCPT TO: ";
    private static final String DATA = "DATA";
    private static final String READY = "250";
    private static final String START_BODY = "354";
    private static final String EOD = ".";
    private static final String EOL = "\r\n";
    protected Socket s;
    protected PrintStream os;
    protected DataInputStream is;

    public Mailer(InetAddress _ip) throws IOException {
        this(_ip, 25);
    }

    public Mailer(String _ip) throws IOException {
        this(_ip, 25);
    }

    public Mailer(InetAddress _ip, int _port) throws IOException {
        this._mailer(new Socket(_ip, _port));
    }

    public Mailer(String _ip, int _port) throws IOException {
        this._mailer(new Socket(_ip, _port));
    }

    private final void _mailer(Socket socket) throws IOException {
        InetAddress here;
        this.s = socket;
        this.is = new DataInputStream(this.s.getInputStream());
        this.os = new PrintStream(this.s.getOutputStream());
        String in = this.readLine(this.is);
        if (!in.startsWith(START)) {
            throw new ProtocolException(in);
        }
        try {
            here = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            return;
        }
        String host = here.getHostName();
        this.writeln(this.os, HELLO + host, READY);
    }

    public final void send(Message _message) throws IOException, ProtocolException {
        this.writeln(this.os, FROM + _message.getFrom(), READY);
        this.writeln(this.os, TO + _message.getTo(), READY);
        String list = _message.getCC();
        if (list != null) {
            int count = DString.dcount(list, ";");
            int i = 0;
            while (i < count) {
                String toAddress = DString.extract(list, ";", i).trim();
                this.writeln(this.os, TO + toAddress, READY);
                ++i;
            }
        }
        this.writeln(this.os, DATA, START_BODY);
        _message.send(this.os);
        this.writeln(this.os, EOD, READY);
    }

    public final void close() {
        try {
            this.writeln(this.os, "QUIT", READY);
            this.s.close();
            this.s = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected final void finalize() throws Throwable {
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void writeln(PrintStream _ps, String _message, String _rc) throws IOException, ProtocolException {
        this.write(_ps, _message);
        _ps.print(EOL);
        _ps.flush();
        String in = this.readLine(this.is);
        if (!in.startsWith(_rc)) {
            throw new ProtocolException(in);
        }
    }

    private final void write(PrintStream _ps, String _message) throws ProtocolException, IOException {
        _ps.print(_message);
    }

    private final String readLine(DataInputStream is) throws IOException {
        String input = is.readLine();
        return input;
    }

    private final void debug(String msg) {
        System.out.println(msg);
    }
}

