/*
 * Decompiled with CFR 0.152.
 */
package stec.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class Codecs {
    private static final String CRLF = "\r\n";
    private static final int CRLF_LENGTH = "\r\n".length();
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final byte[] base64EncodeTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] base64DecodeTable = new byte[128];

    static {
        int length = base64EncodeTable.length;
        int i = 0;
        while (i < length) {
            Codecs.base64DecodeTable[Codecs.base64EncodeTable[i]] = (byte)i;
            ++i;
        }
    }

    public static final String base64Encode(String string) {
        return new String(Codecs.base64Encode(string.getBytes()));
    }

    public static final byte[] base64Encode(byte[] bytes) {
        int bytes_length = bytes.length;
        byte[] tbytes = new byte[(bytes_length + 2) / 3 * 4];
        int length = bytes_length - 2;
        int si = 0;
        int di = 0;
        while (si < length) {
            tbytes[di++] = base64EncodeTable[bytes[si] >>> 2 & 0x3F];
            tbytes[di++] = base64EncodeTable[bytes[si + 1] >>> 4 & 0xF | bytes[si] << 4 & 0x3F];
            tbytes[di++] = base64EncodeTable[bytes[si + 2] >>> 6 & 3 | bytes[si + 1] << 2 & 0x3F];
            tbytes[di++] = base64EncodeTable[bytes[si + 2] & 0x3F];
            si += 3;
        }
        if (si < bytes_length) {
            tbytes[di++] = base64EncodeTable[bytes[si] >>> 2 & 0x3F];
            if (si < bytes_length - 1) {
                tbytes[di++] = base64EncodeTable[bytes[si + 1] >>> 4 & 0xF | bytes[si] << 4 & 0x3F];
                tbytes[di++] = base64EncodeTable[bytes[si + 1] << 2 & 0x3F];
            } else {
                tbytes[di++] = base64EncodeTable[bytes[si] << 4 & 0x3F];
            }
        }
        length = tbytes.length;
        while (di < length) {
            tbytes[di] = 61;
            ++di;
        }
        return tbytes;
    }

    public static final String base64Decode(String string) {
        return new String(Codecs.base64Decode(string.getBytes()));
    }

    public static final byte[] base64Decode(byte[] bytes) {
        int bytes_length;
        int tail = bytes_length = bytes.length;
        while (bytes[tail - 1] == 61) {
            --tail;
        }
        byte[] tbytes = new byte[tail - bytes_length / 4];
        int id = 0;
        while (id < bytes_length) {
            bytes[id] = base64DecodeTable[bytes[id]];
            ++id;
        }
        int length = tbytes.length - 2;
        int si = 0;
        int di = 0;
        while (di < length) {
            tbytes[di] = (byte)(bytes[si] << 2 & 0xFF | bytes[si + 1] >>> 4 & 3);
            tbytes[di + 1] = (byte)(bytes[si + 1] << 4 & 0xFF | bytes[si + 2] >>> 2 & 0xF);
            tbytes[di + 2] = (byte)(bytes[si + 2] << 6 & 0xFF | bytes[si + 3] & 0x3F);
            si += 4;
            di += 3;
        }
        length = tbytes.length;
        if (di < length) {
            tbytes[di] = (byte)(bytes[si] << 2 & 0xFF | bytes[si + 1] >>> 4 & 3);
        }
        if (++di < length) {
            tbytes[di] = (byte)(bytes[si + 1] << 4 & 0xFF | bytes[si + 2] >>> 2 & 0xF);
        }
        return tbytes;
    }

    public static final String UUEncode(String string) throws IOException {
        byte[] bytes = Codecs.UUEncode(string.getBytes());
        return new String(bytes, 0, bytes.length);
    }

    public static final byte[] UUEncode(byte[] bytes) throws IOException {
        int ch;
        int n;
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, 0, bytes.length);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[45];
        while ((n = is.read(buffer)) != -1) {
            int n2 = ch = n != 0 ? (n & 0x3F) + 32 : 96;
            if (ch == -1) break;
            os.write((byte)ch);
            int i = 0;
            while (n > 0) {
                ch = buffer[i] >> 2;
                int n3 = ch = n != 0 ? (ch & 0x3F) + 32 : 96;
                if (ch == -1) break;
                os.write((byte)ch);
                ch = buffer[i] << 4 & 0x30 | buffer[i + 1] >> 4 & 0xF;
                int n4 = ch = n != 0 ? (ch & 0x3F) + 32 : 96;
                if (ch == -1) break;
                os.write((byte)ch);
                ch = buffer[i + 1] << 2 & 0x3C | buffer[i + 2] >> 6 & 3;
                int n5 = ch = n != 0 ? (ch & 0x3F) + 32 : 96;
                if (ch == -1) break;
                os.write((byte)ch);
                ch = buffer[i + 2] & 0x3F;
                int n6 = ch = n != 0 ? (ch & 0x3F) + 32 : 96;
                if (ch == -1) break;
                os.write((byte)ch);
                n -= 3;
                i += 3;
            }
            os.write(10);
        }
        ch = 0;
        ch = n != 0 ? (ch & 0x3F) + 32 : 96;
        os.write((byte)ch);
        os.write(10);
        return os.toByteArray();
    }

    public static final String UUDecode(String string) {
        return new String(Codecs.UUDecode(string.getBytes()));
    }

    public static final byte[] UUDecode(byte[] bytes) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int length = bytes.length;
        int i = 0;
        while (i < length) {
            int n = bytes[i] - 32 & 0x3F;
            if (n <= 0) break;
            ++i;
            while (n > 0) {
                byte byt;
                if (n >= 3) {
                    byt = (byte)((bytes[i] - 32 & 0x3F) << 2 | (bytes[i + 1] - 32 & 0x3F) >> 4);
                    os.write(byt);
                    byt = (byte)((bytes[i + 1] - 32 & 0x3F) << 4 | (bytes[i + 2] - 32 & 0x3F) >> 2);
                    os.write(byt);
                    byt = (byte)((bytes[i + 2] - 32 & 0x3F) << 6 | bytes[i + 3] - 32 & 0x3F);
                    os.write(byt);
                } else {
                    if (n >= 1) {
                        byt = (byte)((bytes[i] - 32 & 0x3F) << 2 | (bytes[i + 1] - 32 & 0x3F) >> 4);
                        os.write(byt);
                    }
                    if (n >= 2) {
                        byt = (byte)((bytes[i + 1] - 32 & 0x3F) << 4 | (bytes[i + 2] - 32 & 0x3F) >> 2);
                        os.write(byt);
                    }
                }
                i += 4;
                n -= 3;
            }
            i += CRLF_LENGTH;
        }
        return os.toByteArray();
    }

    public static final String MD5Encode(byte[] message_digest) {
        if (message_digest.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        int i = 0;
        while (i < 16) {
            int low = message_digest[i] & 0xF;
            int high = (message_digest[i] & 0xF0) >> 4;
            buffer[i * 2] = hexadecimal[high];
            buffer[i * 2 + 1] = hexadecimal[low];
            ++i;
        }
        return new String(buffer);
    }
}

