/*
 * Decompiled with CFR 0.152.
 */
package stec.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Env {
    private static Hashtable envs = null;

    private static final void init() throws Exception {
        if (envs != null) {
            return;
        }
        envs = new Hashtable();
        String fileName = System.getProperty("env");
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        BufferedReader is = null;
        try {
            String line;
            is = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = is.readLine()) != null) {
                int offset = line.indexOf("=");
                if (offset <= 0) continue;
                envs.put(line.substring(0, offset), line.substring(offset + 1));
            }
        }
        finally {
            is.close();
        }
    }

    public static String get(String key) throws Exception {
        return Env.get(key, null);
    }

    public static String get(String key, String value) throws Exception {
        Object obj;
        if (envs == null) {
            Env.init();
        }
        if ((obj = envs.get(key)) == null) {
            return value;
        }
        return (String)obj;
    }

    public static Enumeration envs() throws Exception {
        if (envs == null) {
            Env.init();
        }
        return envs.keys();
    }
}

