/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import stec.iws.ClientAddress;
import stec.iws.Logger;
import stec.iws.RealmManager;
import stec.iws.RequestHandler;
import stec.iws.RequestQueue;
import stec.iws.ServletContextImpl;
import stec.iws.ServletContextManager;
import stec.iws.ServletImpl;
import stec.iws.ServletManager;
import stec.iws.SessionStore;
import stec.iws.SocketHandler;
import stec.iws.Utils;
import stec.lang.DString;
import stec.sql.ConnectionPoolManager;
import stec.util.LocalStrings;

public final class iws {
    private static final String COPYRIGHT = "Copyright (C) 1998-2005 Servertec. All rights reserved.";
    private static final String COMPANY_NAME = "Servertec";
    private static final String PRODUCT_NAME = "Internet Server";
    private static final String ALT_PRODUCT_NAME = "Application/Web Server";
    private static final String VERSION_NUMBER = "1.12.0";
    private static final String REVISION = null;
    private static final String RELEASE_DATE = "09/04/2005";
    private static final String RELEASE = "Open Source Release";
    private static boolean logo_displayed;
    protected static LocalStrings local_strings;
    public static Hashtable mimetypes;
    public static Hashtable messages;
    public static Hashtable aliases;
    public static Hashtable servlets;
    public static Hashtable servlet_contexts;
    public static Hashtable hosts;
    public static Hashtable locales;
    public static Hashtable resources;
    public static Hashtable realms;
    protected static boolean security;
    protected static ThreadGroup threadGroup;
    protected static Vector threads;
    protected static String basedir;
    protected static String contextdir;
    protected static String configdir;
    protected static String templatesdir;
    protected static boolean inArchive;
    protected static String adminID;
    protected static String adminPW;
    protected static int port;
    protected static int connections;
    protected static int maxConnections;
    protected static int actualConnections;
    protected static int usedConnections;
    protected static int inuse;
    protected static int input_buffer_size;
    protected static int output_buffer_size;
    protected static int socket_send_buffer_size;
    protected static int socket_receive_buffer_size;
    protected static int shutdown_delay;
    protected static int wait_on_close;
    protected static int linger;
    protected static int nodelay;
    protected static boolean keepAlive;
    protected static int keepAliveTimeout;
    protected static int keepAliveTimeoutMillis;
    protected static int keepAliveRequests;
    protected static int backlog;
    protected static ServerSocket serverSocket;
    protected static String[] default_pages;
    protected static boolean shell;
    protected static boolean dns_lookup;
    protected static boolean remote_admin;
    protected static boolean servlet_chaining;
    protected static boolean obscure_server;
    protected static String[] envs;
    protected static String preloadServlets;
    protected static boolean logErrors;
    protected static boolean logEvents;
    protected static boolean logAccess;
    protected static Logger logger;
    protected static String loggerService;
    protected static Class[] logger_ignore_exceptions;
    protected static SessionStore sessionStore;
    protected static String sessionStoreService;
    protected static long sessionStoreInterval;
    protected static long sessionTimeout;
    protected static int sessionSource;
    protected static String sessionName;
    protected static String sessionComment;
    protected static String sessionDomain;
    protected static String sessionPath;
    protected static int sessionMaxAge;
    protected static boolean sessionSecure;
    protected static boolean sessionCheckIpAddress;
    protected static boolean sessionCheckSessionSource;
    protected static boolean debug;
    protected static long debug_log_request_counter;
    protected static File debug_log_basedir;
    protected static long connection_pool_interval;
    protected static String ip_address;
    private static int shutdown_code;
    protected static long start_time;
    protected static boolean ssl;
    protected static String plain_socket_handler_def;
    protected static SocketHandler plain_socket_handler;
    protected static String secure_socket_handler_def;
    protected static SocketHandler secure_socket_handler;
    protected static ServletContextImpl servlet_context;
    protected static boolean shutdown;
    protected static boolean system_was_shutdown;
    private static boolean can_destroy_servlets;
    protected static boolean service;
    private static boolean shutdown_hook_inuse;
    private static boolean force_shutdown;
    private static boolean force_exit;
    protected static boolean wait_on_full;
    private static int server_socket_timeout;
    protected static int socket_timeout;
    protected static int server_protocol_version;
    protected static boolean send_vary;
    protected static String file_encoding;
    protected static boolean content_negotiation;
    protected static String default_language;
    protected static String default_charset;
    protected static Locale default_locale;
    protected static String[] default_content_encoding;
    protected static Hashtable content_encodings;
    protected static String[] default_content_type;
    protected static Hashtable content_types;
    protected static int max_request_header_length;
    protected static int max_request_header_count;
    protected static int max_request_content_length;
    protected static int max_client_requests;
    protected static Hashtable client_addresses;
    protected static String error_message_template;
    protected static RequestQueue request_queue;
    protected static Object lock;
    protected static Object debug_log_request_counter_lock;
    public static final int WORKER_SOCKET_SOURCE = 0;
    public static final int MAIN_SOCKET_SOURCE = 1;
    public static final int QUEUE_SOCKET_SOURCE = 2;
    public static int socket_source;
    protected static boolean multiline_request_headers;
    protected static final String SERVER_SOFTWARE;

    static {
        local_strings = new LocalStrings("stec.iws.LocalStrings");
        logErrors = true;
        debug_log_request_counter = 0L;
        shutdown_code = 0;
        shutdown = false;
        system_was_shutdown = false;
        can_destroy_servlets = false;
        service = false;
        shutdown_hook_inuse = false;
        force_shutdown = false;
        force_exit = false;
        server_socket_timeout = -1;
        content_encodings = new Hashtable();
        content_types = new Hashtable();
        client_addresses = new Hashtable();
        lock = new Object();
        debug_log_request_counter_lock = new Object();
        socket_source = 1;
        SERVER_SOFTWARE = local_strings.getLocalString("server_software");
    }

    public static final void main(String[] args) throws Exception {
        try {
            try {
                iws.init(args);
                iws.run();
            }
            catch (Throwable ex) {
                iws.log(ex);
            }
        }
        finally {
            iws.destroy();
        }
        if (!service) {
            System.exit(shutdown_code);
        }
    }

    public static final void run() throws Exception {
        iws instance = new iws();
        instance._run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void _run() throws Exception {
        block30: {
            block29: {
                if (iws.socket_source != 0) break block29;
                while (!iws.shutdown) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException var1_1) {
                        // empty catch block
                    }
                }
                break block30;
            }
            thread = Thread.currentThread();
            thread.setPriority(6);
            while (!iws.shutdown) {
                try {
                    socket = iws.serverSocket.accept();
                }
                catch (InterruptedIOException ex) {
                    continue;
                }
                catch (Throwable ex) {
                    try {
                        if (iws.ignoreException(ex)) continue;
                        try {
                            iws.log(ex);
                        }
                        catch (Exception var6_10) {
                        }
                    }
                    catch (Throwable v0) {}
                    continue;
                }
                if (iws.shutdown) break;
                if (iws.socket_source == 2) {
                    if (iws.addSocket(socket)) continue;
                    iws.request_queue.add(socket);
                    var5_6 = iws.lock;
                    synchronized (var5_6) {
                        if (iws.actualConnections - iws.usedConnections == 0 && (iws.actualConnections <= iws.maxConnections || iws.maxConnections == -1)) {
                            ++iws.actualConnections;
                            worker = new RequestHandler();
                            new Thread(iws.threadGroup, worker).start();
                        }
                        ++iws.usedConnections;
                        continue;
                    }
                }
                if (iws.socket_source != 1) continue;
                var5_6 = iws.threads;
                synchronized (var5_6) {
                    block32: {
                        block31: {
                            if (iws.actualConnections - iws.usedConnections != 0) break block31;
                            if (iws.actualConnections <= iws.maxConnections || iws.maxConnections == -1) ** GOTO lbl64
                            if (iws.wait_on_full) {
                                if (iws.addSocket(socket)) {
                                    continue;
                                }
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var6_11) {}
                            } else {
                                try {
                                    socket.close();
                                }
                                catch (Exception var6_12) {
                                    // empty catch block
                                }
                                continue;
lbl64:
                                // 1 sources

                                if (iws.addSocket(socket)) {
                                    continue;
                                }
                            }
                            ++iws.actualConnections;
                            worker = new RequestHandler();
                            worker.setSocket(socket);
                            new Thread(iws.threadGroup, worker).start();
                            break block32;
                        }
                        if (iws.addSocket(socket)) {
                            continue;
                        }
                        last = iws.threads.size() - 1;
                        worker = (RequestHandler)iws.threads.elementAt(last);
                        iws.threads.removeElementAt(last);
                        worker.setSocket(socket);
                    }
                    ++iws.usedConnections;
                }
            }
            if (!iws.shutdown) {
                throw new Exception(iws.local_strings.getLocalString("err.socket_listener_exited_without_shutdown"));
            }
        }
    }

    public static final synchronized void destroy() {
        block71: {
            if (system_was_shutdown) {
                return;
            }
            shutdown = true;
            system_was_shutdown = true;
            if (socket_source == 1) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception ex) {
                        iws.log(ex);
                    }
                    serverSocket = null;
                }
                if (threadGroup != null) {
                    block70: {
                        try {
                            if (shutdown_delay == -1) {
                                while (usedConnections > 0) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException ex) {}
                                }
                                break block70;
                            }
                            long etime = System.currentTimeMillis() + (long)shutdown_delay;
                            while (System.currentTimeMillis() < etime) {
                                if (usedConnections > 0) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception ex) {
                            iws.log(ex);
                        }
                    }
                    try {
                        threadGroup.stop();
                    }
                    catch (Exception ex) {
                        iws.log(ex);
                    }
                    threadGroup = null;
                }
            } else if (socket_source == 2) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception ex) {
                        iws.log(ex);
                    }
                    serverSocket = null;
                }
                try {
                    if (shutdown_delay == -1) {
                        while (usedConnections > 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {}
                        }
                        break block71;
                    }
                    long etime = System.currentTimeMillis() + (long)shutdown_delay;
                    while (System.currentTimeMillis() < etime) {
                        if (usedConnections > 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    iws.log(ex);
                }
            } else if (socket_source == 0) {
                iws.dec_inuse();
                try {
                    if (shutdown_delay == -1) {
                        while (iws.get_inuse() > 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {}
                        }
                        break block71;
                    }
                    long etime = System.currentTimeMillis() + (long)shutdown_delay;
                    while (System.currentTimeMillis() < etime) {
                        if (iws.get_inuse() > 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    iws.log(ex);
                }
            }
        }
        if (plain_socket_handler != null) {
            try {
                plain_socket_handler.destroy();
            }
            catch (Exception ex) {
                iws.log(ex);
            }
        }
        if (secure_socket_handler != null) {
            try {
                secure_socket_handler.destroy();
            }
            catch (Exception ex) {
                iws.log(ex);
            }
        }
        if (can_destroy_servlets) {
            if (servlet_context == null) {
                try {
                    servlet_context = ServletContextManager.getServletContext("/");
                }
                catch (Exception ex) {
                    iws.log(ex);
                }
            }
            if (servlet_context != null) {
                try {
                    ServletManager.destroyServlets(servlet_context);
                }
                catch (Exception ex) {
                    iws.log(ex);
                }
            }
            try {
                ServletContextManager.destroyAllServletContexts();
            }
            catch (Exception ex) {
                iws.log(ex);
            }
        }
        if (sessionStore != null) {
            try {
                sessionStore.destroy();
            }
            catch (Exception ex) {
                sessionStore = null;
                iws.log(ex);
            }
            sessionStore = null;
        }
        try {
            RealmManager.destroyRealms();
        }
        catch (Exception ex) {
            iws.log(ex);
        }
        try {
            ConnectionPoolManager.destroyAllConnectionPools();
        }
        catch (Exception ex) {
            iws.log(ex);
        }
        iws.log(local_strings.getLocalString("msg.server_was_stopped"));
        if (logger != null) {
            try {
                logger.destroy();
            }
            catch (Exception ex) {
                logger = null;
                iws.log(ex);
            }
            logger = null;
        }
    }

    public static final void shutdown(int _shutdown_code) {
        shutdown_code = _shutdown_code;
        shutdown = true;
        if (force_shutdown) {
            iws.doForcedShutdown();
        } else if (socket_source != 0) {
            iws.destroy();
            if (force_exit || server_socket_timeout == -1 && !service) {
                System.exit(shutdown_code);
            }
        }
    }

    public static final void log(Throwable ex, String msg) {
        try {
            if (logger == null) {
                while (ex instanceof InvocationTargetException) {
                    ex = ((InvocationTargetException)ex).getTargetException();
                }
                if (msg != null && msg.length() > 0) {
                    System.err.println(msg);
                }
                Utils.printStackTrace(System.err, ex);
            } else {
                logger.log(ex, msg);
            }
        }
        catch (Exception err) {
            err.printStackTrace(System.err);
        }
    }

    public static final void log(String msg) {
        try {
            if (logger == null) {
                System.out.println(msg);
            } else {
                logger.log(msg);
            }
        }
        catch (Exception err) {
            err.printStackTrace(System.err);
        }
    }

    public static final void log(Throwable ex) {
        iws.log(ex, "");
    }

    private static final void displayLogo() {
        if (!logo_displayed) {
            logo_displayed = true;
            System.err.print(COMPANY_NAME);
            System.err.print(" (R) ");
            if (ALT_PRODUCT_NAME == null) {
                System.err.print(PRODUCT_NAME);
            } else {
                System.err.print(ALT_PRODUCT_NAME);
            }
            System.err.print(" Version ");
            System.err.print(VERSION_NUMBER);
            if (REVISION != null) {
                System.err.print(REVISION);
            }
            System.err.print(' ');
            System.err.print(RELEASE_DATE);
            System.err.print(' ');
            System.err.println(RELEASE);
            System.err.println(COPYRIGHT);
            System.err.println();
        }
    }

    public static void init(String[] parameters) throws Exception {
        Hashtable args;
        String classfile;
        Hashtable sessionStoreArgs;
        String sessionStoreClass;
        Hashtable loggerArgs;
        String loggerClass;
        boolean disable_shutdown_hook;
        iws.displayLogo();
        can_destroy_servlets = false;
        shutdown_code = 0;
        system_was_shutdown = false;
        shutdown = false;
        service = System.getProperty("SERVICE") != null;
        force_shutdown = System.getProperty("FORCE_SHUTDOWN") != null;
        force_exit = System.getProperty("FORCE_EXIT") != null;
        boolean bl = disable_shutdown_hook = System.getProperty("DISABLE_SHUTDOWN_HOOK") != null;
        if (!(disable_shutdown_hook || service || shutdown_hook_inuse || force_exit)) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        iws.destroy();
                    }
                });
                shutdown_hook_inuse = true;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        start_time = System.currentTimeMillis();
        serverSocket = null;
        basedir = parameters.length == 0 ? "./" : parameters[0];
        File file = new File(basedir);
        if (!file.exists()) {
            throw new Exception(local_strings.getLocalString("err.base_directory_does_not_exist", basedir));
        }
        basedir = file.getCanonicalPath();
        configdir = System.getProperty("configdir");
        if (configdir == null) {
            configdir = "./config";
        }
        configdir = iws.getRealPath(configdir);
        String tbasedir = basedir.toLowerCase();
        inArchive = tbasedir.endsWith(".jar") || tbasedir.endsWith(".zip");
        envs = new String[0];
        file_encoding = System.getProperty("file.encoding");
        if (file_encoding == null) {
            file_encoding = iws.getDefaultFileEncoding();
        }
        iws.loadServerConfig();
        iws.loadSessionConfig();
        iws.loadLoggerConfig();
        mimetypes = Utils.getConfig("./mimetypes.ini");
        messages = Utils.getConfig("./messages.ini");
        aliases = Utils.getConfig("./aliases.ini");
        servlets = Utils.getConfig("./servlets.ini");
        servlet_contexts = Utils.getConfig("./contexts.ini");
        hosts = Utils.getConfig("./hosts.ini");
        locales = Utils.getConfig("./locales.ini");
        if (debug) {
            iws.initDebugLog();
        }
        if (security) {
            resources = Utils.getConfig("./resources.ini");
            realms = Utils.getConfig("./realms.ini");
        }
        envs = Utils.loadEnv();
        iws.initConnectionPools();
        int offset = loggerService.indexOf(63);
        if (offset == -1) {
            loggerClass = loggerService;
            loggerArgs = new Hashtable();
        } else {
            loggerClass = loggerService.substring(0, offset);
            loggerArgs = Utils.parseParameters(loggerService.substring(offset + 1));
        }
        loggerClass = loggerClass.trim();
        Class<?> cls = Class.forName(loggerClass);
        Logger tlogger = (Logger)cls.newInstance();
        tlogger.init(loggerArgs);
        logger = tlogger;
        if (iws.logger.interval > 0) {
            Thread thread = new Thread(logger);
            thread.setDaemon(true);
            thread.start();
        }
        if ((offset = sessionStoreService.indexOf(63)) == -1) {
            sessionStoreClass = sessionStoreService;
            sessionStoreArgs = new Hashtable();
        } else {
            sessionStoreClass = sessionStoreService.substring(0, offset);
            sessionStoreArgs = Utils.parseParameters(sessionStoreService.substring(offset + 1));
        }
        sessionStoreClass = sessionStoreClass.trim();
        cls = Class.forName(sessionStoreClass);
        SessionStore tsessionStore = (SessionStore)cls.newInstance();
        tsessionStore.init(sessionStoreArgs);
        sessionStore = tsessionStore;
        if (sessionStoreInterval > 0L) {
            Thread thread = new Thread(sessionStore);
            thread.setDaemon(true);
            thread.start();
        }
        if (socket_source == 2) {
            request_queue = backlog < 1 ? new RequestQueue() : new RequestQueue(backlog);
        }
        if (socket_source != 0) {
            actualConnections = connections;
            usedConnections = 0;
            ThreadGroup threadGroup = new ThreadGroup("RequestHandlers");
            if (socket_source == 1) {
                threads = new Vector(connections);
            }
            int i = 0;
            while (i < connections) {
                RequestHandler w = new RequestHandler();
                new Thread(threadGroup, w).start();
                if (socket_source == 1) {
                    threads.addElement(w);
                }
                ++i;
            }
        }
        if ((offset = plain_socket_handler_def.indexOf(63)) == -1) {
            classfile = plain_socket_handler_def;
            args = new Hashtable();
        } else {
            classfile = plain_socket_handler_def.substring(0, offset);
            args = Utils.parseParameters(plain_socket_handler_def.substring(offset + 1));
        }
        classfile = classfile.trim();
        cls = Class.forName(classfile);
        plain_socket_handler = (SocketHandler)cls.newInstance();
        plain_socket_handler.init(args);
        if (secure_socket_handler_def != null) {
            offset = secure_socket_handler_def.indexOf(63);
            if (offset == -1) {
                classfile = secure_socket_handler_def;
                args = new Hashtable();
            } else {
                classfile = secure_socket_handler_def.substring(0, offset);
                args = Utils.parseParameters(secure_socket_handler_def.substring(offset + 1));
            }
            classfile = classfile.trim();
            cls = Class.forName(classfile);
            secure_socket_handler = (SocketHandler)cls.newInstance();
            secure_socket_handler.init(args);
        }
        if (socket_source == 0) {
            ServerSocket server_socket;
            if (ssl) {
                if (secure_socket_handler == null) {
                    throw new Exception(local_strings.getLocalString("err.was_not_specified", "secure_socket_handler"));
                }
                server_socket = secure_socket_handler.getServerSocket(port, backlog, ip_address);
            } else {
                server_socket = plain_socket_handler.getServerSocket(port, backlog, ip_address);
            }
            if (server_socket_timeout != -1) {
                server_socket.setSoTimeout(server_socket_timeout);
            }
            ThreadGroup threadGroup = new ThreadGroup("RequestHandlers");
            int i = 0;
            while (i < connections) {
                RequestHandler w = new RequestHandler(server_socket);
                new Thread(threadGroup, w).start();
                ++i;
            }
        } else {
            if (ssl) {
                if (secure_socket_handler == null) {
                    throw new Exception(local_strings.getLocalString("err.was_not_specified", "secure_socket_handler"));
                }
                serverSocket = secure_socket_handler.getServerSocket(port, backlog, ip_address);
            } else {
                serverSocket = plain_socket_handler.getServerSocket(port, backlog, ip_address);
            }
            if (server_socket_timeout != -1) {
                serverSocket.setSoTimeout(server_socket_timeout);
            }
        }
        logger.log(local_strings.getLocalString("msg.server_was_started"));
        can_destroy_servlets = true;
        iws.preload_servlets();
    }

    private static final void initConnectionPools() throws Exception {
        Hashtable ht = Utils.getConfig("./dbpools.ini");
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            try {
                long timeout;
                int maxSize;
                int initSize;
                String key = (String)e.nextElement();
                String value = (String)ht.get(key);
                Hashtable args = Utils.parseParameters(value);
                Object obj = args.remove("driver");
                if (obj == null) {
                    throw new Exception(local_strings.getLocalString("err.invalid_connection_pool_entry_was_not_specified", key, "driver"));
                }
                String driver = ((String[])obj)[0];
                obj = args.remove("url");
                if (obj == null) {
                    throw new Exception(local_strings.getLocalString("err.invalid_connection_pool_entry_was_not_specified", key, "url"));
                }
                String url = ((String[])obj)[0];
                obj = args.remove("init_size");
                if (obj == null) {
                    initSize = 10;
                } else {
                    value = ((String[])obj)[0].trim();
                    if (value.length() == 0) {
                        initSize = 10;
                    } else {
                        try {
                            initSize = Integer.parseInt(value);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception(local_strings.getLocalString("err.invalid_connection_pool_entry_must_be_numeric", key, "init_size", value));
                        }
                    }
                }
                obj = args.remove("max_size");
                if (obj == null) {
                    maxSize = 20;
                } else {
                    value = ((String[])obj)[0].trim();
                    if (value.length() == 0) {
                        maxSize = 20;
                    } else {
                        try {
                            maxSize = Integer.parseInt(value);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception(local_strings.getLocalString("err.invalid_connection_pool_entry_must_be_numeric", key, "max_size", value));
                        }
                    }
                }
                if (initSize > maxSize) {
                    maxSize = initSize;
                }
                if ((obj = args.remove("timeout")) == null) {
                    timeout = 1800000L;
                } else {
                    value = ((String[])obj)[0].trim();
                    if (value.length() == 0) {
                        timeout = 1800000L;
                    } else {
                        try {
                            timeout = Integer.parseInt(value);
                        }
                        catch (NumberFormatException ex) {
                            throw new Exception(local_strings.getLocalString("err.invalid_connection_pool_entry_must_be_numeric", key, "timeout", value));
                        }
                        if (timeout != -1L) {
                            timeout = timeout < 1L ? 60000L : (timeout *= 60000L);
                        }
                    }
                }
                Properties info = new Properties();
                if (args.size() > 0) {
                    Enumeration te = args.keys();
                    while (te.hasMoreElements()) {
                        String tkey = (String)te.nextElement();
                        String tvalue = ((String[])args.get(tkey))[0];
                        info.put(tkey, tvalue);
                    }
                }
                ConnectionPoolManager.createConnectionPool(key, driver, url, info, initSize, maxSize, timeout);
            }
            catch (Exception ex) {
                iws.log(ex);
            }
        }
        if (connection_pool_interval > 0L) {
            ConnectionPoolManager connection_pool_manager = new ConnectionPoolManager(connection_pool_interval);
            Thread thread = new Thread(connection_pool_manager);
            thread.setDaemon(true);
            thread.start();
        }
    }

    protected static final boolean get_boolean_value(Hashtable ht, String key, boolean default_value) {
        Object obj = ht.get(key);
        if (obj != null) {
            return ((String)obj).equalsIgnoreCase("y");
        }
        return default_value;
    }

    private static final String get_string_value(Hashtable ht, String key, String default_value) {
        String value;
        Object obj = ht.get(key);
        if (obj != null && (value = ((String)obj).trim()).length() > 0) {
            return value;
        }
        return default_value;
    }

    private static final int get_integer_value(Hashtable ht, String key, int default_value, String config_filename) throws NumberFormatException {
        String value;
        Object obj = ht.get(key);
        if (obj != null && (value = ((String)obj).trim()).length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException(local_strings.getLocalString("err.config_must_be_numeric", config_filename, key, value));
            }
        }
        return default_value;
    }

    private static final String getDefaultFileEncoding() {
        OutputStreamWriter writer = new OutputStreamWriter(new ByteArrayOutputStream());
        return writer.getEncoding();
    }

    private static final String[] parse_accept(String value) {
        String[] accept = new String[2];
        int offset = value.indexOf(61);
        if (offset == -1) {
            accept[0] = value.trim();
            accept[1] = "";
        } else {
            accept[0] = value.substring(0, offset).trim();
            accept[1] = value.substring(offset + 1).trim();
            if (accept[1].charAt(0) != '.') {
                accept[1] = "." + accept[1];
            }
        }
        return accept;
    }

    private static final void loadServerConfig() throws IOException, Exception {
        String[] textensions;
        Object obj;
        int count;
        Hashtable ht = Utils.getConfig("./iws.ini");
        String value = iws.get_string_value(ht, "socket_source", "main");
        socket_source = value.equalsIgnoreCase("worker") ? 0 : (value.equalsIgnoreCase("queue") ? 2 : 1);
        default_pages = null;
        value = iws.get_string_value(ht, "default", null);
        if (value != null && (count = DString.dcount(value, ',')) > 0) {
            default_pages = new String[count];
            int i = 0;
            while (i < count) {
                iws.default_pages[i] = DString.extract(value, ',', i).trim();
                ++i;
            }
        }
        shell = iws.get_boolean_value(ht, "shell", false);
        dns_lookup = iws.get_boolean_value(ht, "dns_lookup", false);
        remote_admin = iws.get_boolean_value(ht, "remote_admin", true);
        security = iws.get_boolean_value(ht, "security", true);
        ssl = iws.get_boolean_value(ht, "ssl", false);
        servlet_chaining = iws.get_boolean_value(ht, "servlet_chaining", false);
        obscure_server = iws.get_boolean_value(ht, "obscure_server", false);
        wait_on_full = iws.get_boolean_value(ht, "wait_on_full", false);
        multiline_request_headers = iws.get_boolean_value(ht, "multiline_request_headers", false);
        debug = iws.get_boolean_value(ht, "debug", false);
        value = iws.get_string_value(ht, "nodelay", null);
        if (value == null) {
            value = "";
        }
        nodelay = value.equalsIgnoreCase("y") ? 1 : (value.equalsIgnoreCase("n") ? 0 : -1);
        value = iws.get_string_value(ht, "wait_on_close", null);
        if (value == null) {
            value = "";
        }
        wait_on_close = value.equalsIgnoreCase("y") ? 1 : (value.equalsIgnoreCase("n") ? 0 : -1);
        linger = iws.get_integer_value(ht, "linger", -1, "./iws.ini");
        if (linger < 0) {
            linger = 128;
        }
        keepAlive = iws.get_boolean_value(ht, "keep_alive", true);
        keepAliveTimeout = iws.get_integer_value(ht, "keep_alive_timeout", 15, "./iws.ini");
        if (keepAliveTimeout < 15 && keepAliveTimeout != -1) {
            keepAliveTimeout = 15;
        }
        keepAliveTimeoutMillis = keepAliveTimeout == -1 ? -1 : keepAliveTimeout * 1000;
        keepAliveRequests = iws.get_integer_value(ht, "keep_alive_requests", 5, "./iws.ini");
        if (keepAliveRequests < 5 && keepAliveRequests != -1) {
            keepAliveRequests = 5;
        }
        plain_socket_handler_def = iws.get_string_value(ht, "plain_socket_handler", "stec.iws.PlainSocketHandler");
        secure_socket_handler_def = iws.get_string_value(ht, "secure_socket_handler", null);
        connection_pool_interval = iws.get_integer_value(ht, "connection_pool_interval", 300000, "./iws.ini");
        if (connection_pool_interval < 1L && connection_pool_interval != -1L) {
            connection_pool_interval = 60000L;
        } else if (connection_pool_interval != -1L) {
            connection_pool_interval *= 60000L;
        }
        socket_timeout = iws.get_integer_value(ht, "socket_timeout", 300000, "./iws.ini");
        if (socket_timeout < 1000 && socket_timeout != -1 && socket_timeout != 0) {
            socket_timeout = 1000;
        }
        if ((server_socket_timeout = iws.get_integer_value(ht, "server_socket_timeout", -1, "./iws.ini")) < 1000 && server_socket_timeout != -1 && server_socket_timeout != 0) {
            server_socket_timeout = 1000;
        }
        if ((port = iws.get_integer_value(ht, "port", 8080, "./iws.ini")) == 0) {
            port = 8080;
        }
        if ((connections = iws.get_integer_value(ht, "connections", 25, "./iws.ini")) < 0) {
            connections = 0;
        }
        if (socket_source != 0) {
            maxConnections = iws.get_integer_value(ht, "max_connections", connections, "./iws.ini");
            if (maxConnections < connections && maxConnections != -1) {
                maxConnections = connections;
            }
            if (maxConnections == 0) {
                maxConnections = 1;
            }
        }
        if ((backlog = iws.get_integer_value(ht, "backlog", 50, "./iws.ini")) < 0 && backlog != -1) {
            backlog = -1;
        }
        input_buffer_size = iws.get_integer_value(ht, "input_buffer_size", -1, "./iws.ini");
        output_buffer_size = iws.get_integer_value(ht, "output_buffer_size", 8192, "./iws.ini");
        socket_send_buffer_size = iws.get_integer_value(ht, "socket_send_buffer_size", -1, "./iws.ini");
        socket_receive_buffer_size = iws.get_integer_value(ht, "socket_receive_buffer_size", -1, "./iws.ini");
        max_request_header_length = iws.get_integer_value(ht, "max_request_header_length", -1, "./iws.ini");
        if (max_request_header_length < 128 && max_request_header_length != -1) {
            max_request_header_length = 128;
        }
        if ((max_request_header_count = iws.get_integer_value(ht, "max_request_header_count", -1, "./iws.ini")) < 32 && max_request_header_count != -1) {
            max_request_header_count = 32;
        }
        if ((max_request_content_length = iws.get_integer_value(ht, "max_request_content_length", -1, "./iws.ini")) < 128 && max_request_content_length != -1) {
            max_request_content_length = 128;
        }
        if ((max_client_requests = iws.get_integer_value(ht, "max_client_requests", -1, "./iws.ini")) < 1 && max_client_requests != -1) {
            max_client_requests = 1;
        }
        shutdown_delay = (shutdown_delay = iws.get_integer_value(ht, "shutdown_delay", 60000, "./iws.ini")) != -1 && shutdown_delay < 0 ? 60000 : (shutdown_delay *= 1000);
        adminID = iws.get_string_value(ht, "username", "");
        adminPW = iws.get_string_value(ht, "password", "");
        ip_address = iws.get_string_value(ht, "ip_address", null);
        if (ip_address != null) {
            if (ip_address.length() == 0) {
                ip_address = null;
            } else if (ip_address.equals("*")) {
                ip_address = null;
            }
        }
        server_protocol_version = (value = iws.get_string_value(ht, "server_protocol", null)) == null ? -1 : ((value = value.trim()).length() == 0 ? -1 : Utils.parseServerProtocolVersion(value));
        content_negotiation = iws.get_boolean_value(ht, "content_negotiation", false);
        send_vary = iws.get_boolean_value(ht, "send_vary", false);
        default_language = iws.get_string_value(ht, "default_language", null);
        if (default_language != null && default_language.length() == 0) {
            default_language = null;
        }
        if (default_language == null) {
            default_locale = Locale.getDefault();
        } else {
            String default_variant;
            String default_country = iws.get_string_value(ht, "default_country", null);
            if (default_country != null && default_country.length() == 0) {
                default_country = null;
            }
            if (default_country == null) {
                default_country = "";
            }
            if ((default_variant = iws.get_string_value(ht, "default_variant", null)) != null && default_variant.length() == 0) {
                default_variant = null;
            }
            default_locale = default_variant == null ? new Locale(default_language, default_country) : new Locale(default_language, default_country, default_variant);
        }
        default_charset = iws.get_string_value(ht, "default_charset", null);
        if (default_charset != null && default_charset.length() == 0) {
            default_charset = null;
        }
        if ((value = iws.get_string_value(ht, "default_content_encoding", null)) != null) {
            default_content_encoding = iws.parse_accept(value);
        }
        value = iws.get_string_value(ht, "content_encodings", "");
        int count2 = DString.dcount(value, ',');
        int i = 0;
        while (i < count2) {
            String[] extensions;
            String[] content_encoding = iws.parse_accept(DString.extract(value, ',', i));
            obj = content_encodings.get(content_encoding[0]);
            if (obj == null) {
                extensions = new String[]{content_encoding[1]};
            } else {
                textensions = (String[])obj;
                extensions = new String[textensions.length + 1];
                System.arraycopy(textensions, 0, extensions, 0, textensions.length);
                extensions[textensions.length] = content_encoding[1];
            }
            content_encodings.put(content_encoding[0], extensions);
            ++i;
        }
        value = iws.get_string_value(ht, "default_content_type", null);
        if (value != null) {
            default_content_type = iws.parse_accept(value);
        }
        value = iws.get_string_value(ht, "content_types", "");
        count2 = DString.dcount(value, ',');
        int i2 = 0;
        while (i2 < count2) {
            String[] extensions;
            String[] content_type = iws.parse_accept(DString.extract(value, ',', i2));
            obj = content_types.get(content_type[0]);
            if (obj == null) {
                extensions = new String[]{content_type[1]};
            } else {
                textensions = (String[])obj;
                extensions = new String[textensions.length + 1];
                System.arraycopy(textensions, 0, extensions, 0, textensions.length);
                extensions[textensions.length] = content_type[1];
            }
            content_types.put(content_type[0], extensions);
            ++i2;
        }
        preloadServlets = iws.get_string_value(ht, "preload_servlets", null);
        contextdir = iws.get_string_value(ht, "contextdir", "./contexts");
        contextdir = iws.getWorkDirectory(contextdir);
        templatesdir = iws.get_string_value(ht, "templatesdir", "./templates");
        templatesdir = iws.getRealPath(templatesdir);
        error_message_template = Utils.getTemplate("./messages.html");
    }

    private static final void loadLoggerConfig() throws IOException, Exception {
        int count;
        logger = null;
        Hashtable ht = Utils.getConfig("./logger.ini");
        logErrors = iws.get_boolean_value(ht, "log_errors", true);
        logEvents = iws.get_boolean_value(ht, "log_events", true);
        logAccess = iws.get_boolean_value(ht, "log_access", true);
        loggerService = iws.get_string_value(ht, "service", "stec.iws.ConsoleLogger");
        logger_ignore_exceptions = null;
        String value = iws.get_string_value(ht, "ignore_exceptions", null);
        if (value != null && (count = DString.dcount(value, ',')) > 0) {
            Vector vclasses = new Vector();
            int i = 0;
            while (i < count) {
                try {
                    String tvalue = DString.extract(value, ',', i).trim();
                    if (tvalue.length() > 0) {
                        vclasses.addElement(Class.forName(tvalue));
                    }
                }
                catch (Throwable throwable) {
                    iws.log(throwable);
                }
                ++i;
            }
            count = vclasses.size();
            logger_ignore_exceptions = new Class[count];
            i = 0;
            while (i < count) {
                iws.logger_ignore_exceptions[i] = (Class)vclasses.elementAt(i);
                ++i;
            }
        }
    }

    private static final void loadSessionConfig() throws IOException, Exception {
        String value;
        Hashtable ht = Utils.getConfig("./session.ini");
        sessionStoreService = iws.get_string_value(ht, "session_store", "stec.iws.MemorySessionStore");
        sessionCheckIpAddress = iws.get_boolean_value(ht, "check_ip_address", true);
        sessionCheckSessionSource = iws.get_boolean_value(ht, "check_session_source", true);
        sessionStoreInterval = iws.get_integer_value(ht, "interval", 300000, "./session.ini");
        if (sessionStoreInterval != -1L && (sessionStoreInterval *= 60000L) < 60000L) {
            sessionStoreInterval = 60000L;
        }
        if ((sessionTimeout = (long)iws.get_integer_value(ht, "timeout", 1800000, "./session.ini")) != -1L && (sessionTimeout *= 60000L) < 60000L) {
            sessionTimeout = 60000L;
        }
        sessionSource = (value = iws.get_string_value(ht, "source", "cookie")).equalsIgnoreCase("url") ? 1 : 2;
        sessionName = iws.get_string_value(ht, "name", "iwsSessionID");
        sessionComment = iws.get_string_value(ht, "comment", null);
        sessionDomain = iws.get_string_value(ht, "domain", null);
        sessionPath = iws.get_string_value(ht, "path", null);
        sessionMaxAge = iws.get_integer_value(ht, "max_age", -1, "./session.ini");
        sessionSecure = iws.get_boolean_value(ht, "secure", false);
    }

    private static final void preload_servlets() throws Exception {
        if (preloadServlets != null) {
            String item;
            int index = 0;
            servlet_context = ServletContextManager.getServletContext("/");
            while ((item = DString.extract(preloadServlets, ',', index++)) != null) {
                item = item.trim();
                try {
                    ServletImpl obj = ServletManager.loadServlet(servlet_context, item);
                    if (obj != null) continue;
                    iws.log(local_strings.getLocalString("err.was_not_found", local_strings.getLocalString("Servlet"), item));
                }
                catch (Exception ex) {
                    iws.log(ex, local_strings.getLocalString("err.unable_to_load", local_strings.getLocalString("Servlet"), item));
                }
            }
        }
    }

    public static final String getMimeType(String filename) {
        String mimetype = null;
        int offset = filename.lastIndexOf(46);
        if (offset != -1) {
            mimetype = (String)mimetypes.get(filename.substring(offset).toLowerCase());
        }
        if (mimetype == null) {
            mimetype = (String)mimetypes.get("*");
        }
        if (mimetype != null) {
            mimetype = DString.extract(mimetype, '&', 0);
        }
        return mimetype;
    }

    public static final String getBaseDirectory() {
        if (inArchive) {
            int offset = basedir.lastIndexOf(File.separatorChar);
            if (offset == -1) {
                return File.separator;
            }
            return basedir.substring(0, offset);
        }
        return basedir;
    }

    public static final String getConfigDirectory() {
        return configdir;
    }

    public static final String getTemplatesDirectory() {
        return templatesdir;
    }

    public static final String getContextDirectory() {
        return contextdir;
    }

    public static final long getStartTime() {
        return start_time;
    }

    public static final String getWorkDirectory(String _tempdir) throws IOException {
        if (Utils.isAbsolute(_tempdir)) {
            _tempdir = Utils.normalizePath(_tempdir);
        } else {
            _tempdir = Utils.normalizeURI(_tempdir);
            _tempdir = Utils.concatPaths(iws.getBaseDirectory(), _tempdir);
        }
        File file = new File(_tempdir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException(local_strings.getLocalString("err.path_is_not_a_directory", _tempdir));
            }
        } else {
            file.mkdirs();
        }
        return file.getCanonicalPath();
    }

    public static final String getRealPath(String path) throws IOException {
        if (Utils.isAbsolute(path)) {
            path = Utils.normalizePath(path);
        } else {
            path = Utils.normalizeURI(path);
            path = Utils.concatPaths(basedir, path);
        }
        return Utils.getCanonicalPath(path);
    }

    public static final boolean shutdown() {
        return shutdown;
    }

    public static final int getShutdownCode() {
        return shutdown_code;
    }

    protected static final synchronized void initDebugLog() throws IOException {
        debug_log_basedir = new File(iws.getWorkDirectory("./debug"));
        String[] list = debug_log_basedir.list();
        int length = list.length;
        int i = 0;
        while (i < length) {
            File file = new File(debug_log_basedir, list[i]);
            file.delete();
            ++i;
        }
    }

    protected static final synchronized BufferedOutputStream openDebugLog(String filename, long counter) throws IOException {
        StringBuffer sb = new StringBuffer(filename);
        sb.append(counter);
        sb.append(".dbg");
        File file = new File(debug_log_basedir, sb.toString());
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static final boolean ignoreException(Throwable ex) {
        if (logger_ignore_exceptions != null) {
            Class<?> exception = ex.getClass();
            int length = logger_ignore_exceptions.length;
            int i = 0;
            while (i < length) {
                if (logger_ignore_exceptions[i].isAssignableFrom(exception)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static final void doForcedShutdown() {
        try {
            Socket socket;
            if (ssl) {
                if (secure_socket_handler == null) {
                    return;
                }
                socket = secure_socket_handler.getSocket("localhost", port);
            } else {
                if (plain_socket_handler == null) {
                    return;
                }
                socket = plain_socket_handler.getSocket("localhost", port);
            }
            try {
                OutputStream os = socket.getOutputStream();
                try {
                    os.write("GET / HTTP/1.0\n".getBytes());
                    os.write("Connection: Close\n".getBytes());
                    os.write(10);
                }
                finally {
                    os.close();
                }
            }
            finally {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final boolean remoteAdmin() {
        return remote_admin;
    }

    public static final String getSessionName() {
        return sessionName;
    }

    public static final int getPort() {
        return port;
    }

    public static final boolean isService() {
        return service;
    }

    public static final boolean verifyAdminLogin(String id, String pw) {
        return id.equals(adminID) && pw.equals(adminPW);
    }

    public static final SocketHandler getPlainSocketHandler() {
        return plain_socket_handler;
    }

    public static final SocketHandler getSecureSocketHandler() {
        return secure_socket_handler;
    }

    public static final String getDefaultLanguage() {
        return default_language;
    }

    public static final String getDefaultCharset() {
        return default_charset;
    }

    public static final String[] getDefaultContentEncoding() {
        return default_content_encoding;
    }

    public static final String[] getDefaultContentType() {
        return default_content_type;
    }

    public static final String getFileEncoding() {
        return file_encoding;
    }

    public static final boolean isContentNegotiated() {
        return content_negotiation;
    }

    public static final Locale getDefaultLocale() {
        if (default_locale == null) {
            default_locale = Locale.getDefault();
        }
        return default_locale;
    }

    protected static final synchronized int get_inuse() {
        return inuse;
    }

    protected static final synchronized void dec_inuse() {
        --inuse;
    }

    protected static final synchronized void inc_inuse() {
        ++inuse;
    }

    protected static String getLogo() {
        StringBuffer sb = new StringBuffer();
        sb.append(COMPANY_NAME);
        sb.append(' ');
        sb.append(PRODUCT_NAME);
        sb.append(' ');
        sb.append(VERSION_NUMBER);
        if (REVISION != null) {
            sb.append(REVISION);
        }
        sb.append(' ');
        sb.append(RELEASE_DATE);
        sb.append(' ');
        sb.append(RELEASE);
        return sb.toString();
    }

    public static String getServerVersion() {
        if (REVISION == null) {
            return "1.12.0 09/04/2005 Open Source Release";
        }
        return VERSION_NUMBER + REVISION + " " + RELEASE_DATE + " " + RELEASE;
    }

    public static final String getReleaseInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(COMPANY_NAME);
        sb.append(" (R) ");
        sb.append(PRODUCT_NAME);
        sb.append(' ');
        sb.append(VERSION_NUMBER);
        if (REVISION != null) {
            sb.append(REVISION);
        }
        sb.append(' ');
        sb.append(RELEASE_DATE);
        sb.append(' ');
        sb.append(RELEASE);
        sb.append('\n');
        sb.append(COPYRIGHT);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final boolean addSocket(Socket socket) {
        if (max_client_requests == -1) {
            return false;
        }
        Hashtable hashtable = client_addresses;
        synchronized (hashtable) {
            int count;
            ClientAddress client_address;
            String local_address;
            block7: {
                local_address = socket.getInetAddress().getHostAddress();
                Object object = client_addresses.get(local_address);
                client_address = object == null ? new ClientAddress() : (ClientAddress)object;
                count = client_address.count + 1;
                if (count <= max_client_requests) break block7;
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            client_addresses.put(socket, local_address);
            client_address.count = count;
            client_addresses.put(local_address, client_address);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void removeSocket(Socket socket) {
        Hashtable hashtable = client_addresses;
        synchronized (hashtable) {
            Object object = client_addresses.get(socket);
            if (object != null) {
                client_addresses.remove(socket);
                String local_address = (String)object;
                object = client_addresses.get(local_address);
                if (object != null) {
                    ClientAddress client_address = (ClientAddress)object;
                    --client_address.count;
                    if (client_address.count <= 0) {
                        client_addresses.remove(local_address);
                    }
                }
            }
        }
    }
}

