/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import stec.iws.IOHandler;
import stec.iws.IOManager;
import stec.iws.Request;
import stec.iws.RequestHandler;
import stec.iws.Response;
import stec.iws.iws;
import stec.lang.DString;

public final class Utils {
    static boolean[] raw_chars = new boolean[256];
    private static final String tokens = "()<>@,;:\\\"/[]?={} \t";

    static {
        int i = 97;
        while (i <= 122) {
            Utils.raw_chars[i] = true;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            Utils.raw_chars[i] = true;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            Utils.raw_chars[i] = true;
            ++i;
        }
        Utils.raw_chars[32] = true;
        Utils.raw_chars[45] = true;
        Utils.raw_chars[95] = true;
        Utils.raw_chars[46] = true;
        Utils.raw_chars[42] = true;
    }

    public static final String encodeURL(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        StringBuffer sb = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            int chr = value.charAt(i) & 0xFF;
            if (chr <= 256) {
                if (raw_chars[chr]) {
                    if (chr == 32) {
                        chr = 43;
                    }
                    sb.append((char)chr);
                } else {
                    sb.append('%');
                    sb.append(Integer.toHexString((char)chr));
                }
            } else {
                sb.append('%');
                sb.append(Integer.toHexString((char)chr));
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String decodeURL(String value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        int length = value.length();
        StringBuffer result = new StringBuffer();
        int offset = 0;
        while (offset < length) {
            char chr;
            int tOffset = offset;
            while (tOffset < length) {
                chr = value.charAt(tOffset);
                if (chr == '+' || chr == '%') break;
                ++tOffset;
            }
            if (tOffset > offset) {
                result.append(value.substring(offset, tOffset));
                offset = tOffset;
            }
            if (offset >= length) break;
            chr = value.charAt(offset);
            if (chr == '+') {
                result.append(' ');
                ++offset;
                continue;
            }
            if (chr != '%') continue;
            try {
                result.append((char)Integer.parseInt(value.substring(offset + 1, offset + 3), 16));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(iws.local_strings.getLocalString("err.invalid_hex_value", value.substring(offset + 1, offset + 3)));
            }
            offset += 3;
        }
        return result.toString();
    }

    public static final String encodeURL(String value, String charset) throws IllegalArgumentException {
        byte[] bytes;
        if (value == null) {
            return null;
        }
        try {
            bytes = value.getBytes(charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        int length = bytes.length;
        ByteArrayOutputStream os = new ByteArrayOutputStream(length);
        int i = 0;
        while (i < length) {
            int chr = bytes[i] & 0xFF;
            if (chr <= 256) {
                if (raw_chars[chr]) {
                    if (chr == 32) {
                        chr = 43;
                    }
                    os.write((char)chr);
                } else {
                    os.write(37);
                    try {
                        os.write(Integer.toHexString((char)chr).getBytes());
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException(ex.getMessage());
                    }
                }
            } else {
                os.write(37);
                try {
                    os.write(Integer.toHexString((char)chr).getBytes());
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
            ++i;
        }
        try {
            return new String(os.toByteArray(), charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static final String decodeURL(String value, String charset) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        int length = value.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(length);
        int offset = 0;
        while (offset < length) {
            char chr = value.charAt(offset);
            if (chr == '+') {
                os.write(32);
                ++offset;
                continue;
            }
            if (chr == '%') {
                String tvalue = value.substring(offset + 1, offset + 3);
                try {
                    os.write((byte)Integer.parseInt(tvalue, 16));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(iws.local_strings.getLocalString("err.invalid_hex_value", tvalue));
                }
                offset += 3;
                continue;
            }
            os.write((byte)chr);
            ++offset;
        }
        if (charset == null) {
            return os.toString();
        }
        try {
            return new String(os.toByteArray(), charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static final Cookie[] parseCookieHeader(String header) {
        if (header == null) {
            return new Cookie[0];
        }
        int count = DString.dcount(header, "; ");
        Cookie[] cookies = new Cookie[count];
        int i = 0;
        while (i < count) {
            String value;
            String key;
            String cookie = DString.extract(header, "; ", i);
            int offset = cookie.indexOf(61);
            if (offset == -1) {
                key = cookie;
                value = "";
            } else {
                key = cookie.substring(0, offset);
                value = cookie.substring(offset + 1);
            }
            cookies[i] = new Cookie(key, value);
            ++i;
        }
        return cookies;
    }

    private static final boolean isToken(String value) {
        int length = value.length();
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (c < ' ' || c >= '\u007f' || tokens.indexOf(c) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final void encodeCookieData(int version, StringBuffer sb, String value) {
        if (version == 0 || Utils.isToken(value)) {
            sb.append(value);
        } else {
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
        }
    }

    public static final String encodeCookie(Cookie cookie) {
        int version = cookie.getVersion();
        StringBuffer sb = new StringBuffer(cookie.getName());
        sb.append('=');
        Utils.encodeCookieData(version, sb, cookie.getValue());
        if (version == 1) {
            sb.append(";Version=1");
            if (cookie.getComment() != null) {
                sb.append(";Comment=");
                Utils.encodeCookieData(version, sb, cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            sb.append(";Domain=");
            Utils.encodeCookieData(version, sb, cookie.getDomain());
        }
        int max_age = cookie.getMaxAge();
        if (version == 0) {
            if (max_age >= 0) {
                sb.append(";Expires=");
                Date dt = max_age == 0 ? new Date(10000L) : new Date(System.currentTimeMillis() + (long)max_age * 1000L);
                SimpleDateFormat cookieDate = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
                cookieDate.setTimeZone(TimeZone.getTimeZone("GMT"));
                sb.append(cookieDate.format(dt));
            }
        } else if (max_age < 0) {
            sb.append(";Discard");
        } else {
            sb.append(";Max-Age=");
            sb.append(max_age);
        }
        if (cookie.getPath() != null) {
            sb.append(";Path=");
            Utils.encodeCookieData(version, sb, cookie.getPath());
        }
        if (cookie.getSecure()) {
            sb.append(";Secure");
        }
        return sb.toString();
    }

    public static final Cookie extractCookie(Cookie[] cookies, String id) {
        if (cookies != null) {
            int length = cookies.length;
            int i = 0;
            while (i < length) {
                Cookie cookie = cookies[i];
                if (id.equalsIgnoreCase(cookie.getName())) {
                    return cookie;
                }
                ++i;
            }
        }
        return null;
    }

    public static final Cookie extractCookie(Vector cookies, String id) {
        if (cookies != null) {
            int count = cookies.size();
            int i = 0;
            while (i < count) {
                Cookie cookie = (Cookie)cookies.elementAt(i);
                if (id.equals(cookie.getName())) {
                    return cookie;
                }
                ++i;
            }
        }
        return null;
    }

    public static final String parseCharacterEncoding(String contentType, String value) {
        if (contentType == null) {
            return value;
        }
        int soffset = contentType.indexOf("charset=");
        if (soffset == -1) {
            return value;
        }
        int eoffset = contentType.indexOf(59, soffset += 8);
        if (eoffset == -1) {
            return contentType.substring(soffset).trim();
        }
        return contentType.substring(soffset, eoffset);
    }

    public static final String getArgs(HttpServletRequest _request) throws IOException {
        String script_name = Utils.concatURIs(((Request)_request).handler.servlet_context.uri, _request.getServletPath());
        String path = Utils.translatePath(_request.getServerName(), script_name);
        String qs = _request.getQueryString();
        if (qs == null) {
            return path;
        }
        int offset = qs.indexOf(61);
        if (offset == -1) {
            StringBuffer sb = new StringBuffer(path);
            sb.append('+');
            sb.append(qs);
            return sb.toString();
        }
        String args = qs.substring(0, offset);
        if ((offset = args.lastIndexOf(38)) == -1) {
            return path;
        }
        StringBuffer sb = new StringBuffer(path);
        sb.append('+');
        sb.append(qs.substring(0, offset));
        return sb.toString();
    }

    public static final String getParameters(HttpServletRequest _request) {
        String qs = _request.getQueryString();
        if (qs == null) {
            return null;
        }
        int offset = qs.indexOf(61);
        if (offset == -1) {
            return null;
        }
        String value = qs.substring(0, offset);
        if ((offset = value.lastIndexOf(38)) == -1) {
            return qs;
        }
        return qs.substring(offset + 1);
    }

    public static final String normalizeURI(String _uri) {
        int offset;
        String turi;
        String token;
        StringBuffer uri = new StringBuffer();
        if (_uri.length() == 0) {
            return "/";
        }
        StringTokenizer st = new StringTokenizer(_uri, "/\\");
        if (_uri.charAt(0) != '/' && _uri.charAt(0) != '\\' && st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("..")) {
                turi = uri.toString();
                offset = turi.lastIndexOf(47);
                if (offset == -1) {
                    offset = 0;
                }
                uri.setLength(offset);
            } else if (!Utils.isCurrentDir(token)) {
                uri.append(token);
            }
        }
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals("..")) {
                turi = uri.toString();
                offset = turi.lastIndexOf(47);
                if (offset == -1) {
                    offset = 0;
                }
                uri.setLength(offset);
                continue;
            }
            if (Utils.isCurrentDir(token)) continue;
            uri.append('/');
            uri.append(token);
        }
        char chr = _uri.charAt(_uri.length() - 1);
        if (chr == '/' || chr == '\\') {
            uri.append('/');
        }
        if (uri.length() == 0) {
            return "/";
        }
        return uri.toString();
    }

    public static final String normalizePath(String _path) throws IOException {
        String path;
        StringBuffer result = new StringBuffer();
        if (File.separatorChar == '\\') {
            result.append(Utils.parseDrive(_path));
            path = Utils.parsePath(_path);
        } else {
            path = _path;
        }
        StringBuffer sb = new StringBuffer();
        if (path.length() > 0) {
            int offset;
            String tpath;
            String token;
            StringTokenizer st = new StringTokenizer(path, "/\\");
            if (path.charAt(0) != '/' && path.charAt(0) != '\\' && st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("..")) {
                    tpath = sb.toString();
                    offset = tpath.lastIndexOf(File.separatorChar);
                    if (offset == -1) {
                        offset = 0;
                    }
                    sb.setLength(offset);
                } else if (!Utils.isCurrentDir(token)) {
                    sb.append(token);
                }
            }
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (token.equals("..")) {
                    tpath = sb.toString();
                    offset = tpath.lastIndexOf(File.separatorChar);
                    if (offset == -1) {
                        offset = 0;
                    }
                    sb.setLength(offset);
                    continue;
                }
                if (Utils.isCurrentDir(token)) continue;
                sb.append(File.separatorChar);
                sb.append(token);
            }
        }
        if (sb.length() == 0) {
            result.append(File.separatorChar);
        } else {
            result.append(sb.toString());
        }
        return result.toString();
    }

    public static final String translatePath(String server_name, String _path) throws IOException {
        IOHandler handler = null;
        String path = Utils.normalizeURI(_path);
        String tpath = Utils.translateAliases(server_name, path);
        if (tpath != null) {
            if (Utils.isAbsolute(tpath)) {
                tpath = Utils.normalizeURI(tpath);
                return Utils.getCanonicalPath(tpath);
            }
            path = tpath;
        }
        IOHandler thandler = Utils.getRootHandler(server_name);
        handler = IOManager.getHandler(thandler, path);
        return handler.getCanonicalPath();
    }

    public static final String concatPaths(String base, String ext) {
        return Utils.concat(base, ext, File.separatorChar);
    }

    public static final String concatURIs(String base, String ext) {
        return Utils.concat(base, ext, '/');
    }

    private static final String concat(String dir, String path, char delimiter) {
        if (dir.length() == 0) {
            return path;
        }
        if (path.length() == 0) {
            return dir;
        }
        StringBuffer sb = new StringBuffer(dir);
        char chr = path.charAt(0);
        if (dir.endsWith("/") || dir.endsWith("\\")) {
            if (chr == '/' || chr == '\\') {
                sb.append(path.substring(1));
            } else {
                sb.append(path);
            }
        } else if (chr == '/' || chr == '\\') {
            sb.append(path);
        } else {
            sb.append(delimiter);
            sb.append(path);
        }
        return sb.toString();
    }

    public static final IOHandler getRootHandler(String server_name) throws IOException {
        String server_basedir;
        Object obj = iws.hosts.get(server_name.toLowerCase());
        if (obj == null && (obj = iws.hosts.get("*")) == null) {
            obj = "./wwwroot";
        }
        IOHandler handler = Utils.isAbsolute(server_basedir = (String)obj) ? IOManager.getHandler(server_basedir) : IOManager.getHandler(iws.basedir, server_basedir);
        return handler;
    }

    protected static final String translateAliases(String server_name, String _uri) throws IOException {
        String uri = _uri;
        while (true) {
            String value;
            Object obj;
            if ((obj = iws.aliases.get(uri)) != null && (value = (String)obj).startsWith("file:")) {
                value = value.substring("file:".length());
                value = DString.change(value, "$wwwroot", Utils.getRootHandler(server_name).getCanonicalPath());
                value = DString.change(value, "$basedir", iws.getBaseDirectory());
                value = Utils.getAbsolutePath(value);
                return Utils.concatPaths(value, _uri.substring(uri.length()));
            }
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
                continue;
            }
            int offset = uri.lastIndexOf(47);
            if (offset == -1) {
                return null;
            }
            uri = uri.substring(0, offset + 1);
        }
    }

    protected static final long parseDate(String dt) {
        SimpleDateFormat dtFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        try {
            Date date = dtFmt.parse(dt);
            return date.getTime();
        }
        catch (Exception date) {
            dtFmt = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            try {
                Date date2 = dtFmt.parse(dt);
                return date2.getTime();
            }
            catch (Exception date2) {
                dtFmt = new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US);
                try {
                    Date date3 = dtFmt.parse(dt);
                    return date3.getTime();
                }
                catch (Exception ex) {
                    return -1L;
                }
            }
        }
    }

    public static final int readLine(InputStream is, byte[] buffer, int sOffset, int length) throws IOException {
        if (length <= 0) {
            return 0;
        }
        int eOffset = sOffset + length;
        if (eOffset > buffer.length) {
            eOffset = buffer.length;
        }
        int count = 0;
        int offset = sOffset;
        while (offset < eOffset) {
            int byt = is.read();
            if (byt == -1) break;
            ++count;
            buffer[offset] = (byte)byt;
            if (byt == 10) break;
            ++offset;
        }
        if (count > 0) {
            return count;
        }
        return -1;
    }

    public static final String getItem(Reader reader) throws IOException {
        int bytes_read;
        char[] buffer = new char[8192];
        StringBuffer sb = new StringBuffer();
        while ((bytes_read = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, bytes_read);
        }
        return sb.toString();
    }

    public static final String getItem(InputStream is) throws IOException {
        String charset = iws.default_charset;
        if (charset == null) {
            charset = iws.file_encoding;
        }
        InputStreamReader reader = new InputStreamReader(is, charset);
        try {
            String string = Utils.getItem(reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static final String getItem(File fh) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fh));
        try {
            String string = Utils.getItem(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static final String getItem(IOHandler handler) throws IOException {
        BufferedInputStream is = new BufferedInputStream(handler.getInputStream());
        try {
            String string = Utils.getItem(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static final String getItem(String filename) throws IOException {
        filename = Utils.getAbsolutePath(iws.basedir, filename);
        return Utils.getItem(IOManager.getHandler(filename));
    }

    public static final String getTemplate(String filename) throws IOException {
        filename = Utils.getAbsolutePath(iws.templatesdir, filename);
        return Utils.getItem(IOManager.getHandler(filename));
    }

    public static final Hashtable getConfig(String filename) throws IOException {
        return Utils.getConfig(filename, false);
    }

    public static final Hashtable getConfig(String filename, boolean admin) throws IOException {
        IOHandler handler = IOManager.getHandler(filename = Utils.getAbsolutePath(iws.configdir, filename));
        if (!handler.exists()) {
            throw new FileNotFoundException(iws.local_strings.getLocalString("err.file_was_not_found", filename));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(handler.getInputStream(), iws.file_encoding));
        try {
            String line;
            Hashtable<String, String> ht = new Hashtable<String, String>();
            while ((line = reader.readLine()) != null) {
                String value;
                String key;
                int offset;
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                if (filename.endsWith("./messages.ini") || filename.endsWith("./templates.ini")) {
                    line = DString.replace(line, "\\n", "\n");
                }
                if ((offset = line.indexOf(61)) == -1) {
                    key = line;
                    value = "";
                } else {
                    key = line.substring(0, offset).trim();
                    value = line.substring(offset + 1).trim();
                }
                if (filename.endsWith("./aliases.ini") || filename.endsWith("./resources.ini")) {
                    ht.put(key.replace('\\', '/'), value);
                } else if ((filename.endsWith("./hosts.ini") || filename.endsWith("./mimetypes.ini")) && !admin) {
                    ht.put(key.toLowerCase(), value);
                } else {
                    ht.put(key, value);
                }
                ht.put(key, value);
            }
            Hashtable<String, String> hashtable = ht;
            return hashtable;
        }
        finally {
            reader.close();
        }
    }

    protected static final String[] loadEnv() throws Exception {
        String filename = System.getProperty("env");
        if (filename == null) {
            return new String[0];
        }
        IOHandler handler = IOManager.getHandler(filename);
        if (!handler.exists()) {
            return new String[0];
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(handler.getInputStream()));
        try {
            String line;
            Vector<String> env = new Vector<String>();
            while ((line = br.readLine()) != null) {
                int offset = line.indexOf(61);
                if (offset <= 0) continue;
                env.addElement(line);
            }
            Object[] envs = new String[env.size()];
            env.copyInto(envs);
            Object[] objectArray = envs;
            return objectArray;
        }
        finally {
            br.close();
        }
    }

    public static Hashtable decodeParameters(InputStream is, int content_length) {
        return Utils.decodeParameters(is, content_length, null);
    }

    public static Hashtable decodeParameters(InputStream is, int content_length, String charset) {
        if (is == null || content_length <= 0) {
            return new Hashtable();
        }
        byte[] bytes = new byte[content_length];
        try {
            int bytes_read;
            int total_bytes_read = 0;
            do {
                if ((bytes_read = is.read(bytes, total_bytes_read, content_length - total_bytes_read)) > 0) continue;
                throw new IllegalArgumentException(iws.local_strings.getLocalString("err.short_read"));
            } while ((total_bytes_read += bytes_read) < content_length);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        return Utils.decodeParameters(new String(bytes, 0, content_length), charset);
    }

    public static final Hashtable decodeParameters(String _parameters) {
        return Utils.decodeParameters(_parameters, null);
    }

    public static final Hashtable decodeParameters(String _parameters, String charset) {
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        if (_parameters != null) {
            int count = DString.dcount(_parameters, '&');
            int i = 0;
            while (i < count) {
                String value = DString.extract(_parameters, '&', i);
                int offset = value.indexOf(61);
                if (offset != -1) {
                    String[] avalue;
                    String key = Utils.decodeURL(value.substring(0, offset), charset);
                    value = Utils.decodeURL(value.substring(offset + 1), charset);
                    Object obj = ht.get(key);
                    if (obj == null) {
                        avalue = new String[]{value};
                    } else {
                        String[] tarray = (String[])obj;
                        avalue = new String[tarray.length + 1];
                        System.arraycopy(tarray, 0, avalue, 0, tarray.length);
                        avalue[tarray.length] = value;
                    }
                    ht.put(key, avalue);
                }
                ++i;
            }
        }
        return ht;
    }

    public static final Hashtable parseParameters(String _parameters) {
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        if (_parameters != null) {
            int count = DString.dcount(_parameters, '&');
            int i = 0;
            while (i < count) {
                String value = DString.extract(_parameters, '&', i);
                int offset = value.indexOf(61);
                if (offset != -1) {
                    String[] avalue;
                    String key = value.substring(0, offset);
                    value = value.substring(offset + 1);
                    Object obj = ht.get(key);
                    if (obj == null) {
                        avalue = new String[]{value};
                    } else {
                        String[] tarray = (String[])obj;
                        avalue = new String[tarray.length + 1];
                        System.arraycopy(tarray, 0, avalue, 0, tarray.length);
                        avalue[tarray.length] = value;
                    }
                    ht.put(key, avalue);
                }
                ++i;
            }
        }
        return ht;
    }

    public static final String encodeParameters(Hashtable _ht) {
        StringBuffer sb = new StringBuffer();
        Enumeration e = _ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)_ht.get(key);
            sb.append(key);
            sb.append('=');
            sb.append(value);
            sb.append('&');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final boolean isAbsolute(String path) {
        char chr;
        int offset;
        if (path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/' || path.charAt(0) == '\\') {
            return true;
        }
        return File.separatorChar == '\\' && (offset = path.indexOf(58)) != -1 && ((chr = path.charAt(offset + 1)) == '/' || chr == '\\');
    }

    public static final String getCanonicalPath(String _path) throws IOException {
        int offset;
        String path;
        if (Utils.isAbsolute(_path)) {
            path = _path;
        } else {
            String drive = Utils.parseDrive(_path);
            path = Utils.parsePath(_path);
            File file = new File(drive);
            String cwd = file.getCanonicalPath();
            path = Utils.concatPaths(cwd, path);
        }
        if (File.separatorChar == '\\' && (offset = path.indexOf(58)) != -1) {
            path = String.valueOf(path.substring(0, offset).toUpperCase()) + path.substring(offset);
        }
        return Utils.normalizePath(path);
    }

    protected static final String parseDrive(String path) throws IOException {
        if (File.separatorChar == '\\') {
            if (path.length() == 0) {
                return Utils.parseDrive();
            }
            int offset = path.indexOf(58);
            if (offset == -1) {
                return Utils.parseDrive();
            }
            return path.substring(0, offset + 1);
        }
        return "";
    }

    private static final String parseDrive() throws IOException {
        String basedir = iws.basedir;
        int offset = basedir.indexOf(58);
        if (offset == -1) {
            basedir = new File(".").getCanonicalPath();
            offset = basedir.indexOf(58);
            if (offset == -1) {
                return "";
            }
            return basedir.substring(0, offset + 1);
        }
        return basedir.substring(0, offset + 1);
    }

    protected static final String parsePath(String path) {
        int offset;
        if (File.separatorChar == '\\' && (offset = path.indexOf(58)) != -1) {
            return path.substring(offset + 1);
        }
        return path;
    }

    public static final Hashtable mergeParameters(Hashtable ht1, Hashtable ht2) {
        Enumeration e = ht2.keys();
        while (e.hasMoreElements()) {
            String[] tarray;
            String key = (String)e.nextElement();
            String[] sarray = (String[])ht2.get(key);
            Object obj = ht1.get(key);
            if (obj == null) {
                tarray = sarray;
            } else {
                String[] oarray = (String[])obj;
                tarray = new String[oarray.length + sarray.length];
                System.arraycopy(oarray, 0, tarray, 0, oarray.length);
                System.arraycopy(sarray, 0, tarray, oarray.length, sarray.length);
            }
            ht1.put(key, tarray);
        }
        return ht1;
    }

    public static final Hashtable concatParameters(Hashtable ht1, Hashtable ht2) {
        Hashtable ht = (Hashtable)ht1.clone();
        Enumeration e = ht2.keys();
        while (e.hasMoreElements()) {
            String[] tarray;
            String key = (String)e.nextElement();
            String[] sarray = (String[])ht2.get(key);
            Object obj = ht.get(key);
            if (obj == null) {
                tarray = sarray;
            } else {
                String[] oarray = (String[])obj;
                tarray = new String[oarray.length + sarray.length];
                System.arraycopy(oarray, 0, tarray, 0, oarray.length);
                System.arraycopy(sarray, 0, tarray, oarray.length, sarray.length);
            }
            ht.put(key, tarray);
        }
        return ht;
    }

    protected static final void setHeader(Hashtable ht, String key, String value) {
        int offset = value.indexOf(10);
        if (offset != -1) {
            char[] aValue = value.toCharArray();
            aValue[offset] = 32;
            while ((offset = value.indexOf(10, offset + 1)) != -1) {
                aValue[offset] = 32;
            }
            value = new String(aValue);
        }
        String[] sarray = new String[]{value};
        ht.put(key, sarray);
    }

    protected static final void addCookie(RequestHandler _handler, Vector cookies, String id, String value) {
        Cookie cookie = new Cookie(id, value);
        if (iws.sessionComment != null) {
            cookie.setComment(iws.sessionComment);
        }
        if (iws.sessionDomain != null) {
            String domain = DString.replace(iws.sessionDomain, "%host%", _handler.request.getServerName());
            domain = DString.replace(domain, "%local_address%", _handler.request.getLocalAddr());
            cookie.setDomain(domain);
        }
        if (iws.sessionPath != null) {
            String path = DString.replace(iws.sessionPath, "%base_uri%", _handler.request.getRequestURI());
            path = DString.replace(path, "%request_uri%", _handler.request.getRequestURI());
            path = DString.replace(path, "%script_name%", _handler.request.getServletPath());
            path = DString.replace(path, "%servlet_context_path%", _handler.request.getContextPath());
            cookie.setPath(path);
        }
        cookie.setMaxAge(iws.sessionMaxAge);
        cookie.setSecure(iws.sessionSecure);
        int count = cookies.size();
        int i = 0;
        int o = 0;
        while (i < count) {
            Cookie tcookie = (Cookie)cookies.elementAt(o);
            if (tcookie.getName().equals(id)) {
                cookies.removeElementAt(o);
            } else {
                ++o;
            }
            ++i;
        }
        cookies.addElement(cookie);
    }

    public static final int parseServerProtocolVersion(String server_protocol) {
        int eoffset;
        int protocol_version = 0;
        int soffset = server_protocol.indexOf(47);
        if (soffset == -1) {
            protocol_version = 0;
        } else if ((eoffset = server_protocol.indexOf(46, ++soffset)) == -1) {
            try {
                protocol_version = Integer.parseInt(server_protocol.substring(soffset));
                if (protocol_version < 2) {
                    protocol_version = 0;
                }
            }
            catch (NumberFormatException ex) {
                protocol_version = 0;
            }
        } else {
            int major_version;
            try {
                major_version = Integer.parseInt(server_protocol.substring(soffset, eoffset));
            }
            catch (NumberFormatException ex) {
                major_version = 0;
            }
            if (major_version == 0) {
                protocol_version = 0;
            } else {
                int minor_version;
                try {
                    minor_version = Integer.parseInt(server_protocol.substring(eoffset + 1));
                }
                catch (NumberFormatException ex) {
                    minor_version = 0;
                }
                protocol_version = major_version == 1 ? (minor_version == 0 ? 0 : 1) : 1;
            }
        }
        return protocol_version;
    }

    public static final IOHandler getBestHandler(String filename, Request request, Response response) throws IOException {
        int content_encoding_extension_index;
        IOHandler handler;
        int content_encoding_extensions_count;
        String[] content_encoding_extensions;
        String accept_content_encoding;
        int charset_length;
        String charset;
        int language_length;
        int content_length;
        Object obj;
        response.headers.remove("Content-Type");
        response.headers.remove("Content-Language");
        response.headers.remove("Content-Encoding");
        if (iws.send_vary) {
            response.headers.remove("Vary");
        }
        if (!iws.content_negotiation) {
            IOHandler handler2 = IOManager.getHandler(filename);
            if (!handler2.exists()) {
                return null;
            }
            if (handler2.isDirectory()) {
                return null;
            }
            StringBuffer sb = new StringBuffer(iws.getMimeType(filename));
            if (iws.default_charset != null) {
                sb.append("; charset=");
                sb.append(iws.default_charset);
            }
            response.setContentType(sb.toString());
            if (iws.default_language != null) {
                response.setHeader("Content-Language", iws.default_language);
            }
            return handler2;
        }
        StringBuffer sb = new StringBuffer(filename);
        int filename_length = sb.length();
        Vector locales = request._getLocales();
        Vector charsets = request._getCharsets();
        int locales_count = locales.size();
        int charsets_count = charsets.size();
        String[] accept_content_encodings = request._getAcceptContentEncodings();
        int accept_content_encodings_count = accept_content_encodings.length;
        String[] accept_content_types = request._getAcceptContentTypes();
        int accept_content_types_count = accept_content_types.length;
        int content_type_index = 0;
        while (content_type_index < accept_content_types_count) {
            String accept_content_type = accept_content_types[content_type_index];
            obj = iws.content_types.get(accept_content_type);
            if (obj != null) {
                String[] content_type_extensions = (String[])obj;
                int content_type_extensions_count = content_type_extensions.length;
                int content_type_extension_index = 0;
                while (content_type_extension_index < content_type_extensions_count) {
                    sb.append(content_type_extensions[content_type_extension_index]);
                    content_length = sb.length();
                    int locale_index = 0;
                    while (locale_index < locales_count) {
                        Locale locale = (Locale)locales.elementAt(locale_index);
                        String language = locale.getLanguage();
                        sb.append('.');
                        sb.append(language);
                        language_length = sb.length();
                        int charset_index = 0;
                        while (charset_index < charsets_count) {
                            charset = (String)charsets.elementAt(charset_index);
                            sb.append('.');
                            sb.append(charset);
                            charset_length = sb.length();
                            int content_encoding_index = 0;
                            while (content_encoding_index < accept_content_encodings_count) {
                                accept_content_encoding = accept_content_encodings[content_encoding_index];
                                obj = iws.content_encodings.get(accept_content_encoding);
                                if (obj != null) {
                                    content_encoding_extensions = (String[])obj;
                                    content_encoding_extensions_count = content_encoding_extensions.length;
                                    int content_encoding_extension_index2 = 0;
                                    while (content_encoding_extension_index2 < content_encoding_extensions_count) {
                                        sb.append(content_encoding_extensions[content_encoding_extension_index2]);
                                        handler = IOManager.getHandler(sb.toString());
                                        if (handler.exists() && !handler.isDirectory()) {
                                            response.setContentType(String.valueOf(accept_content_type) + "; charset=" + charset);
                                            response.setHeader("Content-Language", language);
                                            response.setHeader("Content-Encoding", accept_content_encoding);
                                            if (iws.send_vary) {
                                                response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset,accept-encoding");
                                            }
                                            return handler;
                                        }
                                        sb.setLength(charset_length);
                                        ++content_encoding_extension_index2;
                                    }
                                }
                                ++content_encoding_index;
                            }
                            handler = IOManager.getHandler(sb.toString());
                            if (handler.exists() && !handler.isDirectory()) {
                                response.setContentType(String.valueOf(accept_content_type) + "; charset=" + charset);
                                response.setHeader("Content-Language", language);
                                if (iws.send_vary) {
                                    response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset");
                                }
                                return handler;
                            }
                            sb.setLength(language_length);
                            ++charset_index;
                        }
                        int content_encoding_index = 0;
                        while (content_encoding_index < accept_content_encodings_count) {
                            accept_content_encoding = accept_content_encodings[content_encoding_index];
                            obj = iws.content_encodings.get(accept_content_encoding);
                            if (obj != null) {
                                content_encoding_extensions = (String[])obj;
                                content_encoding_extensions_count = content_encoding_extensions.length;
                                int content_encoding_extension_index3 = 0;
                                while (content_encoding_extension_index3 < content_encoding_extensions_count) {
                                    sb.append(content_encoding_extensions[content_encoding_extension_index3]);
                                    handler = IOManager.getHandler(sb.toString());
                                    if (handler.exists() && !handler.isDirectory()) {
                                        response.setContentType(accept_content_type);
                                        response.setHeader("Content-Language", language);
                                        response.setHeader("Content-Encoding", accept_content_encoding);
                                        if (iws.send_vary) {
                                            response.setHeader("Vary", "negotiate,accept,accept_language,accept-encoding");
                                        }
                                        return handler;
                                    }
                                    sb.setLength(language_length);
                                    ++content_encoding_extension_index3;
                                }
                            }
                            ++content_encoding_index;
                        }
                        handler = IOManager.getHandler(sb.toString());
                        if (handler.exists() && !handler.isDirectory()) {
                            response.setContentType(accept_content_type);
                            response.setHeader("Content-Language", language);
                            if (iws.send_vary) {
                                response.setHeader("Vary", "negotiate,accept,accept_language");
                            }
                            return handler;
                        }
                        sb.setLength(content_length);
                        ++locale_index;
                    }
                    int content_encoding_index = 0;
                    while (content_encoding_index < accept_content_encodings_count) {
                        accept_content_encoding = accept_content_encodings[content_encoding_index];
                        obj = iws.content_encodings.get(accept_content_encoding);
                        if (obj != null) {
                            content_encoding_extensions = (String[])obj;
                            content_encoding_extensions_count = content_encoding_extensions.length;
                            int content_encoding_extension_index4 = 0;
                            while (content_encoding_extension_index4 < content_encoding_extensions_count) {
                                sb.append(content_encoding_extensions[content_encoding_extension_index4]);
                                handler = IOManager.getHandler(sb.toString());
                                if (handler.exists() && !handler.isDirectory()) {
                                    response.setContentType(accept_content_type);
                                    response.setHeader("Content-Encoding", accept_content_encoding);
                                    if (iws.send_vary) {
                                        response.setHeader("Vary", "negotiate,accept,accept-encoding");
                                    }
                                    return handler;
                                }
                                sb.setLength(content_length);
                                ++content_encoding_extension_index4;
                            }
                        }
                        ++content_encoding_index;
                    }
                    handler = IOManager.getHandler(sb.toString());
                    if (handler.exists() && !handler.isDirectory()) {
                        response.setContentType(accept_content_type);
                        if (iws.send_vary) {
                            response.setHeader("Vary", "negotiate,accept");
                        }
                        return handler;
                    }
                    sb.setLength(filename_length);
                    ++content_type_extension_index;
                }
            }
            ++content_type_index;
        }
        int locale_index = 0;
        while (locale_index < locales_count) {
            Locale locale = (Locale)locales.elementAt(locale_index);
            String language = locale.getLanguage();
            sb.append('.');
            sb.append(language);
            language_length = sb.length();
            int charset_index = 0;
            while (charset_index < charsets_count) {
                charset = (String)charsets.elementAt(charset_index);
                sb.append('.');
                sb.append(charset);
                charset_length = sb.length();
                int content_encoding_index = 0;
                while (content_encoding_index < accept_content_encodings_count) {
                    accept_content_encoding = accept_content_encodings[content_encoding_index];
                    obj = iws.content_encodings.get(accept_content_encoding);
                    if (obj != null) {
                        content_encoding_extensions = (String[])obj;
                        content_encoding_extensions_count = content_encoding_extensions.length;
                        content_encoding_extension_index = 0;
                        while (content_encoding_extension_index < content_encoding_extensions_count) {
                            sb.append(content_encoding_extensions[content_encoding_extension_index]);
                            handler = IOManager.getHandler(sb.toString());
                            if (handler.exists() && !handler.isDirectory()) {
                                response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + charset);
                                response.setHeader("Content-Language", language);
                                response.setHeader("Content-Encoding", accept_content_encoding);
                                if (iws.send_vary) {
                                    response.setHeader("Vary", "negotiate,accept_language,accept-charset,accept-encoding");
                                }
                                return handler;
                            }
                            sb.setLength(charset_length);
                            ++content_encoding_extension_index;
                        }
                    }
                    ++content_encoding_index;
                }
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + charset);
                    response.setHeader("Content-Language", language);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept_language,accept-charset");
                    }
                    return handler;
                }
                sb.setLength(language_length);
                ++charset_index;
            }
            int content_encoding_index = 0;
            while (content_encoding_index < accept_content_encodings_count) {
                accept_content_encoding = accept_content_encodings[content_encoding_index];
                obj = iws.content_encodings.get(accept_content_encoding);
                if (obj != null) {
                    content_encoding_extensions = (String[])obj;
                    content_encoding_extensions_count = content_encoding_extensions.length;
                    int content_encoding_extension_index5 = 0;
                    while (content_encoding_extension_index5 < content_encoding_extensions_count) {
                        sb.append(content_encoding_extensions[content_encoding_extension_index5]);
                        handler = IOManager.getHandler(sb.toString());
                        if (handler.exists() && !handler.isDirectory()) {
                            response.setContentType(iws.getMimeType(filename));
                            response.setHeader("Content-Language", language);
                            response.setHeader("Content-Encoding", accept_content_encoding);
                            if (iws.send_vary) {
                                response.setHeader("Vary", "negotiate,accept_language,accept-encoding");
                            }
                            return handler;
                        }
                        sb.setLength(language_length);
                        ++content_encoding_extension_index5;
                    }
                }
                ++content_encoding_index;
            }
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Language", language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language");
                }
                return handler;
            }
            sb.setLength(filename_length);
            ++locale_index;
        }
        String default_language = iws.default_language == null ? "en" : iws.default_language;
        String default_charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
        if (iws.default_content_type != null && (obj = iws.content_types.get(iws.default_content_type[1])) != null) {
            String content_type = iws.default_content_type[0];
            sb.append(content_type);
            content_length = sb.length();
            sb.append('.');
            sb.append(default_language);
            language_length = sb.length();
            sb.append('.');
            sb.append(default_charset);
            charset_length = sb.length();
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(String.valueOf(content_type) + "; charset=" + default_charset);
                    response.setHeader("Content-Language", default_language);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(charset_length);
            }
            if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(String.valueOf(content_type) + "; charset=" + default_charset);
                response.setHeader("Content-Language", default_language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset");
                }
                return handler;
            }
            sb.setLength(language_length);
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(content_type);
                    response.setHeader("Content-Language", default_language);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept_language,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(language_length);
            }
            if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(content_type);
                response.setHeader("Content-Language", default_language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept,accept_language");
                }
                return handler;
            }
            sb.setLength(content_length);
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(content_type);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(content_length);
            }
            if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(content_type);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept");
                }
                return handler;
            }
        }
        sb.append('.');
        sb.append(default_language);
        language_length = sb.length();
        sb.append('.');
        sb.append(default_charset);
        charset_length = sb.length();
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + default_charset);
                response.setHeader("Content-Language", default_language);
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language,accept-charset,accept-encoding");
                }
                return handler;
            }
            sb.setLength(charset_length);
        }
        if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
            response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + default_charset);
            response.setHeader("Content-Language", default_language);
            if (iws.send_vary) {
                response.setHeader("Vary", "negotiate,accept_language,accept-charset");
            }
            return handler;
        }
        sb.setLength(language_length);
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Language", default_language);
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language,accept-encoding");
                }
                return handler;
            }
            sb.setLength(language_length);
        }
        if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
            response.setContentType(iws.getMimeType(filename));
            response.setHeader("Content-Language", default_language);
            if (iws.send_vary) {
                response.setHeader("Vary", "negotiate,accept_language");
            }
            return handler;
        }
        sb.setLength(filename_length);
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept-encoding");
                }
                return handler;
            }
            sb.setLength(filename_length);
        }
        int content_encoding_index = 0;
        while (content_encoding_index < accept_content_encodings_count) {
            accept_content_encoding = accept_content_encodings[content_encoding_index];
            obj = iws.content_encodings.get(accept_content_encoding);
            if (obj != null) {
                content_encoding_extensions = (String[])obj;
                content_encoding_extensions_count = content_encoding_extensions.length;
                content_encoding_extension_index = 0;
                while (content_encoding_extension_index < content_encoding_extensions_count) {
                    sb.append(content_encoding_extensions[content_encoding_extension_index]);
                    handler = IOManager.getHandler(sb.toString());
                    if (handler.exists() && !handler.isDirectory()) {
                        response.setContentType(iws.getMimeType(filename));
                        response.setHeader("Content-Encoding", accept_content_encoding);
                        if (iws.send_vary) {
                            response.setHeader("Vary", "negotiate,accept-encoding");
                        }
                        return handler;
                    }
                    sb.setLength(filename_length);
                    ++content_encoding_extension_index;
                }
            }
            ++content_encoding_index;
        }
        handler = IOManager.getHandler(filename);
        if (handler.exists() && !handler.isDirectory()) {
            response.setContentType(iws.getMimeType(filename));
            return handler;
        }
        return null;
    }

    private static final boolean isCurrentDir(String dir) {
        int length = dir.length();
        int i = 0;
        while (i < length) {
            if (dir.charAt(i) != '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static final String filter(String str) {
        if (str == null) {
            return null;
        }
        return DString.replace(DString.replace(str, "<", "&lt;"), ">", "&gt;");
    }

    public static final String getAbsolutePath(String path) {
        if (!Utils.isAbsolute(path)) {
            path = Utils.concatPaths(iws.getBaseDirectory(), path);
        }
        return path;
    }

    public static final String getAbsolutePath(String basedir, String path) {
        if (!Utils.isAbsolute(path)) {
            path = Utils.concatPaths(basedir, path);
        }
        return path;
    }

    protected static final void printStackTrace(PrintStream stream, Throwable exception) {
        do {
            exception.printStackTrace(stream);
        } while (exception instanceof ServletException && (exception = ((ServletException)exception).getRootCause()) != null);
    }

    protected static final void printStackTrace(PrintWriter writer, Throwable exception) {
        do {
            exception.printStackTrace(writer);
        } while (exception instanceof ServletException && (exception = ((ServletException)exception).getRootCause()) != null);
    }
}

