/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import stec.iws.AccessLogEntry;
import stec.iws.Delay;
import stec.iws.Realm;
import stec.iws.RealmManager;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.ServletContextImpl;
import stec.iws.ServletContextManager;
import stec.iws.ServletImpl;
import stec.iws.ServletManager;
import stec.iws.Session;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;
import stec.net.Codecs;

public final class RequestHandler
implements Runnable {
    private static final byte[] ACK = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    protected Socket socket;
    protected long startTime;
    protected Request request = new Request(this);
    protected Response response = new Response(this);
    protected ServletImpl servlet_instance;
    protected boolean in_servlet_chain;
    protected int servlet_chain_index;
    protected boolean isAuthenticated;
    protected Realm realm_instance;
    protected ServletContextImpl servlet_context;
    protected boolean keepAlive;
    protected long keepAliveTimeout;
    protected int keepAliveRequests;
    BufferedOutputStream debug_log_request_os;
    BufferedOutputStream debug_log_response_os;
    ServerSocket server_socket;

    protected RequestHandler() {
        this.reset_keep_alive();
    }

    protected RequestHandler(ServerSocket _server_socket) {
        this();
        this.server_socket = _server_socket;
    }

    protected final synchronized void setSocket(Socket _socket) {
        this.socket = _socket;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void run() {
        while (!iws.shutdown) {
            Object object;
            block158: {
                block153: {
                    block156: {
                        if (iws.socket_source == 1) {
                            if (this.socket == null) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException ex) {
                                    continue;
                                }
                            }
                        } else if (iws.socket_source == 0) {
                            try {
                                this.socket = this.server_socket.accept();
                            }
                            catch (InterruptedIOException ex) {
                                continue;
                            }
                            catch (Throwable ex) {
                                try {
                                    this.log(ex);
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            if (iws.addSocket(this.socket)) {
                                continue;
                            }
                        } else if (iws.socket_source == 2) {
                            this.socket = iws.request_queue.next();
                            if (this.socket == null) break;
                        }
                        if (iws.shutdown) break;
                        try {
                            try {
                                if (iws.socket_source == 0) {
                                    iws.inc_inuse();
                                }
                                if (iws.socket_timeout != -1) {
                                    this.socket.setSoTimeout(iws.socket_timeout);
                                }
                                if (iws.wait_on_close != -1) {
                                    this.socket.setSoLinger(iws.wait_on_close != 0, iws.linger);
                                }
                                if (iws.nodelay != -1) {
                                    this.socket.setTcpNoDelay(iws.nodelay == 1);
                                }
                                if (iws.socket_send_buffer_size != -1) {
                                    this.socket.setSendBufferSize(iws.socket_send_buffer_size);
                                }
                                if (iws.socket_receive_buffer_size != -1) {
                                    this.socket.setReceiveBufferSize(iws.socket_receive_buffer_size);
                                }
                                this.processRequest();
                            }
                            catch (Throwable ex) {
                                this.log(ex);
                                break block153;
                            }
                        }
                        catch (Throwable throwable) {
                            block154: {
                                try {
                                    this.reset_keep_alive();
                                    this.request.close();
                                    this.response.close();
                                    if (this.socket == null) break block154;
                                    try {
                                        iws.removeSocket(this.socket);
                                    }
                                    finally {
                                        try {
                                            try {
                                                this.socket.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        finally {
                                            this.socket = null;
                                        }
                                    }
                                }
                                catch (Throwable throwable2) {
                                    if (iws.socket_source == 1) {
                                        object = iws.threads;
                                        synchronized (object) {
                                            --iws.usedConnections;
                                            if (iws.actualConnections > iws.connections) {
                                                --iws.actualConnections;
                                                if (iws.wait_on_full) {
                                                    this.notify();
                                                }
                                                return;
                                            }
                                            iws.threads.addElement(this);
                                            if (iws.wait_on_full) {
                                                this.notify();
                                            }
                                        }
                                    } else if (iws.socket_source == 2) {
                                        object = iws.lock;
                                        synchronized (object) {
                                            --iws.usedConnections;
                                            if (iws.actualConnections > iws.connections) {
                                                --iws.actualConnections;
                                                return;
                                            }
                                        }
                                    } else if (iws.socket_source == 0) {
                                        iws.dec_inuse();
                                    }
                                    throw throwable2;
                                }
                            }
                            if (iws.socket_source == 1) {
                                object = iws.threads;
                                synchronized (object) {
                                    --iws.usedConnections;
                                    if (iws.actualConnections > iws.connections) {
                                        --iws.actualConnections;
                                        if (iws.wait_on_full) {
                                            this.notify();
                                        }
                                        return;
                                    }
                                    iws.threads.addElement(this);
                                    if (iws.wait_on_full) {
                                        this.notify();
                                    }
                                }
                            } else if (iws.socket_source == 2) {
                                object = iws.lock;
                                synchronized (object) {
                                    --iws.usedConnections;
                                    if (iws.actualConnections > iws.connections) {
                                        --iws.actualConnections;
                                        return;
                                    }
                                }
                            } else if (iws.socket_source == 0) {
                                iws.dec_inuse();
                            }
                            throw throwable;
                        }
                        try {
                            this.reset_keep_alive();
                            this.request.close();
                            this.response.close();
                            if (this.socket == null) break block156;
                            try {
                                iws.removeSocket(this.socket);
                            }
                            finally {
                                try {
                                    try {
                                        this.socket.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                finally {
                                    this.socket = null;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (iws.socket_source == 1) {
                                object = iws.threads;
                                synchronized (object) {
                                    --iws.usedConnections;
                                    if (iws.actualConnections > iws.connections) {
                                        --iws.actualConnections;
                                        if (iws.wait_on_full) {
                                            this.notify();
                                        }
                                        return;
                                    }
                                    iws.threads.addElement(this);
                                    if (iws.wait_on_full) {
                                        this.notify();
                                    }
                                }
                            } else if (iws.socket_source == 2) {
                                object = iws.lock;
                                synchronized (object) {
                                    --iws.usedConnections;
                                    if (iws.actualConnections > iws.connections) {
                                        --iws.actualConnections;
                                        return;
                                    }
                                }
                            } else if (iws.socket_source == 0) {
                                iws.dec_inuse();
                            }
                            throw throwable;
                        }
                    }
                    if (iws.socket_source == 1) {
                        object = iws.threads;
                        synchronized (object) {
                            --iws.usedConnections;
                            if (iws.actualConnections > iws.connections) {
                                --iws.actualConnections;
                                if (iws.wait_on_full) {
                                    this.notify();
                                }
                                return;
                            }
                            iws.threads.addElement(this);
                            if (iws.wait_on_full) {
                                this.notify();
                            }
                            continue;
                        }
                    }
                    if (iws.socket_source == 2) {
                        object = iws.lock;
                        synchronized (object) {
                            --iws.usedConnections;
                            if (iws.actualConnections > iws.connections) {
                                --iws.actualConnections;
                                return;
                            }
                            continue;
                        }
                    }
                    if (iws.socket_source != 0) continue;
                    iws.dec_inuse();
                    continue;
                }
                try {
                    this.reset_keep_alive();
                    this.request.close();
                    this.response.close();
                    if (this.socket == null) break block158;
                    try {
                        iws.removeSocket(this.socket);
                    }
                    finally {
                        try {
                            try {
                                this.socket.close();
                            }
                            catch (Exception exception) {}
                        }
                        finally {
                            this.socket = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (iws.socket_source == 1) {
                        object = iws.threads;
                        synchronized (object) {
                            --iws.usedConnections;
                            if (iws.actualConnections > iws.connections) {
                                --iws.actualConnections;
                                if (iws.wait_on_full) {
                                    this.notify();
                                }
                                return;
                            }
                            iws.threads.addElement(this);
                            if (iws.wait_on_full) {
                                this.notify();
                            }
                        }
                    } else if (iws.socket_source == 2) {
                        object = iws.lock;
                        synchronized (object) {
                            --iws.usedConnections;
                            if (iws.actualConnections > iws.connections) {
                                --iws.actualConnections;
                                return;
                            }
                        }
                    } else if (iws.socket_source == 0) {
                        iws.dec_inuse();
                    }
                    throw throwable;
                }
            }
            if (iws.socket_source == 1) {
                object = iws.threads;
                synchronized (object) {
                    --iws.usedConnections;
                    if (iws.actualConnections > iws.connections) {
                        --iws.actualConnections;
                        if (iws.wait_on_full) {
                            this.notify();
                        }
                        return;
                    }
                    iws.threads.addElement(this);
                    if (iws.wait_on_full) {
                        this.notify();
                    }
                    continue;
                }
            }
            if (iws.socket_source == 2) {
                object = iws.lock;
                synchronized (object) {
                    --iws.usedConnections;
                    if (iws.actualConnections > iws.connections) {
                        --iws.actualConnections;
                        return;
                    }
                    continue;
                }
            }
            if (iws.socket_source != 0) continue;
            iws.dec_inuse();
        }
    }

    private final void processRequest() throws Exception {
        if (this.canKeepAlive()) {
            this.keepAliveTimeout = iws.keepAliveTimeoutMillis == -1 ? -1L : System.currentTimeMillis() + (long)iws.keepAliveTimeoutMillis;
            this.keepAliveRequests = iws.keepAliveRequests;
        }
        this.init();
        while (!iws.shutdown) {
            if (!this.nextRequest() || !this.canKeepAlive() || !this.keepAlive) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean nextRequest() {
        boolean bl;
        int result;
        boolean log;
        block97: {
            String uri;
            block95: {
                boolean bl2;
                block96: {
                    block93: {
                        block94: {
                            String value;
                            block92: {
                                log = false;
                                result = -1;
                                this.response.iStatus = 0;
                                if (iws.debug) {
                                    long counter;
                                    Object object = iws.debug_log_request_counter_lock;
                                    synchronized (object) {
                                        counter = iws.debug_log_request_counter++;
                                    }
                                    this.debug_log_request_os = iws.openDebugLog("request", counter);
                                    this.debug_log_response_os = iws.openDebugLog("response", counter);
                                }
                                this.startTime = System.currentTimeMillis();
                                result = this.request.getRequest();
                                if (result == 1) break block92;
                                return false;
                            }
                            log = true;
                            this.servlet_context = ServletContextManager.getServletContext(Utils.decodeURL(Utils.normalizeURI(this.request.request_uri)));
                            this.setSession();
                            String charset = this.request.getCharset();
                            if (charset == null) {
                                charset = iws.default_charset;
                            }
                            this.request.script_name = Utils.decodeURL(Utils.normalizeURI(this.request.request_uri), charset);
                            if (this.canKeepAlive() && this.request.getServerProtocolVersion() > 0 && (value = this.request.getHeader("Connection")) != null) {
                                if (value.equalsIgnoreCase("Keep-Alive")) {
                                    this.keepAlive = true;
                                } else if (value.equalsIgnoreCase("Close")) {
                                    this.keepAlive = false;
                                }
                            }
                            uri = this.request.getServletPath();
                            if (!iws.security) break block93;
                            this.isAuthenticated = this.canAccess(uri);
                            if (this.isAuthenticated) break block93;
                            if (this.request.session == null) break block94;
                            try {
                                iws.sessionStore.saveSession(this.request.session, false);
                            }
                            catch (Exception ex) {
                                try {
                                    this.response.sendError(ex);
                                }
                                catch (Exception _ex) {
                                    iws.logger.log(_ex);
                                }
                            }
                        }
                        if (result == 1) {
                            try {
                                this.response.flush();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            try {
                                if (log) {
                                    this.log();
                                }
                            }
                            catch (Exception ex) {
                                iws.logger.log(ex);
                            }
                        }
                        this._wrapup();
                        if (this.debug_log_request_os != null) {
                            try {
                                this.debug_log_request_os.close();
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            this.debug_log_request_os = null;
                        }
                        if (this.debug_log_response_os == null) return true;
                        try {
                            this.debug_log_response_os.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        this.debug_log_response_os = null;
                        return true;
                    }
                    if (!iws.servlet_chaining) break block95;
                    bl2 = this.process_servlet_chain(uri);
                    if (this.request.session == null) break block96;
                    try {
                        iws.sessionStore.saveSession(this.request.session, false);
                    }
                    catch (Exception ex) {
                        try {
                            this.response.sendError(ex);
                        }
                        catch (Exception _ex) {
                            iws.logger.log(_ex);
                        }
                    }
                }
                if (result == 1) {
                    try {
                        this.response.flush();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        if (log) {
                            this.log();
                        }
                    }
                    catch (Exception ex) {
                        iws.logger.log(ex);
                    }
                }
                this._wrapup();
                if (this.debug_log_request_os != null) {
                    try {
                        this.debug_log_request_os.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.debug_log_request_os = null;
                }
                if (this.debug_log_response_os == null) return bl2;
                try {
                    this.debug_log_response_os.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.debug_log_response_os = null;
                return bl2;
            }
            bl = this.process_servlet(uri);
            if (this.request.session == null) break block97;
            try {
                iws.sessionStore.saveSession(this.request.session, false);
            }
            catch (Exception ex) {
                try {
                    this.response.sendError(ex);
                }
                catch (Exception _ex) {
                    iws.logger.log(_ex);
                }
            }
        }
        if (result == 1) {
            try {
                this.response.flush();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (log) {
                    this.log();
                }
            }
            catch (Exception ex) {
                iws.logger.log(ex);
            }
        }
        this._wrapup();
        if (this.debug_log_request_os != null) {
            try {
                this.debug_log_request_os.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.debug_log_request_os = null;
        }
        if (this.debug_log_response_os == null) return bl;
        try {
            this.debug_log_response_os.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.debug_log_response_os = null;
        return bl;
        catch (Throwable ex) {
            try {
                this.log(ex);
                return false;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (this.request.session != null) {
                    try {
                        iws.sessionStore.saveSession(this.request.session, false);
                    }
                    catch (Exception ex2) {
                        try {
                            this.response.sendError(ex2);
                        }
                        catch (Exception _ex) {
                            iws.logger.log(_ex);
                        }
                    }
                }
                if (result == 1) {
                    try {
                        this.response.flush();
                    }
                    catch (Exception ex2) {}
                    try {
                        if (log) {
                            this.log();
                        }
                    }
                    catch (Exception ex3) {
                        iws.logger.log(ex3);
                    }
                }
                this._wrapup();
                if (this.debug_log_request_os != null) {
                    try {
                        this.debug_log_request_os.close();
                    }
                    catch (Exception ex3) {}
                    this.debug_log_request_os = null;
                }
                if (this.debug_log_response_os != null) {
                    try {
                        this.debug_log_response_os.close();
                    }
                    catch (Exception ex3) {}
                    this.debug_log_response_os = null;
                }
            }
        }
    }

    protected final void log(Throwable ex) {
        if (iws.ignoreException(ex)) {
            this.response.iStatus = 206;
        } else {
            try {
                this.response.sendError(ex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean process_servlet(String path_info, String script_name, String servlet) throws Exception {
        block14: {
            this.request.path_info = path_info;
            this.request.script_name = script_name;
            if (servlet == null) {
                this.response.sendError(404);
                return false;
            }
            try {
                this.servlet_instance = ServletManager.loadServlet(this.servlet_context, servlet);
            }
            catch (ClassNotFoundException ex) {
                this.response.sendError(404, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet"), servlet));
                return false;
            }
            catch (UnavailableException ex) {
                this.response.iStatus = 503;
                int delay = ex.getUnavailableSeconds();
                if (delay >= 0) {
                    this.response.setIntHeader("Retry-After", delay);
                }
                throw ex;
            }
            if (this.servlet_instance == null) {
                this.response.sendError(404, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet"), servlet));
                return false;
            }
            this.processExpect();
            this.response.setStatus(200);
            try {
                if (this.servlet_instance.servlet instanceof SingleThreadModel) {
                    Servlet ex = this.servlet_instance.servlet;
                    synchronized (ex) {
                        this.servlet_instance.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
                        break block14;
                    }
                }
                this.servlet_instance.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
            }
            catch (UnavailableException ex) {
                String name = this.servlet_instance.config.name;
                int delay = ex.getUnavailableSeconds();
                ServletManager.unavailable_servlets.put(name, new Delay(delay));
                this.response.iStatus = 503;
                if (ex.isPermanent()) {
                    ServletManager.unloadServlet(this.servlet_context, name);
                }
                if (delay >= 0) {
                    this.response.setIntHeader("Retry-After", delay);
                }
                throw ex;
            }
        }
        this.response.sendHeaders();
        return true;
    }

    private final boolean process_servlet(String uri) throws Exception {
        String filter_uri = ServletManager.findFilter(uri);
        if (filter_uri != null) {
            String filter = ServletManager.getFilter(filter_uri);
            if (uri.length() == filter_uri.length()) {
                uri = null;
            } else if ((uri = uri.substring(filter_uri.length())).charAt(0) != '/') {
                uri = "/" + uri;
            }
            if (filter_uri.startsWith(this.servlet_context.uri)) {
                filter_uri = Utils.concatURIs("/", filter_uri.substring(this.servlet_context.uri.length()));
            }
            return this.process_servlet(uri, filter_uri, filter);
        }
        String servlet_uri = ServletManager.findServlet(uri);
        if (servlet_uri != null) {
            if (uri.length() == servlet_uri.length()) {
                uri = null;
            } else if ((uri = uri.substring(servlet_uri.length())).charAt(0) != '/') {
                uri = "/" + uri;
            }
            String servlet = ServletManager.getServlet(servlet_uri);
            if (servlet_uri.startsWith(this.servlet_context.uri)) {
                servlet_uri = Utils.concatURIs("/", servlet_uri.substring(this.servlet_context.uri.length()));
            }
            return this.process_servlet(uri, servlet_uri, servlet);
        }
        this.response.sendError(501);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean process_servlet_chain(String path_info, String script_name, String servlets) throws Exception {
        this.processExpect();
        InputStream is = this.request.requestInputStream.getInputStream();
        OutputStream os = this.response.responseOutputStream.getOutputStream();
        long available = this.request.requestInputStream.getBytesAvailable();
        try {
            this.request.path_info = path_info;
            this.request.script_name = script_name;
            if (servlets == null) {
                this.response.sendError(404);
                return false;
            }
            if ((servlets = servlets.trim()).length() == 0) {
                this.response.sendError(404);
                return false;
            }
            int count = DString.dcount(servlets, ',');
            this.in_servlet_chain = true;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.response.responseOutputStream._init(bos);
            this.servlet_chain_index = 0;
            while (this.servlet_chain_index < count) {
                block24: {
                    String servlet = DString.extract(servlets, ',', this.servlet_chain_index).trim();
                    try {
                        this.servlet_instance = ServletManager.loadServlet(this.servlet_context, servlet);
                    }
                    catch (ClassNotFoundException ex) {
                        this.response.sendError(404, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet"), servlet));
                        return false;
                    }
                    catch (UnavailableException ex) {
                        this.response.iStatus = 503;
                        int delay = ex.getUnavailableSeconds();
                        if (delay < 0) throw ex;
                        this.response.setIntHeader("Retry-After", delay);
                        throw ex;
                    }
                    if (this.servlet_instance == null) {
                        this.response.sendError(404, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet"), servlet));
                        return false;
                    }
                    this.response.setStatus(200);
                    if (this.servlet_chain_index != 0) {
                        byte[] barray = bos.toByteArray();
                        this.request.requestInputStream._init(new ByteArrayInputStream(barray));
                        this.request.requestInputStream.setBytesAvailable(barray.length);
                        this.request.headers.clear();
                        Enumeration e = this.response.headers.keys();
                        while (e.hasMoreElements()) {
                            String key = (String)e.nextElement();
                            Object obj = this.response.headers.get(key);
                            this.request.headers.put(Request.normalizeName(key), obj);
                        }
                    }
                    bos.reset();
                    this.response.responseOutputStream._init(bos);
                    this.request.whichInputStream = 0;
                    this.response.whichOutputStream = 0;
                    try {
                        if (this.servlet_instance.servlet instanceof SingleThreadModel) {
                            Servlet ex = this.servlet_instance.servlet;
                            synchronized (ex) {
                                this.servlet_instance.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
                                break block24;
                            }
                        }
                        this.servlet_instance.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
                    }
                    catch (UnavailableException ex) {
                        String name = this.servlet_instance.config.name;
                        int delay = ex.getUnavailableSeconds();
                        ServletManager.unavailable_servlets.put(name, new Delay(delay));
                        this.response.iStatus = 503;
                        if (ex.isPermanent()) {
                            ServletManager.unloadServlet(this.servlet_context, name);
                        }
                        if (delay < 0) throw ex;
                        this.response.setIntHeader("Retry-After", delay);
                        throw ex;
                    }
                }
                this.response.flush();
                this.response.responseWriter = null;
                if (this.servlet_chain_index == 0) {
                    available = this.request.requestInputStream.getBytesAvailable();
                }
                if (!this.in_servlet_chain) break;
                ++this.servlet_chain_index;
            }
            if (this.in_servlet_chain) {
                this.process_mime_chain(bos);
            }
            this.response.responseOutputStream._init(os);
            this.in_servlet_chain = false;
            this.response.setContentLength(bos.size());
            this.response.sendHeaders();
            this.response.responseOutputStream.write(bos.toByteArray());
            return true;
        }
        finally {
            this.response.responseWriter = null;
            if (this.in_servlet_chain) {
                this.in_servlet_chain = false;
                this.response.responseOutputStream._init(os);
            }
            this.request.whichInputStream = 0;
            this.response.whichOutputStream = 0;
            this.request.requestInputStream._init(is);
            this.request.requestInputStream.setBytesAvailable(available);
        }
    }

    private final boolean process_servlet_chain(String uri) throws Exception {
        String filter_uri = ServletManager.findFilter(uri);
        if (filter_uri != null) {
            String filters = ServletManager.getFilter(filter_uri);
            if (uri.length() == filter_uri.length()) {
                uri = null;
            } else if ((uri = uri.substring(filter_uri.length())).charAt(0) != '/') {
                uri = "/" + uri;
            }
            if (filter_uri.startsWith(this.servlet_context.uri)) {
                filter_uri = Utils.concatURIs("/", filter_uri.substring(this.servlet_context.uri.length()));
            }
            return this.process_servlet_chain(uri, filter_uri, filters);
        }
        String servlet_uri = ServletManager.findServlet(uri);
        if (servlet_uri != null) {
            if (uri.length() == servlet_uri.length()) {
                uri = null;
            } else if ((uri = uri.substring(servlet_uri.length())).charAt(0) != '/') {
                uri = "/" + uri;
            }
            String servlets = ServletManager.getServlet(servlet_uri);
            if (servlet_uri.startsWith(this.servlet_context.uri)) {
                servlet_uri = Utils.concatURIs("/", servlet_uri.substring(this.servlet_context.uri.length()));
            }
            return this.process_servlet_chain(uri, servlet_uri, servlets);
        }
        this.response.sendError(501);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void process_mime_chain(ByteArrayOutputStream bos) throws Exception {
        String tmimetype;
        String mimetype = this.response.getContentType();
        if (mimetype == null) {
            return;
        }
        do {
            block16: {
                String servlet;
                if ((servlet = ServletManager.getMime(mimetype)) == null) continue;
                try {
                    this.servlet_instance = ServletManager.loadServlet(this.servlet_context, servlet);
                }
                catch (ClassNotFoundException ex) {
                    this.response.sendError(404, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet"), servlet));
                    return;
                }
                catch (UnavailableException ex) {
                    this.response.iStatus = 503;
                    int delay = ex.getUnavailableSeconds();
                    if (delay >= 0) {
                        this.response.setIntHeader("Retry-After", delay);
                    }
                    throw ex;
                }
                if (this.servlet_instance == null) {
                    this.response.sendError(404, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Servlet"), servlet));
                    return;
                }
                this.response.setStatus(200);
                byte[] barray = bos.toByteArray();
                this.request.requestInputStream._init(new ByteArrayInputStream(barray));
                this.request.requestInputStream.setBytesAvailable(barray.length);
                this.request.headers.clear();
                Enumeration e = this.response.headers.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Object obj = this.response.headers.get(key);
                    this.request.headers.put(Request.normalizeName(key), obj);
                }
                bos.reset();
                this.response.responseOutputStream._init(bos);
                this.request.whichInputStream = 0;
                this.response.whichOutputStream = 0;
                try {
                    if (this.servlet_instance.servlet instanceof SingleThreadModel) {
                        Servlet ex = this.servlet_instance.servlet;
                        synchronized (ex) {
                            this.servlet_instance.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
                            break block16;
                        }
                    }
                    this.servlet_instance.servlet.service((ServletRequest)this.request, (ServletResponse)this.response);
                }
                catch (UnavailableException ex) {
                    String name = this.servlet_instance.config.name;
                    int delay = ex.getUnavailableSeconds();
                    ServletManager.unavailable_servlets.put(name, new Delay(delay));
                    this.response.iStatus = 503;
                    if (ex.isPermanent()) {
                        ServletManager.unloadServlet(this.servlet_context, name);
                    }
                    if (delay >= 0) {
                        this.response.setIntHeader("Retry-After", delay);
                    }
                    throw ex;
                }
            }
            this.response.flush();
            this.response.responseWriter = null;
            if (!this.in_servlet_chain) break;
        } while (!mimetype.equalsIgnoreCase(tmimetype = this.response.getContentType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean canAccess(String uri) throws Exception {
        boolean authenticates;
        String definition = RealmManager.getRealm(uri);
        if (definition == null) {
            return true;
        }
        if ((definition = definition.trim()).length() == 0) {
            this.response.sendError(401);
            return false;
        }
        int offset = definition.indexOf(38);
        if (offset == -1) {
            this.response.sendError(401, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Realm"), definition));
            return false;
        }
        String realm = definition.substring(0, offset);
        String acls = definition.substring(offset + 1);
        boolean contains_computers = RequestHandler.containsComputers(acls);
        boolean contains_users = RequestHandler.containsUsers(acls);
        if (!contains_computers && !contains_users) {
            this.response.sendError(401);
            return false;
        }
        try {
            this.realm_instance = RealmManager.loadRealm(realm);
        }
        catch (ClassNotFoundException ex) {
            this.response.sendError(401, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Realm"), realm));
            return false;
        }
        if (this.realm_instance == null) {
            this.response.sendError(401, iws.local_strings.getLocalString("err.was_not_found", iws.local_strings.getLocalString("Realm"), realm));
            return false;
        }
        String method = this.request.getMethod();
        if (contains_computers) {
            String hostname = iws.dns_lookup ? this.request.getRemoteHost() : this.socket.getInetAddress().getHostName();
            String ip_address = this.request.getRemoteAddr();
            if (this.realm_instance instanceof SingleThreadModel) {
                Realm realm2 = this.realm_instance;
                synchronized (realm2) {
                    authenticates = this.realm_instance.authenticateComputer(acls, hostname, ip_address, method);
                }
            } else {
                authenticates = this.realm_instance.authenticateComputer(acls, hostname, ip_address, method);
            }
            if (!authenticates) {
                this.response.sendError(401);
                return false;
            }
        }
        if (contains_users) {
            String scheme;
            authenticates = false;
            String authorization = this.request.getHeader("Authorization");
            if (authorization != null && (scheme = DString.extract(authorization, ' ', 0)).equalsIgnoreCase("Basic")) {
                String password;
                String username;
                offset = authorization.indexOf(32);
                String sValue = authorization.substring(offset + 1);
                byte[] bytes = Codecs.base64Decode(sValue.getBytes());
                String charset = this.request.getCharset();
                if (charset == null) {
                    charset = iws.default_charset;
                }
                if ((username = DString.extract(sValue = charset == null ? new String(bytes) : new String(bytes, charset), ':', 0)) == null) {
                    username = "";
                }
                if ((password = DString.extract(sValue, ':', 1)) == null) {
                    password = "";
                }
                this.request.setHeader("Remote-User", username);
                this.request.auth_user = username;
                this.request.auth_password = password;
                this.request.auth_type = scheme;
                if (this.realm_instance instanceof SingleThreadModel) {
                    Realm realm3 = this.realm_instance;
                    synchronized (realm3) {
                        authenticates = this.realm_instance.authenticateUser(acls, username, password, method);
                    }
                } else {
                    authenticates = this.realm_instance.authenticateUser(acls, username, password, method);
                }
            }
            if (!authenticates) {
                StringBuffer sb = new StringBuffer("Basic");
                sb.append(" realm=\"");
                sb.append(realm);
                sb.append("\"");
                this.response.setHeader("WWW-Authenticate", sb.toString());
                this.response.sendError(401);
                return false;
            }
        }
        return true;
    }

    private final void init() throws Exception {
        this.request.init(this.socket);
        this.response.init(this.socket);
    }

    private final void _wrapup() {
        this.in_servlet_chain = false;
        this.isAuthenticated = false;
        this.realm_instance = null;
        this.servlet_context = null;
        this.request._wrapup();
        this.response._wrapup();
    }

    private final void log() {
        if (!iws.logAccess) {
            return;
        }
        if (this.request == null) {
            return;
        }
        AccessLogEntry entry = new AccessLogEntry();
        entry.remoteAddress = this.request.getRemoteAddr();
        entry.remoteHost = this.request.getRemoteHost();
        entry.timestamp = System.currentTimeMillis();
        entry.remoteUser = this.request.getRemoteUser();
        entry.host = this.request.getServerName();
        entry.port = this.request.getServerPort();
        entry.localAddress = this.request.getLocalAddr();
        entry.contentLength = this.response.responseOutputStream.getBytesWritten();
        entry.requestLength = this.request.requestInputStream.getBytesRead();
        entry.responseTime = entry.timestamp - this.startTime;
        entry.statusCode = this.response.iStatus;
        entry.errorCode = 0;
        entry.requestMethod = this.request.getMethod();
        entry.baseURI = this.request.getRequestURI();
        entry.requestURI = this.request.raw_request_uri;
        entry.queryString = this.request.getQueryString();
        entry.userAgent = this.request.getHeader("User-Agent");
        entry.referer = this.request.getHeader("Referer");
        entry.protocol = this.request.getProtocol();
        entry.serverService = "W3SVC";
        iws.logger.log(entry);
    }

    private final boolean isSessionValid(String session_id, Session session, int session_source) {
        if (!session_id.equals(session.id)) {
            return false;
        }
        if (!iws.sessionStore.isDistributed() && iws.sessionCheckIpAddress && !session.remote_address.equals(this.socket.getInetAddress())) {
            return false;
        }
        if (iws.sessionCheckSessionSource && session_source != session.session_source) {
            return false;
        }
        return session.isValid();
    }

    private final Session getCookieSession() throws Exception {
        Cookie[] cookies = this.request.cookies;
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        String session_name = iws.sessionName;
        int length = cookies.length;
        int i = 0;
        while (i < length) {
            Cookie cookie = cookies[i];
            String session_id = cookie.getValue();
            Session session = iws.sessionStore.getSession(this.servlet_context, session_id);
            if (session != null) {
                if (this.isSessionValid(session_id, session, 2)) {
                    return session;
                }
                session._invalidate();
            }
            ++i;
        }
        return null;
    }

    private final Session getUrlSession() throws Exception {
        try {
            String url_key;
            String turl_sessionid;
            int offset = this.request.request_uri.indexOf(59);
            if (offset != -1 && (turl_sessionid = this.request.request_uri.substring(offset + 1)).startsWith(url_key = String.valueOf(iws.sessionName) + "=")) {
                this.request.request_uri = this.request.request_uri.substring(0, offset);
                String session_id = turl_sessionid.substring(url_key.length());
                Session session = iws.sessionStore.getSession(this.servlet_context, session_id);
                if (session != null) {
                    if (this.isSessionValid(session_id, session, 1)) {
                        return session;
                    }
                    session._invalidate();
                }
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private final void setSession() throws Exception {
        this.request.session = this.getCookieSession();
        if (this.request.session == null) {
            this.request.session = this.getUrlSession();
            if (this.request.session == null) {
                this.request.session_source = 0;
            } else {
                this.request.session_source = 1;
                this.request.session.access();
            }
        } else {
            this.request.session_source = 2;
            this.request.session.access();
        }
    }

    protected final void shutdown() {
        try {
            this.response.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.log();
        }
        catch (Exception ex) {
            iws.logger.log(ex);
        }
        this.request.close();
        this.response.close();
        if (this.socket != null) {
            try {
                iws.removeSocket(this.socket);
            }
            finally {
                try {
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {}
                }
                finally {
                    this.socket = null;
                }
            }
        }
    }

    private final void reset_keep_alive() {
        this.keepAlive = this.canKeepAlive();
    }

    protected final boolean canKeepAlive() {
        return iws.keepAlive && iws.server_protocol_version != 0;
    }

    private final void processExpect() throws IOException {
        String header;
        if (iws.server_protocol_version != 0 && this.request.server_protocol_version > 0 && (header = this.request.getHeader("Expect")) != null && header.equalsIgnoreCase("100-continue")) {
            this.response.responseOutputStream.write(ACK);
        }
    }

    private static final boolean containsComputers(String acls) {
        int count = DString.dcount(acls, ',');
        int i = 0;
        while (i < count) {
            String acl = DString.extract(acls, ',', i).trim().toLowerCase();
            if (acl.startsWith("hostname.") || acl.startsWith("ip_address.") || acl.startsWith("ip_range.")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean containsUsers(String acls) {
        int count = DString.dcount(acls, ',');
        int i = 0;
        while (i < count) {
            String acl = DString.extract(acls, ',', i).trim().toLowerCase();
            if (acl.startsWith("user.") || acl.startsWith("group.")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

