/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import stec.iws.Delay;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.ServletImpl;
import stec.iws.ServletManager;
import stec.iws.iws;

public final class RequestDispatcherImpl
implements RequestDispatcher {
    protected String raw_request_uri;
    protected String request_uri;
    protected String path_info;
    protected String script_name;
    protected String query_string;
    protected ServletImpl servlet_instance;

    public final void forward(ServletRequest _request, ServletResponse _response) throws ServletException, IOException {
        Request request = (Request)_request;
        Response response = (Response)_response;
        if (response.handler.in_servlet_chain) {
            response.reset();
        } else if (response.whichOutputStream != 0) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.unable_to_use"));
        }
        this.dispatcher(request, response);
    }

    public final void include(ServletRequest _request, ServletResponse _response) throws ServletException, IOException {
        Request request = (Request)_request;
        Response response = (Response)_response;
        Hashtable o_response_headers = response.headers;
        int o_length = response.getContentLength();
        response.flush();
        int o_whichOutputStream = response.whichOutputStream;
        PrintWriter o_responseWriter = response.responseWriter;
        response.whichOutputStream = 0;
        response.responseWriter = null;
        try {
            response.headers = new Hashtable();
            this.dispatcher(request, response);
        }
        finally {
            response.flush();
            response.whichOutputStream = o_whichOutputStream;
            response.responseWriter = o_responseWriter;
            int n_length = response.getContentLength();
            response.headers = o_response_headers;
            if (n_length > -1) {
                response.setContentLength(o_length + n_length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatcher(Request request, Response response) throws ServletException, IOException {
        block10: {
            String o_raw_request_uri = request.raw_request_uri;
            String o_request_uri = request.request_uri;
            String o_path_info = request.path_info;
            String o_script_name = request.script_name;
            String o_query_string = request.query_string;
            Hashtable o_params = request.params;
            response.flush();
            int o_whichOutputStream = response.whichOutputStream;
            PrintWriter o_responseWriter = response.responseWriter;
            request.raw_request_uri = this.raw_request_uri;
            request.request_uri = this.request_uri;
            request.path_info = this.path_info;
            request.script_name = this.script_name;
            request.query_string = this.query_string;
            request.params = null;
            try {
                try {
                    if (this.servlet_instance.servlet instanceof SingleThreadModel) {
                        Servlet servlet = this.servlet_instance.servlet;
                        synchronized (servlet) {
                            this.servlet_instance.servlet.service((ServletRequest)request, (ServletResponse)response);
                            break block10;
                        }
                    }
                    this.servlet_instance.servlet.service((ServletRequest)request, (ServletResponse)response);
                }
                catch (UnavailableException ex) {
                    String name = this.servlet_instance.config.name;
                    int delay = ex.getUnavailableSeconds();
                    ServletManager.unavailable_servlets.put(name, new Delay(delay));
                    if (ex.isPermanent()) {
                        ServletManager.unloadServlet(this.servlet_instance.config.context, name);
                    }
                    throw new ServletException(ex.getMessage());
                }
            }
            finally {
                request.raw_request_uri = o_raw_request_uri;
                request.request_uri = o_request_uri;
                request.path_info = o_path_info;
                request.script_name = o_script_name;
                request.query_string = o_query_string;
                request.params = o_params;
            }
        }
    }
}

