/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import stec.iws.RequestHandler;
import stec.iws.RequestInputStream;
import stec.iws.Response;
import stec.iws.ServletContextImpl;
import stec.iws.Session;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;
import stec.lang.QuickSort;

public final class Request
implements HttpServletRequest {
    protected String auth_type;
    protected String auth_user;
    protected String auth_password;
    protected String location;
    protected String server_software;
    protected String remote_host;
    protected String remote_addr;
    protected String server_name;
    protected int server_port;
    protected String request_method;
    protected String raw_request_uri;
    protected String request_uri;
    protected String query_string;
    protected String script_name;
    protected String server_protocol;
    protected String local_addr;
    protected String path_info;
    protected int server_protocol_version;
    Vector locales = new Vector();
    boolean locales_parsed;
    Vector charsets = new Vector();
    boolean charsets_parsed;
    String[] accept_content_types;
    boolean accept_content_types_parsed;
    String[] accept_content_encodings;
    boolean accept_content_encodings_parsed;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable headers = new Hashtable();
    protected Hashtable params;
    private boolean parse_params = true;
    private boolean inputRead = false;
    protected Cookie[] cookies = null;
    protected RequestInputStream requestInputStream;
    protected BufferedReader servletReader = null;
    protected int session_source = 0;
    protected Session session = null;
    protected int whichInputStream = 0;
    protected static final int NONE = 0;
    protected static final int SERVLET_READER = 1;
    protected static final int SERVLET_INPUT_STREAM = 2;
    protected RequestHandler handler;

    protected Request(RequestHandler _handler) {
        this.handler = _handler;
        this.requestInputStream = new RequestInputStream(this);
    }

    protected final void init(Socket _socket) throws Exception {
        if (iws.input_buffer_size < 0) {
            this.requestInputStream._init(new BufferedInputStream(_socket.getInputStream()));
        } else if (iws.input_buffer_size == 0) {
            this.requestInputStream._init(_socket.getInputStream());
        } else {
            this.requestInputStream._init(new BufferedInputStream(_socket.getInputStream(), iws.input_buffer_size));
        }
    }

    protected final int getRequest() throws Exception {
        int content_length;
        String value;
        this.server_protocol_version = 0;
        String header = this.requestInputStream._readHeader(true);
        if (header == null) {
            this.handler.response.headersSent = true;
            return 0;
        }
        if (header.length() == 0) {
            this.handler.response.headersSent = true;
            return 0;
        }
        int offset = header.indexOf(32);
        if (offset == -1) {
            throw new Exception(iws.local_strings.getLocalString("err.invalid_request", header));
        }
        this.request_method = header.substring(0, offset);
        int offset2 = header.lastIndexOf(32);
        if (offset2 == -1) {
            throw new Exception(iws.local_strings.getLocalString("err.invalid_request", header));
        }
        if (offset == offset2) {
            throw new Exception(iws.local_strings.getLocalString("err.invalid_request", header));
        }
        this.raw_request_uri = header.substring(offset + 1, offset2);
        offset = this.raw_request_uri.indexOf(63);
        if (offset == -1) {
            this.request_uri = this.raw_request_uri;
        } else {
            this.query_string = this.raw_request_uri.substring(offset + 1);
            this.request_uri = this.raw_request_uri.substring(0, offset);
        }
        this.server_protocol = header.substring(offset2 + 1);
        this.server_protocol_version = iws.server_protocol_version == -1 ? Utils.parseServerProtocolVersion(this.server_protocol) : iws.server_protocol_version;
        if (!this.request_uri.startsWith("/") && (offset = this.request_uri.indexOf("://")) != -1) {
            offset2 = this.request_uri.indexOf(47, offset + 3);
            this.request_uri = offset2 == -1 ? "/" : this.request_uri.substring(offset2);
        }
        int request_header_count = 1;
        while (true) {
            if (iws.shutdown) {
                return -1;
            }
            header = this.requestInputStream._readHeader(false);
            if (header == null || header.length() == 0) break;
            if (iws.max_request_header_count != -1 && ++request_header_count > iws.max_request_header_count) {
                Response cfr_ignored_0 = this.handler.response;
                this.handler.response.setStatus(413);
                throw new IOException(iws.local_strings.getLocalString("err.request_header_count_exceeds_maximum_request_header_count", String.valueOf(request_header_count), String.valueOf(iws.max_request_header_count)));
            }
            offset = header.indexOf(58);
            if (offset == -1) continue;
            String key = header.substring(0, offset);
            value = header.substring(offset + 1).trim();
            this.setHeader(key, value);
        }
        InetAddress inet_address = this.handler.socket.getLocalAddress();
        this.local_addr = inet_address.getHostAddress();
        String hostname = this.getHeader("Host");
        if (hostname == null) {
            if (iws.dns_lookup) {
                hostname = inet_address.getHostName();
                if (hostname.endsWith(".")) {
                    hostname = hostname.substring(0, hostname.length() - 1);
                }
            } else {
                hostname = this.local_addr;
            }
            this.server_port = iws.port;
        } else {
            offset = hostname.indexOf(93);
            offset = offset == -1 ? 0 : ++offset;
            offset = hostname.indexOf(58, offset);
            if (offset == -1) {
                this.server_port = iws.port;
            } else {
                value = hostname.substring(offset + 1);
                try {
                    this.server_port = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    this.server_port = -1;
                }
                hostname = hostname.substring(0, offset);
            }
        }
        if (hostname.startsWith("[")) {
            hostname = hostname.substring(1);
        }
        if (hostname.endsWith("]")) {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        this.server_name = hostname;
        inet_address = this.handler.socket.getInetAddress();
        this.remote_addr = value = inet_address.getHostAddress();
        if (iws.dns_lookup) {
            value = inet_address.getHostName();
        }
        this.remote_host = value;
        this.server_software = iws.SERVER_SOFTWARE;
        this.cookies = Utils.parseCookieHeader(this.getHeader("Cookie"));
        this.requestInputStream.setBytesAvailable(this.getContentLength());
        if (iws.max_request_content_length != -1 && (content_length = this.getContentLength()) != -1 && content_length > iws.max_request_content_length) {
            Response cfr_ignored_1 = this.handler.response;
            this.handler.response.setStatus(413);
            throw new IOException(iws.local_strings.getLocalString("err.request_content_length_exceeds_maximum_request_content_length", String.valueOf(content_length), String.valueOf(iws.max_request_content_length)));
        }
        return 1;
    }

    private final void parseAcceptLanguage() {
        if (this.locales_parsed) {
            return;
        }
        this.locales_parsed = true;
        String accept_language = this.getHeader("Accept-Language");
        if (accept_language == null) {
            this.locales.addElement(iws.default_locale);
            return;
        }
        Hashtable<Double, Vector<Locale>> ht = new Hashtable<Double, Vector<Locale>>();
        Vector v = new Vector();
        int count = DString.dcount(accept_language, ',');
        int i = 0;
        while (i < count) {
            String entry = DString.extract(accept_language, ',', i).trim();
            double quality_value = 1.0;
            int offset = entry.indexOf(";q=");
            if (offset != -1) {
                try {
                    quality_value = new Double(entry.substring(offset + 3));
                }
                catch (NumberFormatException ex) {
                    quality_value = 0.0;
                }
                entry = entry.substring(0, offset);
            }
            if (!(quality_value < 5.0E-5) && !entry.equals("*")) {
                String language = null;
                String country = null;
                offset = entry.indexOf(45);
                if (offset == -1) {
                    language = entry;
                    country = "";
                } else {
                    language = entry.substring(0, offset);
                    country = entry.substring(offset + 1);
                }
                Locale locale = new Locale(language, country);
                Double key = new Double(quality_value);
                Vector<Locale> values = (Vector<Locale>)ht.get(key);
                if (values == null) {
                    values = new Vector<Locale>();
                    ht.put(key, values);
                    v.addElement(key);
                }
                values.addElement(locale);
            }
            ++i;
        }
        if (v.size() > 1) {
            QuickSortDoubleVector qs = new QuickSortDoubleVector();
            v = qs.sort(v);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Double key = (Double)e.nextElement();
            Vector values = (Vector)ht.get(key);
            Enumeration te = values.elements();
            while (te.hasMoreElements()) {
                Locale locale = (Locale)te.nextElement();
                this.locales.addElement(locale);
            }
        }
        if (this.locales.size() == 0) {
            this.locales.addElement(iws.default_locale);
        }
    }

    private final void parseAcceptCharset() {
        if (this.charsets_parsed) {
            return;
        }
        this.charsets_parsed = true;
        String accept_charset = this.getHeader("Accept-Charset");
        if (accept_charset == null) {
            if (iws.default_charset == null) {
                this.charsets.addElement("ISO-8859-1");
            } else {
                this.charsets.addElement(iws.default_charset);
            }
            return;
        }
        Hashtable<Double, Vector<String>> ht = new Hashtable<Double, Vector<String>>();
        Vector v = new Vector();
        int count = DString.dcount(accept_charset, ',');
        int i = 0;
        while (i < count) {
            String entry = DString.extract(accept_charset, ',', i).trim();
            double quality_value = 1.0;
            int offset = entry.indexOf(";q=");
            if (offset != -1) {
                try {
                    quality_value = new Double(entry.substring(offset + 3));
                }
                catch (NumberFormatException ex) {
                    quality_value = 0.0;
                }
                entry = entry.substring(0, offset);
            }
            if (!(quality_value < 5.0E-5) && !entry.equals("*")) {
                String charset = entry;
                Double key = new Double(quality_value);
                Vector<String> values = (Vector<String>)ht.get(key);
                if (values == null) {
                    values = new Vector<String>();
                    ht.put(key, values);
                    v.addElement(key);
                }
                values.addElement(charset);
            }
            ++i;
        }
        if (v.size() > 1) {
            QuickSortDoubleVector qs = new QuickSortDoubleVector();
            v = qs.sort(v);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Double key = (Double)e.nextElement();
            Vector values = (Vector)ht.get(key);
            Enumeration te = values.elements();
            while (te.hasMoreElements()) {
                String charset = (String)te.nextElement();
                this.charsets.addElement(charset);
            }
        }
        if (this.charsets.size() == 0) {
            if (iws.default_charset == null) {
                this.charsets.addElement("ISO-8859-1");
            } else {
                this.charsets.addElement(iws.default_charset);
            }
        }
    }

    private final void parseAcceptContentTypes() {
        if (this.accept_content_types_parsed) {
            return;
        }
        this.accept_content_types_parsed = true;
        Vector<String> content_types = new Vector<String>();
        String value = this.getHeader("Accept");
        if (value == null) {
            this.accept_content_types = new String[0];
            return;
        }
        Hashtable<Double, Vector<String>> ht = new Hashtable<Double, Vector<String>>();
        Vector v = new Vector();
        int count = DString.dcount(value, ',');
        int i = 0;
        while (i < count) {
            String entry = DString.extract(value, ',', i).trim();
            double quality_value = 1.0;
            int offset = entry.indexOf(";q=");
            if (offset != -1) {
                try {
                    quality_value = new Double(entry.substring(offset + 3));
                }
                catch (NumberFormatException ex) {
                    quality_value = 0.0;
                }
                entry = entry.substring(0, offset);
            }
            if (!(quality_value < 5.0E-5 || entry.equals("*") || entry.equals("*/*"))) {
                String content_type = entry;
                Double key = new Double(quality_value);
                Vector<String> values = (Vector<String>)ht.get(key);
                if (values == null) {
                    values = new Vector<String>();
                    ht.put(key, values);
                    v.addElement(key);
                }
                values.addElement(content_type);
            }
            ++i;
        }
        if (v.size() > 1) {
            QuickSortDoubleVector qs = new QuickSortDoubleVector();
            v = qs.sort(v);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Double key = (Double)e.nextElement();
            Vector values = (Vector)ht.get(key);
            Enumeration te = values.elements();
            while (te.hasMoreElements()) {
                String content_type = (String)te.nextElement();
                content_types.addElement(content_type);
            }
        }
        this.accept_content_types = Request.toStringArray(content_types);
    }

    private final void parseAcceptContentEncodings() {
        if (this.accept_content_encodings_parsed) {
            return;
        }
        this.accept_content_encodings_parsed = true;
        Vector<String> content_encodings = new Vector<String>();
        String value = this.getHeader("Accept-Encoding");
        if (value == null) {
            this.accept_content_encodings = new String[0];
            return;
        }
        Hashtable<Double, Vector<String>> ht = new Hashtable<Double, Vector<String>>();
        Vector v = new Vector();
        int count = DString.dcount(value, ',');
        int i = 0;
        while (i < count) {
            String entry = DString.extract(value, ',', i).trim();
            double quality_value = 1.0;
            int offset = entry.indexOf(";q=");
            if (offset != -1) {
                try {
                    quality_value = new Double(entry.substring(offset + 3));
                }
                catch (NumberFormatException ex) {
                    quality_value = 0.0;
                }
                entry = entry.substring(0, offset);
            }
            if (!(quality_value < 5.0E-5) && !entry.equals("*")) {
                String content_encoding = entry;
                Double key = new Double(quality_value);
                Vector<String> values = (Vector<String>)ht.get(key);
                if (values == null) {
                    values = new Vector<String>();
                    ht.put(key, values);
                    v.addElement(key);
                }
                values.addElement(content_encoding);
            }
            ++i;
        }
        if (v.size() > 1) {
            QuickSortDoubleVector qs = new QuickSortDoubleVector();
            v = qs.sort(v);
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Double key = (Double)e.nextElement();
            Vector values = (Vector)ht.get(key);
            Enumeration te = values.elements();
            while (te.hasMoreElements()) {
                String content_encoding = (String)te.nextElement();
                content_encodings.addElement(content_encoding);
            }
        }
        this.accept_content_encodings = Request.toStringArray(content_encodings);
    }

    private static final String[] toStringArray(Vector v) {
        int size = v.size();
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            array[i] = (String)v.elementAt(i);
            ++i;
        }
        return array;
    }

    protected final void _wrapup() {
        if (this.servletReader != null) {
            try {
                this.servletReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.servletReader = null;
        this.whichInputStream = 0;
        this.auth_type = null;
        this.auth_user = null;
        this.auth_password = null;
        this.location = null;
        this.server_software = null;
        this.remote_host = null;
        this.remote_addr = null;
        this.server_name = null;
        this.server_port = -1;
        this.request_method = null;
        this.raw_request_uri = null;
        this.request_uri = null;
        this.query_string = null;
        this.script_name = null;
        this.server_protocol = null;
        this.local_addr = null;
        this.locales.removeAllElements();
        this.locales_parsed = false;
        this.charsets.removeAllElements();
        this.charsets_parsed = false;
        this.accept_content_types = null;
        this.accept_content_types_parsed = false;
        this.accept_content_encodings = null;
        this.accept_content_encodings_parsed = false;
        this.cookies = null;
        this.attributes.clear();
        this.headers.clear();
        this.params = null;
        this.parse_params = true;
        this.inputRead = false;
        this.session_source = 0;
        this.session = null;
    }

    public final String getAuthType() {
        return this.auth_type;
    }

    public final Cookie[] getCookies() {
        return this.cookies;
    }

    public final String getHeader(String name) {
        Object obj = this.headers.get(Request.normalizeName(name));
        if (obj == null) {
            return null;
        }
        return ((String[])obj)[0];
    }

    public final int getIntHeader(String name) throws NumberFormatException {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public final long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        return Utils.parseDate(value);
    }

    public final Enumeration getHeaders(String name) {
        Object obj = this.headers.get(Request.normalizeName(name));
        if (obj == null) {
            return null;
        }
        String[] values = (String[])obj;
        int length = values.length;
        Vector<String> v = new Vector<String>(length);
        int i = 0;
        while (i < length) {
            v.addElement(values[i]);
            ++i;
        }
        return v.elements();
    }

    public final Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    protected final void setHeader(String key, String value) {
        Utils.setHeader(this.headers, Request.normalizeName(key), value);
    }

    public final String getMethod() {
        return this.request_method;
    }

    public final String getPathInfo() {
        return this.path_info;
    }

    public final String getPathTranslated() {
        if (this.path_info == null) {
            return null;
        }
        try {
            return Utils.translatePath(this.server_name, this.path_info);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String getContextPath() {
        String uri = this.handler.servlet_instance.config.context.uri;
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public final String getQueryString() {
        return this.query_string;
    }

    public final String getRemoteUser() {
        if (this.handler.isAuthenticated) {
            return this.getHeader("Remote-User");
        }
        return null;
    }

    public final boolean isUserInRole(String groupname) {
        if (this.handler.isAuthenticated) {
            try {
                return this.handler.realm_instance.checkGroup(groupname, this.getRemoteUser());
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public final Principal getUserPrincipal() {
        if (this.handler.isAuthenticated && this.handler.realm_instance != null) {
            return this.handler.realm_instance.getPrincipal(this.getRemoteUser());
        }
        return null;
    }

    public final String getRequestedSessionId() {
        return this.session == null ? null : this.session.id;
    }

    public final String getRequestURI() {
        return this.request_uri;
    }

    public final StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = iws.port;
        }
        url.append(scheme);
        url.append("://");
        String server_name = this.getServerName();
        if (server_name.indexOf(58) == -1) {
            url.append(server_name);
        } else {
            url.append('[');
            url.append(server_name);
            url.append(']');
        }
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public final String getServletPath() {
        return this.script_name;
    }

    public final HttpSession getSession() {
        return this.getSession(true);
    }

    public final HttpSession getSession(boolean create) {
        if (this.session != null) {
            if (this.session.isValid()) {
                return this.session;
            }
            this.session = null;
        }
        if (create) {
            try {
                this.session = iws.sessionStore.createSession(this.handler);
                return this.session;
            }
            catch (Exception ex) {
                iws.logger.log(iws.local_strings.getLocalString("err.unable_to_create_session", ex.getMessage()));
            }
        }
        return null;
    }

    public final boolean isRequestedSessionIdValid() {
        if (this.session == null) {
            return false;
        }
        if (this.session.isValid()) {
            return true;
        }
        this.session = null;
        return false;
    }

    public final boolean isRequestedSessionIdFromCookie() {
        return this.session_source == 2;
    }

    public final boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public final boolean isRequestedSessionIdFromURL() {
        return this.session_source == 1;
    }

    public final Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public final Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public final void setAttribute(String name, Object obj) {
        this.attributes.put(name, obj);
    }

    public final void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public final Locale getLocale() {
        this.parseAcceptLanguage();
        return (Locale)this.locales.elementAt(0);
    }

    public final Enumeration getLocales() {
        this.parseAcceptLanguage();
        return this.locales.elements();
    }

    protected final Vector _getLocales() {
        this.parseAcceptLanguage();
        return this.locales;
    }

    public final String getCharset() {
        this.parseAcceptCharset();
        return (String)this.charsets.elementAt(0);
    }

    public final Enumeration getCharsets() {
        this.parseAcceptCharset();
        return this.charsets.elements();
    }

    protected final Vector _getCharsets() {
        this.parseAcceptCharset();
        return this.charsets;
    }

    public final String getCharacterEncoding() {
        String charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
        return Utils.parseCharacterEncoding(this.getContentType(), charset);
    }

    protected final String[] _getAcceptContentTypes() {
        this.parseAcceptContentTypes();
        return this.accept_content_types;
    }

    protected final String[] _getAcceptContentEncodings() {
        this.parseAcceptContentEncodings();
        return this.accept_content_encodings;
    }

    public final int getContentLength() {
        String value = this.getHeader("Content-Length");
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public final String getContentType() {
        return this.getHeader("Content-Type");
    }

    public final String getLocalAddr() {
        return this.local_addr;
    }

    public final ServletInputStream getInputStream() throws IOException {
        if (this.whichInputStream == 1) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.has_already_been_called", "getReader()"));
        }
        this.whichInputStream = 2;
        this.inputRead = true;
        return this.requestInputStream;
    }

    private final void parseQueryString(String charset) {
        this.params = this.query_string == null ? new Hashtable(1) : Utils.decodeParameters(Utils.getParameters(this), charset);
    }

    private final void parseParams() {
        if (this.parse_params) {
            String method;
            this.parse_params = false;
            String charset = this.getCharset();
            if (charset == null) {
                charset = iws.default_charset;
            }
            if ((method = this.getMethod()).equals("GET")) {
                this.parseQueryString(charset);
            } else if (method.equals("POST")) {
                ServletInputStream is;
                this.parseQueryString(charset);
                if (this.inputRead) {
                    return;
                }
                this.inputRead = true;
                try {
                    is = this.getInputStream();
                }
                catch (Exception ex) {
                    return;
                }
                this.params = Utils.mergeParameters(Utils.decodeParameters((InputStream)is, this.getContentLength(), charset), this.params);
            }
        }
    }

    public final void setParameters(Hashtable ht) {
        this.parse_params = false;
        this.params = ht;
    }

    public final String getParameter(String name) {
        this.parseParams();
        Object obj = this.params.get(name);
        if (obj == null) {
            return null;
        }
        return ((String[])obj)[0];
    }

    public final Enumeration getParameterNames() {
        this.parseParams();
        return this.params.keys();
    }

    public final String[] getParameterValues(String name) {
        this.parseParams();
        Object obj = this.params.get(name);
        if (obj == null) {
            return null;
        }
        return (String[])obj;
    }

    public final String getProtocol() {
        return this.server_protocol;
    }

    public int getServerProtocolVersion() {
        return this.server_protocol_version;
    }

    public void getServerProtocolVersion(int _server_protocol_version) {
        this.server_protocol_version = _server_protocol_version;
    }

    public final BufferedReader getReader() throws IOException {
        if (this.whichInputStream == 2) {
            throw new IllegalStateException(iws.local_strings.getLocalString("err.has_already_been_called", "getInputStream()"));
        }
        if (this.servletReader == null) {
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
            }
            this.servletReader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.requestInputStream), Utils.parseCharacterEncoding(this.getContentType(), charset)));
            this.whichInputStream = 1;
            this.inputRead = true;
        }
        return this.servletReader;
    }

    public final String getRealPath(String path) {
        try {
            return Utils.translatePath(this.server_name, path);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public final String getRemoteAddr() {
        return this.remote_addr;
    }

    public final String getRemoteHost() {
        return this.remote_host;
    }

    public final String getScheme() {
        if (this.isSecure()) {
            return "https";
        }
        return "http";
    }

    public final boolean isSecure() {
        return iws.ssl;
    }

    public final RequestDispatcher getRequestDispatcher(String path) {
        ServletContextImpl servlet_context = this.handler.servlet_instance.config.context;
        if (Utils.isAbsolute(path)) {
            path = Utils.normalizeURI(path);
        } else {
            int offset = this.script_name.lastIndexOf(47);
            path = offset == -1 ? Utils.concatURIs("/", path) : Utils.concatURIs(this.script_name.substring(servlet_context.uri.length(), offset), path);
            path = Utils.normalizeURI(path);
        }
        return servlet_context.getRequestDispatcher(this.server_name, path);
    }

    public final String getServerName() {
        return this.server_name;
    }

    public final int getServerPort() {
        return this.server_port;
    }

    protected static final String normalizeName(String _name) {
        StringBuffer sb = new StringBuffer();
        boolean change = true;
        int length = _name.length();
        int i = 0;
        while (i < length) {
            char chr = _name.charAt(i);
            if (change) {
                chr = Character.toUpperCase(chr);
                change = false;
            } else {
                chr = Character.toLowerCase(chr);
            }
            sb.append(chr);
            if (chr == '-') {
                change = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public final Socket getSocket() {
        return this.handler.socket;
    }

    protected final void close() {
        if (this.requestInputStream != null) {
            try {
                this.requestInputStream._close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final class QuickSortDoubleVector
    extends QuickSort {
        QuickSortDoubleVector() {
        }

        public final Vector sort(Vector items) {
            return (Vector)super.sort(items);
        }

        @Override
        public final int compare(Object object1, Object object2) {
            double d2;
            double d1 = (Double)object1;
            if (d1 < (d2 = ((Double)object2).doubleValue())) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
            long d1bits = Double.doubleToLongBits(d1);
            long d2bits = Double.doubleToLongBits(d2);
            return d2bits == d2bits ? 0 : (d2bits < d2bits ? 1 : -1);
        }

        @Override
        public final int count(Object objects) {
            return ((Vector)objects).size();
        }

        @Override
        public final Object extract(Object objects, int index) {
            return ((Vector)objects).elementAt(index);
        }

        @Override
        public final void replace(Object objects, int index, Object object) {
            ((Vector)objects).setElementAt(object, index);
        }
    }
}

