/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.math.BigInteger;
import java.security.Principal;
import java.util.Hashtable;
import stec.iws.iws;
import stec.lang.DString;

public abstract class Realm {
    Hashtable init_parameters;

    public void init(Hashtable _init_parameters) throws Exception {
        this.init_parameters = _init_parameters;
    }

    public void destroy() {
    }

    public abstract boolean authenticateUser(String var1, String var2, String var3, String var4) throws Exception;

    public abstract boolean authenticateComputer(String var1, String var2, String var3, String var4) throws Exception;

    public abstract boolean checkGroup(String var1, String var2) throws Exception;

    public abstract Principal getPrincipal(String var1);

    public static boolean checkRange(String _range, String _ip_address) throws Exception {
        boolean address_is_ipv6;
        boolean range_is_ipv6 = _range.indexOf(58) != -1;
        boolean bl = address_is_ipv6 = _ip_address.indexOf(58) != -1;
        if (range_is_ipv6 != address_is_ipv6) {
            return false;
        }
        if (_ip_address.indexOf(58) == -1) {
            return Realm.checkIPv4Range(_range, _ip_address);
        }
        return Realm.checkIPv6Range(_range, _ip_address);
    }

    private static long parseIPv4Address(String _ip_address) throws Exception {
        if (DString.dcount(_ip_address, '.') != 4) {
            throw new NumberFormatException();
        }
        String tvalue = DString.extract(_ip_address, '.', 0);
        int ivalue = Integer.parseInt(tvalue);
        long lvalue = ivalue;
        lvalue <<= 8;
        tvalue = DString.extract(_ip_address, '.', 1);
        ivalue = Integer.parseInt(tvalue);
        lvalue += (long)ivalue;
        lvalue <<= 8;
        tvalue = DString.extract(_ip_address, '.', 2);
        ivalue = Integer.parseInt(tvalue);
        lvalue += (long)ivalue;
        lvalue <<= 8;
        tvalue = DString.extract(_ip_address, '.', 3);
        ivalue = Integer.parseInt(tvalue);
        return lvalue += (long)ivalue;
    }

    private static boolean checkIPv4Range(String _range, String _ip_address) throws Exception {
        if (_range.indexOf(45) == -1) {
            int count = DString.dcount(_ip_address, '.');
            if (DString.dcount(_range, '.') != count) {
                return false;
            }
            int i = 0;
            while (i < count) {
                String ivalue;
                String rvalue = DString.extract(_range, '.', i);
                if (!rvalue.equals("*") && !(ivalue = DString.extract(_ip_address, '.', i)).equals(rvalue)) {
                    return false;
                }
                ++i;
            }
        } else {
            long address;
            long erange;
            long srange;
            String value = DString.extract(_range, '-', 0).trim();
            try {
                srange = Realm.parseIPv4Address(value);
            }
            catch (NumberFormatException ex) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_range", _range));
            }
            value = DString.extract(_range, '-', 1).trim();
            try {
                erange = Realm.parseIPv4Address(value);
            }
            catch (NumberFormatException ex) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_range", _range));
            }
            if (srange > erange) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_range", _range));
            }
            try {
                address = Realm.parseIPv4Address(_ip_address);
            }
            catch (NumberFormatException ex) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_ip_address", _ip_address));
            }
            if (address < srange || address > erange) {
                return false;
            }
        }
        return true;
    }

    private static BigInteger parseIPv6Address(String _ip_address) throws Exception {
        if (DString.dcount(_ip_address, ':') != 8) {
            throw new NumberFormatException();
        }
        String tvalue = DString.extract(_ip_address, ':', 0);
        int ivalue = Integer.parseInt(tvalue, 16);
        BigInteger lvalue = new BigInteger(String.valueOf(ivalue));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 1);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 2);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 3);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 4);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 5);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 6);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        lvalue = lvalue.shiftLeft(16);
        tvalue = DString.extract(_ip_address, ':', 7);
        ivalue = Integer.parseInt(tvalue, 16);
        lvalue = lvalue.add(new BigInteger(String.valueOf(ivalue)));
        return lvalue;
    }

    private static boolean checkIPv6Range(String _range, String _ip_address) throws Exception {
        if (_range.indexOf(45) == -1) {
            int count = DString.dcount(_ip_address, ':');
            if (DString.dcount(_range, ':') != count) {
                return false;
            }
            int i = 0;
            while (i < count) {
                String ivalue;
                String rvalue = DString.extract(_range, ':', i);
                if (!rvalue.equals("*") && !(ivalue = DString.extract(_ip_address, ':', i)).equals(rvalue)) {
                    return false;
                }
                ++i;
            }
        } else {
            BigInteger address;
            BigInteger erange;
            BigInteger srange;
            String value = DString.extract(_range, '-', 0).trim();
            try {
                srange = Realm.parseIPv6Address(value);
            }
            catch (NumberFormatException ex) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_range", _range));
            }
            value = DString.extract(_range, '-', 1).trim();
            try {
                erange = Realm.parseIPv6Address(value);
            }
            catch (NumberFormatException ex) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_range", _range));
            }
            if (srange.compareTo(erange) > 0) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_range", _range));
            }
            try {
                address = Realm.parseIPv6Address(_ip_address);
            }
            catch (NumberFormatException ex) {
                throw new Exception(iws.local_strings.getLocalString("err.invalid_ip_address", _ip_address));
            }
            if (address.compareTo(srange) < 0 || address.compareTo(erange) > 0) {
                return false;
            }
        }
        return true;
    }
}

