/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.Logger;
import stec.iws.Utils;
import stec.pos.Blob;
import stec.pos.ByteArray;
import stec.xpos.ObjectStore;
import stec.xpos.ObjectStoreReference;

public final class PosLogger
extends Logger {
    private static final int TIMESTAMP_LENGTH = 8;
    private static final int PORT_LENGTH = 4;
    private static final int CONTENT_LENGTH_LENGTH = 8;
    private static final int REQUEST_LENGTH_LENGTH = 8;
    private static final int RESPONSE_TIME_LENGTH = 8;
    private static final int STATUS_CODE_LENGTH = 4;
    private static final int ERROR_CODE_LENGTH = 4;
    private static final String BASEDIR = "./databases";
    private ObjectStoreReference server_reference;
    private ObjectStoreReference errors_reference;
    private ObjectStoreReference events_reference;
    private ObjectStoreReference access_reference;
    private long errors_counter;
    private long events_counter;
    private long access_counter;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        super.init(_parameters);
        try {
            long capacity;
            Object obj = _parameters.get("errors_store");
            String object_store = obj == null ? Utils.concatPaths(BASEDIR, "/errors.store") : ((String[])obj)[0];
            object_store = Utils.getAbsolutePath(object_store);
            if (!ObjectStore.exists((String)object_store)) {
                obj = _parameters.get("errors_capacity");
                if (obj == null) {
                    capacity = 65536L;
                } else {
                    capacity = Long.parseLong(((String[])obj)[0]);
                    if (capacity < 1L) {
                        throw new IllegalArgumentException("errors_capacity must be at least 1: " + capacity);
                    }
                }
                ObjectStore.create((String)object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)9, (int)1024, (boolean)false);
            }
            this.errors_reference = ObjectStore.open((String)object_store, (boolean)false);
            obj = _parameters.get("events_store");
            object_store = obj == null ? Utils.concatPaths(BASEDIR, "/events.store") : ((String[])obj)[0];
            if (!ObjectStore.exists((String)(object_store = Utils.getAbsolutePath(object_store)))) {
                obj = _parameters.get("events_capacity");
                if (obj == null) {
                    capacity = 65536L;
                } else {
                    capacity = Long.parseLong(((String[])obj)[0]);
                    if (capacity < 1L) {
                        throw new IllegalArgumentException("events_capacity must be at least 1: " + capacity);
                    }
                }
                ObjectStore.create((String)object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)9, (int)128, (boolean)false);
            }
            this.events_reference = ObjectStore.open((String)object_store, (boolean)false);
            obj = _parameters.get("access_store");
            object_store = obj == null ? Utils.concatPaths(BASEDIR, "/access.store") : ((String[])obj)[0];
            if (!ObjectStore.exists((String)(object_store = Utils.getAbsolutePath(object_store)))) {
                obj = _parameters.get("access_capacity");
                if (obj == null) {
                    capacity = 65536L;
                } else {
                    capacity = Long.parseLong(((String[])obj)[0]);
                    if (capacity < 1L) {
                        throw new IllegalArgumentException("access_capacity must be at least 1: " + capacity);
                    }
                }
                ObjectStore.create((String)object_store, (long)capacity, (long)-1L, (long)-1L, (long)-1L, (int)9, (int)512, (boolean)false);
            }
            this.access_reference = ObjectStore.open((String)object_store, (boolean)false);
            obj = _parameters.get("server_store");
            object_store = obj == null ? Utils.concatPaths(BASEDIR, "/iws.store") : ((String[])obj)[0];
            if (!ObjectStore.exists((String)(object_store = Utils.getAbsolutePath(object_store)))) {
                ObjectStore.create((String)object_store, (long)15L, (long)-1L, (long)-1L, (long)-1L, (int)10, (int)9, (boolean)false);
            }
            this.server_reference = ObjectStore.open((String)object_store, (boolean)false);
            obj = this.server_reference.get((Object)"errors");
            this.errors_counter = obj == null ? 0L : (Long)obj;
            obj = this.server_reference.get((Object)"events");
            this.events_counter = obj == null ? 0L : (Long)obj;
            obj = this.server_reference.get((Object)"access");
            this.access_counter = obj == null ? 0L : (Long)obj;
        }
        catch (Exception ex) {
            this._destroy();
            throw ex;
        }
    }

    @Override
    public final void output(AccessLogEntry entry) throws Exception {
        if (entry.remoteAddress == null) {
            entry.remoteAddress = "";
        }
        if (entry.remoteHost == null) {
            entry.remoteHost = "";
        }
        if (entry.remoteUser == null) {
            entry.remoteUser = "";
        }
        if (entry.host == null) {
            entry.host = "";
        }
        if (entry.localAddress == null) {
            entry.localAddress = "";
        }
        if (entry.requestMethod == null) {
            entry.requestMethod = "";
        }
        if (entry.requestURI == null) {
            entry.requestURI = "";
        }
        if (entry.queryString == null) {
            entry.queryString = "";
        }
        if (entry.userAgent == null) {
            entry.userAgent = "";
        }
        if (entry.referer == null) {
            entry.referer = "";
        }
        if (entry.protocol == null) {
            entry.protocol = "";
        }
        if (entry.serverService == null) {
            entry.serverService = "";
        }
        int remote_address_length = ByteArray.getUtf8StringLength((String)entry.remoteAddress);
        int remote_host_length = ByteArray.getUtf8StringLength((String)entry.remoteHost);
        int remote_user_length = ByteArray.getUtf8StringLength((String)(entry.remoteUser == null ? "" : entry.remoteUser));
        int host_length = ByteArray.getUtf8StringLength((String)entry.host);
        int local_address_length = ByteArray.getUtf8StringLength((String)entry.localAddress);
        int request_method_length = ByteArray.getUtf8StringLength((String)entry.requestMethod);
        int request_uri_length = ByteArray.getUtf8StringLength((String)entry.requestURI);
        int query_string_length = ByteArray.getUtf8StringLength((String)entry.queryString);
        int user_agent_length = ByteArray.getUtf8StringLength((String)entry.userAgent);
        int referer_length = ByteArray.getUtf8StringLength((String)entry.referer);
        int protocol_length = ByteArray.getUtf8StringLength((String)entry.protocol);
        int server_service_length = ByteArray.getUtf8StringLength((String)entry.serverService);
        int length = 8 + remote_address_length + remote_host_length + remote_user_length + host_length + 4 + local_address_length + 8 + 8 + 8 + 4 + 4 + request_method_length + request_uri_length + query_string_length + user_agent_length + referer_length + protocol_length + server_service_length;
        byte[] bytes = new byte[length];
        int offset = 0;
        ByteArray.setLong((byte[])bytes, (int)offset, (long)entry.timestamp);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += 8), (String)entry.remoteAddress);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += remote_address_length), (String)entry.remoteHost);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += remote_host_length), (String)entry.remoteUser);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += remote_user_length), (String)entry.host);
        ByteArray.setInt((byte[])bytes, (int)(offset += host_length), (int)(entry.port == -1 ? 80 : entry.port));
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += 4), (String)entry.localAddress);
        ByteArray.setLong((byte[])bytes, (int)(offset += local_address_length), (long)(entry.contentLength == -1L ? 0L : entry.contentLength));
        ByteArray.setLong((byte[])bytes, (int)(offset += 8), (long)entry.requestLength);
        ByteArray.setLong((byte[])bytes, (int)(offset += 8), (long)entry.responseTime);
        ByteArray.setInt((byte[])bytes, (int)(offset += 8), (int)entry.statusCode);
        ByteArray.setInt((byte[])bytes, (int)(offset += 4), (int)entry.errorCode);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += 4), (String)entry.requestMethod);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += request_method_length), (String)entry.requestURI);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += request_uri_length), (String)entry.queryString);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += query_string_length), (String)entry.userAgent);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += user_agent_length), (String)entry.referer);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += referer_length), (String)entry.protocol);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += protocol_length), (String)entry.serverService);
        Blob blob = new Blob(bytes);
        this.access_reference.put((Object)new Long(this.access_counter), (Object)blob);
        ++this.access_counter;
        this.server_reference.put((Object)"access", (Object)new Long(this.access_counter));
    }

    @Override
    public final void output(EventLogEntry entry) throws Exception {
        if (entry.message == null) {
            entry.message = "";
        }
        int message_length = ByteArray.getUtf8StringLength((String)entry.message);
        int length = 8 + message_length;
        byte[] bytes = new byte[length];
        int offset = 0;
        ByteArray.setLong((byte[])bytes, (int)offset, (long)entry.timestamp);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += 8), (String)entry.message);
        Blob blob = new Blob(bytes);
        this.events_reference.put((Object)new Long(this.events_counter), (Object)blob);
        ++this.events_counter;
        this.server_reference.put((Object)"events", (Object)new Long(this.events_counter));
    }

    @Override
    public final void output(ErrorLogEntry entry) throws Exception {
        if (entry.message == null) {
            entry.message = "";
        }
        System.err.println(entry.message);
        Utils.printStackTrace(System.err, entry.error);
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        Utils.printStackTrace(writer, entry.error);
        String exception = String.valueOf(buf);
        int message_length = ByteArray.getUtf8StringLength((String)entry.message);
        int exception_length = ByteArray.getUtf8StringLength((String)exception);
        int length = 8 + message_length + exception_length;
        byte[] bytes = new byte[length];
        int offset = 0;
        ByteArray.setLong((byte[])bytes, (int)offset, (long)entry.timestamp);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += 8), (String)entry.message);
        ByteArray.setUtf8String((byte[])bytes, (int)(offset += message_length), (String)exception);
        Blob blob = new Blob(bytes);
        this.errors_reference.put((Object)new Long(this.errors_counter), (Object)blob);
        ++this.errors_counter;
        this.server_reference.put((Object)"errors", (Object)new Long(this.errors_counter));
    }

    @Override
    public final synchronized void destroy() {
        try {
            super.destroy();
        }
        finally {
            this._destroy();
        }
    }

    public final void _destroy() {
        if (this.access_reference != null) {
            try {
                this.access_reference.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.access_reference = null;
        }
        if (this.errors_reference != null) {
            try {
                this.errors_reference.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.errors_reference = null;
        }
        if (this.events_reference != null) {
            try {
                this.events_reference.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.events_reference = null;
        }
        if (this.server_reference != null) {
            try {
                this.server_reference.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.server_reference = null;
        }
    }
}

