/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.Logger;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public abstract class OutputStreamLogger
extends Logger {
    private static final String NONE = "-";
    private static final String DELIMITER = ", ";
    public PrintStream accesslog = null;
    public PrintStream errorslog = null;
    public PrintStream eventslog = null;
    public String accessLogTemplate;
    public String accessLogHeaderTemplate;

    @Override
    public void init(Hashtable _parameters) throws Exception {
        String value;
        super.init(_parameters);
        Hashtable accessLogTemplates = Utils.getConfig("./templates.ini");
        Object obj = _parameters.get("access_log_header_template");
        if (obj != null) {
            value = ((String[])obj)[0];
            if ((obj = accessLogTemplates.get(value)) == null) {
                throw new Exception(iws.local_strings.getLocalString("err.was_not_found", "access_log_header_template", value));
            }
            this.accessLogHeaderTemplate = (String)obj;
        }
        if ((value = (obj = _parameters.get("access_log_template")) == null ? "default" : ((String[])obj)[0]).equalsIgnoreCase("none")) {
            this.accessLogTemplate = null;
            return;
        }
        obj = accessLogTemplates.get(value);
        if (obj == null) {
            obj = accessLogTemplates.get("default");
        }
        if (obj == null) {
            throw new Exception(iws.local_strings.getLocalString("err.was_not_found", "access_log_template", value));
        }
        this.accessLogTemplate = (String)obj;
    }

    public String convertToString(AccessLogEntry entry) {
        Date dt = new Date(entry.timestamp);
        if (this.accessLogTemplate == null) {
            String hostname;
            StringBuffer sb = new StringBuffer();
            sb.append(entry.remoteAddress == null ? NONE : entry.remoteAddress);
            sb.append(DELIMITER);
            sb.append(entry.remoteHost == null ? NONE : entry.remoteHost);
            sb.append(DELIMITER);
            sb.append(OutputStreamLogger.formatTimeDateStamp(dt, "MM/dd/yy"));
            sb.append(DELIMITER);
            sb.append(OutputStreamLogger.formatTimeDateStamp(dt, "HH:mm:ss"));
            sb.append(DELIMITER);
            sb.append(entry.remoteUser == null ? NONE : entry.remoteUser);
            sb.append(DELIMITER);
            String string = hostname = entry.host == null ? NONE : entry.host;
            if (hostname.indexOf(58) == -1) {
                sb.append(hostname);
            } else {
                sb.append('[');
                sb.append(hostname);
                sb.append(']');
            }
            sb.append(':');
            sb.append(String.valueOf(entry.port == -1 ? 80 : entry.port));
            sb.append(DELIMITER);
            sb.append(entry.localAddress == null ? NONE : entry.localAddress);
            sb.append(DELIMITER);
            sb.append(String.valueOf(entry.contentLength == -1L ? 0L : entry.contentLength));
            sb.append(DELIMITER);
            sb.append(String.valueOf(entry.requestLength));
            sb.append(DELIMITER);
            sb.append(String.valueOf(entry.responseTime));
            sb.append(DELIMITER);
            sb.append(String.valueOf(entry.statusCode));
            sb.append(DELIMITER);
            sb.append(String.valueOf(entry.errorCode));
            sb.append(DELIMITER);
            sb.append(entry.requestMethod == null ? NONE : entry.requestMethod);
            sb.append(DELIMITER);
            sb.append(entry.requestURI == null ? NONE : entry.requestURI);
            sb.append(DELIMITER);
            sb.append(entry.userAgent == null ? NONE : entry.userAgent);
            sb.append(DELIMITER);
            sb.append(entry.referer == null ? NONE : entry.referer);
            sb.append(DELIMITER);
            sb.append(entry.protocol == null ? NONE : entry.protocol);
            sb.append(DELIMITER);
            sb.append(entry.serverService == null ? NONE : entry.serverService);
            return sb.toString();
        }
        String svalue = this.accessLogTemplate;
        svalue = DString.replace(svalue, "%remote_address%", entry.remoteAddress == null ? NONE : entry.remoteAddress);
        svalue = DString.replace(svalue, "%remote_host%", entry.remoteHost == null ? NONE : entry.remoteHost);
        svalue = DString.replace(svalue, "%date%", OutputStreamLogger.formatTimeDateStamp(dt, "MM/dd/yy"));
        svalue = DString.replace(svalue, "%ldate%", OutputStreamLogger.formatTimeDateStamp(dt, "MM/dd/yyyy"));
        svalue = DString.replace(svalue, "%xdate%", OutputStreamLogger.formatTimeDateStamp(dt, "yyyy-MM-dd"));
        svalue = DString.replace(svalue, "%edate%", OutputStreamLogger.formatTimeDateStamp(dt, "yyyy/MM/dd"));
        svalue = DString.replace(svalue, "%time%", OutputStreamLogger.formatTimeDateStamp(dt, "HH:mm:ss"));
        svalue = DString.replace(svalue, "%timestamp%", OutputStreamLogger.formatTimeDateStamp(dt, "MM/dd/yyyy:HH:mm:ss zzz"));
        svalue = DString.replace(svalue, "%xtimestamp%", OutputStreamLogger.formatTimeDateStamp(dt, "dd/MMM/yyyy:HH:mm:ss zzz"));
        svalue = DString.replace(svalue, "%remote_user%", entry.remoteUser == null ? NONE : entry.remoteUser);
        svalue = DString.replace(svalue, "%host%", entry.host == null ? NONE : entry.host);
        svalue = DString.replace(svalue, "%port%", String.valueOf(entry.port == -1 ? 80 : entry.port));
        svalue = DString.replace(svalue, "%local_address%", entry.localAddress == null ? NONE : entry.localAddress);
        svalue = DString.replace(svalue, "%content_length%", String.valueOf(entry.contentLength == -1L ? 0L : entry.contentLength));
        svalue = DString.replace(svalue, "%request_length%", String.valueOf(entry.requestLength));
        svalue = DString.replace(svalue, "%response_time%", String.valueOf(entry.responseTime));
        svalue = DString.replace(svalue, "%status_code%", String.valueOf(entry.statusCode));
        svalue = DString.replace(svalue, "%error_code%", String.valueOf(entry.errorCode));
        svalue = DString.replace(svalue, "%request_method%", entry.requestMethod == null ? NONE : entry.requestMethod);
        svalue = DString.replace(svalue, "%request_uri%", entry.requestURI == null ? NONE : entry.requestURI);
        svalue = DString.replace(svalue, "%base_uri%", entry.baseURI == null ? NONE : entry.baseURI);
        svalue = DString.replace(svalue, "%query_string%", entry.queryString == null ? NONE : entry.queryString);
        svalue = DString.replace(svalue, "%user_agent%", entry.userAgent == null ? NONE : entry.userAgent);
        svalue = DString.replace(svalue, "%xuser_agent%", entry.userAgent == null ? NONE : DString.replace(entry.userAgent, " ", "+"));
        svalue = DString.replace(svalue, "%referer%", entry.referer == null ? NONE : entry.referer);
        svalue = DString.replace(svalue, "%protocol%", entry.protocol == null ? NONE : entry.protocol);
        svalue = DString.replace(svalue, "%server_service%", entry.serverService == null ? NONE : entry.serverService);
        return svalue;
    }

    public String convertHeaderToString() {
        String svalue = this.accessLogHeaderTemplate;
        Date dt = new Date();
        svalue = DString.replace(svalue, "%date%", OutputStreamLogger.formatTimeDateStamp(dt, "MM/dd/yy"));
        svalue = DString.replace(svalue, "%ldate%", OutputStreamLogger.formatTimeDateStamp(dt, "MM/dd/yyyy"));
        svalue = DString.replace(svalue, "%xdate%", OutputStreamLogger.formatTimeDateStamp(dt, "yyyy-MM-dd"));
        svalue = DString.replace(svalue, "%edate%", OutputStreamLogger.formatTimeDateStamp(dt, "yyyy/MM/dd"));
        svalue = DString.replace(svalue, "%time%", OutputStreamLogger.formatTimeDateStamp(dt, "HH:mm:ss"));
        svalue = DString.replace(svalue, "%logo%", iws.getLogo());
        return svalue;
    }

    public static String formatTimeDateStamp(Date dt, String mask) {
        SimpleDateFormat formatter = new SimpleDateFormat(mask);
        return formatter.format(dt);
    }
}

