/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import stec.iws.IOHandler;
import stec.iws.IOManager;
import stec.iws.SocketHandler;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public final class JsseSecureSocketHandler
extends SocketHandler {
    private boolean authenticate_client;
    private String protocol;
    private String key_algorithm;
    private String keystore_file;
    private String keystore_type;
    private String keystore_password;
    private String provider_classfile;
    private String[] cipher_suites;
    private String[] supported_cipher_suites;

    @Override
    public final ServerSocket getServerSocket(int port, int backlog, String ip_address) throws Exception {
        ServerSocket obj;
        this.check_version();
        this.loadKeystoreConfig();
        Class<?> cls = Class.forName(this.provider_classfile);
        Provider provider = (Provider)cls.newInstance();
        Security.addProvider(provider);
        KeyStore keystore = KeyStore.getInstance(this.keystore_type);
        String keystoreFile = Utils.getAbsolutePath(iws.configdir, "keystore.db");
        IOHandler handler = IOManager.getHandler(keystoreFile);
        keystore.load(handler.getInputStream(), this.keystore_password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)this.key_algorithm);
        kmf.init(keystore, this.keystore_password.toCharArray());
        SSLContext ctx = SSLContext.getInstance((String)this.protocol);
        ctx.init(kmf.getKeyManagers(), null, null);
        SSLServerSocketFactory socket_factory = ctx.getServerSocketFactory();
        if (ip_address == null) {
            obj = backlog == -1 ? socket_factory.createServerSocket(port) : socket_factory.createServerSocket(port, backlog);
        } else {
            if (backlog == -1) {
                backlog = 50;
            }
            obj = socket_factory.createServerSocket(port, backlog, InetAddress.getByName(ip_address));
        }
        SSLServerSocket serverSocket = (SSLServerSocket)obj;
        if (this.cipher_suites != null) {
            serverSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        serverSocket.setNeedClientAuth(this.authenticate_client);
        return serverSocket;
    }

    private final void loadKeystoreConfig() throws Exception {
        String value;
        int count;
        this.authenticate_client = false;
        this.protocol = "TLS";
        this.key_algorithm = "SunX509";
        this.keystore_file = "keystore.db";
        this.keystore_type = "JKS";
        this.keystore_password = "password";
        this.provider_classfile = "com.sun.net.ssl.internal.ssl.Provider";
        Hashtable ht = Utils.getConfig("./keystore.ini");
        Object obj = ht.get("protocol");
        if (obj != null) {
            this.protocol = (String)obj;
        }
        if ((obj = ht.get("key_algorithm")) != null) {
            this.key_algorithm = (String)obj;
        }
        if ((obj = ht.get("authenticate_client")) != null) {
            this.authenticate_client = ((String)obj).equalsIgnoreCase("y");
        }
        if ((obj = ht.get("keystore_file")) != null) {
            this.keystore_file = (String)obj;
        }
        if ((obj = ht.get("keystore_type")) != null) {
            this.keystore_type = (String)obj;
        }
        if ((obj = ht.get("keystore_password")) != null) {
            this.keystore_password = (String)obj;
        }
        if ((obj = ht.get("provider_classfile")) != null) {
            this.provider_classfile = (String)obj;
        }
        if ((obj = ht.get("cipher_suites")) != null && (count = DString.dcount(value = ((String)obj).trim(), ',')) > 0) {
            this.cipher_suites = new String[count];
            int i = 0;
            while (i < count) {
                this.cipher_suites[i] = DString.extract(value, ',', i).trim();
                ++i;
            }
        }
    }

    @Override
    public final Socket getSocket(String hostname, int port) throws Exception {
        this.check_version();
        SSLSocketFactory socket_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        return socket_factory.createSocket(hostname, port);
    }

    private final void check_version() throws Exception {
        String value = System.getProperty("java.version");
        if (value.charAt(0) == '1' && value.charAt(2) < '2') {
            throw new Exception(iws.local_strings.getLocalString("err.ssl_requires_java_version"));
        }
    }
}

