/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import stec.iws.ArchiveIOHandler;
import stec.iws.FileIOHandler;
import stec.iws.IOHandler;
import stec.iws.iws;

public final class IOManager {
    public static final IOHandler getHandler(String path) throws IOException {
        if (iws.inArchive) {
            return new ArchiveIOHandler(path);
        }
        return new FileIOHandler(path);
    }

    public static final IOHandler getHandler(String path, String filename) throws IOException {
        String value = path.toLowerCase();
        if (value.endsWith(".jar") || value.endsWith(".zip")) {
            return new ArchiveIOHandler(path, filename);
        }
        return new FileIOHandler(path, filename);
    }

    public static final IOHandler getHandler(IOHandler handler, String filename) throws IOException {
        if (handler instanceof ArchiveIOHandler) {
            return new ArchiveIOHandler(handler, filename);
        }
        return new FileIOHandler(handler, filename);
    }
}

