/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import stec.iws.FileCache;
import stec.iws.FileIOHandler;
import stec.iws.IOHandler;
import stec.iws.IOManager;
import stec.iws.Request;
import stec.iws.Response;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;
import stec.lang.QuickSort;

public final class FileServlet
extends HttpServlet {
    private static final String DIRECTORY_TEMPLATE = "./directory.html";
    private static final String DIRECTORY_ITEM_TEMPLATE = "./directory_item.tf";
    private static final String LOCAL_DIRECTORY_TEMPLATE = "./directory.html";
    private static final int SORT_BY_NAME = 0;
    private static final int SORT_BY_TYPE = 1;
    private static final int SORT_BY_SIZE = 2;
    private static final int SORT_BY_MODIFIED = 3;
    private static final int FSIZELEN = 10;
    private static final String DIRECTORY_ITEM_TAG = "%list%";
    private String directoryItemTemplate;
    private FileCache fileCache;
    private boolean sort_directory_listing = true;
    private String sort_field_name = "Name";
    private boolean sort_descending;
    private boolean sort_ignore_case = true;
    private int read_buffer_size;
    private String default_language;
    private String default_charset;
    private boolean use_redirect = true;
    private boolean directory_access;
    private boolean display_icons;
    private boolean include_hidden;
    private String parent_folder_icon;
    private String default_folder_icon;
    private String default_folder_type;

    public final void init(ServletConfig _config) throws ServletException {
        super.init(_config);
        try {
            this.directoryItemTemplate = Utils.getTemplate(DIRECTORY_ITEM_TEMPLATE);
            int buffer_size = iws.output_buffer_size;
            String value = _config.getInitParameter("read_buffer_size");
            if (value != null && (value = value.trim()).length() > 0) {
                try {
                    buffer_size = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(iws.local_strings.getLocalString("err.must_be_numeric", "read_buffer_size", value));
                }
            }
            if (buffer_size < 0) {
                this.read_buffer_size = iws.output_buffer_size;
                if (this.read_buffer_size < 0) {
                    this.read_buffer_size = 8192;
                }
            } else {
                this.read_buffer_size = buffer_size < 512 ? 512 : buffer_size;
            }
            int cacheSize = 4;
            value = _config.getInitParameter("cache_size");
            if (value != null && (value = value.trim()).length() > 0) {
                try {
                    cacheSize = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(iws.local_strings.getLocalString("err.must_be_numeric", "cache_size", value));
                }
            }
            if (cacheSize > 0) {
                this.fileCache = new FileCache(cacheSize * 0x100000);
                String files = _config.getInitParameter("files");
                if (files != null && (files = files.trim()).length() > 0) {
                    int count = DString.dcount(files, ',');
                    int i = 0;
                    while (i < count) {
                        String filename = DString.extract(files, ',', i).trim();
                        this.fileCache.get(IOManager.getHandler(filename));
                        ++i;
                    }
                }
            }
            if ((value = _config.getInitParameter("use_redirect")) != null) {
                this.use_redirect = value.equalsIgnoreCase("y");
            }
            if ((value = _config.getInitParameter("directory_access")) != null) {
                this.directory_access = value.equalsIgnoreCase("y");
            }
            if (this.directory_access) {
                value = _config.getInitParameter("display_icons");
                if (value != null) {
                    this.display_icons = value.equalsIgnoreCase("y");
                }
                if (this.display_icons) {
                    this.parent_folder_icon = _config.getInitParameter("parent_folder_icon");
                    if (this.parent_folder_icon == null) {
                        this.parent_folder_icon = iws.local_strings.getLocalString("parent_folder_icon");
                    }
                    this.default_folder_icon = _config.getInitParameter("default_folder_icon");
                    if (this.default_folder_icon == null) {
                        this.default_folder_icon = iws.local_strings.getLocalString("default_folder_icon");
                    }
                    this.default_folder_type = _config.getInitParameter("default_folder_type");
                    if (this.default_folder_type == null) {
                        this.default_folder_type = iws.local_strings.getLocalString("default_folder_type");
                    }
                }
                if ((value = _config.getInitParameter("include_hidden")) != null) {
                    this.include_hidden = value.equalsIgnoreCase("y");
                }
                if ((value = _config.getInitParameter("sort")) != null) {
                    this.sort_directory_listing = value.equalsIgnoreCase("y");
                }
                if (this.sort_directory_listing) {
                    value = _config.getInitParameter("sort_field_name");
                    this.sort_field_name = value == null ? "Name" : value;
                    value = _config.getInitParameter("sort_descending");
                    if (value != null) {
                        this.sort_descending = value.equalsIgnoreCase("y");
                    }
                    if ((value = _config.getInitParameter("sort_ignore_case")) != null) {
                        this.sort_ignore_case = value.equalsIgnoreCase("y");
                    }
                }
            }
            if (iws.content_negotiation) {
                this.default_language = iws.default_language == null ? "en" : iws.default_language;
                this.default_charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
            }
        }
        catch (IOException ex) {
            throw new ServletException(ex.getMessage());
        }
    }

    public final void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException {
        int version;
        Response response;
        Request request;
        IOHandler handler;
        boolean headersOnly;
        String method = _request.getMethod();
        if (method.equals("GET") || method.equals("POST")) {
            headersOnly = false;
        } else if (method.equals("HEAD")) {
            headersOnly = true;
        } else {
            _response.sendError(405);
            return;
        }
        String filename = _request.getPathTranslated();
        if (filename == null) {
            filename = Utils.translatePath(_request.getServerName(), "/");
        }
        if ((handler = this.getBestHandler(request = (Request)_request, response = (Response)_response, filename)) == null) {
            if (!iws.content_negotiation && this.fileCache != null) {
                this.fileCache.remove(IOManager.getHandler(filename));
            }
            if (iws.content_negotiation) {
                _response.sendError(406);
            } else {
                _response.sendError(404);
            }
            return;
        }
        boolean conditional = false;
        String sdt = _request.getHeader("If-Modified-Since");
        if (sdt != null) {
            long ldt = Utils.parseDate(sdt);
            if (handler.lastModified() <= ldt) {
                headersOnly = true;
                conditional = true;
            }
        }
        if ((version = request.getServerProtocolVersion()) > 0 && (sdt = _request.getHeader("If-Unmodified-Since")) != null) {
            long ldt = Utils.parseDate(sdt);
            if (handler.lastModified() > ldt) {
                headersOnly = true;
                conditional = true;
            }
        }
        if (handler.isDirectory() && iws.default_pages != null) {
            int length = iws.default_pages.length;
            int i = 0;
            while (i < length) {
                String default_page = iws.default_pages[i];
                IOHandler thandler = this.getBestHandler(request, response, handler, default_page);
                if (thandler != null) {
                    handler = thandler;
                    if (this.use_redirect) {
                        String uri = _request.getRequestURI();
                        int offset = uri.indexOf(63);
                        if (offset != -1) {
                            uri = uri.substring(0, offset);
                        }
                        String location = Utils.normalizeURI(uri);
                        StringBuffer sb = new StringBuffer(location);
                        if (!location.endsWith("/")) {
                            sb.append('/');
                        }
                        sb.append(default_page);
                        _response.sendRedirect(sb.toString());
                        return;
                    }
                }
                ++i;
            }
        }
        if (handler.isDirectory()) {
            if (!this.directory_access) {
                if (iws.obscure_server) {
                    _response.sendError(404);
                } else {
                    _response.sendError(403);
                }
                return;
            }
            this.sendDirectory(request, response, handler, headersOnly);
        } else if (version > 0) {
            this.sendFile_1_1(request, response, handler, headersOnly);
        } else {
            this.sendFile_1_0(request, response, handler, headersOnly);
        }
        if (conditional) {
            response.setStatus(304);
            response.headers.remove("Content-Length");
        }
    }

    private final IOHandler getBestHandler(Request request, Response response, String filename) throws IOException {
        IOHandler handler;
        int content_encoding_extensions_count;
        String[] content_encoding_extensions;
        String accept_content_encoding;
        int charset_length;
        String charset;
        int language_length;
        int content_length;
        Object obj;
        response.headers.remove("Content-Type");
        response.headers.remove("Content-Language");
        response.headers.remove("Content-Encoding");
        if (iws.send_vary) {
            response.headers.remove("Vary");
        }
        if (!iws.content_negotiation) {
            IOHandler handler2 = IOManager.getHandler(filename);
            if (!handler2.exists()) {
                return null;
            }
            if (!handler2.isDirectory()) {
                StringBuffer sb = new StringBuffer(iws.getMimeType(filename));
                if (iws.default_charset != null) {
                    sb.append("; charset=");
                    sb.append(iws.default_charset);
                }
                response.setContentType(sb.toString());
                if (iws.default_language != null) {
                    response.setHeader("Content-Language", iws.default_language);
                }
            }
            return handler2;
        }
        StringBuffer sb = new StringBuffer(filename);
        int filename_length = sb.length();
        Vector locales = request._getLocales();
        Vector charsets = request._getCharsets();
        int locales_count = locales.size();
        int charsets_count = charsets.size();
        String[] accept_content_encodings = request._getAcceptContentEncodings();
        int accept_content_encodings_count = accept_content_encodings.length;
        String[] accept_content_types = request._getAcceptContentTypes();
        int accept_content_types_count = accept_content_types.length;
        int content_type_index = 0;
        while (content_type_index < accept_content_types_count) {
            String accept_content_type = accept_content_types[content_type_index];
            obj = iws.content_types.get(accept_content_type);
            if (obj != null) {
                String[] content_type_extensions = (String[])obj;
                int content_type_extensions_count = content_type_extensions.length;
                int content_type_extension_index = 0;
                while (content_type_extension_index < content_type_extensions_count) {
                    sb.append(content_type_extensions[content_type_extension_index]);
                    content_length = sb.length();
                    int locale_index = 0;
                    while (locale_index < locales_count) {
                        Locale locale = (Locale)locales.elementAt(locale_index);
                        String language = locale.getLanguage();
                        sb.append('.');
                        sb.append(language);
                        language_length = sb.length();
                        int charset_index = 0;
                        while (charset_index < charsets_count) {
                            charset = (String)charsets.elementAt(charset_index);
                            sb.append('.');
                            sb.append(charset);
                            charset_length = sb.length();
                            int content_encoding_index = 0;
                            while (content_encoding_index < accept_content_encodings_count) {
                                accept_content_encoding = accept_content_encodings[content_encoding_index];
                                obj = iws.content_encodings.get(accept_content_encoding);
                                if (obj != null) {
                                    content_encoding_extensions = (String[])obj;
                                    content_encoding_extensions_count = content_encoding_extensions.length;
                                    int content_encoding_extension_index = 0;
                                    while (content_encoding_extension_index < content_encoding_extensions_count) {
                                        sb.append(content_encoding_extensions[content_encoding_extension_index]);
                                        handler = IOManager.getHandler(sb.toString());
                                        if (handler.exists() && !handler.isDirectory()) {
                                            response.setContentType(String.valueOf(accept_content_type) + "; charset=" + charset);
                                            response.setHeader("Content-Language", language);
                                            response.setHeader("Content-Encoding", accept_content_encoding);
                                            if (iws.send_vary) {
                                                response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset,accept-encoding");
                                            }
                                            return handler;
                                        }
                                        sb.setLength(charset_length);
                                        ++content_encoding_extension_index;
                                    }
                                }
                                ++content_encoding_index;
                            }
                            handler = IOManager.getHandler(sb.toString());
                            if (handler.exists() && !handler.isDirectory()) {
                                response.setContentType(String.valueOf(accept_content_type) + "; charset=" + charset);
                                response.setHeader("Content-Language", language);
                                if (iws.send_vary) {
                                    response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset");
                                }
                                return handler;
                            }
                            sb.setLength(language_length);
                            ++charset_index;
                        }
                        int content_encoding_index = 0;
                        while (content_encoding_index < accept_content_encodings_count) {
                            accept_content_encoding = accept_content_encodings[content_encoding_index];
                            obj = iws.content_encodings.get(accept_content_encoding);
                            if (obj != null) {
                                content_encoding_extensions = (String[])obj;
                                content_encoding_extensions_count = content_encoding_extensions.length;
                                int content_encoding_extension_index = 0;
                                while (content_encoding_extension_index < content_encoding_extensions_count) {
                                    sb.append(content_encoding_extensions[content_encoding_extension_index]);
                                    handler = IOManager.getHandler(sb.toString());
                                    if (handler.exists() && !handler.isDirectory()) {
                                        response.setContentType(accept_content_type);
                                        response.setHeader("Content-Language", language);
                                        response.setHeader("Content-Encoding", accept_content_encoding);
                                        if (iws.send_vary) {
                                            response.setHeader("Vary", "negotiate,accept,accept_language,accept-encoding");
                                        }
                                        return handler;
                                    }
                                    sb.setLength(language_length);
                                    ++content_encoding_extension_index;
                                }
                            }
                            ++content_encoding_index;
                        }
                        handler = IOManager.getHandler(sb.toString());
                        if (handler.exists() && !handler.isDirectory()) {
                            response.setContentType(accept_content_type);
                            response.setHeader("Content-Language", language);
                            if (iws.send_vary) {
                                response.setHeader("Vary", "negotiate,accept,accept_language");
                            }
                            return handler;
                        }
                        sb.setLength(content_length);
                        ++locale_index;
                    }
                    int content_encoding_index = 0;
                    while (content_encoding_index < accept_content_encodings_count) {
                        accept_content_encoding = accept_content_encodings[content_encoding_index];
                        obj = iws.content_encodings.get(accept_content_encoding);
                        if (obj != null) {
                            content_encoding_extensions = (String[])obj;
                            content_encoding_extensions_count = content_encoding_extensions.length;
                            int content_encoding_extension_index = 0;
                            while (content_encoding_extension_index < content_encoding_extensions_count) {
                                sb.append(content_encoding_extensions[content_encoding_extension_index]);
                                handler = IOManager.getHandler(sb.toString());
                                if (handler.exists() && !handler.isDirectory()) {
                                    response.setContentType(accept_content_type);
                                    response.setHeader("Content-Encoding", accept_content_encoding);
                                    if (iws.send_vary) {
                                        response.setHeader("Vary", "negotiate,accept,accept-encoding");
                                    }
                                    return handler;
                                }
                                sb.setLength(content_length);
                                ++content_encoding_extension_index;
                            }
                        }
                        ++content_encoding_index;
                    }
                    handler = IOManager.getHandler(sb.toString());
                    if (handler.exists() && !handler.isDirectory()) {
                        response.setContentType(accept_content_type);
                        if (iws.send_vary) {
                            response.setHeader("Vary", "negotiate,accept");
                        }
                        return handler;
                    }
                    sb.setLength(filename_length);
                    ++content_type_extension_index;
                }
            }
            ++content_type_index;
        }
        int locale_index = 0;
        while (locale_index < locales_count) {
            Locale locale = (Locale)locales.elementAt(locale_index);
            String language = locale.getLanguage();
            sb.append('.');
            sb.append(language);
            language_length = sb.length();
            int charset_index = 0;
            while (charset_index < charsets_count) {
                charset = (String)charsets.elementAt(charset_index);
                sb.append('.');
                sb.append(charset);
                charset_length = sb.length();
                int content_encoding_index = 0;
                while (content_encoding_index < accept_content_encodings_count) {
                    accept_content_encoding = accept_content_encodings[content_encoding_index];
                    obj = iws.content_encodings.get(accept_content_encoding);
                    if (obj != null) {
                        content_encoding_extensions = (String[])obj;
                        content_encoding_extensions_count = content_encoding_extensions.length;
                        int content_encoding_extension_index = 0;
                        while (content_encoding_extension_index < content_encoding_extensions_count) {
                            sb.append(content_encoding_extensions[content_encoding_extension_index]);
                            handler = IOManager.getHandler(sb.toString());
                            if (handler.exists() && !handler.isDirectory()) {
                                response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + charset);
                                response.setHeader("Content-Language", language);
                                response.setHeader("Content-Encoding", accept_content_encoding);
                                if (iws.send_vary) {
                                    response.setHeader("Vary", "negotiate,accept_language,accept-charset,accept-encoding");
                                }
                                return handler;
                            }
                            sb.setLength(charset_length);
                            ++content_encoding_extension_index;
                        }
                    }
                    ++content_encoding_index;
                }
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + charset);
                    response.setHeader("Content-Language", language);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept_language,accept-charset");
                    }
                    return handler;
                }
                sb.setLength(language_length);
                ++charset_index;
            }
            int content_encoding_index = 0;
            while (content_encoding_index < accept_content_encodings_count) {
                accept_content_encoding = accept_content_encodings[content_encoding_index];
                obj = iws.content_encodings.get(accept_content_encoding);
                if (obj != null) {
                    content_encoding_extensions = (String[])obj;
                    content_encoding_extensions_count = content_encoding_extensions.length;
                    int content_encoding_extension_index = 0;
                    while (content_encoding_extension_index < content_encoding_extensions_count) {
                        sb.append(content_encoding_extensions[content_encoding_extension_index]);
                        handler = IOManager.getHandler(sb.toString());
                        if (handler.exists() && !handler.isDirectory()) {
                            response.setContentType(iws.getMimeType(filename));
                            response.setHeader("Content-Language", language);
                            response.setHeader("Content-Encoding", accept_content_encoding);
                            if (iws.send_vary) {
                                response.setHeader("Vary", "negotiate,accept_language,accept-encoding");
                            }
                            return handler;
                        }
                        sb.setLength(language_length);
                        ++content_encoding_extension_index;
                    }
                }
                ++content_encoding_index;
            }
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Language", language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language");
                }
                return handler;
            }
            sb.setLength(filename_length);
            ++locale_index;
        }
        if (iws.default_content_type != null && (obj = iws.content_types.get(iws.default_content_type[1])) != null) {
            String content_type = iws.default_content_type[0];
            sb.append(content_type);
            content_length = sb.length();
            sb.append('.');
            sb.append(this.default_language);
            language_length = sb.length();
            sb.append('.');
            sb.append(this.default_charset);
            charset_length = sb.length();
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(String.valueOf(content_type) + "; charset=" + this.default_charset);
                    response.setHeader("Content-Language", this.default_language);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(charset_length);
            }
            if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(String.valueOf(content_type) + "; charset=" + this.default_charset);
                response.setHeader("Content-Language", this.default_language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset");
                }
                return handler;
            }
            sb.setLength(language_length);
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(content_type);
                    response.setHeader("Content-Language", this.default_language);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept_language,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(language_length);
            }
            if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(content_type);
                response.setHeader("Content-Language", this.default_language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept,accept_language");
                }
                return handler;
            }
            sb.setLength(content_length);
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(content_type);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(content_length);
            }
            if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(content_type);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept");
                }
                return handler;
            }
        }
        sb.append('.');
        sb.append(this.default_language);
        language_length = sb.length();
        sb.append('.');
        sb.append(this.default_charset);
        charset_length = sb.length();
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + this.default_charset);
                response.setHeader("Content-Language", this.default_language);
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language,accept-charset,accept-encoding");
                }
                return handler;
            }
            sb.setLength(charset_length);
        }
        if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
            response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + this.default_charset);
            response.setHeader("Content-Language", this.default_language);
            if (iws.send_vary) {
                response.setHeader("Vary", "negotiate,accept_language,accept-charset");
            }
            return handler;
        }
        sb.setLength(language_length);
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Language", this.default_language);
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language,accept-encoding");
                }
                return handler;
            }
            sb.setLength(language_length);
        }
        if ((handler = IOManager.getHandler(sb.toString())).exists() && !handler.isDirectory()) {
            response.setContentType(iws.getMimeType(filename));
            response.setHeader("Content-Language", this.default_language);
            if (iws.send_vary) {
                response.setHeader("Vary", "negotiate,accept_language");
            }
            return handler;
        }
        sb.setLength(filename_length);
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept-encoding");
                }
                return handler;
            }
            sb.setLength(filename_length);
        }
        int content_encoding_index = 0;
        while (content_encoding_index < accept_content_encodings_count) {
            accept_content_encoding = accept_content_encodings[content_encoding_index];
            obj = iws.content_encodings.get(accept_content_encoding);
            if (obj != null) {
                content_encoding_extensions = (String[])obj;
                content_encoding_extensions_count = content_encoding_extensions.length;
                int content_encoding_extension_index = 0;
                while (content_encoding_extension_index < content_encoding_extensions_count) {
                    sb.append(content_encoding_extensions[content_encoding_extension_index]);
                    handler = IOManager.getHandler(sb.toString());
                    if (handler.exists() && !handler.isDirectory()) {
                        response.setContentType(iws.getMimeType(filename));
                        response.setHeader("Content-Encoding", accept_content_encoding);
                        if (iws.send_vary) {
                            response.setHeader("Vary", "negotiate,accept-encoding");
                        }
                        return handler;
                    }
                    sb.setLength(filename_length);
                    ++content_encoding_extension_index;
                }
            }
            ++content_encoding_index;
        }
        handler = IOManager.getHandler(filename);
        if (handler.exists()) {
            if (!handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
            }
            return handler;
        }
        return null;
    }

    private final IOHandler getBestHandler(Request request, Response response, IOHandler base_handler, String filename) throws IOException {
        IOHandler handler;
        int content_encoding_extensions_count;
        String[] content_encoding_extensions;
        String accept_content_encoding;
        int charset_length;
        String charset;
        int language_length;
        int content_length;
        Object obj;
        response.headers.remove("Content-Type");
        response.headers.remove("Content-Language");
        response.headers.remove("Content-Encoding");
        if (iws.send_vary) {
            response.headers.remove("Vary");
        }
        if (!iws.content_negotiation) {
            IOHandler handler2 = IOManager.getHandler(base_handler, filename);
            if (!handler2.exists() || handler2.isDirectory()) {
                return null;
            }
            StringBuffer sb = new StringBuffer(iws.getMimeType(filename));
            if (iws.default_charset != null) {
                sb.append("; charset=");
                sb.append(iws.default_charset);
            }
            response.setContentType(sb.toString());
            if (iws.default_language != null) {
                response.setHeader("Content-Language", iws.default_language);
            }
            return handler2;
        }
        StringBuffer sb = new StringBuffer(filename);
        int filename_length = sb.length();
        Vector locales = request._getLocales();
        Vector charsets = request._getCharsets();
        int locales_count = locales.size();
        int charsets_count = charsets.size();
        String[] accept_content_encodings = request._getAcceptContentEncodings();
        int accept_content_encodings_count = accept_content_encodings.length;
        String[] accept_content_types = request._getAcceptContentTypes();
        int accept_content_types_count = accept_content_types.length;
        int content_type_index = 0;
        while (content_type_index < accept_content_types_count) {
            String accept_content_type = accept_content_types[content_type_index];
            obj = iws.content_types.get(accept_content_type);
            if (obj != null) {
                String[] content_type_extensions = (String[])obj;
                int content_type_extensions_count = content_type_extensions.length;
                int content_type_extension_index = 0;
                while (content_type_extension_index < content_type_extensions_count) {
                    sb.append(content_type_extensions[content_type_extension_index]);
                    content_length = sb.length();
                    int locale_index = 0;
                    while (locale_index < locales_count) {
                        Locale locale = (Locale)locales.elementAt(locale_index);
                        String language = locale.getLanguage();
                        sb.append('.');
                        sb.append(language);
                        language_length = sb.length();
                        int charset_index = 0;
                        while (charset_index < charsets_count) {
                            charset = (String)charsets.elementAt(charset_index);
                            sb.append('.');
                            sb.append(charset);
                            charset_length = sb.length();
                            int content_encoding_index = 0;
                            while (content_encoding_index < accept_content_encodings_count) {
                                accept_content_encoding = accept_content_encodings[content_encoding_index];
                                obj = iws.content_encodings.get(accept_content_encoding);
                                if (obj != null) {
                                    content_encoding_extensions = (String[])obj;
                                    content_encoding_extensions_count = content_encoding_extensions.length;
                                    int content_encoding_extension_index = 0;
                                    while (content_encoding_extension_index < content_encoding_extensions_count) {
                                        sb.append(content_encoding_extensions[content_encoding_extension_index]);
                                        handler = IOManager.getHandler(base_handler, sb.toString());
                                        if (handler.exists() && !handler.isDirectory()) {
                                            response.setContentType(String.valueOf(accept_content_type) + "; charset=" + charset);
                                            response.setHeader("Content-Language", language);
                                            response.setHeader("Content-Encoding", accept_content_encoding);
                                            if (iws.send_vary) {
                                                response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset,accept-encoding");
                                            }
                                            return handler;
                                        }
                                        sb.setLength(charset_length);
                                        ++content_encoding_extension_index;
                                    }
                                }
                                ++content_encoding_index;
                            }
                            handler = IOManager.getHandler(base_handler, sb.toString());
                            if (handler.exists() && !handler.isDirectory()) {
                                response.setContentType(String.valueOf(accept_content_type) + "; charset=" + charset);
                                response.setHeader("Content-Language", language);
                                if (iws.send_vary) {
                                    response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset");
                                }
                                return handler;
                            }
                            sb.setLength(language_length);
                            ++charset_index;
                        }
                        int content_encoding_index = 0;
                        while (content_encoding_index < accept_content_encodings_count) {
                            accept_content_encoding = accept_content_encodings[content_encoding_index];
                            obj = iws.content_encodings.get(accept_content_encoding);
                            if (obj != null) {
                                content_encoding_extensions = (String[])obj;
                                content_encoding_extensions_count = content_encoding_extensions.length;
                                int content_encoding_extension_index = 0;
                                while (content_encoding_extension_index < content_encoding_extensions_count) {
                                    sb.append(content_encoding_extensions[content_encoding_extension_index]);
                                    handler = IOManager.getHandler(base_handler, sb.toString());
                                    if (handler.exists() && !handler.isDirectory()) {
                                        response.setContentType(accept_content_type);
                                        response.setHeader("Content-Language", language);
                                        response.setHeader("Content-Encoding", accept_content_encoding);
                                        if (iws.send_vary) {
                                            response.setHeader("Vary", "negotiate,accept,accept_language,accept-encoding");
                                        }
                                        return handler;
                                    }
                                    sb.setLength(language_length);
                                    ++content_encoding_extension_index;
                                }
                            }
                            ++content_encoding_index;
                        }
                        handler = IOManager.getHandler(base_handler, sb.toString());
                        if (handler.exists() && !handler.isDirectory()) {
                            response.setContentType(accept_content_type);
                            response.setHeader("Content-Language", language);
                            if (iws.send_vary) {
                                response.setHeader("Vary", "negotiate,accept,accept_language");
                            }
                            return handler;
                        }
                        sb.setLength(content_length);
                        ++locale_index;
                    }
                    int content_encoding_index = 0;
                    while (content_encoding_index < accept_content_encodings_count) {
                        accept_content_encoding = accept_content_encodings[content_encoding_index];
                        obj = iws.content_encodings.get(accept_content_encoding);
                        if (obj != null) {
                            content_encoding_extensions = (String[])obj;
                            content_encoding_extensions_count = content_encoding_extensions.length;
                            int content_encoding_extension_index = 0;
                            while (content_encoding_extension_index < content_encoding_extensions_count) {
                                sb.append(content_encoding_extensions[content_encoding_extension_index]);
                                handler = IOManager.getHandler(base_handler, sb.toString());
                                if (handler.exists() && !handler.isDirectory()) {
                                    response.setContentType(accept_content_type);
                                    response.setHeader("Content-Encoding", accept_content_encoding);
                                    if (iws.send_vary) {
                                        response.setHeader("Vary", "negotiate,accept,accept-encoding");
                                    }
                                    return handler;
                                }
                                sb.setLength(content_length);
                                ++content_encoding_extension_index;
                            }
                        }
                        ++content_encoding_index;
                    }
                    handler = IOManager.getHandler(base_handler, sb.toString());
                    if (handler.exists() && !handler.isDirectory()) {
                        response.setContentType(accept_content_type);
                        if (iws.send_vary) {
                            response.setHeader("Vary", "negotiate,accept");
                        }
                        return handler;
                    }
                    sb.setLength(filename_length);
                    ++content_type_extension_index;
                }
            }
            ++content_type_index;
        }
        int locale_index = 0;
        while (locale_index < locales_count) {
            Locale locale = (Locale)locales.elementAt(locale_index);
            String language = locale.getLanguage();
            sb.append('.');
            sb.append(language);
            language_length = sb.length();
            int charset_index = 0;
            while (charset_index < charsets_count) {
                charset = (String)charsets.elementAt(charset_index);
                sb.append('.');
                sb.append(charset);
                charset_length = sb.length();
                int content_encoding_index = 0;
                while (content_encoding_index < accept_content_encodings_count) {
                    accept_content_encoding = accept_content_encodings[content_encoding_index];
                    obj = iws.content_encodings.get(accept_content_encoding);
                    if (obj != null) {
                        content_encoding_extensions = (String[])obj;
                        content_encoding_extensions_count = content_encoding_extensions.length;
                        int content_encoding_extension_index = 0;
                        while (content_encoding_extension_index < content_encoding_extensions_count) {
                            sb.append(content_encoding_extensions[content_encoding_extension_index]);
                            handler = IOManager.getHandler(base_handler, sb.toString());
                            if (handler.exists() && !handler.isDirectory()) {
                                response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + charset);
                                response.setHeader("Content-Language", language);
                                response.setHeader("Content-Encoding", accept_content_encoding);
                                if (iws.send_vary) {
                                    response.setHeader("Vary", "negotiate,accept_language,accept-charset,accept-encoding");
                                }
                                return handler;
                            }
                            sb.setLength(charset_length);
                            ++content_encoding_extension_index;
                        }
                    }
                    ++content_encoding_index;
                }
                handler = IOManager.getHandler(base_handler, sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + charset);
                    response.setHeader("Content-Language", language);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept_language,accept-charset");
                    }
                    return handler;
                }
                sb.setLength(language_length);
                ++charset_index;
            }
            int content_encoding_index = 0;
            while (content_encoding_index < accept_content_encodings_count) {
                accept_content_encoding = accept_content_encodings[content_encoding_index];
                obj = iws.content_encodings.get(accept_content_encoding);
                if (obj != null) {
                    content_encoding_extensions = (String[])obj;
                    content_encoding_extensions_count = content_encoding_extensions.length;
                    int content_encoding_extension_index = 0;
                    while (content_encoding_extension_index < content_encoding_extensions_count) {
                        sb.append(content_encoding_extensions[content_encoding_extension_index]);
                        handler = IOManager.getHandler(base_handler, sb.toString());
                        if (handler.exists() && !handler.isDirectory()) {
                            response.setContentType(iws.getMimeType(filename));
                            response.setHeader("Content-Language", language);
                            response.setHeader("Content-Encoding", accept_content_encoding);
                            if (iws.send_vary) {
                                response.setHeader("Vary", "negotiate,accept_language,accept-encoding");
                            }
                            return handler;
                        }
                        sb.setLength(language_length);
                        ++content_encoding_extension_index;
                    }
                }
                ++content_encoding_index;
            }
            handler = IOManager.getHandler(base_handler, sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Language", language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language");
                }
                return handler;
            }
            sb.setLength(filename_length);
            ++locale_index;
        }
        if (iws.default_content_type != null && (obj = iws.content_types.get(iws.default_content_type[1])) != null) {
            String content_type = iws.default_content_type[0];
            sb.append(content_type);
            content_length = sb.length();
            sb.append('.');
            sb.append(this.default_language);
            language_length = sb.length();
            sb.append('.');
            sb.append(this.default_charset);
            charset_length = sb.length();
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(base_handler, sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(String.valueOf(content_type) + "; charset=" + this.default_charset);
                    response.setHeader("Content-Language", this.default_language);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(charset_length);
            }
            if ((handler = IOManager.getHandler(base_handler, sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(String.valueOf(content_type) + "; charset=" + this.default_charset);
                response.setHeader("Content-Language", this.default_language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept,accept_language,accept-charset");
                }
                return handler;
            }
            sb.setLength(language_length);
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(base_handler, sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(content_type);
                    response.setHeader("Content-Language", this.default_language);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept_language,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(language_length);
            }
            if ((handler = IOManager.getHandler(base_handler, sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(content_type);
                response.setHeader("Content-Language", this.default_language);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept,accept_language");
                }
                return handler;
            }
            sb.setLength(content_length);
            if (iws.default_content_encoding != null) {
                sb.append(iws.default_content_encoding[1]);
                handler = IOManager.getHandler(base_handler, sb.toString());
                if (handler.exists() && !handler.isDirectory()) {
                    response.setContentType(content_type);
                    response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                    if (iws.send_vary) {
                        response.setHeader("Vary", "negotiate,accept,accept-encoding");
                    }
                    return handler;
                }
                sb.setLength(content_length);
            }
            if ((handler = IOManager.getHandler(base_handler, sb.toString())).exists() && !handler.isDirectory()) {
                response.setContentType(content_type);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept");
                }
                return handler;
            }
        }
        sb.append('.');
        sb.append(this.default_language);
        language_length = sb.length();
        sb.append('.');
        sb.append(this.default_charset);
        charset_length = sb.length();
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(base_handler, sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + this.default_charset);
                response.setHeader("Content-Language", this.default_language);
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language,accept-charset,accept-encoding");
                }
                return handler;
            }
            sb.setLength(charset_length);
        }
        if ((handler = IOManager.getHandler(base_handler, sb.toString())).exists() && !handler.isDirectory()) {
            response.setContentType(String.valueOf(iws.getMimeType(filename)) + "; charset=" + this.default_charset);
            response.setHeader("Content-Language", this.default_language);
            if (iws.send_vary) {
                response.setHeader("Vary", "negotiate,accept_language,accept-charset");
            }
            return handler;
        }
        sb.setLength(language_length);
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(base_handler, sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Language", this.default_language);
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept_language,accept-encoding");
                }
                return handler;
            }
            sb.setLength(language_length);
        }
        if ((handler = IOManager.getHandler(base_handler, sb.toString())).exists() && !handler.isDirectory()) {
            response.setContentType(iws.getMimeType(filename));
            response.setHeader("Content-Language", this.default_language);
            if (iws.send_vary) {
                response.setHeader("Vary", "negotiate,accept_language");
            }
            return handler;
        }
        sb.setLength(filename_length);
        if (iws.default_content_encoding != null) {
            sb.append(iws.default_content_encoding[1]);
            handler = IOManager.getHandler(base_handler, sb.toString());
            if (handler.exists() && !handler.isDirectory()) {
                response.setContentType(iws.getMimeType(filename));
                response.setHeader("Content-Encoding", iws.default_content_encoding[0]);
                if (iws.send_vary) {
                    response.setHeader("Vary", "negotiate,accept-encoding");
                }
                return handler;
            }
            sb.setLength(filename_length);
        }
        int content_encoding_index = 0;
        while (content_encoding_index < accept_content_encodings_count) {
            accept_content_encoding = accept_content_encodings[content_encoding_index];
            obj = iws.content_encodings.get(accept_content_encoding);
            if (obj != null) {
                content_encoding_extensions = (String[])obj;
                content_encoding_extensions_count = content_encoding_extensions.length;
                int content_encoding_extension_index = 0;
                while (content_encoding_extension_index < content_encoding_extensions_count) {
                    sb.append(content_encoding_extensions[content_encoding_extension_index]);
                    handler = IOManager.getHandler(base_handler, sb.toString());
                    if (handler.exists() && !handler.isDirectory()) {
                        response.setContentType(iws.getMimeType(filename));
                        response.setHeader("Content-Encoding", accept_content_encoding);
                        if (iws.send_vary) {
                            response.setHeader("Vary", "negotiate,accept-encoding");
                        }
                        return handler;
                    }
                    sb.setLength(filename_length);
                    ++content_encoding_extension_index;
                }
            }
            ++content_encoding_index;
        }
        handler = IOManager.getHandler(base_handler, filename);
        if (handler.exists() && !handler.isDirectory()) {
            response.setContentType(iws.getMimeType(filename));
            return handler;
        }
        return null;
    }

    private final void sendFile_1_0(HttpServletRequest _request, HttpServletResponse _response, IOHandler _handler, boolean _headersOnly) throws IOException {
        _response.setStatus(200);
        String name = _handler.getCanonicalPath();
        _response.setDateHeader("Date", System.currentTimeMillis());
        _response.setDateHeader("Last-Modified", _handler.lastModified());
        if (_headersOnly) {
            return;
        }
        ServletOutputStream os = _response.getOutputStream();
        byte[] buffer = null;
        if (this.fileCache != null) {
            buffer = this.fileCache.get(_handler);
        }
        if (buffer == null) {
            buffer = new byte[this.read_buffer_size];
            _response.setContentLength((int)_handler.length());
            BufferedInputStream is = new BufferedInputStream(_handler.getInputStream());
            try {
                int n;
                while ((n = is.read(buffer)) != -1) {
                    os.write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
        } else {
            _response.setContentLength(buffer.length);
            int blocks = buffer.length / this.read_buffer_size;
            int i = 0;
            while (i < blocks) {
                os.write(buffer, i * this.read_buffer_size, this.read_buffer_size);
                ++i;
            }
            int n = buffer.length - blocks * this.read_buffer_size;
            if (n > 0) {
                os.write(buffer, blocks * this.read_buffer_size, n);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendFile_1_1(HttpServletRequest _request, HttpServletResponse _response, IOHandler _handler, boolean _headersOnly) throws IOException {
        String sValue;
        int offset;
        String range;
        boolean checkRange;
        _response.setStatus(200);
        String name = _handler.getCanonicalPath();
        _response.setDateHeader("Date", System.currentTimeMillis());
        _response.setDateHeader("Last-Modified", _handler.lastModified());
        _response.setHeader("Accept-Ranges", "bytes");
        String eTag = "\"" + Integer.toHexString(name.hashCode()) + "\"";
        _response.setHeader("ETag", eTag);
        if (_headersOnly) {
            return;
        }
        String sdt = _request.getHeader("If-Range");
        if (sdt == null) {
            checkRange = true;
        } else if (sdt.equals(eTag)) {
            checkRange = true;
        } else {
            try {
                long ldt = Utils.parseDate(sdt);
                checkRange = _handler.lastModified() <= ldt;
            }
            catch (Exception ex) {
                checkRange = false;
            }
        }
        long sOffset = 0L;
        long eOffset = _handler.length() - 1L;
        boolean doRange = false;
        if (checkRange && (range = _request.getHeader("Range")) != null && (offset = range.indexOf(61)) != -1 && (sValue = range.substring(0, offset).trim()).equalsIgnoreCase("bytes") && (range = range.substring(offset + 1)).indexOf(44) == -1 && (offset = range.indexOf(45)) != -1) {
            try {
                sOffset = Long.parseLong(range.substring(0, offset).trim());
            }
            catch (NumberFormatException ex) {
                sOffset = -1L;
            }
            try {
                eOffset = Long.parseLong(range.substring(offset + 1).trim());
            }
            catch (NumberFormatException ex) {
                eOffset = _handler.length() - 1L;
            }
            if (sOffset == -1L) {
                sOffset = _handler.length() - eOffset;
                eOffset = _handler.length() - 1L;
            }
            if (eOffset >= sOffset) {
                doRange = true;
            }
        }
        ServletOutputStream os = _response.getOutputStream();
        byte[] buffer = null;
        if (this.fileCache != null) {
            buffer = this.fileCache.get(_handler);
        }
        if (buffer == null) {
            BufferedInputStream is;
            buffer = new byte[this.read_buffer_size];
            if (doRange) {
                if (_handler instanceof FileIOHandler) {
                    long bytes = eOffset - sOffset + 1L;
                    StringBuffer sb = new StringBuffer("bytes ");
                    sb.append(sOffset);
                    sb.append("-");
                    sb.append(eOffset);
                    sb.append("/");
                    sb.append(_handler.length());
                    _response.setHeader("Content-Range", sb.toString());
                    _response.setContentLength((int)bytes);
                    _response.setStatus(206);
                    RandomAccessFile is2 = new RandomAccessFile(((FileIOHandler)_handler).file, "r");
                    try {
                        int n;
                        is2.seek(sOffset);
                        long blocks = bytes / (long)this.read_buffer_size;
                        int i = 0;
                        while ((long)i < blocks) {
                            n = is2.read(buffer);
                            os.write(buffer, 0, n);
                            ++i;
                        }
                        n = (int)(bytes - blocks * (long)this.read_buffer_size);
                        if (n <= 0) return;
                        n = is2.read(buffer, 0, n);
                        os.write(buffer, 0, n);
                        return;
                    }
                    finally {
                        is2.close();
                    }
                } else {
                    is = new BufferedInputStream(_handler.getInputStream());
                    try {
                        int bytes_read;
                        int total_bytes;
                        if (sOffset > 0L) {
                            is.skip(sOffset);
                        }
                        int bytes = (int)(eOffset - sOffset + 1L);
                        StringBuffer sb = new StringBuffer("bytes ");
                        sb.append(sOffset);
                        sb.append("-");
                        sb.append(eOffset);
                        sb.append("/");
                        sb.append(buffer.length);
                        _response.setHeader("Content-Range", sb.toString());
                        _response.setContentLength(bytes);
                        _response.setStatus(206);
                        int blocks = bytes / this.read_buffer_size;
                        int i = 0;
                        while (i < blocks) {
                            total_bytes = this.read_buffer_size;
                            while (total_bytes > 0) {
                                bytes_read = is.read(buffer, 0, total_bytes);
                                if (bytes_read == -1) break;
                                os.write(buffer, 0, bytes_read);
                                total_bytes -= bytes_read;
                            }
                            ++i;
                        }
                        total_bytes = bytes - blocks * this.read_buffer_size;
                        while (total_bytes > 0) {
                            bytes_read = is.read(buffer, 0, total_bytes);
                            if (bytes_read == -1) {
                                return;
                            }
                            os.write(buffer, 0, bytes_read);
                            total_bytes -= bytes_read;
                        }
                        return;
                    }
                    finally {
                        is.close();
                    }
                }
            } else {
                _response.setContentLength((int)_handler.length());
                is = new BufferedInputStream(_handler.getInputStream());
                try {
                    int n;
                    while ((n = is.read(buffer)) != -1) {
                        os.write(buffer, 0, n);
                    }
                    return;
                }
                finally {
                    is.close();
                }
            }
        } else if (doRange) {
            int bytes = (int)(eOffset - sOffset + 1L);
            StringBuffer sb = new StringBuffer("bytes ");
            sb.append(sOffset);
            sb.append("-");
            sb.append(eOffset);
            sb.append("/");
            sb.append(buffer.length);
            _response.setHeader("Content-Range", sb.toString());
            _response.setContentLength(bytes);
            _response.setStatus(206);
            long blocks = bytes / this.read_buffer_size;
            int i = 0;
            while ((long)i < blocks) {
                os.write(buffer, (int)((long)(i * this.read_buffer_size) + sOffset), this.read_buffer_size);
                ++i;
            }
            int n = (int)((long)bytes - blocks * (long)this.read_buffer_size);
            if (n <= 0) return;
            os.write(buffer, (int)(blocks * (long)this.read_buffer_size + sOffset), n);
            return;
        } else {
            _response.setContentLength(buffer.length);
            int blocks = buffer.length / this.read_buffer_size;
            int i = 0;
            while (i < blocks) {
                os.write(buffer, i * this.read_buffer_size, this.read_buffer_size);
                ++i;
            }
            int n = buffer.length - blocks * this.read_buffer_size;
            if (n <= 0) return;
            os.write(buffer, blocks * this.read_buffer_size, n);
        }
    }

    private final void sendDirectory(Request _request, Response _response, IOHandler _handler, boolean _headersOnly) throws IOException {
        int sort_by;
        String value;
        String template;
        _response.setStatus(200);
        String filename = Utils.concatPaths(_handler.getCanonicalPath(), "./directory.html");
        String charset = null;
        IOHandler io_handler = Utils.getBestHandler(filename, _request, _response);
        if (io_handler == null) {
            filename = Utils.concatPaths(iws.templatesdir, "./directory.html");
            io_handler = Utils.getBestHandler(filename, _request, _response);
        } else {
            charset = _response.getCharacterEncoding();
        }
        if (charset == null) {
            charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(io_handler.getInputStream()), charset);
        try {
            template = Utils.getItem(reader);
        }
        finally {
            reader.close();
        }
        StringBuffer sb = new StringBuffer("text/html");
        if (charset != null) {
            sb.append("; charset=");
            sb.append(charset);
        }
        _response.setContentType(sb.toString());
        if (iws.default_language != null) {
            _response.setHeader("Content-Language", iws.default_language);
        }
        _response.setDateHeader("Date", System.currentTimeMillis());
        _response.setDateHeader("Last-Modified", _handler.lastModified());
        if (_headersOnly) {
            return;
        }
        String uri = _request.getRequestURI();
        int offset = uri.indexOf(63);
        if (offset != -1) {
            uri = uri.substring(0, offset);
        }
        if ((charset = _request.getCharset()) == null) {
            charset = iws.default_charset == null ? "ISO-8859-1" : iws.default_charset;
        }
        if ((uri = Utils.decodeURL(Utils.normalizeURI(uri), charset)).endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        String parent = (offset = uri.lastIndexOf(47)) == -1 || offset == 0 ? "/" : uri.substring(0, offset);
        template = DString.replace(template, "%host%", _request.getServerName());
        template = DString.replace(template, "%uri%", uri);
        template = DString.replace(template, "%parent%", parent);
        template = DString.replace(template, "%date%", new Date().toString());
        template = this.parent_folder_icon == null ? DString.replace(template, "%icon%", "") : DString.replace(template, "%icon%", "<img src=\"" + this.parent_folder_icon + "\">");
        String field_name = _request.getParameter("sort_field_name");
        if (field_name == null) {
            field_name = this.sort_field_name;
        }
        boolean descending = (value = _request.getParameter("sort_descending")) == null ? this.sort_descending : value.equalsIgnoreCase("y");
        value = _request.getParameter("sort_ignore_case");
        boolean ignore_case = value == null ? this.sort_ignore_case : value.equalsIgnoreCase("y");
        if (field_name.equalsIgnoreCase("Type")) {
            sort_by = 1;
            template = DString.replace(template, "%name_sort_descending%", "n");
            template = DString.replace(template, "%type_sort_descending%", descending ? "n" : "y");
            template = DString.replace(template, "%size_sort_descending%", "n");
            template = DString.replace(template, "%modified_sort_descending%", "n");
        } else if (field_name.equalsIgnoreCase("Size")) {
            sort_by = 2;
            template = DString.replace(template, "%name_sort_descending%", "n");
            template = DString.replace(template, "%type_sort_descending%", "n");
            template = DString.replace(template, "%size_sort_descending%", descending ? "n" : "y");
            template = DString.replace(template, "%modified_sort_descending%", "n");
        } else if (field_name.equalsIgnoreCase("Modified")) {
            sort_by = 3;
            template = DString.replace(template, "%name_sort_descending%", "n");
            template = DString.replace(template, "%type_sort_descending%", "n");
            template = DString.replace(template, "%size_sort_descending%", "n");
            template = DString.replace(template, "%modified_sort_descending%", descending ? "n" : "y");
        } else {
            sort_by = 0;
            template = DString.replace(template, "%name_sort_descending%", descending ? "n" : "y");
            template = DString.replace(template, "%type_sort_descending%", "n");
            template = DString.replace(template, "%size_sort_descending%", "n");
            template = DString.replace(template, "%modified_sort_descending%", "n");
        }
        PrintWriter writer = _response.getWriter();
        int directory_item_tag_offset = template.indexOf(DIRECTORY_ITEM_TAG);
        if (directory_item_tag_offset == -1) {
            writer.print(template);
            return;
        }
        writer.print(template.substring(0, directory_item_tag_offset));
        String[] list = _handler.list();
        if (list != null && this.sort_directory_listing) {
            QuickSortDirectory qs = new QuickSortDirectory(_handler, sort_by, descending, ignore_case);
            list = qs.sort(list);
        }
        Locale locale = _request.getLocale();
        SimpleDateFormat date_formatter = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        SimpleDateFormat time_formatter = (SimpleDateFormat)DateFormat.getTimeInstance(3, locale);
        int count = list.length;
        int i = 0;
        while (i < count) {
            String list_item = list[i];
            if (this.include_hidden || list_item.charAt(0) != '.') {
                String path = Utils.concatURIs(uri, list_item);
                String item = new String(this.directoryItemTemplate);
                IOHandler thandler = IOManager.getHandler(_handler, list_item);
                Date dt = new Date(thandler.lastModified());
                item = DString.replace(item, "%date%", date_formatter.format(dt));
                item = DString.replace(item, "%time%", time_formatter.format(dt));
                String length = thandler.isDirectory() ? "" : DString.pad(String.valueOf(thandler.length()), ' ', 10, 'R');
                item = DString.replace(item, "%length%", length);
                String icon = this.getIcon(thandler, list_item);
                icon = icon == null ? "" : "<img src=\"" + icon.trim() + "\">";
                item = DString.replace(item, "%icon%", icon);
                item = DString.replace(item, "%type%", this.getType(_handler, list_item));
                item = DString.replace(item, "%link%", path);
                item = DString.replace(item, "%name%", list_item);
                writer.print(item);
            }
            ++i;
        }
        writer.print(template.substring(directory_item_tag_offset + DIRECTORY_ITEM_TAG.length()));
    }

    private final String getExtension(String filename) {
        int offset = filename.lastIndexOf(46);
        if (offset == -1) {
            return ".";
        }
        return filename.substring(offset).toLowerCase();
    }

    private final String getMimetype(String filename) {
        String mimetype = null;
        int offset = filename.lastIndexOf(46);
        if (offset != -1) {
            mimetype = (String)iws.mimetypes.get(filename.substring(offset));
        }
        if (mimetype == null) {
            mimetype = (String)iws.mimetypes.get("*");
        }
        return mimetype;
    }

    private final String filter(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    private final String getType(IOHandler base_io_handler, String filename) {
        IOHandler io_handler;
        String extension = this.getExtension(filename);
        String type = null;
        try {
            io_handler = IOManager.getHandler(base_io_handler, filename);
        }
        catch (IOException ex) {
            io_handler = null;
        }
        if (io_handler != null) {
            if (io_handler.isDirectory()) {
                return this.default_folder_type;
            }
            String mimetype = this.getMimetype(extension);
            if (mimetype != null) {
                type = this.filter(DString.extract(mimetype, '&', 2));
            }
            if (type == null && (mimetype = (String)iws.mimetypes.get("*")) != null) {
                type = this.filter(DString.extract(mimetype, '&', 2));
            }
        }
        if (type == null) {
            return iws.local_strings.getLocalString("default_file_type");
        }
        return DString.replace(type, "%extension%", extension.substring(1).toUpperCase()).trim();
    }

    private final String getIcon(IOHandler io_handler, String filename) {
        if (!this.display_icons) {
            return null;
        }
        if (io_handler.isDirectory()) {
            return this.default_folder_icon;
        }
        String icon = null;
        String mimetype = this.getMimetype(filename);
        if (mimetype != null) {
            icon = this.filter(DString.extract(mimetype, '&', 1));
        }
        if (icon == null && (mimetype = (String)iws.mimetypes.get("*")) != null) {
            icon = this.filter(DString.extract(mimetype, '&', 1));
        }
        if (icon == null) {
            return iws.local_strings.getLocalString("default_file_icon");
        }
        return icon;
    }

    private class QuickSortDirectory
    extends QuickSort {
        IOHandler io_handler;
        boolean ignore_case;
        int descending_switch;
        int sort_by;

        QuickSortDirectory(IOHandler _io_handler, int _sort_by, boolean _descending, boolean _ignore_case) {
            this.io_handler = _io_handler;
            this.sort_by = _sort_by;
            this.descending_switch = _descending ? -1 : 1;
            this.ignore_case = _ignore_case;
        }

        public final String[] sort(String[] sArray) {
            return (String[])super.sort(sArray);
        }

        @Override
        public final int compare(Object object1, Object object2) {
            int result;
            block15: {
                if (this.sort_by == 1) {
                    result = FileServlet.this.getType(this.io_handler, (String)object1).toLowerCase().compareTo(FileServlet.this.getType(this.io_handler, (String)object2).toLowerCase());
                    if (result == 0) {
                        result = this.ignore_case ? ((String)object1).toLowerCase().compareTo(((String)object2).toLowerCase()) : ((String)object1).compareTo((String)object2);
                    }
                } else if (this.sort_by == 2) {
                    try {
                        long lresult = IOManager.getHandler(this.io_handler, (String)object1).length() - IOManager.getHandler(this.io_handler, (String)object2).length();
                        if (lresult == 0L) {
                            result = this.ignore_case ? ((String)object1).toLowerCase().compareTo(((String)object2).toLowerCase()) : ((String)object1).compareTo((String)object2);
                            break block15;
                        }
                        if (lresult < 0L) {
                            result = -1;
                            break block15;
                        }
                        result = 1;
                    }
                    catch (IOException ex) {
                        result = 0;
                    }
                } else if (this.sort_by == 3) {
                    try {
                        long lresult = IOManager.getHandler(this.io_handler, (String)object1).lastModified() - IOManager.getHandler(this.io_handler, (String)object2).lastModified();
                        if (lresult == 0L) {
                            result = this.ignore_case ? ((String)object1).toLowerCase().compareTo(((String)object2).toLowerCase()) : ((String)object1).compareTo((String)object2);
                            break block15;
                        }
                        if (lresult < 0L) {
                            result = -1;
                            break block15;
                        }
                        result = 1;
                    }
                    catch (IOException ex) {
                        result = 0;
                    }
                } else {
                    result = this.ignore_case ? ((String)object1).toLowerCase().compareTo(((String)object2).toLowerCase()) : ((String)object1).compareTo((String)object2);
                }
            }
            return result * this.descending_switch;
        }

        @Override
        public final int count(Object objects) {
            return ((String[])objects).length;
        }

        @Override
        public final Object extract(Object objects, int index) {
            return ((String[])objects)[index];
        }

        @Override
        public final void replace(Object objects, int index, Object object) {
            ((String[])objects)[index] = (String)object;
        }
    }
}

