/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import stec.iws.PrincipalImpl;
import stec.iws.Realm;
import stec.iws.Utils;
import stec.lang.DString;

public final class FileRealm
extends Realm {
    private Hashtable users;
    private Hashtable groups;
    private ACL[] acls;

    @Override
    public final void init(Hashtable init_parameters) throws Exception {
        super.init(init_parameters);
        this.users = Utils.getConfig("./users.ini");
        this.groups = Utils.getConfig("./groups.ini");
        Hashtable ht = Utils.getConfig("./acl.ini");
        this.acls = new ACL[ht.size()];
        int index = 0;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ACL acl = new ACL();
            acl.key = (String)e.nextElement();
            acl.rights = (String)ht.get(acl.key);
            this.acls[index++] = acl;
        }
    }

    @Override
    public final boolean authenticateUser(String _acls, String _username, String _password, String _method) throws Exception {
        if (!this.isValid(_username, _password)) {
            return false;
        }
        int count = DString.dcount(_acls, ',');
        int i = 0;
        while (i < count) {
            String acl = DString.extract(_acls, ',', i).trim();
            String rights = this.checkACL(acl, _username);
            if (rights != null) {
                return this.canAccess(rights, _method);
            }
            ++i;
        }
        return false;
    }

    private final boolean isValid(String _username, String _password) {
        Object obj = this.users.get(_username);
        if (obj == null) {
            return false;
        }
        return _password.equals((String)obj);
    }

    private final boolean canAccess(String _rights, String _method) {
        int count = DString.dcount(_rights, ',');
        int i = 0;
        while (i < count) {
            String right = DString.extract(_rights, ',', i).trim();
            if (right.equals("*") || right.equalsIgnoreCase(_method)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final String checkACL(String _acl, String _username) throws Exception {
        int offset = _acl.indexOf(46);
        String type = _acl.substring(0, offset);
        String name = _acl.substring(offset + 1);
        int count = this.acls.length;
        int i = 0;
        while (i < count) {
            ACL acl = this.acls[i];
            if (acl.key.equals(_acl)) {
                if (type.equals("group") ? this.checkGroup(name, _username) : type.equals("user") && name.equals(_username)) {
                    return acl.rights;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final boolean checkGroup(String _groupname, String _username) throws Exception {
        Object obj = this.groups.get(_groupname);
        if (obj == null) {
            return false;
        }
        String usernames = (String)obj;
        int count = DString.dcount(usernames, ',');
        int i = 0;
        while (i < count) {
            String username = DString.extract(usernames, ',', i).trim();
            if (username.equals(_username)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final boolean authenticateComputer(String _acls, String _hostname, String _ip_address, String _method) throws Exception {
        int count = DString.dcount(_acls, ',');
        int i = 0;
        while (i < count) {
            String acl = DString.extract(_acls, ',', i).trim();
            String rights = this.checkACL(acl, _hostname, _ip_address);
            if (rights != null) {
                return this.canAccess(rights, _method);
            }
            ++i;
        }
        return false;
    }

    private final String checkACL(String _acl, String _hostname, String _ip_address) throws Exception {
        int offset = _acl.indexOf(46);
        String type = _acl.substring(0, offset);
        String value = _acl.substring(offset + 1);
        if (type.equalsIgnoreCase("hostname")) {
            if (!value.equalsIgnoreCase(_hostname)) {
                return null;
            }
        } else if (type.equalsIgnoreCase("ip_address")) {
            if (!value.equalsIgnoreCase(_ip_address)) {
                return null;
            }
        } else if (type.equalsIgnoreCase("ip_range")) {
            if (!FileRealm.checkRange(value, _ip_address)) {
                return null;
            }
        } else {
            return null;
        }
        int count = this.acls.length;
        int i = 0;
        while (i < count) {
            ACL acl = this.acls[i];
            if (acl.key.equals(_acl)) {
                return acl.rights;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final Principal getPrincipal(String username) {
        return new PrincipalImpl(username);
    }

    final class ACL {
        String key;
        String rights;

        ACL() {
        }
    }
}

