/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import stec.iws.IOHandler;
import stec.iws.Utils;

public final class FileIOHandler
implements IOHandler {
    protected File file;

    public FileIOHandler(String path) {
        this.file = new File(path);
    }

    public FileIOHandler(String base_dir, String path) {
        this.file = new File(base_dir, path);
    }

    public FileIOHandler(IOHandler handler, String path) {
        this.file = new File(((FileIOHandler)handler).file, path);
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public final String getItem() throws IOException {
        return Utils.getItem(this.file);
    }

    @Override
    public final long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public final long length() {
        return this.file.length();
    }

    @Override
    public final boolean exists() {
        return this.file.exists();
    }

    @Override
    public final String[] list() {
        return this.file.list();
    }

    @Override
    public final String getCanonicalPath() throws IOException {
        try {
            return this.file.getCanonicalPath();
        }
        catch (Exception ex) {
            return Utils.getCanonicalPath(this.file.getPath());
        }
    }

    @Override
    public final boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public final boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public final boolean isAbsolute() {
        return this.file.isAbsolute();
    }
}

