/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import stec.iws.LockTable;
import stec.iws.MemorySessionStore;
import stec.iws.ServletContextImpl;
import stec.iws.Session;
import stec.iws.iws;
import stec.sql.Connection;
import stec.sql.ConnectionPoolManager;

public final class DatabaseSessionStore
extends MemorySessionStore {
    private String connection_pool;
    private boolean persistent = true;
    private long save_interval;
    private LockTable locks = new LockTable();
    private boolean checking = false;
    private boolean distributed;
    private boolean master;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        super.init(_parameters);
        Object obj = _parameters.get("connection_pool");
        this.connection_pool = obj == null ? "iserver" : ((String[])obj)[0];
        if (!ConnectionPoolManager.containsConnectionPool(this.connection_pool)) {
            throw new Exception(iws.local_strings.getLocalString("err.connection_pool_does_not_exist", this.connection_pool));
        }
        obj = _parameters.get("master");
        String value = obj == null ? "n" : ((String[])obj)[0];
        this.master = value.equalsIgnoreCase("y");
        obj = _parameters.get("distributed");
        value = obj == null ? "n" : ((String[])obj)[0];
        this.distributed = value.equalsIgnoreCase("y");
        if (this.distributed) {
            this.persistent = true;
            this.save_interval = 0L;
        } else {
            obj = _parameters.get("persistent");
            value = obj == null ? "n" : ((String[])obj)[0];
            this.persistent = value.equalsIgnoreCase("y");
            obj = _parameters.get("save_interval");
            if (obj == null) {
                this.save_interval = 300000L;
            } else {
                try {
                    this.save_interval = Integer.parseInt(((String[])obj)[0]);
                }
                catch (NumberFormatException ex) {
                    this.save_interval = -1L;
                }
                this.save_interval = this.save_interval < 0L ? 300000L : (this.save_interval *= 60000L);
            }
        }
    }

    @Override
    public final void checkSessionStore() throws Exception {
        this.checking = true;
        try {
            super.checkSessionStore();
            if (!this.distributed || this.master) {
                this.checkDatabaseSessionStore();
            }
        }
        finally {
            this.checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkDatabaseSessionStore() throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            try {
                connection = ConnectionPoolManager.getConnection(this.connection_pool);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                statement = connection.createStatement();
                resultset = statement.executeQuery("SELECT ID, Cookie_ID FROM Sessions WHERE Expires is not NULL AND NOW() > Expires");
                while (resultset.next()) {
                    Object lock;
                    int id = resultset.getInt(1);
                    String session_id = resultset.getString(2);
                    Object object = lock = this.locks.lock(session_id);
                    synchronized (object) {
                        try {
                            this.removeSession(connection, id);
                        }
                        finally {
                            this.locks.unlock(lock);
                        }
                    }
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            if (resultset != null) {
                try {
                    resultset.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                super.checkSession(_session);
                if (_session.isValid && this.save_interval > 0L && System.currentTimeMillis() > _session.lastUpdate + this.save_interval && _session.lastUpdate != -1L) {
                    _session.lastUpdate = -1L;
                    this._saveSession(_session);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Session getSession(ServletContextImpl _context, String _session_id) throws Exception {
        Object lock;
        Session session = null;
        Object object = lock = this.locks.lock(_session_id);
        synchronized (object) {
            try {
                session = super.getSession(_context, _session_id);
                if (session == null) {
                    session = this._getSession(_context, _session_id);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
        return session;
    }

    private final Session _getSession(ServletContextImpl _context, String _session_id) throws Exception {
        Session session;
        block28: {
            session = null;
            Connection connection = null;
            Statement statement = null;
            ResultSet resultset = null;
            try {
                connection = ConnectionPoolManager.getConnection(this.connection_pool);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                statement = connection.createStatement();
                StringBuffer sb = new StringBuffer("SELECT ID, Cookie_ID, Creation_Time, Last_Accessed_Time, Session_Timeout, Remote_Address, isNew FROM Sessions WHERE Cookie_ID = '");
                sb.append(_session_id);
                sb.append("' AND Context_ID =");
                sb.append(this.getContext(connection, _context));
                resultset = statement.executeQuery(sb.toString());
                if (!resultset.next()) break block28;
                int id = resultset.getInt(1);
                session = new Session();
                session.context = _context;
                session.lastUpdate = -1L;
                session.isValid = true;
                session.id = resultset.getString(2);
                session.creationTime = resultset.getTimestamp(3).getTime();
                session.lastAccessedTime = resultset.getTimestamp(4).getTime();
                session.sessionTimeout = resultset.getTimestamp(5).getTime();
                if (session.sessionTimeout == 0L) {
                    session.sessionTimeout = -1L;
                }
                if (session._isValid()) {
                    InputStream is = resultset.getBinaryStream(6);
                    ObjectInputStream ois = new ObjectInputStream(is);
                    session.remote_address = (InetAddress)ois.readObject();
                    session.isNew = resultset.getBoolean(7);
                    try {
                        resultset.close();
                        resultset = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.setLength(0);
                    sb.append("SELECT Data FROM SessionData WHERE Session_ID = ");
                    sb.append(id);
                    resultset = statement.executeQuery(sb.toString());
                    while (resultset.next()) {
                        is = resultset.getBinaryStream(1);
                        ois = new ObjectInputStream(is);
                        String key = ois.readUTF();
                        Object value = ois.readObject();
                        session._putValue(key, value);
                    }
                    _context.sessions.put(session.id, session);
                    break block28;
                }
                try {
                    try {
                        this.removeSession(connection, id);
                        connection.commit();
                    }
                    catch (Exception ex) {
                        connection.rollback();
                        throw ex;
                    }
                }
                finally {
                    session = null;
                }
            }
            finally {
                if (resultset != null) {
                    try {
                        resultset.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return session;
    }

    @Override
    public final void load(ServletContextImpl _context) throws Exception {
        Connection connection = null;
        try {
            try {
                connection = ConnectionPoolManager.getConnection(this.connection_pool);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                if (this.getContext(connection, _context) == -1) {
                    StringBuffer sb = new StringBuffer("INSERT INTO Contexts (Name) VALUES ('");
                    sb.append(_context.name);
                    sb.append("')");
                    this.executeUpdate(connection, sb.toString());
                    connection.commit();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!this.persistent) {
            this.removeAllSessions(_context);
        }
    }

    @Override
    public final void unload(ServletContextImpl _context) throws Exception {
        try {
            if (this.persistent) {
                this.saveAllSessions(_context);
            } else {
                this.removeAllSessions(_context);
            }
        }
        finally {
            super.unload(_context);
        }
    }

    @Override
    public final void saveSession(Session _session, boolean _immediately) throws Exception {
        if (this.save_interval == 0L || _immediately) {
            this.saveSession(_session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                if (_session.isValid() && _session.lastUpdate != -1L) {
                    _session.lastUpdate = -1L;
                    this._saveSession(_session);
                }
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _saveSession(Session session) throws Exception {
        Session session2 = session;
        synchronized (session2) {
            if (!session.canSerialize()) {
                return;
            }
            session.context.sessions.remove(session.id);
            Connection connection = null;
            Statement pstatement = null;
            Statement statement = null;
            ResultSet resultset = null;
            try {
                try {
                    byte[] array;
                    ObjectOutputStream oos;
                    ByteArrayOutputStream bos;
                    int id;
                    connection = ConnectionPoolManager.getConnection(this.connection_pool);
                    connection.setAutoCommit(false);
                    connection.setTransactionIsolation(2);
                    int context_id = this.getContext(connection, session.context);
                    StringBuffer sb = new StringBuffer("SELECT ID FROM Sessions WHERE Cookie_ID = '");
                    sb.append(session.id);
                    sb.append("' AND Context_ID =");
                    sb.append(context_id);
                    statement = connection.createStatement();
                    resultset = statement.executeQuery(sb.toString());
                    if (resultset.next()) {
                        id = resultset.getInt("ID");
                        try {
                            resultset.close();
                            resultset = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        sb.setLength(0);
                        sb.append("DELETE FROM SessionData WHERE Session_ID = ");
                        sb.append(id);
                        statement.executeUpdate(sb.toString());
                        pstatement = connection.prepareStatement("UPDATE Sessions SET Last_Accessed_Time = ?, Session_Timeout = ?, isNew = ?, Remote_Address = ?, Expires = ? WHERE ID = ?");
                        pstatement.setTimestamp(1, new Timestamp(session.lastAccessedTime));
                        pstatement.setTimestamp(2, new Timestamp(session.sessionTimeout));
                        pstatement.setBoolean(3, session.isNew);
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(session.remote_address);
                        array = bos.toByteArray();
                        pstatement.setBinaryStream(4, new ByteArrayInputStream(array), array.length);
                        if (session.sessionTimeout == -1L) {
                            pstatement.setNull(5, 93);
                        } else {
                            pstatement.setTimestamp(5, new Timestamp(session.lastAccessedTime + session.sessionTimeout));
                        }
                        pstatement.setInt(6, id);
                        pstatement.executeUpdate();
                        try {
                            pstatement.close();
                            pstatement = null;
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            resultset.close();
                            resultset = null;
                        }
                        catch (Exception bos2) {
                            // empty catch block
                        }
                        pstatement = connection.prepareStatement("INSERT INTO Sessions (Context_ID, Cookie_ID, Creation_Time, Last_Accessed_Time, Session_Timeout, isNew, Remote_Address, Expires) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                        pstatement.setInt(1, context_id);
                        pstatement.setString(2, session.id);
                        pstatement.setTimestamp(3, new Timestamp(session.creationTime));
                        pstatement.setTimestamp(4, new Timestamp(session.lastAccessedTime));
                        pstatement.setTimestamp(5, new Timestamp(session.sessionTimeout));
                        pstatement.setBoolean(6, session.isNew);
                        bos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(session.remote_address);
                        array = bos.toByteArray();
                        pstatement.setBinaryStream(7, new ByteArrayInputStream(array), array.length);
                        if (session.sessionTimeout == -1L) {
                            pstatement.setNull(8, 93);
                        } else {
                            pstatement.setTimestamp(8, new Timestamp(session.lastAccessedTime + session.sessionTimeout));
                        }
                        pstatement.executeUpdate();
                        try {
                            pstatement.close();
                            pstatement = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        sb.setLength(0);
                        sb.append("SELECT ID FROM Sessions WHERE Cookie_ID = '");
                        sb.append(session.id);
                        sb.append("' AND Context_ID =");
                        sb.append(context_id);
                        statement = connection.createStatement();
                        resultset = statement.executeQuery(sb.toString());
                        if (resultset.next()) {
                            id = resultset.getInt("ID");
                            try {
                                resultset.close();
                                resultset = null;
                            }
                            catch (Exception exception) {}
                        } else {
                            throw new Exception(iws.local_strings.getLocalString("err.unable_to_insert_into_table", "Sessions", session.context.name, session.id));
                        }
                    }
                    pstatement = connection.prepareStatement("INSERT INTO SessionData (Session_ID, Data) VALUES (?, ?)");
                    bos = new ByteArrayOutputStream();
                    Enumeration e = session.sessionData.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        Object value = session.sessionData.get(key);
                        pstatement.setInt(1, id);
                        bos.reset();
                        oos = new ObjectOutputStream(bos);
                        oos.writeUTF(key);
                        oos.writeObject(value);
                        byte[] array2 = bos.toByteArray();
                        pstatement.setBinaryStream(2, new ByteArrayInputStream(array2), array2.length);
                        pstatement.executeUpdate();
                    }
                    connection.commit();
                }
                catch (Exception ex) {
                    connection.rollback();
                    throw ex;
                }
            }
            finally {
                try {
                    if (resultset != null) {
                        try {
                            resultset.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (pstatement != null) {
                        try {
                            pstatement.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    session._clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                super.removeSession(_session);
                this._removeSession(_session);
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeResidentSession(Session _session) throws Exception {
        Object lock;
        Object object = lock = this.locks.lock(_session.id);
        synchronized (object) {
            try {
                this._removeSession(_session);
            }
            finally {
                this.locks.unlock(lock);
            }
        }
    }

    protected final void _removeSession(Session _session) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            try {
                connection = ConnectionPoolManager.getConnection(this.connection_pool);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                statement = connection.createStatement();
                StringBuffer sb = new StringBuffer("SELECT ID FROM Sessions WHERE Cookie_ID = '");
                sb.append(_session.id);
                sb.append("' AND Context_ID =");
                sb.append(this.getContext(connection, _session.context));
                resultset = statement.executeQuery(sb.toString());
                if (resultset.next()) {
                    this.removeSession(connection, resultset.getInt("ID"));
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            if (resultset != null) {
                try {
                    resultset.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private final void removeSession(Connection connection, int session_id) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM SessionData WHERE Session_ID = ");
        sb.append(session_id);
        this.executeUpdate(connection, sb.toString());
        sb.setLength(0);
        sb.append("DELETE FROM Sessions WHERE ID = ");
        sb.append(session_id);
        this.executeUpdate(connection, sb.toString());
    }

    private final void saveAllSessions(ServletContextImpl _context) throws Exception {
        Enumeration e = _context.sessions.elements();
        while (e.hasMoreElements()) {
            Session session = (Session)e.nextElement();
            this.saveSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeAllSessions(ServletContextImpl _context) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultset = null;
        try {
            try {
                connection = ConnectionPoolManager.getConnection(this.connection_pool);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                int context_id = this.getContext(connection, _context);
                statement = connection.createStatement();
                StringBuffer sb = new StringBuffer("SELECT ID, Cookie_ID FROM Sessions WHERE Context_ID = ");
                sb.append(context_id);
                resultset = statement.executeQuery(sb.toString());
                while (resultset.next()) {
                    Object lock;
                    int id = resultset.getInt(1);
                    String session_id = resultset.getString(2);
                    Object object = lock = this.locks.lock(session_id);
                    synchronized (object) {
                        try {
                            this.removeSession(connection, id);
                        }
                        finally {
                            this.locks.unlock(lock);
                        }
                    }
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            if (resultset != null) {
                try {
                    resultset.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private final int executeUpdate(Connection _connection, String _query) throws Exception {
        Statement stmt = null;
        try {
            stmt = _connection.createStatement();
            int n = stmt.executeUpdate(_query);
            return n;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private final int getContext(Connection _connection, ServletContextImpl _context) throws Exception {
        Statement statement = null;
        ResultSet resultset = null;
        try {
            statement = _connection.createStatement();
            StringBuffer sb = new StringBuffer("SELECT ID FROM Contexts WHERE Name = '");
            sb.append(_context.name);
            sb.append("'");
            resultset = statement.executeQuery(sb.toString());
            if (resultset.next()) {
                int n = resultset.getInt(1);
                return n;
            }
            return -1;
        }
        finally {
            if (resultset != null) {
                try {
                    resultset.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public final boolean isDistributed() {
        return this.distributed;
    }
}

