/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.Logger;
import stec.iws.Utils;
import stec.iws.iws;

public final class DatabaseLogger
extends Logger {
    private static String NONE = "";
    private Connection connection = null;
    private PreparedStatement insertErrorStatement = null;
    private PreparedStatement insertEventStatement = null;
    private PreparedStatement insertAccessStatement = null;

    @Override
    public final void init(Hashtable _parameters) throws Exception {
        super.init(_parameters);
        Object obj = _parameters.get("driver");
        if (obj == null) {
            throw new Exception(iws.local_strings.getLocalString("err.was_not_specified", "driver"));
        }
        String driver = ((String[])obj)[0];
        Class.forName(driver);
        obj = _parameters.get("url");
        if (obj == null) {
            throw new Exception(iws.local_strings.getLocalString("err.was_not_specified", "url"));
        }
        String url = ((String[])obj)[0];
        obj = _parameters.get("user");
        String username = obj == null ? "" : ((String[])obj)[0];
        obj = _parameters.get("password");
        String password = obj == null ? "" : ((String[])obj)[0];
        try {
            this.connection = DriverManager.getConnection(url, username, password);
            this.connection.setAutoCommit(true);
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO AccessLog (");
            query.append("Date_Time");
            query.append(", Remote_Address");
            query.append(", Remote_Host");
            query.append(", Remote_User");
            query.append(", Host");
            query.append(", Port");
            query.append(", Local_Address");
            query.append(", Content_Length");
            query.append(", Request_Length");
            query.append(", Response_Time");
            query.append(", Status_Code");
            query.append(", Error_Code");
            query.append(", Request_Method");
            query.append(", Request_URI");
            query.append(", User_Agent");
            query.append(", Referer");
            query.append(", Protocol");
            query.append(", Server_Service");
            query.append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            this.insertAccessStatement = this.connection.prepareStatement(query.toString());
            query.setLength(0);
            query.append("INSERT INTO EventLog (");
            query.append("Date_Time");
            query.append(", Message");
            query.append(") VALUES (?,?)");
            this.insertEventStatement = this.connection.prepareStatement(query.toString());
            query.setLength(0);
            query.append("INSERT INTO ErrorLog (");
            query.append("Date_Time");
            query.append(", Exception");
            query.append(", Message");
            query.append(") VALUES (?,?,?)");
            this.insertErrorStatement = this.connection.prepareStatement(query.toString());
        }
        catch (Exception ex) {
            this._destroy();
            throw ex;
        }
    }

    @Override
    public final void output(ErrorLogEntry entry) throws SQLException, IOException {
        String error;
        System.err.print(entry.message);
        Utils.printStackTrace(System.err, entry.error);
        this.insertErrorStatement.setTimestamp(1, new Timestamp(entry.timestamp));
        if (entry.error == null) {
            error = NONE;
        } else {
            CharArrayWriter buf = new CharArrayWriter();
            PrintWriter writer = new PrintWriter(buf);
            Utils.printStackTrace(writer, entry.error);
            error = String.valueOf(buf);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(error);
        byte[] array = bos.toByteArray();
        this.insertErrorStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(array), array.length);
        String message = entry.message == null ? NONE : entry.message;
        bos = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(bos);
        oos.writeObject(message);
        array = bos.toByteArray();
        this.insertErrorStatement.setBinaryStream(3, (InputStream)new ByteArrayInputStream(array), array.length);
        this.insertErrorStatement.executeUpdate();
    }

    @Override
    public final void output(EventLogEntry entry) throws SQLException, IOException {
        this.insertEventStatement.setTimestamp(1, new Timestamp(entry.timestamp));
        String message = entry.message == null ? NONE : entry.message;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(message);
        byte[] array = bos.toByteArray();
        this.insertEventStatement.setBinaryStream(2, (InputStream)new ByteArrayInputStream(array), array.length);
        this.insertEventStatement.executeUpdate();
    }

    @Override
    public final void output(AccessLogEntry entry) throws SQLException {
        this.insertAccessStatement.setTimestamp(1, new Timestamp(entry.timestamp));
        this.insertAccessStatement.setString(2, entry.remoteAddress == null ? NONE : entry.remoteAddress);
        this.insertAccessStatement.setString(3, entry.remoteHost == null ? NONE : entry.remoteHost);
        this.insertAccessStatement.setString(4, entry.remoteUser == null ? NONE : entry.remoteUser);
        this.insertAccessStatement.setString(5, entry.host == null ? NONE : entry.host);
        this.insertAccessStatement.setInt(6, entry.port == -1 ? 80 : entry.port);
        this.insertAccessStatement.setString(7, entry.localAddress == null ? NONE : entry.localAddress);
        this.insertAccessStatement.setInt(8, entry.contentLength == -1L ? 0 : (int)entry.contentLength);
        this.insertAccessStatement.setInt(9, (int)entry.requestLength);
        this.insertAccessStatement.setInt(10, (int)entry.responseTime);
        this.insertAccessStatement.setInt(11, entry.statusCode);
        this.insertAccessStatement.setInt(12, entry.errorCode);
        this.insertAccessStatement.setString(13, entry.requestMethod == null ? NONE : entry.requestMethod);
        this.insertAccessStatement.setString(14, entry.requestURI == null ? NONE : entry.requestURI);
        this.insertAccessStatement.setString(15, entry.userAgent == null ? NONE : entry.userAgent);
        this.insertAccessStatement.setString(16, entry.referer == null ? NONE : entry.referer);
        this.insertAccessStatement.setString(17, entry.protocol == null ? NONE : entry.protocol);
        this.insertAccessStatement.setString(18, entry.serverService == null ? NONE : entry.serverService);
        this.insertAccessStatement.executeUpdate();
    }

    @Override
    public final synchronized void destroy() {
        try {
            super.destroy();
        }
        finally {
            this._destroy();
        }
    }

    private final void _destroy() {
        if (this.insertEventStatement != null) {
            try {
                this.insertEventStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.insertEventStatement = null;
        }
        if (this.insertErrorStatement != null) {
            try {
                this.insertErrorStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.insertErrorStatement = null;
        }
        if (this.insertAccessStatement != null) {
            try {
                this.insertAccessStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.insertAccessStatement = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
    }
}

