/*
 * Decompiled with CFR 0.152.
 */
package com.dell.oma.common.collaboration;

import com.dell.oma.common.collaboration.Collaborator;
import com.dell.oma.common.collaboration.IDependent;
import com.dell.oma.common.collaboration.INotification;
import com.dell.oma.common.collaboration.RemoteCollaboratorThreadAssociation;
import java.util.Vector;

public abstract class RemoteCollaborator
extends Collaborator
implements Runnable {
    private int m_hRegistration = -1;
    private RemoteCollaboratorThreadAssociation m_collaboratorThread = new RemoteCollaboratorThreadAssociation(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependent(IDependent iDependent) {
        RemoteCollaboratorThreadAssociation remoteCollaboratorThreadAssociation = this.m_collaboratorThread;
        synchronized (remoteCollaboratorThreadAssociation) {
            super.addDependent(iDependent);
            this.m_collaboratorThread.startThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDependent(IDependent iDependent) {
        RemoteCollaboratorThreadAssociation remoteCollaboratorThreadAssociation = this.m_collaboratorThread;
        synchronized (remoteCollaboratorThreadAssociation) {
            boolean bl = false;
            Vector vector = this.m_vDependents;
            synchronized (vector) {
                super.removeDependent(iDependent);
                if (this.m_vDependents.size() == 0) {
                    bl = true;
                }
            }
            if (bl) {
                this.stopWaitNotification(this.m_hRegistration);
                this.m_collaboratorThread.waitForThread();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.m_hRegistration = this.registerForNotification();
        if (this.m_hRegistration < 0) return;
        boolean bl = true;
        while (bl) {
            int n = this.waitForNotification(this.m_hRegistration);
            if (n == -1) return;
            INotification iNotification = this.createNotification(n);
            this.notify(iNotification);
        }
    }

    protected abstract int registerForNotification();

    protected abstract void stopWaitNotification(int var1);

    protected abstract int waitForNotification(int var1);

    protected abstract INotification createNotification(int var1);
}

