/*
 * Decompiled with CFR 0.152.
 */
package com.dell.oma.common;

import com.dell.oma.cliplugins.AOMACLIPlugin;
import com.dell.oma.common.IOMAStylesheetLoader;
import com.dell.oma.common.OMALogging;
import com.dell.oma.common.OMAStylesheetLoaderXalan2;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public final class OMAStylesheetLoader
implements Runnable {
    private static boolean m_bUseXalan2 = false;
    private IOMAStylesheetLoader m_transformer = null;
    private Thread m_thread = null;
    private String m_sStylesheetPath = null;
    private Reader m_rStylesheetReader = null;
    private Exception m_loadException = null;
    private long m_nTimestamp = 0L;
    private OMALogging m_logger = OMALogging.getInstance();
    private String m_sDynamicStylesheet = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OMAStylesheetLoader(String string) {
        try {
            if (string != null) {
                string = string.trim();
            }
            if (string != null) {
                if (string.startsWith(AOMACLIPlugin.A_B_C_D("=?{oi"))) {
                    if (!string.endsWith(AOMACLIPlugin.A_B_C_D("=/{qi@vtrfpyeil|/"))) {
                        string = string + AOMACLIPlugin.A_B_C_D("=/{qi@vtrfpyeil|/");
                    }
                    this.m_sDynamicStylesheet = string;
                    this.m_logger.write(7, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>P}y\u007fm2Jpouqy\n}\u0019\u0004J{VdRHLGFO~\\J^XA]QTD\u0006") + this.m_sDynamicStylesheet);
                    StringReader stringReader = new StringReader(string);
                    this.setStylesheet(stringReader);
                    return;
                }
            }
            this.setStylesheet(string);
            return;
        }
        catch (Exception exception) {
            this.m_logger.write(1, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>P}y\u007fm2Jpouqy\n}\u0019\u0004B^FCY^DEC\u000e") + exception.getMessage());
        }
    }

    public OMAStylesheetLoader(Reader reader) {
        try {
            this.setStylesheet(reader);
        }
        catch (Exception exception) {
            this.m_logger.write(1, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>P}y\u007fm2I\u007f~z|n\n}\u0019\u0004B^FCY^DEC\u000e") + exception.getMessage());
        }
    }

    protected synchronized void joinStylesheet() throws InstantiationException, Exception {
        try {
            long l = System.currentTimeMillis();
            this.m_thread.join();
            long l2 = System.currentTimeMillis();
            this.m_logger.write(9, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>tqcEmaw\u007fpv|{U\u001c\u0003uFMS\b]AHO\r\u0011\u000f") + (l2 - l));
            if (this.m_sStylesheetPath != null) {
                this.m_logger.write(9, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>tqcEmaw\u007fpv|{U\u001c\u0003WXMIA\u0001") + this.m_sStylesheetPath + AOMACLIPlugin.A_B_C_D("*"));
                File file = new File(this.m_sStylesheetPath);
                if (this.m_nTimestamp != file.lastModified()) {
                    this.m_nTimestamp = file.lastModified();
                    this.m_thread = new Thread(this);
                    this.m_thread.start();
                }
            }
            if (this.m_loadException != null) {
                throw this.m_loadException;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InstantiationException(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>tqcEmaw\u007fpv|{U\u001c\u0003tWKFC\\[DFL\u000eHBEUABBFCS]\u0018"));
        }
    }

    public synchronized void setStylesheet(String string) throws InstantiationException {
        try {
            if (this.m_thread != null) {
                this.m_thread.join();
            }
            this.m_logger.write(9, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>hqcEmaw\u007fpv|{U\u001c\u0003wXMIA\t[_SAI^HVUG\u0014") + string);
            this.m_loadException = null;
            this.m_rStylesheetReader = null;
            this.m_sStylesheetPath = string;
            File file = new File(this.m_sStylesheetPath);
            this.m_nTimestamp = file.lastModified();
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
        catch (InterruptedException interruptedException) {
            throw new InstantiationException(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>hqcEmaw\u007fpv|{U\u001c\u0003qBR\u0007BJAGOI\u0004"));
        }
    }

    public synchronized void setStylesheet(Reader reader) throws InstantiationException {
        try {
            if (this.m_thread != null) {
                this.m_thread.join();
            }
            this.m_logger.write(9, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>hqcEmaw\u007fpv|{U\u001c\u0003wXMIA\t\\PKII]\u0010`TYWXB\u0019"));
            this.m_loadException = null;
            this.m_sStylesheetPath = null;
            this.m_rStylesheetReader = reader;
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
        catch (InterruptedException interruptedException) {
            throw new InstantiationException(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>hqcEmaw\u007fpv|{U\u001c\u0003qBR\u0007BJAGOI\u0004"));
        }
    }

    public void process(Reader reader, Writer writer) throws InstantiationException, Exception {
        this.joinStylesheet();
        this.m_transformer.process(reader, writer);
    }

    @Override
    public void run() {
        block7: {
            try {
                if (m_bUseXalan2) {
                    this.m_transformer = new OMAStylesheetLoaderXalan2();
                }
                if (this.m_sStylesheetPath != null) {
                    this.m_transformer.load(this.m_sStylesheetPath);
                    break block7;
                }
                if (this.m_rStylesheetReader != null) {
                    this.m_transformer.load(this.m_rStylesheetReader);
                    break block7;
                }
                throw new Exception(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>gay.9BJX=orkSCH\u0004KKS\b\\M_"));
            }
            catch (Exception exception) {
                this.m_logger.write(1, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>gay.9") + exception.getMessage());
                if (this.m_sStylesheetPath != null) {
                    this.m_logger.write(9, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>gay.9kj'") + this.m_sStylesheetPath);
                }
                if (this.m_sDynamicStylesheet != null) {
                    this.m_logger.write(9, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>gay.9kj'") + this.m_sDynamicStylesheet);
                }
                this.m_loadException = exception;
            }
        }
    }

    public static void unitTest(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>b|\u0080dM}jp'>LmBGH\u0004lihu]QGO`FLKE~^SQQE\u0018d\u0015Xg\u001dfnta\u001a\u0010\u0010"));
            System.out.println(AOMACLIPlugin.A_B_C_D("!\"#$%&'()*+,-./0123456789:;<=>JxFTH"));
            System.out.println(AOMACLIPlugin.A_B_C_D("!\"#$%&'()*+,-./0123456789:;<=>?@\u0001\u0002\u0003\u000fJ\u0006\f\bq{g\f]M]O^UGWG\u0016`E\u0019QUXVT\\ \u0019\u0013\u000f"));
            return;
        }
        try {
            Closeable closeable;
            OMAStylesheetLoader oMAStylesheetLoader = null;
            String string = null;
            if (stringArray[0].equalsIgnoreCase(AOMACLIPlugin.A_B_C_D(".m"))) {
                System.out.println(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>b|\u0080dM}jp'>sqBFLND\u0006AVHE\u000bYY`HBX\u0012") + stringArray[1]);
                closeable = new StringReader(stringArray[1]);
                oMAStylesheetLoader = new OMAStylesheetLoader((Reader)closeable);
                string = stringArray[2];
            } else {
                System.out.println(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>b|\u0080dM}jp'>sqBFLND\u0006AVHE\u000bNFBL\u0010") + stringArray[0]);
                oMAStylesheetLoader = new OMAStylesheetLoader(stringArray[0]);
                string = stringArray[1];
            }
            closeable = new StringWriter();
            oMAStylesheetLoader.process(new FileReader(string), (Writer)closeable);
            System.out.println(closeable);
        }
        catch (Exception exception) {
            System.out.println(AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua>b|\u0080dM}jp'>") + exception.toString());
        }
    }

    static {
        String string = AOMACLIPlugin.A_B_C_D("utxg");
        try {
            Class<?> clazz = Class.forName(AOMACLIPlugin.A_B_C_D("kauc},\u007fke(\u007fznd~j\u0080d\u0080>Ahxzl\u0080vjrymZBCWMW]"));
            OMALogging.getInstance().write(3, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua*5af\u007fw\u007f;UR]NlZNHQMADTeGLPJ`wO]Q]\u0002"));
            m_bUseXalan2 = true;
        }
        catch (Exception exception) {
            OMALogging.getInstance().write(2, AOMACLIPlugin.A_B_C_D("PMDQq}kc|bpoyBbouua*5Nx|zx;*=rx~SAQ[\u0005LJT\tPF_CJ\u0001"));
            m_bUseXalan2 = false;
        }
    }
}

