package Collectd::Graph::Type::Threephasecurrent;

# Copyright (C) 2009  Stefan Pfab <spfab at noris.net>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; only version 2 of the License is applicable.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

use strict;
use warnings;
use base ('Collectd::Graph::Type');

use Collectd::Graph::Common (qw(ident_to_filename get_faded_color));

return (1);

sub getDataSources
{
  return ([qw(current)]);
} # getDataSources

sub new
{
  my $pkg = shift;
  my $obj = Collectd::Graph::Type->new (@_);
  $obj->{'data_sources'} = [qw(current)];
  $obj->{'rrd_opts'} = ['-v', 'Ampere'];
  $obj->{'rrd_title'} = 'Ampere ({type_instance})';
  $obj->{'rrd_format'} = '%5.1lf%s A';
  $obj->{'colors'} = [qw(000000 f00000)];

  return (bless ($obj, $pkg));
} # new

sub getRRDArgs
{
  my $obj = shift;
  my $index = shift;

  my $ident = $obj->{'files'}[$index];
  if (!$ident)
  {
    cluck ("Invalid index: $index");
    return;
  }
  my $filename = ident_to_filename ($ident);
  $filename =~ s#:#\\:#g;

  my $faded_green = get_faded_color ('00ff00');
  my $faded_red = get_faded_color ('ff0000');

  #/var/lib/collectd/rrd/mgw1-nbg3.hs.noris.de/snmp/current-L1_field-evu.rrd
  #  /(.*)(current-)L([d])(_field(.*)\.rrd)/)
  if ($filename =~ /(.*current-)L(\d)(.*\.rrd)/)
  {
        my $file_l1 = $1 . "L1" . $3;
        my $file_l2 = $1 . "L2" . $3;
        my $file_l3 = $1 . "L3" . $3;
        my $file_n = $1 . "N" . $3;  

  return (['-t', 'Strom (' . $ident->{'type_instance'} . ')', '-v', 'Ampere', '-l', '0',
    "DEF:min1=${file_l1}:value:MIN",
    "DEF:avg1=${file_l1}:value:AVERAGE",
    "DEF:max1=${file_l1}:value:MAX",
    "DEF:min2=${file_l2}:value:MIN",
    "DEF:avg2=${file_l2}:value:AVERAGE",
    "DEF:max2=${file_l2}:value:MAX",
    "DEF:min3=${file_l3}:value:MIN",
    "DEF:avg3=${file_l3}:value:AVERAGE",
    "DEF:max3=${file_l3}:value:MAX",
    'CDEF:ravg1=avg1,10,/,',
    'CDEF:ravg2=avg2,10,/,',
    'CDEF:ravg3=avg3,10,/,',
    'CDEF:sum=ravg1,ravg2,+,ravg3,+,',

    #'VDEF:total=watt_total,TOTAL',
    #'VDEF:first=watt_total,FIRST',
    #'VDEF:last=watt_total,LAST',
    #'CDEF:first_value=first,POP',
    #'CDEF:first_time=first,POP',
    'LINE1:ravg1#ff0000:L1 A',
    'GPRINT:ravg1:AVERAGE:%4.1lfA Avg,\l',
    'LINE1:ravg2#00ff00:L2 A',
    'GPRINT:ravg1:AVERAGE:%4.1lfA Avg,\l',
    'LINE1:ravg3#0000ff:L3 A',
    'GPRINT:ravg2:AVERAGE:%4.1lfA Avg,\l',
    'LINE1:sum#00000f:Summe L123 Ampere',
    'GPRINT:sum:AVERAGE:%4.1lfA L3 Avg\l']);
    #'GPRINT:sum:%4.1lf%sA alle Phasen\l',
    #'GPRINT:first:erster Wert %c:strftime',
    #'GPRINT:last:letzter Wert %c:strftime']);



  }
  else
  {

  return (['-t', 'Strom (' . $ident->{'type_instance'} . ')', '-v', 'Ampere', '-l', '0',
    "DEF:min0=${filename}:value:MIN",
    "DEF:avg0=${filename}:value:AVERAGE",
    "DEF:max0=${filename}:value:MAX",
    'AREA:max0#bfbfbf',
    'AREA:min0#FFFFFF',
    #'CDEF:watt_avg0=avg0,36000,*,',
    #'CDEF:watt_min0=min0,36000,*,',
    #'CDEF:watt_max0=max0,36000,*,',
    #'CDEF:watt_total=avg0,10,*,',
    #'VDEF:total=watt_total,TOTAL',
    #'VDEF:first=watt_total,FIRST',
    #'VDEF:last=watt_total,LAST',
    #'CDEF:first_value=first,POP',
    #'CDEF:first_time=first,POP',
    'LINE1:avg0#000000:A',
    #'HRULE:2300#ff0000',
    'GPRINT:min0:MIN:%4.1lfA Min,',
    'GPRINT:avg0:AVERAGE:%4.1lfA Avg,',
    'GPRINT:max0:MAX:%4.1lfA Max,',
    'GPRINT:avg0:LAST:%4.1lfA Last\l']);
    #'GPRINT:total:%4.1lf%sWh Gesamtverbrauch im angezeigten Zeitraum\l',
    #'GPRINT:first:erster Wert %c:strftime',
    #'GPRINT:last:letzter Wert %c:strftime']);

    # HRULE:190\ ff0000    
  } # normal current
} # getRRDArgs

# vim: set shiftwidth=2 softtabstop=2 tabstop=8 :
