package Collectd::Graph::Type::Cosphi;

# Copyright (C) 2009  Stefan Pfab <spfab at noris.net>
# Copyright (C) 2010  Florian Forster <octo at noris.net>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; only version 2 of the License is applicable.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

use strict;
use warnings;
use base ('Collectd::Graph::Type');

use Collectd::Graph::Common (qw(ident_to_filename get_faded_color));

return (1);

sub getDataSources
{
  return ([qw(value)]);
} # getDataSources

sub new
{
  my $pkg = shift;
  my $obj = Collectd::Graph::Type->new (@_);
  $obj->{'data_sources'} = [qw(value)];
  $obj->{'rrd_opts'} = ['-v', 'cos(Phi)'];
  $obj->{'rrd_title'} = 'cos(Phi) ({instance})';
  $obj->{'rrd_format'} = '%.3lf';
  $obj->{'colors'} = [qw(000000 f00000)];

  return (bless ($obj, $pkg));
} # new

sub getRRDArgs
{
  my $obj = shift;
  my $index = shift;

  my $ident = $obj->{'files'}[$index];
  if (!$ident)
  {
    cluck ("Invalid index: $index");
    return;
  }
  my $filename = ident_to_filename ($ident);
  $filename =~ s#:#\\:#g;

  my $faded_blue = get_faded_color ('0000ff');
  my $faded_red = get_faded_color ('ff0000');

  my $rrd_title = $obj->getTitle ($ident);

  return (['-t', $rrd_title, '-v', 'cos(Phi)', '-l', '0', '-u', '1', '-X', '0',
    "DEF:raw_min=${filename}:value:MIN",
    "DEF:raw_avg=${filename}:value:AVERAGE",
    "DEF:raw_max=${filename}:value:MAX",
    # Induktive Werte
    "CDEF:ind_min=raw_min,0,GE,1,raw_min,-,UNKN,IF",
    "CDEF:ind_avg=raw_avg,0,GE,1,raw_avg,-,UNKN,IF",
    "CDEF:ind_max=raw_max,0,GE,1,raw_max,-,UNKN,IF",
    # Kapazitive Werte
    "CDEF:cap_min=raw_min,0,LE,1,raw_min,+,UNKN,IF",
    "CDEF:cap_avg=raw_avg,0,LE,1,raw_avg,+,UNKN,IF",
    "CDEF:cap_max=raw_max,0,LE,1,raw_max,+,UNKN,IF",
    "CDEF:ind_cnt=raw_min,0,GE,1,0,IF",
    "CDEF:cap_cnt=raw_min,0,LE,1,0,IF",
    'VDEF:l_ind_min=ind_min,MINIMUM',
    'VDEF:l_ind_avg=ind_avg,AVERAGE',
    'VDEF:l_ind_max=ind_max,MAXIMUM',
    'VDEF:l_ind_lst=ind_avg,LAST',
    'VDEF:l_cap_min=cap_min,MINIMUM',
    'VDEF:l_cap_avg=cap_avg,AVERAGE',
    'VDEF:l_cap_max=cap_max,MAXIMUM',
    'VDEF:l_cap_lst=cap_avg,LAST',
    "AREA:ind_avg#${faded_red}",
    'LINE1:ind_avg#ff0000:Induktiv ',
    'GPRINT:l_ind_min:%5.3lf min,',
    'GPRINT:l_ind_avg:%5.3lf avg,',
    'GPRINT:l_ind_max:%5.3lf max,',
    'GPRINT:l_ind_lst:%5.3lf last\l',
    "AREA:cap_avg#${faded_blue}",
    'LINE1:cap_avg#0000ff:Kapazitiv',
    'GPRINT:l_cap_min:%5.3lf min,',
    'GPRINT:l_cap_avg:%5.3lf avg,',
    'GPRINT:l_cap_max:%5.3lf max,',
    'GPRINT:l_cap_lst:%5.3lf last\l']);
} # getRRDArgs

# vim: set shiftwidth=2 softtabstop=2 tabstop=8 :
