#!/usr/bin/perl

use strict;
use warnings;
use lib ('../lib');
use utf8;

use FindBin ('$RealBin');
use Carp (qw(confess cluck));
use CGI (':cgi');
use RRDs ();

use CGI::Fast;

use Collectd::Graph::Config (qw(gc_read_config gc_get_scalar));
use Collectd::Graph::TypeLoader (qw(tl_load_type));

use Collectd::Graph::Common (qw(sanitize_type get_selected_files
      epoch_to_rfc1123 flush_files));
use Collectd::Graph::Type ();

## versuche für fast-cgi
while ( my $fcgi = new CGI::Fast ) {

our $Debug = param ('debug');
our $Begin = param ('begin');
our $End = param ('end');
our $GraphWidth = param ('width');
our $GraphHeight = param ('height');
our $y_min;
if (defined( param ('y_min'))) { $y_min = param('y_min') } else { $y_min = '' };
our $y_max;
if (defined( param ('y_max'))) { $y_max = param('y_max') } else { $y_max = '' };

our $Index;
if (defined param ('index')) { $Index = param ('index') } else { $Index = 0 };

our $OutputFormat = 'PNG';
our $ContentType = 'image/png';


# while ( my $fcgi = new CGI::Fast ) {

if (param ('format'))
{
  my $temp = param ('format') || '';
  $temp = uc ($temp);

  if ($temp =~ m/^(PNG|SVG|EPS|PDF)$/)
  {
    $OutputFormat = $temp;

    if ($OutputFormat eq 'SVG') { $ContentType = 'image/svg+xml'; }
    elsif ($OutputFormat eq 'EPS') { $ContentType = 'image/eps'; }
    elsif ($OutputFormat eq 'PDF') { $ContentType = 'application/pdf'; }
  }
}

if ($Debug)
{
  print $fcgi <<HTTP;
Content-Type: text/plain

HTTP
}

gc_read_config ("$RealBin/../etc/collection.conf");

if ($GraphWidth)
{
  $GraphWidth =~ s/\D//g;
}

if (!$GraphWidth)
{
  $GraphWidth = gc_get_scalar ('GraphWidth', 400);
}

if ($GraphHeight)
{
  $GraphHeight =~ s/\D//g;
}

if (!$GraphHeight)
{
  $GraphHeight = gc_get_scalar ('GraphHeight', 100);
}

{ # Sanitize begin and end times
  $End ||= 0;
  $Begin ||= 0;

  if ($End =~ m/\D/)
  {
    $End = 0;
  }

  if (!$Begin || !($Begin =~ m/^-?([1-9][0-9]*)$/))
  {
    $Begin = -86400;
  }

  if ($Begin < 0)
  {
    if ($End)
    {
      $Begin = $End + $Begin;
    }
    else
    {
      $Begin = time () + $Begin;
    }
  }

  if ($Begin < 0)
  {
    $Begin = time () - 86400;
  }

  if (($End > 0) && ($Begin > $End))
  {
    my $temp = $End;
    $End = $Begin;
    $Begin = $temp;
  }
}

my $type = param ('type') or die;
my $obj;

$obj = tl_load_type ($type);
if (!$obj)
{
  confess ("tl_load_type ($type) failed");
}

$type = ucfirst (lc ($type));
$type =~ s/_([A-Za-z])/\U$1\E/g;
$type = sanitize_type ($type);

my $files = get_selected_files ();
if ($Debug)
{
  require Data::Dumper;
  print $fcgi Data::Dumper->Dump ([$files], ['files']);
}
for (@$files)
{
  $obj->addFiles ($_);
}

my $expires = time ();
# IF (End is `now')
#    OR (Begin is before `now' AND End is after `now')
if (($End == 0) || (($Begin <= $expires) && ($End >= $expires)))
{
  # 400 == width in pixels
  my $timespan;

  if ($End == 0)
  {
    $timespan = $expires - $Begin;
  }
  else
  {
    $timespan = $End - $Begin;
  }
  $expires += int ($timespan / 400.0);
}
# IF (End is not `now')
#    AND (End is before `now')
# ==> Graph will never change again!
elsif (($End > 0) && ($End < $expires))
{
  $expires += (366 * 86400);
}
elsif ($Begin > $expires)
{
  $expires = $Begin;
}

# Send FLUSH command to the daemon if necessary and possible.
flush_files ($files,
    begin => $Begin,
    end => $End,
    addr => gc_get_scalar ('UnixSockAddr', undef),
    interval => gc_get_scalar ('Interval', 10));

print $fcgi->header (-Content_type => $ContentType,
  -Last_Modified => epoch_to_rfc1123 ($obj->getLastModified ()),
  -Expires => epoch_to_rfc1123 ($expires));

if ($Debug)
{
  print "\$expires = $expires;\n";
}

my $args = $obj->getRRDArgs (0 + $Index);

if ($Debug)
{
  require Data::Dumper;
  print Data::Dumper->Dump ([$obj], ['obj']);
  print join (",\n", @$args) . "\n";
  print "Last-Modified: " . epoch_to_rfc1123 ($obj->getLastModified ()) . "\n";
}
else
{
  my @timesel = ();

  if ($End) # $Begin is always true
  {
    @timesel = ('-s', $Begin, '-e', $End);
  }
  else
  {
    @timesel = ('-s', $Begin); # End is implicitely `now'.
  }

  $| = 1;
  $ENV{"RRDCACHED_ADDRESS"} = "/var/run/rrdcached.sock";

  # Ticket 14091214: title anzeigen
  if (param('title')) {
    push @$args, '--title', scalar(param('title'));
  }

  # Workaround für Ausgabeproblem i. V. m. FastCGI, vgl. Ticket 13551155:
  use File::Temp qw/tempfile/;
  my ( $temp_fh, $temp_filename ) = tempfile();
  if ($y_max eq '' || $y_min eq '') {
  	RRDs::graph ( $temp_filename, '-a', $OutputFormat, '--width', $GraphWidth, '--height', $GraphHeight, @timesel, @$args);
  } else {
	RRDs::graph ( $temp_filename, '-a', $OutputFormat, '--width', $GraphWidth, '--height', $GraphHeight, '--rigid', '--upper-limit', $y_max, '--lower-limit', $y_min, @timesel, @$args);  
  }
  unlink $temp_filename;
  if (my $err = RRDs::error ())
  {
    print STDERR "RRDs::graph failed: $err\n";
    #exit (1);
  }
  else {
    local $/;
    print <$temp_fh>;
  }
}

} ## fastcgi-loop

exit (0);

# vim: set shiftwidth=2 softtabstop=2 tabstop=8 :
