#!/usr/bin/env python2
# -*- coding: utf-8 -*-
import getpass
from pysphere import VIServer # will nicht mit python3
from pysphere import VIException
from pysphere import MORTypes
import argparse
import sys
import os
from threading import Thread
from threading import activeCount
import setproctitle
import time
import re
import datetime
import ConfigParser
from subprocess import (PIPE, Popen)


# Anlegen, Loeschen und Anzeigen von Snapshots fuer eine Liste von VMs
# klaus.franken@noris.de
VERSION="2016-06.1"
MYNAME=os.path.basename(__file__)
setproctitle.setproctitle(MYNAME)

# FIXME:
# - in all_hosts wird server.get_registered_vms() aufgerufen, fast immer ist der vmx-Dateinam auch der vm-Name
#   Aber nicht immer, z.B. bei fw-neu.schwancosmetics.noris.de
#   Abhilfe: Benutze sowas:
#           vm = server.get_vm_by_path(vmx)
#           vmname = vm.get_property('name')
#   aber dauert ewig.
# - -F: Handling, wenn es Folder nicht gibt

# ToDo:

# Globals
sn_created=0
sn_deleted=0
threads = []
verbose=0

def printverbose(m):
  if verbose>0:
    print m

def snapshot_create(vm, snname, sndescr):
  global sn_created
  global args
  host = vm.get_property('name')
  print "%s Snapshot %s anlegen ..." % (host, snname)
  snapshots = vm.get_snapshots()
  if snapshots:
    print "WARNUNG: es gibt schon Snapshots für Host %s, das kann Performance-Probleme machen:" % (host)
    snapshot_list(vm, 0)
  if not args.dry:
    try:
      vm.create_snapshot(snname, description=sndescr)
      print "%s Snapshot %s angelegt." % (host, snname)
      sn_created += 1
    except VIException, e:
      print "%s Snapshot %s FEHLER: %s" % (host, snname, e)

def snapshot_delete(vm, snname):
  global sn_deleted
  global args
  host = vm.get_property('name')
  snapshot_list = vm.get_snapshots()
  for snapshot in snapshot_list:
    if snapshot.get_name() == snname:
      print "%s Snapshot %s loeschen ..." % (host, snname)
      if not args.dry:
        try:
          vm.delete_named_snapshot(snname) # kanns ja mehrfach geben ...
          sn_deleted += 1
          print "%s Snapshot %s geloescht." % (host, snname)
        except VIException, e:
          print "%s Snapshot %s loeschen FEHLER: %s" % (host, snname, e)

def snapshot_list(vm, old):
  snapshot_list = vm.get_snapshots()
  host = vm.get_property('name')
  for snapshot in snapshot_list:
    vmdate=snapshot.get_create_time()
    jetzt=datetime.datetime.today()
    vmdate_dt=datetime.datetime(vmdate[0], vmdate[1], vmdate[2], vmdate[3], vmdate[4])
    alter=jetzt-vmdate_dt
    altertage=alter.days
    if altertage >= old:
      datum="%d-%02d-%02d %02d:%02d:%02d" % ( vmdate[0], vmdate[1], vmdate[2], vmdate[3], vmdate[4], vmdate[5] )
      print "%s, %s (%d Tage), %s, %s" % (host, datum, altertage, snapshot.get_name(), snapshot.get_description())

def all_hosts(server, hosts):
  allhosts=[]
  found=dict()
  for vmx in server.get_registered_vms():
    # Beispiel: [na5-vmstor2] fw-neu.schwancosmetics.noris.de/fw-neu.schwancosmetics.noris.de.vmx
    matchObj = re.match( r'\[.*\]\s*(.*)\/', vmx, re.I)
    if matchObj:
      vm = matchObj.group(1)
      # Beispiel: vm: fw-neu.schwancosmetics.noris.de
      for host in hosts:
        matchObjHost = re.match( host, vm, re.I)
        if matchObjHost:
          allhosts.append(vm)
          printverbose("'%s' passt auf '%s'" % (host, vm))
          found[vm] = True
    else:
      print "ERROR: kann VM-Name nicht interpretieren: %s" % (vmx)
  for host in hosts:
    if not found.has_key(host):
      print("WARNING: kein Host gefunden für '%s'" % host)
  allhosts = sorted(set(allhosts)) # set: macht es unique (doppelte Hosts elimieren)
  return allhosts

def hostscmd(cmd, allhosts):
  printverbose("Kommando '%s':" % (cmd))
  for host in Popen(cmd, stdout=PIPE, shell=True).stdout:
    host=host.rstrip()
    printverbose("  '%s'" % (host))
    allhosts.append(host)
  allhosts = sorted(set(allhosts)) # set: macht es unique (doppelte Hosts elimieren)
  return allhosts

def expand_folder(server, folders, allhosts):
  for folder in folders:
    # stolen from Tim
    folder_mor_arr=[mor for mor,name in server._get_managed_objects(MORTypes.Folder).items() if name == folder]
    if not folder_mor_arr:
      print "Folder '%s' existiert nicht" % folder
    else:
      folder_mor=folder_mor_arr[0]
      hostdict = server._get_managed_objects(MORTypes.VirtualMachine, from_mor=folder_mor)
      allhosts = allhosts+hostdict.values()
      printverbose("Folder '%s' expandiert zu:" % (folder))
      for host in hostdict.values():
        printverbose("  %s" % host)
  allhosts = sorted(set(allhosts))
  return allhosts


parser = argparse.ArgumentParser()
parser.add_argument('-v', '--version',    dest='version',   action='store_true', help="Drucke Version und beenden")
parser.add_argument('-c', '--create',     dest='create',    action='store_true', help='Create Snapshots')
parser.add_argument('-d', '--delete',     dest='delete',    action='store_true', help='Delete Snapshots')
parser.add_argument('-n', '--dry-run',    dest='dry',       action='store_true', help='Trockenlauf: nur Anzeige')
parser.add_argument('-l', '--list',       dest='list',      action='store_true', help='List Snapshots')
parser.add_argument('-H', '--hosts',      dest='hosts',     type=str, nargs='*', help='Liste von Hosts (VM-Namen)')
parser.add_argument(      '--hostscmd',   dest='hostscmd',  type=str,            help='Kommando für Liste von Hosts')
parser.add_argument('-F', '--folder',     dest='folder',    type=str, nargs='*', help='Folder (alle Hosts aus diesem Folder, rekursiv)')
parser.add_argument(      '--foldercmd',  dest='foldercmd', type=str,            help='Kommando für Liste von Foldern')
parser.add_argument('-t', '--ticket',     dest='ticket',    type=str,            help='Ticketnr.')
parser.add_argument('-p', '--praefix',    dest='praefix',   type=str, default='autosnap-', help="Snapshot-Praefix (Default: 'autosnap-')")
parser.add_argument('-s', '--server',     dest='vmserver',  type=str, default='vcenter01vp.vmware.noris.de', help="vcenter-Servername (vcenter01vp.vmware.noris.de oder vcenter02vp.vmware.noris.de)")
parser.add_argument('-u', '--user',       dest='username',  type=str, default='',help="vcenter-Username")
parser.add_argument('-m', '--maxthreats', dest='maxthreats',type=int, default=5, help="max. parallele Snapshots anlegen")
parser.add_argument('-o', '--old',        dest='old',       type=int, default=0, help="bei --list: alte Snapshots, älter als N Tage")
parser.add_argument('-V', '--verbose',    dest='verbose',   action='store_true', help="verbose")
parser.add_argument('-P', '--password',   dest='password',  type=str,            help='Password (unsicher!)')
parser.add_argument('-C', '--config',     dest='config',    type=str,            help='Config-File')

args = parser.parse_args()

if args.verbose:
  verbose=1
if args.version:
  print "%s %s" % (MYNAME, VERSION)
  sys.exit(0)
if args.config:
  config = ConfigParser.ConfigParser(allow_no_value = True)
  if not config.read(args.config):
    print "Configfile '%s' kann nicht gelesen werden" % (args.config)
    sys.exit(42)
  if config.has_section('options'):
    if not args.verbose and config.has_option('options','verbose'):
      verbose=config.getboolean('options', 'verbose')
      printverbose("Config: verbose='%s'" % verbose)
    if not args.dry and config.has_option('options','dry'):
      args.dry=config.getboolean('options', 'dry')
      printverbose("Config: dry='%s'" % args.dry)
    if not args.ticket and config.has_option('options','ticket'):
      args.ticket=config.get('options', 'ticket')
      printverbose("Config: ticket='%s'" % args.ticket)
    if args.praefix is 'autosnap-' and config.has_option('options','praefix'):
      args.praefix=config.get('options', 'praefix')
      printverbose("Config: praefix='%s'" % args.praefix)
    if args.maxthreats == 5 and config.has_option('options','maxthreats'):
      args.maxthreats=config.getint('options', 'maxthreats')
      printverbose("Config: maxthreats='%s'" % args.maxthreats)
    if args.old == 0 and config.has_option('options','old'):
      args.old=config.getint('options', 'old')
      printverbose("Config: old='%s'" % args.old)
  if config.has_section('user'):
    if not args.password and config.has_option('user','password'):
      args.password=config.get('user','password')
      printverbose("Passwort aus Config gelesen")
    if not args.username and config.has_option('user','username'):
      args.username=config.get('user','username')
      printverbose("Config: username='%s'" % args.username)
  if config.has_section('hosts'):
    if not args.folder and config.has_option('hosts','folder'):
      args.folder=config.get('hosts', 'folder').split(" ")
      printverbose("Config: folder='%s'" % args.folder)
    if not args.hosts and config.has_option('hosts','hosts'):
      args.hosts=config.get('hosts', 'hosts').split(" ")
      printverbose("Config: hosts='%s'" % args.hosts)
    if not args.hostscmd and config.has_option('hosts','hostscmd'):
      args.hostscmd=config.get('hosts', 'hostscmd')
      printverbose("Config: hostscmd='%s'" % args.hostscmd)
    if not args.foldercmd and config.has_option('hosts','foldercmd'):
      args.foldercmd=config.get('hosts', 'foldercmd')
      printverbose("Config: foldercmd='%s'" % args.foldercmd)
  if config.has_section('command'):
    if not args.create and config.has_option('command','create'):
      args.create=config.getboolean('command', 'create')
      printverbose("Config: create='%s'" % args.create)
    if not args.delete and config.has_option('command','delete'):
      args.delete=config.getboolean('command', 'delete')
      printverbose("Config: delete='%s'" % args.delete)
    if not args.list and config.has_option('command','list'):
      args.list=config.getboolean('command', 'list')
      printverbose("Config: list='%s'" % args.list)
if not args.username:
  args.username="WINZONE\%s" % os.environ['USER']

if not args.ticket and (args.create or args.delete):
  print "Ticket-Nummer angeben! (-t)"
  sys.exit(42)
if not args.hosts and not args.folder and not args.hostscmd and not args.foldercmd:
  print "Hosts auswaehlen mit --hosts und/oder --folder und/oder --hostscmd und/oder --holdercmd"
  sys.exit(42)
  
if args.password:
  passwd = args.password
else:
  passwd = getpass.getpass(prompt="Password fuer '%s' auf vCenter '%s': " % (args.username, args.vmserver))
server = VIServer()
try:
  server.connect(args.vmserver, args.username, passwd)
except VIException, e:
  print "Fehler bei Anmeldung: %s" % (e)
  sys.exit(42)

if not args.create and not args.delete and not args.list:
  print "Mindestens eines der Kommando --create oder --delete oder --list angeben!"

snname="%s%s" % (args.praefix, args.ticket)

allhosts=[]
if args.hosts:
  allhosts = all_hosts(server, args.hosts)
if args.hostscmd:
  allhosts = hostscmd(args.hostscmd, allhosts)
if args.foldercmd:
  args.folder = hostscmd(args.foldercmd, [])
if args.folder:
  allhosts = expand_folder(server, args.folder, allhosts)
for host in allhosts:
  test_replica = re.compile('.*replica[_1]*$')
  if test_replica.match(host):
    printverbose("ignoriere Replica-Host %s" % host)
    continue
  printverbose("Bearbeite Host %s" % host)
  try:
    vm = server.get_vm_by_name(host)
    if args.create:
      while args.maxthreats and activeCount() > args.maxthreats:
        time.sleep(5)
      t = Thread(target=snapshot_create, args=(vm, snname, "created with %s %s" % (MYNAME, VERSION)))
      t.start()
      threads += [t]
    if args.delete:
      snapshot_delete(vm, snname)
    if args.list:
      snapshot_list(vm, args.old)
  except VIException, e:
    print "%s FEHLER: %s" % (host, e)

# joine alle Threads, um auf Beendigung zu warten
for t in threads: 
    t.join()

if args.create:
  print "Snapshots angelegt: %d" % (sn_created)
if args.delete:
  print "Snapshots geloescht: %d" % (sn_deleted)

sys.exit(0)

