use strict;
use warnings;
use utf8;
use Test::More tests => 6;
use Data::Dump qw(pp);
use NorisOtrsReport::Framework qw(generate :convert);
use NorisOtrsReport::QuelleProcessor;
use NorisOtrsReport::TestRenderer;

=head1 Funktionaler Test zu Ticket #10016998

Standorte und die Zahl der betroffener Mitarbeiter werden
nun nicht mehr aus dem Freitextfeld ermittelt, sondern aus
dem letzten Ticket-Verlauf.

=cut

my $Conversions = [
    [ CreateTime  => \&convert_isodate_to_date_hash, 'created' ],
    [ Created     => \&convert_isodate_to_date_hash, 'created' ]
];

sub test_run {
    my ($LoadFixture, $DateStr, $Typ) = @_;
    my $Start = convert_isodate_to_date_hash($DateStr)->{epoch};
    my $Renderer = NorisOtrsReport::TestRenderer->new();
    my $Processor = NorisOtrsReport::QuelleProcessor->new(
            Typ => $Typ,
            Start => $Start,
            Renderer => $Renderer
        );
    generate(
        UserID => 1,
        Conversions => $Conversions,
        LoadFixture => $LoadFixture,
        Processors => [ $Processor ]
    );
    return $Renderer->items()->[0];
}
    

my $Computed;

# Im Freitextfeld steht ein falscher Standort/MA
$Computed = test_run(
        't/functional/10016998-01.json',
        '2009-04-08 14:00',
        'daily'
    )->[0];

is_deeply $Computed->{Standorte}, ['Nürnberg'];
is_deeply $Computed->{MA}, ['5/13'];

$Computed = test_run(
        't/functional/10016998-02.json',
        '2009-04-08 14:00',
        'daily'
    )->[0];

# Im Freitextfeld steht gar kein Standort/MA
is_deeply $Computed->{Standorte}, ['Nürnberg'];
is_deeply $Computed->{MA}, ['5/13'];

$Computed = test_run(
        't/functional/10016998-03.json',
        '2009-04-08 14:00',
        'daily'
    )->[0];

# Im Verlauf steht gar kein Standort/MA (im Freitextfeld wohl)
is_deeply $Computed->{Standorte}, [];
is_deeply $Computed->{MA}, [];
