use strict;
use warnings;
use utf8;
use Test::More tests => 4;
use Data::Dump qw(pp);
use NorisOtrsReport::Framework qw(generate :convert);
use NorisOtrsReport::QuelleProcessor;
use NorisOtrsReport::TestRenderer;

=head1 Funktionaler Test zu Ticket #10013755

Zu verlinkten Tickets wird nun neben der TicketNumber auch die Kategorie ermittelt.

=cut

my $Conversions = [
    [ CreateTime  => \&convert_isodate_to_date_hash, 'created' ],
    [ Created     => \&convert_isodate_to_date_hash, 'created' ]
];

sub test_run {
    my ($LoadFixture, $DateStr, $Typ) = @_;
    my $Start = convert_isodate_to_date_hash($DateStr)->{epoch};
    my $Renderer = NorisOtrsReport::TestRenderer->new();
    my $Processor = NorisOtrsReport::QuelleProcessor->new(
            Typ => $Typ,
            Start => $Start,
            Renderer => $Renderer
        );
    generate(
        UserID => 1,
        Conversions => $Conversions,
        LoadFixture => $LoadFixture,
        Processors => [ $Processor ]
    );
    return $Renderer->items()->[0];
}

# gibt eine hash-Refenz zurück, die zu jeder Ticketnummer den Namen der Kategorie enthält.
sub kategorien {
    my ($Data) = @_;
    my %TicketToKategorie = 
        map { ($_->{TicketNumber}, $_->{Kategorie}) } @{$Data->{SubTickets}};   
    return \%TicketToKategorie;
}

my $Computed = test_run(
        't/functional/10013755-01.json',
        '2009-05-10 18:41',
        'daily'
    );
print pp($Computed), "\n";
my $Kat = kategorien($Computed->[0]);
is_deeply $Kat->{9920000010522}, 'Datenbanken-Eigentwicklung';
is_deeply $Kat->{9920000010511}, 'Outlook';
is scalar keys %{$Kat}, 2;

$Kat = kategorien($Computed->[1]);
is scalar keys %{$Kat}, 0;

