use strict;
use warnings;
use utf8;
use Test::More tests => 4;
use Data::Dump qw(pp);
use NorisOtrsReport::Framework qw(generate :convert);
use NorisOtrsReport::QuelleProcessor;
use NorisOtrsReport::TestRenderer;

=head1

Testet die Sortierreihenfolge von Tickets. Siehe Ticket #10010873 zur 
Reihenfolge im Op-Call und Ticket #10015966 zur Reihenfolge im
Tages/Wochenreport

=cut



my $Conversions = [
    [ CreateTime  => \&convert_isodate_to_date_hash, 'created' ],
    [ Created     => \&convert_isodate_to_date_hash, 'created' ]
];

sub test_run {
    my ($LoadFixture, $DateStr, $Typ) = @_;
    my $Start = convert_isodate_to_date_hash($DateStr)->{epoch};
    my $Renderer = NorisOtrsReport::TestRenderer->new();
    my $Processor = NorisOtrsReport::QuelleProcessor->new(
            Typ => $Typ,
            Start => $Start,
            Renderer => $Renderer
        );
    generate(
        UserID => 1,
        Conversions => $Conversions,
        LoadFixture => $LoadFixture,
        Processors => [ $Processor ]
    );
    return [map $_->{TicketNumber}, @{$Renderer->items()->[0]}];
}

# Im Opcall korrekt sortieren
is_deeply test_run('t/functional/10010873-01.json', '2009-03-01 00:00', 'opcall'), [qw(9920000001759 9920000001737 9920000001771 9920000001760)];

# Im Tages- oder Wochenreport korrekt nach IncidentStart (bzw. TicketCreate) sortieren
is_deeply test_run('t/functional/10010873-01.json', '2009-03-01 00:00', 'daily'), [qw(9920000001759 9920000001771 9920000001737 9920000001760)];

# Tickets ohne Angaben kommen beim Opcall zuletzt
is_deeply test_run('t/functional/10010873-02.json', '2009-03-01 00:00', 'opcall'), 
    [qw(9920000001737 9920000001793)];

is_deeply test_run('t/functional/10010873-02.json', '2009-03-01 00:00', 'daily'), [qw(9920000001737 9920000001793)];


