use strict;
use warnings;
use utf8;
use Test::More tests => 5;
use Data::Dump qw(pp);
use NorisOtrsReport::Framework qw(generate :convert);
use NorisOtrsReport::QuelleProcessor;
use NorisOtrsReport::TestRenderer;

my $Conversions = [
    [ CreateTime  => \&convert_isodate_to_date_hash, 'created' ],
    [ Created     => \&convert_isodate_to_date_hash, 'created' ]
];

sub test_run {
    my ($LoadFixture, $DateStr, $Typ) = @_;
    my $Start = convert_isodate_to_date_hash($DateStr)->{epoch};
    my $Renderer = NorisOtrsReport::TestRenderer->new();
    my $Processor = NorisOtrsReport::QuelleProcessor->new(
            Typ => $Typ,
            Start => $Start,
            Renderer => $Renderer
        );
    generate(
        UserID => 1,
        Conversions => $Conversions,
        LoadFixture => $LoadFixture,
        Processors => [ $Processor ]
    );
    return [map $_->{TicketNumber}, @{$Renderer->items()->[0]}];
}
    

# Ticket ohne Artikel
# nach Beginn erzeugt => OK!
is_deeply test_run('t/functional/10010336-01.json', '2009-03-04 21:00', 'daily'), ['9920000001715'];

# vor Beginn erzeugt => Nicht dabei!
is_deeply test_run('t/functional/10010336-01.json', '2009-03-04 22:00', 'daily'), 
    [];

# Ticket mit Artikeln, Beginn nach Erzeugung und vor Verlauf => OK!
is_deeply test_run('t/functional/10010336-02.json', '2009-03-04 22:00', 'daily'),
    ['9920000001715'];

# Ticket mit Artikeln, Beginn nach Erzeugung und nach Verlauf => Nicht dabei!
is_deeply test_run('t/functional/10010336-02.json', '2009-03-04 22:11', 'daily'), 
    [];

# OPC geht nach wie vor
is_deeply test_run('t/functional/10010336-02.json', '2009-03-04 22:11', 'opcall'), 
    ['9920000001715'];