package NorisOtrsReport::Renderer::SimpleXML;

use strict;
use warnings;
use utf8;

use Moose;
use NorisOtrsReport::Framework;
use XML::Simple qw(XMLout);

with 'NorisOtrsReport::Renderer';
has 'SimpleXMLAttributes' => ( is => 'ro', isa => 'HashRef', required => 1 );
has 'AdditionalData' => ( is => 'ro', isa => 'HashRef', default => sub { {} } );

sub item {
    my ( $Self, $Item ) = @_;
    my %Data = %{ $Self->{AdditionalData} };
    $Data{ticket} = $Item;
    print XMLout( \%Data, %{ $Self->{SimpleXMLAttributes} } );
}

1;
