package NorisOtrsReport::Renderer::Mason;

use strict;
use warnings;
use utf8;

use Moose;
use NorisOtrsReport::Framework;
use HTML::Mason;
use HTML::Mason::Compiler::ToObject;

with 'NorisOtrsReport::Renderer';
has 'TemplatePath' => ( is => 'ro', isa => 'Str', default => '-' );
has 'AdditionalData' => ( is => 'ro', isa => 'HashRef', default => sub { {} } );

sub item {
    my ( $Self, $Item ) = @_;

    my $Interpreter =
      HTML::Mason::Interp->new( compiler =>
          HTML::Mason::Compiler::ToObject->new( default_escape_flags => 'h' ),
      );
    $Interpreter->exec(
        $Self->{TemplatePath},
        tickets => $Item,
        %{ $Self->{AdditionalData} }
    );
}

1;
