package NorisOtrsReport::Renderer::Excel;

use strict;
use warnings;
use utf8;

use Class::CSV;
use Spreadsheet::WriteExcel;
use Moose;
use NorisOtrsReport::Framework;

with 'NorisOtrsReport::Renderer';
has 'TemplatePath' => (is => 'ro', isa => 'Str', default => '-');
has 'AdditionalData' => (is => 'ro', isa => 'HashRef', default => sub { {} } );

sub BUILD {
    my ($Self, $Param) = @_;
    $Self->{Fields}   = $Param->{Fields};
    $Self->{Filename} = $Param->{Filename} || 'otrs_report.xls';
    $Self->{Workbook} = Spreadsheet::WriteExcel->new( $Self->{Filename} )
      or die "Problems creating new Excel file: $!";
    #$Self->{Workbook}->set_properties(
    #    title  => 'Ticket Report',
    #    author => 'noris network AG',
    #);

}

sub item {
    my ($Self, $Item) = @_;

    my $worksheet = $Self->{Workbook}->add_worksheet('Ticket Report');

    $worksheet->write(0, 0, 'noris network AG' );
    $worksheet->write(1, 0, 'Ticket Report' );
    $worksheet->write(3, 0, $Self->{Fields} );

    my $format = $Self->{Workbook}->add_format();
    $format->set_text_wrap();

    my $row = 4;
    foreach my $I (@$Item) {
        my @Sorted;
        @Sorted = map +( $I->{$_} ), @{ $Self->{Fields} };
        $worksheet->write( $row++, 0, \@Sorted, $format );
    }

    $Self->{Workbook}->close() or die "Error closing file: $!";
}

1;
