package NorisOtrsReport::Renderer::CSV;

use strict;
use warnings;
use utf8;

use Class::CSV;
use Moose;
use NorisOtrsReport::Framework;

with 'NorisOtrsReport::Renderer';
has 'TemplatePath' => (is => 'ro', isa => 'Str', default => '-');
has 'AdditionalData' => (is => 'ro', isa => 'HashRef', default => sub { {} } );

sub BUILD {
    my ($Self, $Param) = @_;
    $Self->{Fields}       = $Param->{Fields};
    $Self->{Translations} = $Param->{Translations};
    $Self->{CSV} = Class::CSV->new(
        fields => [ @{ $Self->{Fields} } ],
        #line_separator => "\r\n",
    );
}

sub item {
    my ($Self, $Item) = @_;

    foreach my $I (@$Item) {
        my %Sorted;
        %Sorted = map +( $_ => $I->{$_} ), @{ $Self->{Fields} };
        #%Sorted = map { +$_ => $I->{$_} }  @{ $Self->{Fields} };
        #@Sorted{ @{ $Self->{Fields} } } = @{$I}{@{ $Self->{Fields} }};
        $Self->{CSV}->add_line( \%Sorted );
    }

    print join( ',', @{ $Self->{Fields} } ) . "\n";
    #print $Self->{CSV}->string();
    $Self->{CSV}->print();
}

1;
