package NorisOtrsReport::OTRS_API;

use lib '/usr/share/otrs';
use utf8;
use strict;
use warnings;

use Kernel::Config;
use Kernel::System::Time;
use Kernel::System::Log;
use Kernel::System::Main;
use Kernel::System::DB;
use Kernel::System::Encode;
use Kernel::System::LinkObject;
use Kernel::System::Ticket;
use Kernel::System::Ticket::Article;
use Kernel::System::EmailParser;

our $ConfigObject = Kernel::Config->new();
our $EncodeObject = Kernel::System::Encode->new(
        ConfigObject => $ConfigObject,
);
our $LogObject    = Kernel::System::Log->new(
    ConfigObject => $ConfigObject,
    LogPrefix    => 'import',
);
our $TimeObject = Kernel::System::Time->new(
    LogObject    => $LogObject,
    ConfigObject => $ConfigObject,
);
our $MainObject = Kernel::System::Main->new(
    LogObject    => $LogObject,
    ConfigObject => $ConfigObject,
);
our $DBObject = Kernel::System::DB->new(
    ConfigObject => $ConfigObject,
    MainObject   => $MainObject,
    LogObject    => $LogObject,
    EncodeObject => $EncodeObject,
);
our $LinkObject = Kernel::System::LinkObject->new(
    ConfigObject => $ConfigObject,
    LogObject    => $LogObject,
    DBObject     => $DBObject,
    TimeObject   => $TimeObject,
    MainObject   => $MainObject,
    EncodeObject => $EncodeObject,
);
our $TicketObject = Kernel::System::Ticket->new(
    ConfigObject => $ConfigObject,
    LogObject    => $LogObject,
    DBObject     => $DBObject,
    MainObject   => $MainObject,
    TimeObject   => $TimeObject,
    EncodeObject => $EncodeObject,
);
our $UserObject = Kernel::System::User->new(
    ConfigObject => $ConfigObject,
    LogObject    => $LogObject,
    MainObject   => $MainObject,
    TimeObject   => $TimeObject,
    DBObject     => $DBObject,
    EncodeObject => $EncodeObject,
);

1;
