-- MySQL dump 10.11
--
-- Host: localhost    Database: test_qsu
-- ------------------------------------------------------
-- Server version	5.0.51a-24+lenny2~bpo40+1-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acct`
--

DROP TABLE IF EXISTS `acct`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `acct` (
  `hash` int(11) NOT NULL,
  `seq` smallint(6) NOT NULL,
  `kunde` int(11) NOT NULL,
  `jjmm` int(11) NOT NULL,
  `tt` smallint(6) NOT NULL,
  `dienst` smallint(6) NOT NULL,
  `dest` smallint(6) NOT NULL,
  `pakete` bigint(20) unsigned NOT NULL,
  `bytes` bigint(20) unsigned NOT NULL,
  `quelle` smallint(6) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`hash`,`seq`),
  KEY `jjmm` (`jjmm`,`dienst`,`dest`),
  KEY `kunde` (`kunde`,`jjmm`,`dienst`),
  KEY `dienst` (`dienst`,`quelle`,`jjmm`),
  KEY `timestamp` (`timestamp`),
  KEY `dienst_2` (`dienst`,`timestamp`),
  KEY `quelle` (`quelle`,`dienst`,`timestamp`),
  CONSTRAINT `r_acct__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_acct__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `acct`
--

LOCK TABLES `acct` WRITE;
/*!40000 ALTER TABLE `acct` DISABLE KEYS */;
/*!40000 ALTER TABLE `acct` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acctassoc`
--

DROP TABLE IF EXISTS `acctassoc`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `acctassoc` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `hash` int(11) NOT NULL,
  `seq` smallint(6) NOT NULL,
  `tarifkunde` int(11) default NULL,
  `acctinfo` smallint(6) default NULL,
  `info` text character set utf8,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `hash` (`hash`,`seq`),
  KEY `tarifkunde` (`tarifkunde`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_acctassoc__hash_seq` FOREIGN KEY (`hash`, `seq`) REFERENCES `acct` (`hash`, `seq`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `r_acctassoc__tarifkunde` FOREIGN KEY (`tarifkunde`) REFERENCES `tarifkunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `acctassoc`
--

LOCK TABLES `acctassoc` WRITE;
/*!40000 ALTER TABLE `acctassoc` DISABLE KEYS */;
/*!40000 ALTER TABLE `acctassoc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adress_vorlage`
--

DROP TABLE IF EXISTS `adress_vorlage`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `adress_vorlage` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `inhalt` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `adress_vorlage`
--

LOCK TABLES `adress_vorlage` WRITE;
/*!40000 ALTER TABLE `adress_vorlage` DISABLE KEYS */;
/*!40000 ALTER TABLE `adress_vorlage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adresse`
--

DROP TABLE IF EXISTS `adresse`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `adresse` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kurz` varchar(40) character set utf8 default NULL,
  `land` smallint(6) NOT NULL,
  `plz` varchar(10) character set utf8 NOT NULL,
  `ort` varchar(100) character set utf8 NOT NULL,
  `strasse` varchar(250) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `kurz` (`kurz`),
  KEY `timestamp` (`timestamp`),
  KEY `r_adresse__land` (`land`),
  CONSTRAINT `r_adresse__land` FOREIGN KEY (`land`) REFERENCES `land` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `adresse`
--

LOCK TABLES `adresse` WRITE;
/*!40000 ALTER TABLE `adresse` DISABLE KEYS */;
/*!40000 ALTER TABLE `adresse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `applikation`
--

DROP TABLE IF EXISTS `applikation`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `applikation` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `applikation`
--

LOCK TABLES `applikation` WRITE;
/*!40000 ALTER TABLE `applikation` DISABLE KEYS */;
/*!40000 ALTER TABLE `applikation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aufrufe`
--

DROP TABLE IF EXISTS `aufrufe`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `aufrufe` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `tag` int(10) unsigned NOT NULL,
  `applikation` smallint(5) unsigned NOT NULL,
  `funktion` smallint(5) unsigned NOT NULL,
  `person` int(11) NOT NULL,
  `anzahl` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `applikation` (`applikation`,`funktion`,`person`,`tag`),
  KEY `timestamp` (`timestamp`),
  KEY `funktion` (`funktion`,`tag`),
  KEY `r_aufrufe__person` (`person`),
  CONSTRAINT `r_aufrufe__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_aufrufe__applikation` FOREIGN KEY (`applikation`) REFERENCES `applikation` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_aufrufe__funktion` FOREIGN KEY (`funktion`) REFERENCES `funktion` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `aufrufe`
--

LOCK TABLES `aufrufe` WRITE;
/*!40000 ALTER TABLE `aufrufe` DISABLE KEYS */;
/*!40000 ALTER TABLE `aufrufe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ausgabe`
--

DROP TABLE IF EXISTS `ausgabe`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ausgabe` (
  `id` int(11) NOT NULL auto_increment,
  `ausgabe` smallint(6) NOT NULL,
  `befehl` varchar(255) character set utf8 default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ausgabe` (`ausgabe`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ausgabe`
--

LOCK TABLES `ausgabe` WRITE;
/*!40000 ALTER TABLE `ausgabe` DISABLE KEYS */;
/*!40000 ALTER TABLE `ausgabe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_group`
--

DROP TABLE IF EXISTS `auth_group`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_group` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(80) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_group`
--

LOCK TABLES `auth_group` WRITE;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_group_permissions`
--

DROP TABLE IF EXISTS `auth_group_permissions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_group_permissions` (
  `id` int(11) NOT NULL auto_increment,
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `group_id` (`group_id`,`permission_id`),
  KEY `r_auth_group_permissions__permission_id` (`permission_id`),
  CONSTRAINT `r_auth_group_permissions__permission_id` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_auth_group_permissions__group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_group_permissions`
--

LOCK TABLES `auth_group_permissions` WRITE;
/*!40000 ALTER TABLE `auth_group_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_message`
--

DROP TABLE IF EXISTS `auth_message`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_message` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `message` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `r_auth_message__user_id` (`user_id`),
  CONSTRAINT `r_auth_message__user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_message`
--

LOCK TABLES `auth_message` WRITE;
/*!40000 ALTER TABLE `auth_message` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_permission`
--

DROP TABLE IF EXISTS `auth_permission`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_permission` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) character set utf8 NOT NULL,
  `content_type` int(11) NOT NULL,
  `codename` varchar(100) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `content_type` (`content_type`,`codename`),
  CONSTRAINT `r_auth_permission__content_type` FOREIGN KEY (`content_type`) REFERENCES `django_content_type` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_permission`
--

LOCK TABLES `auth_permission` WRITE;
/*!40000 ALTER TABLE `auth_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_user`
--

DROP TABLE IF EXISTS `auth_user`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_user` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(255) character set utf8 NOT NULL,
  `first_name` varchar(30) character set utf8 NOT NULL,
  `last_name` varchar(30) character set utf8 NOT NULL,
  `email` varchar(75) character set utf8 NOT NULL,
  `password` varchar(128) character set utf8 NOT NULL,
  `is_staff` tinyint(4) NOT NULL,
  `is_active` tinyint(4) NOT NULL,
  `is_superuser` tinyint(4) NOT NULL,
  `last_login` datetime NOT NULL,
  `date_joined` datetime NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_user`
--

LOCK TABLES `auth_user` WRITE;
/*!40000 ALTER TABLE `auth_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_user_groups`
--

DROP TABLE IF EXISTS `auth_user_groups`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_user_groups` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `user_id` (`user_id`,`group_id`),
  KEY `r_auth_user_groups__group_id` (`group_id`),
  CONSTRAINT `r_auth_user_groups__group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_auth_user_groups__user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_user_groups`
--

LOCK TABLES `auth_user_groups` WRITE;
/*!40000 ALTER TABLE `auth_user_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auth_user_user_permissions`
--

DROP TABLE IF EXISTS `auth_user_user_permissions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `auth_user_user_permissions` (
  `id` int(11) NOT NULL auto_increment,
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `user_id` (`user_id`,`permission_id`),
  KEY `r_auth_user_user_permissions__permission_id` (`permission_id`),
  CONSTRAINT `r_auth_user_user_permissions__permission_id` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_auth_user_user_permissions__user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `auth_user_user_permissions`
--

LOCK TABLES `auth_user_user_permissions` WRITE;
/*!40000 ALTER TABLE `auth_user_user_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_user_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `backup_report_ticket`
--

DROP TABLE IF EXISTS `backup_report_ticket`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `backup_report_ticket` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `host` varchar(255) character set utf8 NOT NULL,
  `rtticket` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `host` (`host`),
  UNIQUE KEY `rtticket` (`rtticket`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_backup_report_ticket__rtticket` FOREIGN KEY (`rtticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `backup_report_ticket`
--

LOCK TABLES `backup_report_ticket` WRITE;
/*!40000 ALTER TABLE `backup_report_ticket` DISABLE KEYS */;
/*!40000 ALTER TABLE `backup_report_ticket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `buchung`
--

DROP TABLE IF EXISTS `buchung`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `buchung` (
  `rnr` int(11) NOT NULL,
  `seq` smallint(6) NOT NULL,
  `buchtext` varchar(767) character set utf8 NOT NULL,
  `betrag` int(11) NOT NULL,
  `kunde` int(11) NOT NULL,
  `beginn` int(10) unsigned default NULL,
  `ende` int(10) unsigned default NULL,
  `konto` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `mtext` varchar(250) character set utf8 default NULL,
  `manzahl` int(11) default NULL,
  `meinheit` smallint(6) default NULL,
  `mrabatt` smallint(6) NOT NULL,
  `flags` int(11) NOT NULL,
  PRIMARY KEY  (`rnr`,`seq`),
  KEY `timestamp` (`timestamp`),
  KEY `r_buchung__kunde` (`kunde`),
  CONSTRAINT `r_buchung__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_buchung__rnr` FOREIGN KEY (`rnr`) REFERENCES `rechnungen` (`rnr`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `buchung`
--

LOCK TABLES `buchung` WRITE;
/*!40000 ALTER TABLE `buchung` DISABLE KEYS */;
/*!40000 ALTER TABLE `buchung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `confitem`
--

DROP TABLE IF EXISTS `confitem`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `confitem` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) default NULL,
  `name` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `kunde` (`kunde`,`name`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_confitem__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `confitem`
--

LOCK TABLES `confitem` WRITE;
/*!40000 ALTER TABLE `confitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `confitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db_feld`
--

DROP TABLE IF EXISTS `db_feld`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `db_feld` (
  `id` int(11) NOT NULL auto_increment,
  `db_tabelle` int(11) NOT NULL,
  `name` varchar(30) character set utf8 NOT NULL,
  `typ` varchar(8) character set utf8 NOT NULL,
  `beschreib` varchar(100) character set utf8 NOT NULL,
  `rem` varchar(200) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `db_tabelle` (`db_tabelle`,`name`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_db_feld__db_tabelle` FOREIGN KEY (`db_tabelle`) REFERENCES `db_tabelle` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=946 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `db_feld`
--

LOCK TABLES `db_feld` WRITE;
/*!40000 ALTER TABLE `db_feld` DISABLE KEYS */;
INSERT INTO `db_feld` (`id`, `db_tabelle`, `name`, `typ`, `beschreib`, `rem`, `timestamp`) VALUES (1,1,'id','uint2','!?+','ID','2009-10-06 13:49:45'),(2,1,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(3,1,'name','char32','','- Variablenname','2009-10-06 13:49:45'),(4,2,'id','int4','!?+','ID','2009-10-06 13:49:45'),(5,2,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(6,2,'host','char255','','- Backup-Client-Host (in der auf dem Backup-Server gespeicherten Variante)','2009-10-06 13:49:45'),(7,2,'rtticket','int4','!^!>ticket','zugehöriges RT-Ticket','2009-10-06 13:49:45'),(8,3,'id','int4','!?+','ID','2009-10-06 13:49:45'),(9,3,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(10,3,'ticket','int4','!^!>ticket','RT-Ticket','2009-10-06 13:49:45'),(11,3,'frage','int4','!rt_fragen','Frage','2009-10-06 13:49:45'),(12,3,'antwort','fchar1','','- Antwort, z. B. \"j\"/\"n\"','2009-10-06 13:49:45'),(13,4,'id','int4','!?+','ID','2009-10-06 13:49:45'),(14,4,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(15,4,'person','int4','!^perso!>>person','wessen Stunden?','2009-10-06 13:49:45'),(16,4,'ziel','int4','!-!>person','an wen soll die Mail? (NULL=AL+perso)','2009-10-06 13:49:45'),(17,4,'zuletzt','uint4','!/','Wann wurde zuletzt verschickt?','2009-10-06 13:49:45'),(18,4,'zeitraum','int2','!-','Bereich über den die Liste gehen soll? (NULL=Monat)','2009-10-06 13:49:45'),(19,4,'delay','int2','','- Verzögerung zwischen Ende-des-Zeitraums und Absendezeitpunkt','2009-10-06 13:49:45'),(20,4,'art','int1','!std_liste','Art der Liste?','2009-10-06 13:49:45'),(21,4,'kunde','int4','!-!>kunde','welcher Kunde?','2009-10-06 13:49:45'),(22,4,'infotext','char255','!-','Infotext: wieso der Eintrag?','2009-10-06 13:49:45'),(23,5,'ticket','int4','!^!>ticket','','2009-10-06 13:49:45'),(24,5,'person','int4','!>person','','2009-10-06 13:49:45'),(25,5,'seq','int4','!%max(ticketid.seq)','letzte Nummer','2009-10-06 13:49:45'),(26,5,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(27,6,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:45'),(28,6,'name','char100','','- Name für Benutzers','2009-10-06 13:49:45'),(29,6,'app_label','char100','','- Modulname der Applikation','2009-10-06 13:49:45'),(30,6,'model','char100','','- Modell bzw. Tabellenname','2009-10-06 13:49:45'),(31,6,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(32,7,'id','int4','!?+','ID','2009-10-06 13:49:45'),(33,7,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(34,7,'ticket','int4','!^!>ticket','Verweis auf RT-Ticket','2009-10-06 13:49:45'),(35,7,'hash','int4','!^acct','Verweis auf Accounting-Datensatz, Teil 1/2','2009-10-06 13:49:45'),(36,7,'seq','int2','','- Verweis auf Accounting-Datensatz, Teil 2/2','2009-10-06 13:49:45'),(37,7,'gemailt','uint4','!/!-','Timestamp des Accounting-Datensatzes, der an den vertrieblichen Ansprechpartner gemailt wurde','2009-10-06 13:49:45'),(38,8,'id','int4','!^domainkram!?+','ID','2009-10-06 13:49:45'),(39,8,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(40,8,'von','int2','!handlestatus','aktueller Zustand des Handles','2009-10-06 13:49:45'),(41,8,'erkannt','int2','!handlestatus','Typ der erkannten Mail','2009-10-06 13:49:45'),(42,8,'nach','int2','!-!handlestatus','Ziel-Zustand der Domain','2009-10-06 13:49:45'),(43,8,'aktionen','int4','!*handleaktion','was zu tun ist','2009-10-06 13:49:45'),(44,8,'ticketstatus','int2','!-!tickets','RT-Status des betreffenden Tickets','2009-10-06 13:49:45'),(45,8,'statusinfo','char255','!-','Statustext für das Ticket','2009-10-06 13:49:45'),(46,8,'acctinfo','int2','!-!acctinfo','Text für die Rechnung','2009-10-06 13:49:45'),(47,8,'reseller','fchar1','!zsreseller.b','j/n/b (b=beide)','2009-10-06 13:49:45'),(48,9,'id','int4','!?+','ID','2009-10-06 13:49:45'),(49,9,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(50,9,'confitem','int4','!^!>confitem','Conf. Item','2009-10-06 13:49:45'),(51,9,'incident','int4','!^!>ticket','Ticket','2009-10-06 13:49:45'),(52,10,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:45'),(53,10,'user_id','int4','!^!>auth_user','','2009-10-06 13:49:45'),(54,10,'permission_id','int4','!^^!>auth_permission','','2009-10-06 13:49:45'),(55,10,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(56,11,'hash','int4','!%hash(kunde,dienst,dest,jjmm,tt,quelle)','interner Index','2009-10-06 13:49:45'),(57,11,'seq','int2','!%max(hash)+1','Folgenummer für gleiche Hashes','2009-10-06 13:49:45'),(58,11,'kunde','int4','!^!>kunde','ID des Kunden','2009-10-06 13:49:45'),(59,11,'jjmm','int4','!(JJJJMM)','Jahr und Monat des Eintrags','2009-10-06 13:49:45'),(60,11,'tt','int2','!(TT/jjmm)','Tag des Eintrags','2009-10-06 13:49:45'),(61,11,'dienst','int2','!>dienst','Typ des Eintrags','2009-10-06 13:49:45'),(62,11,'dest','int2','!(dienst!ziel)','Ziel','2009-10-06 13:49:45'),(63,11,'pakete','uint8','','- Zahl der IP-Pakete / Mails / Verbindungen','2009-10-06 13:49:45'),(64,11,'bytes','uint8','','- Summe der Bytes / Einheiten','2009-10-06 13:49:45'),(65,11,'quelle','int2','!quelle','Wer hat diese Bytes gezählt?','2009-10-06 13:49:45'),(66,11,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(67,12,'id','uint4','!?+','ID','2009-10-06 13:49:45'),(68,12,'person','int4','!>person','Person, die die Einstellung aufgerufen hat','2009-10-06 13:49:45'),(69,12,'timestamp','datetime','!/+','Zeitstempel, wann der Aufruf erfolgte','2009-10-06 13:49:45'),(70,12,'anzeige','text2','!%ctrl','Angezeigter html-Text zum Nachweis','2009-10-06 13:49:45'),(71,13,'id','int1','!^','kleinste','2009-10-06 13:49:45'),(72,13,'timestamp','datetime','!/+','Zeitstempel (=FibuNet-Übernahmedatum)','2009-10-06 13:49:45'),(73,13,'buchen','uint4','!-!/','Buchungsdatum','2009-10-06 13:49:45'),(74,13,'mandant','int1','!fnmandant','','2009-10-06 13:49:45'),(75,13,'status','int1','!fnstatus','','2009-10-06 13:49:45'),(76,13,'art','char100','','- Kurzbeschreibung, Inhalt der Übernahmedatei','2009-10-06 13:49:45'),(77,13,'fehler','char200','','- Fehlerbeschreibung','2009-10-06 13:49:45'),(78,13,'daten','text3','!%ctrl','Buchungsdaten. Zeichensatz:latin1','2009-10-06 13:49:45'),(79,14,'id','int4','!?+','','2009-10-06 13:49:45'),(80,14,'db_tabelle','int4','!^!>db_tabelle','','2009-10-06 13:49:45'),(81,14,'name','char30','','- Feldname','2009-10-06 13:49:45'),(82,14,'typ','char8','','- Datentyp','2009-10-06 13:49:45'),(83,14,'beschreib','char100','','- Beschreibung des Inhalts, der Maschienenverwertbar ist','2009-10-06 13:49:45'),(84,14,'rem','char200','','- Bemerkungen zum Feld und Beschreibung','2009-10-06 13:49:45'),(85,14,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(86,15,'id','int4','!^Muster!?+','ID','2009-10-06 13:49:45'),(87,15,'name','char30','','- Kurzname','2009-10-06 13:49:45'),(88,15,'inhalt','text2','!%ctrl','Mustertext','2009-10-06 13:49:45'),(89,15,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(90,16,'id','int4','!?+','eindeutige ID','2009-10-06 13:49:45'),(91,16,'zone','char50','','- Name der Region (eindeutig)','2009-10-06 13:49:45'),(92,16,'infotext','char255','!-','zusätzlicher Infotext','2009-10-06 13:49:45'),(93,16,'kunde','int4','!>kunde','dem die Region primär gehört','2009-10-06 13:49:45'),(94,16,'alloc','int1','','- Größe des nächsten zu allozierenden Blocks, wenn eine','2009-10-06 13:49:45'),(95,16,'ipkunde','int4','!^!-!>ipkunde','Bereich, aus dem der Block geholt werden soll','2009-10-06 13:49:45'),(96,16,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(97,17,'id','uint2','!?+','ID','2009-10-06 13:49:45'),(98,17,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(99,17,'namensraum','uint2','!>konfig_namensraum','Namensraum','2009-10-06 13:49:45'),(100,17,'variable','uint2','!>konfig_variable','Variable','2009-10-06 13:49:45'),(101,17,'wert','char255','','- Variableninhalt','2009-10-06 13:49:45'),(102,18,'id','int4','!^updatelog!?+','ID','2009-10-06 13:49:45'),(103,18,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(104,18,'namen','char255','','- Spaltennamen','2009-10-06 13:49:45'),(105,19,'session_key','char40','!^django','Session-Key (pseudozufällige Zeichenfolge)','2009-10-06 13:49:45'),(106,19,'session_data','text3','!%ctrl','Gepickeltes Session-Objekts','2009-10-06 13:49:45'),(107,19,'expire_date','datetime','','- Wann die Session abläuft','2009-10-06 13:49:45'),(108,19,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(109,20,'id','int4','!^domainkram!?+','ID','2009-10-06 13:49:45'),(110,20,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(111,20,'von','int2','!domainstatus','aktueller Zustand der Domain','2009-10-06 13:49:45'),(112,20,'erkannt','int2','!domainstatus','Typ der erkannten Mail','2009-10-06 13:49:45'),(113,20,'nach','int2','!-!domainstatus','Ziel-Zustand der Domain','2009-10-06 13:49:45'),(114,20,'aktionen','int4','!*domainaktion','was zu tun ist','2009-10-06 13:49:45'),(115,20,'ticketstatus','int2','!-!tickets','RT-Status des betreffenden Tickets','2009-10-06 13:49:45'),(116,20,'statusinfo','char255','!-','Statustext für das Ticket','2009-10-06 13:49:45'),(117,20,'acctinfo','int2','!-!acctinfo','Text für die Rechnung','2009-10-06 13:49:45'),(118,20,'reseller','fchar1','!zsreseller.b','j/n/b (b=beide)','2009-10-06 13:49:45'),(119,21,'id','uint2','!?+','ID','2009-10-06 13:49:45'),(120,21,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(121,21,'name','char255','','- Applikationsname, z. B. \"/usr/pop/bin/kunde\" oder \"/usr/pop/bin/gen.adressplan\"','2009-10-06 13:49:45'),(122,22,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:45'),(123,22,'typ','int4','!>mess_geraet_typ','','2009-10-06 13:49:45'),(124,22,'mess_stelle','int4','!>mess_stelle','','2009-10-06 13:49:45'),(125,22,'beginn','uint4','!/','Zeitpunkt der Zuteilung der Adresse','2009-10-06 13:49:45'),(126,22,'ende','uint4','!-!/','Freigabezeitpunkt der Adresse','2009-10-06 13:49:45'),(127,22,'info','char255','!-','Kommentarfeld','2009-10-06 13:49:45'),(128,22,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(129,23,'id','int4','!?+','ID','2009-10-06 13:49:45'),(130,23,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(131,23,'rtticket','int4','!^!>ticket','RT-Ticket, um das es geht','2009-10-06 13:49:45'),(132,23,'template','int4','!>rt_eskalation_muster','verwendetes Template','2009-10-06 13:49:45'),(133,24,'real_id','int4','!?+','ID','2009-10-06 13:49:45'),(134,24,'kunde','int4','!-!^!>kunde','Kunde; NULL: alle','2009-10-06 13:49:45'),(135,24,'id','int4','!%unique(id)','sequentieller Zähler, 1..N, mit Lücken','2009-10-06 13:49:45'),(136,24,'tarifname','int4','!-!>tarifname','Tarif    NULL=alle','2009-10-06 13:49:45'),(137,24,'dienst','int2','!-!%null!>dienst/tarif','Accountingdaten mit diesem Dienst','2009-10-06 13:49:45'),(138,24,'ziel','int2','!-!(dienst!ziel)','Accountingdaten mit diesem Ziel','2009-10-06 13:49:45'),(139,24,'quelle','int2','!-!quelle','Daten mit dieser Quelle','2009-10-06 13:49:45'),(140,24,'faktor','int4','','- Multiplikator*100','2009-10-06 13:49:45'),(141,24,'beginn','uint4','!/','ab wann gilt der Faktor?','2009-10-06 13:49:45'),(142,24,'ende','uint4','!-!/','bis wann gilt der Faktor?','2009-10-06 13:49:45'),(143,24,'ddienst','int2','!-!>dienst/tarif','umgemappter Dienst','2009-10-06 13:49:45'),(144,24,'dkunde','int4','!-!>kunde','Umgemappter Kunde (nur bei direkt=>\'p\')','2009-10-06 13:49:45'),(145,24,'direkt','char','!direkt','wann wird das Mapping aktiv?','2009-10-06 13:49:45'),(146,24,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(147,25,'id','int4','!?+','ID','2009-10-06 13:49:45'),(148,25,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(149,25,'rtticket','int4','!^!-!>ticket','zugehöriges RT-Ticket','2009-10-06 13:49:45'),(150,25,'subject','text2','','- Titel des Trouble Tickets','2009-10-06 13:49:45'),(151,25,'type','int2','!tt_type','Typ des Trouble Tickets','2009-10-06 13:49:45'),(152,25,'beginn','uint4','!/','Beginn der Störung','2009-10-06 13:49:45'),(153,25,'ende','uint4','!/!-','(ggf. voraussichtliches) Ende der Störung','2009-10-06 13:49:45'),(154,25,'priority','int2','!tt_priority','Störungsklasse','2009-10-06 13:49:45'),(155,25,'flag_kunde','int4','!-!%null!*kunde','Auswahl der TT-Empfänger nach Kunden-Flags (ODER-verknüpft)','2009-10-06 13:49:45'),(156,25,'flag_person','int8','!-!%null!*pwdomain','Auswahl der TT-Empfänger nach Personen-Flags (ODER-verknüpft)','2009-10-06 13:49:45'),(157,25,'text_description','text2','!%ctrl','Abschnitt \"Problembeschreibung\"','2009-10-06 13:49:45'),(158,25,'text_affected','text2','!%ctrl!-','Abschnitt \"Betroffen\"','2009-10-06 13:49:45'),(159,25,'text_comment','text2','!%ctrl!-','Abschnitt \"Bemerkungen\"','2009-10-06 13:49:45'),(160,25,'text_progress','text2','!%ctrl!-','Abschnitt \"Update\"','2009-10-06 13:49:45'),(161,25,'text_resolve','text2','!%ctrl!-','Abschnitt \"Lösung\"','2009-10-06 13:49:45'),(162,25,'additional_rcpt','text2','','- zusätzliche E-Mail-Empfänger, whitespace-getrennt','2009-10-06 13:49:45'),(163,25,'confirmer','int4','!-!>person','Person, die diese Version des Tickets bestätigt hat','2009-10-06 13:49:45'),(164,26,'id','int4','!^django!?+','eindeutige Nummer','2009-10-06 13:49:45'),(165,26,'username','char255','','- eindeutiger Benutzername (entspricht person.user)','2009-10-06 13:49:45'),(166,26,'first_name','char30','','- Wird nicht benutzt','2009-10-06 13:49:45'),(167,26,'last_name','char30','','- Wird nicht benutzt','2009-10-06 13:49:45'),(168,26,'email','char75','','- Wird nicht benutzt','2009-10-06 13:49:45'),(169,26,'password','char128','','- Wird nicht benutzt','2009-10-06 13:49:45'),(170,26,'is_staff','int1','','- Zugriff aufs Admin-Interface; hat keine Bedeutung im normalen Betrieb','2009-10-06 13:49:45'),(171,26,'is_active','int1','','- Darf sich einloggen; wird beim Login mit 1 belegt','2009-10-06 13:49:45'),(172,26,'is_superuser','int1','','- Zugriff als Superuser aufs Admin-Interface; hat keine Bedeutung im normalen Betrieb','2009-10-06 13:49:45'),(173,26,'last_login','datetime','','- Letzter Login','2009-10-06 13:49:45'),(174,26,'date_joined','datetime','','- Erster Login','2009-10-06 13:49:45'),(175,26,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(176,27,'id','int4','!^!?+','ID (war: Pointer auf Stringtabelle)','2009-10-06 13:49:45'),(177,27,'name','char30','','- Name der Queue','2009-10-06 13:49:45'),(178,27,'email','char255','','- Mailadresse der Queue','2009-10-06 13:49:45'),(179,27,'flags','int4','!*rt_queue','','2009-10-06 13:49:45'),(180,27,'defprio','int1','','- Standard-Priorität','2009-10-06 13:49:45'),(181,27,'defdue','int2','','- Tage Wiedervorlage','2009-10-06 13:49:45'),(182,27,'deffdue','int2','','- Tage Endtermin','2009-10-06 13:49:45'),(183,27,'defbearb','int4','!-!>person','default-Verantwortlicher','2009-10-06 13:49:45'),(184,27,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(185,28,'id','int4','!?+','ID','2009-10-06 13:49:45'),(186,28,'tarifkunde','int4','!>tarifkunde','ID des berechneten Tarifs','2009-10-06 13:49:45'),(187,28,'knextrech','int4','!^!-!>knextrech','Rechnung','2009-10-06 13:49:45'),(188,28,'beginn','uint4','!/','Anfang des berechneten Zeitraums','2009-10-06 13:49:45'),(189,28,'ende','uint4','!/','Ende des berechneten Zeitraums','2009-10-06 13:49:45'),(190,28,'anzahl','int3','','- momentan: informativ','2009-10-06 13:49:45'),(191,28,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(192,29,'id','int4','!?+','ID','2009-10-06 13:49:45'),(193,29,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(194,29,'trouble_ticket','int4','!^!>trouble_ticket','Datenbank-ID des Trouble Tickets','2009-10-06 13:49:45'),(195,29,'kunde','int4','!>kunde','Kunde, der das Trouble Ticket bekommt','2009-10-06 13:49:45'),(196,30,'rnr','int4','!^!>rechnungen.rnr','Rechnungsnummer','2009-10-06 13:49:45'),(197,30,'seq','int2','','- Buchungssatz','2009-10-06 13:49:45'),(198,30,'buchtext','char767','','- Buchungstext (zur Länge s. RT#469524)','2009-10-06 13:49:45'),(199,30,'betrag','int4','!$','Cent (gesamt) -- manuell: Einzelpreis wird berechnet','2009-10-06 13:49:45'),(200,30,'kunde','int4','!>kunde','(Unter)kunde für den berechnet wurde','2009-10-06 13:49:45'),(201,30,'beginn','uint4','!-!/','Anfang des berechneten Zeitraums','2009-10-06 13:49:45'),(202,30,'ende','uint4','!-!/','Ende des berechneten Zeitraums','2009-10-06 13:49:45'),(203,30,'konto','int4','','- Konto, auf das gebucht wird','2009-10-06 13:49:45'),(204,30,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(205,30,'mtext','char250','!-','Rechnungstext','2009-10-06 13:49:45'),(206,30,'manzahl','int4','!-','Anzahl*1000','2009-10-06 13:49:45'),(207,30,'meinheit','int2','!-!einheit','Stück/Bytes/whatever','2009-10-06 13:49:45'),(208,30,'mrabatt','int2','','- Prozent','2009-10-06 13:49:45'),(209,30,'flags','int4','!*buchung','Flags','2009-10-06 13:49:45'),(210,31,'id','int4','!?+','ID','2009-10-06 13:49:45'),(211,31,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(212,31,'anfang','int4','!^!>rechnungen.rnr','erste Rechnungsnummer','2009-10-06 13:49:45'),(213,31,'ende','int4','!>rechnungen.rnr','letzte Rechnungsnummer','2009-10-06 13:49:45'),(214,31,'template','int4','!-!>rech_fuss.id','Template des Fußtexts','2009-10-06 13:49:45'),(215,32,'id','int2','!?+','ID','2009-10-06 13:49:45'),(216,32,'name','char30','','- textuelle Beschreibung (kurz)','2009-10-06 13:49:45'),(217,32,'infotext','char255','!-','kurze Erklärung (Tooltip)','2009-10-06 13:49:45'),(218,32,'faktor','int2','','- dem Mitarbeiter zugeordneter Anteil, in Prozent','2009-10-06 13:49:45'),(219,32,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(220,32,'flags','int4','!*stunden_art','Flags','2009-10-06 13:49:45'),(221,33,'id','int4','!?+','ID','2009-10-06 13:49:45'),(222,33,'person','int4','!^!%!>person','Mensch mit Handle','2009-10-06 13:49:45'),(223,33,'nic','int2','!nic','Center, bei dem der Handle registriert ist','2009-10-06 13:49:45'),(224,33,'handle','char128','!-','Bezeichner des Handles','2009-10-06 13:49:45'),(225,33,'username','char15','!-','damit verbundener Login','2009-10-06 13:49:45'),(226,33,'passwort','char15','!-','damit verbundenes Passwort','2009-10-06 13:49:45'),(227,33,'ticket','int4','!-!%ticket','auslösendes Ticket','2009-10-06 13:49:45'),(228,33,'status','int1','!handlestatus','Status des Vorgangs','2009-10-06 13:49:45'),(229,33,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(230,34,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:45'),(231,34,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(232,34,'kunde','int4','!^!-!>kunde','Kunde','2009-10-06 13:49:45'),(233,34,'name','char255','','- Name des CIs','2009-10-06 13:49:45'),(234,35,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:45'),(235,35,'kunde','int4','!^!>kunde','Kunde','2009-10-06 13:49:45'),(236,35,'name','char255','','- noris-Bezeichnung der Leitung','2009-10-06 13:49:45'),(237,35,'art','int2','!-!leitungsart','Art der Leitung, vgl. RT#211370','2009-10-06 13:49:45'),(238,35,'carrier','int4','!-!>person','Carrier für diese Leitung','2009-10-06 13:49:45'),(239,35,'name_carrier','char255','!-','Leitungsbezeichnung des Carriers','2009-10-06 13:49:45'),(240,35,'name_kunde','char255','!-','kundeneigene Leitungsbezeichnung','2009-10-06 13:49:45'),(241,35,'backup','int4','!-!>person','Account für das (z. B. ISDN-)Backup, vgl. RT#381245','2009-10-06 13:49:45'),(242,35,'a_ende','int4','!-!>person','A-Endpunkt der Leitung','2009-10-06 13:49:45'),(243,35,'a_hardware','int4','!-!>hardware','Hardware am A-Ende (RT#402575)','2009-10-06 13:49:45'),(244,35,'b_ende','int4','!-!>person','B-Endpunkt der Leitung','2009-10-06 13:49:45'),(245,35,'b_hardware','int4','!-!>hardware','Hardware am B-Ende (RT#402575)','2009-10-06 13:49:45'),(246,35,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(247,35,'beginn','uint4','!/','Zeitpunkt der Zuteilung der Adresse','2009-10-06 13:49:45'),(248,35,'ende','uint4','!-!/','Freigabezeitpunkt der Adresse','2009-10-06 13:49:45'),(249,36,'id','int4','!^auth_user!?+','eindeutige Nummer','2009-10-06 13:49:45'),(250,36,'name','char50','','- Benutzerlesbarer Name','2009-10-06 13:49:45'),(251,36,'content_type','int4','!>django_content_type.id','zugehörige Tabelle','2009-10-06 13:49:45'),(252,36,'codename','char100','','- Symbolischer Name der Berechtigungsart','2009-10-06 13:49:45'),(253,36,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(254,37,'id','int4','!?+','ID','2009-10-06 13:49:45'),(255,37,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(256,37,'person','int4','!-!>person','User','2009-10-06 13:49:45'),(257,37,'programmname','int4','!>startlog_kram','Programmname','2009-10-06 13:49:45'),(258,37,'hostname','int4','!>startlog_kram','Name des Hosts, auf dem das Programm gestartet wurde','2009-10-06 13:49:45'),(259,37,'verzeichnis','int4','!>startlog_kram','aktuelles Verzeichnis','2009-10-06 13:49:45'),(260,37,'argumente','int4','!-!>startlog_kram','Argumente','2009-10-06 13:49:45'),(261,38,'id','int4','!^django!?+','eindeutige Nummer','2009-10-06 13:49:45'),(262,38,'domain','char100','','- Unter welcher Domain die Site läuft','2009-10-06 13:49:45'),(263,38,'name','char50','','- Name für die Anzeige','2009-10-06 13:49:45'),(264,38,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(265,39,'id','int4','!^!?+','ID','2009-10-06 13:49:45'),(266,39,'person','int4','!>person','ändernder Mensch, <- person.id','2009-10-06 13:49:45'),(267,39,'db_tabelle','int4','!^!>db_tabelle','Geänderte Tabelle','2009-10-06 13:49:45'),(268,39,'indexspalten','int4','!>updatelog_spalten','Liste der Datenfelder','2009-10-06 13:49:45'),(269,39,'wert','char100','','- Indexwerte, getrennt mit \'|\'. Sollte \"indexinhalt\" heißen.','2009-10-06 13:49:45'),(270,39,'datenspalten','int4','!>updatelog_spalten','Liste der Datenfelder','2009-10-06 13:49:45'),(271,39,'dwert','text2','!%ctrl!-','alte Datenwerte, getrennt mit \'|\'. Sollte \"dateninhalt\" heißen.','2009-10-06 13:49:45'),(272,39,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(273,40,'id','int4','!^perso!?+','','2009-10-06 13:49:45'),(274,40,'person','int4','!>person','Mitarbeiter','2009-10-06 13:49:45'),(275,40,'kunde','int4','!>kunde','Kunde, für den die Arbeit geleistet wurde','2009-10-06 13:49:45'),(276,40,'ticket','uint8','!-!%ticket','Ticket hierzu','2009-10-06 13:49:45'),(277,40,'beginn','uint4','!/','Startzeit','2009-10-06 13:49:45'),(278,40,'dauer','uint4','!//','wie lang gebraucht?','2009-10-06 13:49:45'),(279,40,'zeit','uint4','!-!//','wie lang gebraucht?','2009-10-06 13:49:45'),(280,40,'art','int2','!>stunden_art','Art des Stundeneintrags (normal/Urlaub/Hotline/...)','2009-10-06 13:49:45'),(281,40,'infotext','text2','!%ctrl!-','was wurde getan?','2009-10-06 13:49:45'),(282,40,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(283,41,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:45'),(284,41,'group_id','int4','!^!>auth_group','','2009-10-06 13:49:45'),(285,41,'permission_id','int4','!^^!>auth_permission','','2009-10-06 13:49:45'),(286,41,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:45'),(287,42,'id','int4','!^releasenotes_note!?+','ID','2009-10-06 13:49:45'),(288,42,'modified','datetime','','- Zeitpunkt der letzten Änderung','2009-10-06 13:49:45'),(289,42,'v1','uint2','','- v1.v2.v3.v4 ist die Versionsnummer','2009-10-06 13:49:45'),(290,42,'v2','uint2','','- v1.v2.v3.v4 ist die Versionsnummer','2009-10-06 13:49:45'),(291,42,'v3','uint2','','- v1.v2.v3.v4 ist die Versionsnummer','2009-10-06 13:49:46'),(292,42,'v4','uint2','!-','v1.v2.v3.v4 ist die Versionsnummer','2009-10-06 13:49:46'),(293,42,'sort_value','uint4','','- Sortierwert','2009-10-06 13:49:46'),(294,42,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(295,43,'id','int4','!^Muster!?+','ID','2009-10-06 13:49:46'),(296,43,'name','char30','','- Kurzname','2009-10-06 13:49:46'),(297,43,'inhalt','text2','!%ctrl','Mustertext','2009-10-06 13:49:46'),(298,43,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(299,44,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:46'),(300,44,'action_time','datetime','','- Zeitpunkt','2009-10-06 13:49:46'),(301,44,'user','int4','!^!>auth_user.id','Wer es getan hat','2009-10-06 13:49:46'),(302,44,'content_type_id','int4','!^^!-!>django_content_type.id','Auf welche Tabellen','2009-10-06 13:49:46'),(303,44,'object_id','text2','!-','id des Eintrags','2009-10-06 13:49:46'),(304,44,'object_repr','char200','','- repr() des Objekts','2009-10-06 13:49:46'),(305,44,'action_flag','int2','','- Art der Aktion','2009-10-06 13:49:46'),(306,44,'change_message','text2','','Textuelle Beschreibung','2009-10-06 13:49:46'),(307,44,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(308,45,'id','uint2','!?+','ID','2009-10-06 13:49:46'),(309,45,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(310,45,'name','char255','','- Funktionsname, z. B. \"edit_kunden\"','2009-10-06 13:49:46'),(311,45,'flags','uint4','!*funktionsflags','Flags (z. B., ob die Funktionalität bereits in kundebunt integriert wurde)','2009-10-06 13:49:46'),(312,46,'id','int4','!^startlog!?+','ID','2009-10-06 13:49:46'),(313,46,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(314,46,'daten','char767','','- Geraffeltext','2009-10-06 13:49:46'),(315,47,'id','int4','!?+','ID','2009-10-06 13:49:46'),(316,47,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(317,47,'hash','int4','!^acct!%','Accountingdatensatz','2009-10-06 13:49:46'),(318,47,'seq','int2','!%','','2009-10-06 13:49:46'),(319,47,'tarifkunde','int4','!^!-!>tarifkunde','bezogener Kundentarif','2009-10-06 13:49:46'),(320,47,'acctinfo','int2','!-!acctinfo','Text für die Rechnung','2009-10-06 13:49:46'),(321,47,'info','text2','!%ctrl!-','Zusatztext','2009-10-06 13:49:46'),(322,48,'id','int4','!?+','ID','2009-10-06 13:49:46'),(323,48,'email','char255','','- Mailadresse','2009-10-06 13:49:46'),(324,48,'person','int4','!^!>person','zugeordnete Person','2009-10-06 13:49:46'),(325,48,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(326,49,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:46'),(327,49,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(328,49,'kunde','int4','!^!>kunde','Kunde','2009-10-06 13:49:46'),(329,49,'ip6','char32','!%ascii','IPv6-Adresse in nicht abgekürzter Hexadezimalschreibweise (IPv4-Adressen mit 24 führenden Nullen)','2009-10-06 13:49:46'),(330,49,'bits','int1','!(0-128)','Anzahl der rechts _nicht_ zur Netzmaske gehörenden Bits','2009-10-06 13:49:46'),(331,49,'tarif','int2','!>dienst','IP-Dienst, dem die IP-Daten dieser Adresse zugeordnet werden','2009-10-06 13:49:46'),(332,49,'beginn','uint4','!/','Zeitpunkt der Zuteilung der Adresse','2009-10-06 13:49:46'),(333,49,'ende','uint4','!-!/','Freigabezeitpunkt der Adresse','2009-10-06 13:49:46'),(334,49,'kiste','char16','!-','Router, der die Adresse announcet','2009-10-06 13:49:46'),(335,49,'mac','fchar12','!-!%ascii','MAC-Adresse der Kiste','2009-10-06 13:49:46'),(336,49,'name','char255','!-','primärer Domainname; bei Netzen: Kurzbeschreibung','2009-10-06 13:49:46'),(337,49,'infotext','char255','!-','Zusatzinfo','2009-10-06 13:49:46'),(338,49,'alloc','char','!-!alloc.n','Auto-Allokation? \"+\" oder \"-\"','2009-10-06 13:49:46'),(339,49,'ipregion','int4','!-!>ipregion','die aus diesem Bereich Adressen vergeben kann','2009-10-06 13:49:46'),(340,49,'ticket','int4','!-!%ticket','Kundenauftrag für das inetnum-Objekt','2009-10-06 13:49:46'),(341,49,'owner','int4','!-!>person','Firma des Adressblocks','2009-10-06 13:49:46'),(342,49,'adminc','int4','!-!>person','Admin-C des Adressblocks','2009-10-06 13:49:46'),(343,49,'techc','int4','!-!>person','Tech-C des Adressblocks','2009-10-06 13:49:46'),(344,49,'nic','int2','!-!nic','Registrar für den Adressblock','2009-10-06 13:49:46'),(345,49,'status','int1','!-!ipstatus','Status des Antrags','2009-10-06 13:49:46'),(346,49,'dest','int2','!ziel','Zielcode für IP-Traffic an diese Adresse','2009-10-06 13:49:46'),(347,49,'nagiosconf','char255','!-','spezielle Konfigurationseinstellungen für Nagios (vgl. RT#259990)','2009-10-06 13:49:46'),(348,49,'flags','int4','!*ipflags','Flags, z. B. \"no_virusscan\"','2009-10-06 13:49:46'),(349,49,'snmp_community','char255','!-','SNMP-Community für Abfragen z. B. durch CapMan (vgl. RT#349627)','2009-10-06 13:49:46'),(350,49,'mail_ip','uint1','!-','Wert des letzten Bytes der IP-Adressen, die auf mail.noris.net für E-Mails verwendet werden soll, die von diesem Host eingeliefert wurden (vgl. RT#407095)','2009-10-06 13:49:46'),(351,49,'vrf','char255','!-','Name des VRFs. Darf nur bei /96-Netzen gesetzt sein, die mit dem $VRF_PREFIX beginnen. Vgl. RT#369538.','2009-10-06 13:49:46'),(352,50,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:46'),(353,50,'name','char255','','- Bezeichnung','2009-10-06 13:49:46'),(354,50,'typ','int4','!>mess_typ','Typ der Mess-Stelle','2009-10-06 13:49:46'),(355,50,'snmp_host','int4','!-!>ipkunde','Über diese IP kann der Wert per SNMP abgefragt werden','2009-10-06 13:49:46'),(356,50,'oid_suffix','char255','!-!%ascii','Der hintere Teil der OID zur SNMP-Abfrage','2009-10-06 13:49:46'),(357,50,'beginn','uint4','!/','Zeitpunkt der Zuteilung der Adresse','2009-10-06 13:49:46'),(358,50,'ende','uint4','!-!/','Freigabezeitpunkt der Adresse','2009-10-06 13:49:46'),(359,50,'info','char255','','- Kommentarfeld','2009-10-06 13:49:46'),(360,50,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(361,51,'person','int4','!^!>person','assoziierter Kunde','2009-10-06 13:49:46'),(362,51,'ipkunde','int4','!>ipkunde','assoziierter Adressbereich','2009-10-06 13:49:46'),(363,51,'metrik','uint1','','- Routen-Metrik, s. RT#413407','2009-10-06 13:49:46'),(364,51,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(365,52,'id','int4','!^Muster!?+','ID','2009-10-06 13:49:46'),(366,52,'name','char30','','- Kurzname','2009-10-06 13:49:46'),(367,52,'inhalt','text2','!%ctrl','Mustertext','2009-10-06 13:49:46'),(368,52,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(369,53,'id','int2','!?+','ID','2009-10-06 13:49:46'),(370,53,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(371,53,'kfz','char3','','- ein- bis dreistellige Kennung','2009-10-06 13:49:46'),(372,53,'iso2','fchar2','','- iso 2stellig','2009-10-06 13:49:46'),(373,53,'iso3','fchar3','','- iso 3stellig','2009-10-06 13:49:46'),(374,53,'name','char30','','- Name des Landes','2009-10-06 13:49:46'),(375,53,'name_en','char30','','- Name des Landes','2009-10-06 13:49:46'),(376,53,'eu','char','!jbool.n','EU-Mitglied?','2009-10-06 13:49:46'),(377,54,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:46'),(378,54,'rt_id','int4','!>ticket','id in rt, also die sichtbare Ticket-Nummer','2009-10-06 13:49:46'),(379,54,'rt_maxseq','int4','','- ticket.maxseq zum Zeitpunkt des Imports; ist 0, wenn es keine Artikel gab.','2009-10-06 13:49:46'),(380,54,'otrs_id','int4','','- (interne) id in otrs','2009-10-06 13:49:46'),(381,54,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(382,55,'id','int4','!?+','ID','2009-10-06 13:49:46'),(383,55,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(384,55,'ticket','int4','!^!>ticket','RT-Ticket','2009-10-06 13:49:46'),(385,55,'art','char255','!-','Art der Störung','2009-10-06 13:49:46'),(386,55,'ursache','text2','!%ctrl!-','Ursache der Störung','2009-10-06 13:49:46'),(387,55,'t_meldung','uint4','!-!/','Zeitpunkt der Störungsmeldung','2009-10-06 13:49:46'),(388,55,'t_reaktion','uint4','!-!/','Zeitpunkt der 1. Reaktion','2009-10-06 13:49:46'),(389,55,'t_entstoerung','uint4','!-!/','Zeitpunkt der Entstörung','2009-10-06 13:49:46'),(390,55,'flags','int4','!*rt_incidents_flags','Flags','2009-10-06 13:49:46'),(391,56,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:46'),(392,56,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(393,56,'child','int4','!>ipkunde','ID des Kind-Objekts','2009-10-06 13:49:46'),(394,56,'parent','int4','!^!>ipkunde','ID des Eltern-Objekts','2009-10-06 13:49:46'),(395,57,'id','int4','!?+','ID','2009-10-06 13:49:46'),(396,57,'monat','int4','!(JJJJMM)','Zeit','2009-10-06 13:49:46'),(397,57,'person','int4','!^!-!>person','(NULL bei globalen Solldatensätzen)','2009-10-06 13:49:46'),(398,57,'soll','uint4','!-!//','Soll-Arbeitszeit in diesem Monat','2009-10-06 13:49:46'),(399,57,'ist','uint4','!-!//','Ist-Arbeitszeit, berechnet bei Abrechnung','2009-10-06 13:49:46'),(400,57,'urlaub','uint4','!%null!-!//','Ist-Urlaubszeit, berechnet bei Abrechnung','2009-10-06 13:49:46'),(401,57,'auszahl','uint4','!%null!-!//','ausgezahlte Überstunden für diesen Monat','2009-10-06 13:49:46'),(402,57,'diff','int4','!//','Differenz Ist/Soll, abgerechnet','2009-10-06 13:49:46'),(403,57,'ueberstundenlimit','uint4','!-!//','drüber rausgehende Überstunden fliegen raus','2009-10-06 13:49:46'),(404,57,'hotline','uint4','!-!//','nicht berücksichtigte Zeit für Hotline-Einsätze','2009-10-06 13:49:46'),(405,57,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(406,58,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:46'),(407,58,'kunde','int4','!^!>kunde','ID des Kunden <- kunde.id','2009-10-06 13:49:46'),(408,58,'tarifname','int4','!-!>tarifname','Tarif.','2009-10-06 13:49:46'),(409,58,'dienst','int2','!>dienst/tarif','genutzter Dienst','2009-10-06 13:49:46'),(410,58,'anzahl','int2','','- Zahl der belegten Anschlüsse, Ports, etc.','2009-10-06 13:49:46'),(411,58,'beginn','uint4','!/','ab wann genutzt?','2009-10-06 13:49:46'),(412,58,'ende','uint4','!-!/','bis wann genutzt?','2009-10-06 13:49:46'),(413,58,'ablauf','uint4','!-!/','bis wann vereinbart?','2009-10-06 13:49:46'),(414,58,'notiz','uint4','!-!/','wann das System zuletzt Traffic bemerkt hat','2009-10-06 13:49:46'),(415,58,'infotext','char255','!-','Kurzbeschreibung wieso (Domainname etc.)','2009-10-06 13:49:46'),(416,58,'rechnung','char','!-','Einrichtungsgebühr berechnet? 0/1 TODO bool','2009-10-06 13:49:46'),(417,58,'nextrech','int4','!-!(JJJJMM)','wann die nächste Rechnung zu stellen ist','2009-10-06 13:49:46'),(418,58,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(419,59,'id','int4','!?+','ID','2009-10-06 13:49:46'),(420,59,'name','char255','','- eindeutige Bezeichnung','2009-10-06 13:49:46'),(421,59,'dienst','int2','!>dienst','Der dienst, der beim Accounting eingetragen wird','2009-10-06 13:49:46'),(422,59,'wertart','char255','','Beschreibung die Mess-Größe, nur eine Art Kommentar','2009-10-06 13:49:46'),(423,59,'einheit','int2','!einheit','','2009-10-06 13:49:46'),(424,59,'collectd_typ','char255','','- Type-Attribut in collectd, bestimmt den Pfad und URL der RRDs','2009-10-06 13:49:46'),(425,59,'collectd_intervall','uint4','','- Abfrageintervall in Sekunden für collectd','2009-10-06 13:49:46'),(426,59,'rrd_typ','int2','!rrd_typ','RRD-Data-Source-Type, z.B. \"GAUGE\"','2009-10-06 13:49:46'),(427,59,'rrd_min','double','!-','Unteres Limit fuer RRD','2009-10-06 13:49:46'),(428,59,'rrd_max','double','!-','Oberes Limit fuer RRD','2009-10-06 13:49:46'),(429,59,'rrd_faktor','double','','- Umrechnungsfaktor von RRD -> Accounting oder Graphanzeige','2009-10-06 13:49:46'),(430,59,'snmp_faktor','double','','- Umrechnungsfaktor von SNMP -> RRD','2009-10-06 13:49:46'),(431,59,'oid_praefix','char255','!-!%ascii','Falls die Werte ueber SNMP abgefragt werden, der gemeinsame OID-Anfang','2009-10-06 13:49:46'),(432,59,'info','char255','!-','Kommentarfeld','2009-10-06 13:49:46'),(433,59,'status','int2','!mess_typ_status','Ist dieser Typ verwendbar?','2009-10-06 13:49:46'),(434,59,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(435,60,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:46'),(436,60,'ticket','int4','!^!>ticket','Nummer des Tickets','2009-10-06 13:49:46'),(437,60,'person','int4','!-!>person','Person','2009-10-06 13:49:46'),(438,60,'email','char255','','- Mailadresse','2009-10-06 13:49:46'),(439,60,'marker','char','!marker.0','Abgleich der Personenliste','2009-10-06 13:49:46'),(440,60,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(441,61,'id','int4','!?+','ID','2009-10-06 13:49:46'),(442,61,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(443,61,'rechstep','int4','!^!>rechstep','Schritt, für den diese Einheit gilt','2009-10-06 13:49:46'),(444,61,'typ','char','','. Art (\'b\':Bytes \'p\':Pakete)','2009-10-06 13:49:46'),(445,61,'start','int8','','. Menge, ab der diese Einheit gedruckt wird, *1000','2009-10-06 13:49:46'),(446,61,'faktor','int8','','. Reduktion um diesen Faktor, *1000','2009-10-06 13:49:46'),(447,61,'name','char10','','. Text der Einheit (kurz)','2009-10-06 13:49:46'),(448,61,'info','char30','','. Text der Einheit (lang)','2009-10-06 13:49:46'),(449,62,'id','int4','!?+','eindeutige ID','2009-10-06 13:49:46'),(450,62,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(451,62,'dienst','int2','!>dienst','Dienst, auf den accountet wurde','2009-10-06 13:49:46'),(452,62,'ziel','int2','!(dienst!ziel)','Ziel (für Debugging-Zwecke)','2009-10-06 13:49:46'),(453,62,'kunde','int4','!^!>kunde','Kunde, auf den accountet wurde','2009-10-06 13:49:46'),(454,62,'person','int4','!^!>person','(Verweis auf den) Einwahl-User','2009-10-06 13:49:46'),(455,62,'gegenstelle','char255','!-','anrufende Rufnummer (\"Calling-Station-Id\")','2009-10-06 13:49:46'),(456,62,'zielrufnr','char255','!-','angerufene Rufnummer (\"Called-Station-Id\")','2009-10-06 13:49:46'),(457,62,'datum','uint4','!/','Timestamp aus den Accounting-Logs','2009-10-06 13:49:46'),(458,62,'dauer','uint4','','- Verbindungsdauer in Sekunden (\"Acct-Session-Time\")','2009-10-06 13:49:46'),(459,62,'pakete_in','uint4','','- Anzahl eingehender Pakete','2009-10-06 13:49:46'),(460,62,'pakete_out','uint4','','- Anzahl abgehender Pakete','2009-10-06 13:49:46'),(461,62,'bytes_in','uint8','','- Anzahl eingehender Bytes','2009-10-06 13:49:46'),(462,62,'bytes_out','uint8','','- Anzahl abgehender Bytes','2009-10-06 13:49:46'),(463,63,'id','int4','!^!?+','eindeutige Nummer','2009-10-06 13:49:46'),(464,63,'name','char30','','- Name der Subtabelle','2009-10-06 13:49:46'),(465,63,'info','char255','!-','kurze Erklärung','2009-10-06 13:49:46'),(466,63,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(467,64,'id','int4','!^exim!?+','ID','2009-10-06 13:49:46'),(468,64,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(469,64,'exim_id','char40','!%ascii','die ID aus dem exim-Log','2009-10-06 13:49:46'),(470,64,'data','bin2','!%ctrl','perl-Blob des Hash-Inhalts','2009-10-06 13:49:46'),(471,65,'id','int4','!?+','ID','2009-10-06 13:49:46'),(472,65,'kunde','int4','!^!>kunde','assoziierter Kunde','2009-10-06 13:49:46'),(473,65,'quelle','char255','!-','E-Mail-Adresse oder Domain, für die diese Regel gilt (NULL = \"*\"-Umleitung)','2009-10-06 13:49:46'),(474,65,'typ','int2','!mailrules','Typ der Regel','2009-10-06 13:49:46'),(475,65,'ziel','text2','!-','Umleitungsziel (genaue Bedeutung je nach Typ unterschiedlich)','2009-10-06 13:49:46'),(476,65,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(477,66,'id','int4','!?+','eindeutige ID','2009-10-06 13:49:46'),(478,66,'domain','char255','','- Name der Superdomain','2009-10-06 13:49:46'),(479,66,'dienst','int2','!>dienst','Dienst zu berechnender Dienst','2009-10-06 13:49:46'),(480,66,'nic','int2','!^!-!nic!>nicdata.nic','zu verwendender NIC','2009-10-06 13:49:46'),(481,66,'techc','int4','!-!>person','Default-Tech-C für diese Domains','2009-10-06 13:49:46'),(482,66,'zonec','int4','!-!>person','Default-Zone-C für diese Domains','2009-10-06 13:49:46'),(483,66,'billc','int4','!-!>person','Default-Bill-C für diese Domains','2009-10-06 13:49:46'),(484,66,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(485,66,'whoisserver','char255','!-','whois-Server für diese Domains (ggf. inkl. zusätzlicher Argumente und Platzhalter <domain> bzw. <domain-ace>)','2009-10-06 13:49:46'),(486,67,'nic','int2','!nic','NIC','2009-10-06 13:49:46'),(487,67,'id','int4','!^!?+','eindeutige ID','2009-10-06 13:49:46'),(488,67,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(489,67,'handle_re','char100','!-','Regulärer Ausdruck zum Prüfen von Handles auf Gültigkeit','2009-10-06 13:49:46'),(490,68,'id','int4','!?+','','2009-10-06 13:49:46'),(491,68,'name','char30','','- Tabellenname','2009-10-06 13:49:46'),(492,68,'text','char100','','- Verwendungstext der Tabelle','2009-10-06 13:49:46'),(493,68,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(494,69,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:46'),(495,69,'person','int4','!>person','die ablesende Person','2009-10-06 13:49:46'),(496,69,'mess_geraet','int4','!>mess_geraet','das abgelesene Gerät','2009-10-06 13:49:46'),(497,69,'ablesezeitpunkt','uint4','!/','Zeitpunkt der Ablesung','2009-10-06 13:49:46'),(498,69,'wert','double','','- abgelesener Wert','2009-10-06 13:49:46'),(499,69,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(500,70,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:46'),(501,70,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(502,70,'host','int4','!>>ipkunde','zugeordneter Host','2009-10-06 13:49:46'),(503,70,'gruppe','int4','!^!>hostgroup','Hostgroup, der der Host zugeordnet ist','2009-10-06 13:49:46'),(504,71,'id','int2','!^!?+','ID','2009-10-06 13:49:46'),(505,71,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(506,71,'name','char15','','. Name dieses Diensts','2009-10-06 13:49:46'),(507,71,'info','char100','!-','Beschreibung, was da accountet wird','2009-10-06 13:49:46'),(508,71,'rechnungstext','char100','!-','Bezeichnung des Dienstes auf Rechnungen (falls NULL, wird der dienst.name verwendet)','2009-10-06 13:49:46'),(509,72,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:46'),(510,72,'user_id','int4','!^!>auth_user','','2009-10-06 13:49:46'),(511,72,'group_id','int4','!^^!>auth_group','','2009-10-06 13:49:46'),(512,72,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(513,73,'person','int4','!^!>person','','2009-10-06 13:49:46'),(514,73,'beginn','uint4','!/','Gültigkeit','2009-10-06 13:49:46'),(515,73,'ende','uint4','!-!/','Gültigkeit','2009-10-06 13:49:46'),(516,73,'abschluss','uint4','!-!/','Datum, bis zu dem Stundeneinträge geändert werden dürfen','2009-10-06 13:49:46'),(517,73,'urlaub','int4','!//','restliche Urlaubszeit, dieses Jahr','2009-10-06 13:49:46'),(518,73,'resturlaub','int4','!//','restliche Urlaubszeit, Vorjahr','2009-10-06 13:49:46'),(519,73,'ueberstunde','int4','!//','angesammelte Überstunden','2009-10-06 13:49:46'),(520,73,'ueberstundenlimit','uint4','!-!//','drüber rausgehende Überstunden fliegen raus','2009-10-06 13:49:46'),(521,73,'letzter','int4','!-!(JJJJMM)','bis zu dem die Daten geupdatet wurden','2009-10-06 13:49:46'),(522,73,'personr','int2','','- Personalnummer','2009-10-06 13:49:46'),(523,73,'jahresurlaub','uint4','!//','Urlaubszeit pro Jahr, Tage','2009-10-06 13:49:46'),(524,73,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(525,73,'vorgesetzter','int4','!-!>person','Adressat für Stundenabrechnungen etc.','2009-10-06 13:49:46'),(526,73,'tagstunden','int4','!-','Stunden*1000 eines Arbeitstags','2009-10-06 13:49:46'),(527,73,'anfangsmonat','uint3','!-!(JJJJMM)','Anfang eines Monats (i. d. R. Jahreswechsel), zu dem ein fester Stand an Überstunden festgelegt wurde','2009-10-06 13:49:46'),(528,73,'anfangsueber','int3','!-','festgelegter Bestand an Überzeit zum Anfangsmonat (vgl. oben) in Sekunden','2009-10-06 13:49:46'),(529,74,'id','int4','!^kundebunt!?+','ID','2009-10-06 13:49:46'),(530,74,'modified','datetime','','- Zeitpunkt der letzten Modifikation','2009-10-06 13:49:46'),(531,74,'created','datetime','','- Zeitpunkt des Anlegens','2009-10-06 13:49:46'),(532,74,'ticket','uint4','!%ticket','Zugehöriges Ticket','2009-10-06 13:49:46'),(533,74,'kind','uint2','','- Art des Releases','2009-10-06 13:49:46'),(534,74,'release_beginn_id','int4','!>releasenotes_release!-','Ab welcher Release der Fehler besteht','2009-10-06 13:49:46'),(535,74,'release_behoben_id','int4','!>releasenotes_release!-','Ab welcher der Fehler behoben ist','2009-10-06 13:49:46'),(536,74,'last_modified_by','int4','!-','Wer den Eintrag zuletzt editiert hat (person)','2009-10-06 13:49:46'),(537,74,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(538,75,'id','int4','!?+','ID','2009-10-06 13:49:46'),(539,75,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(540,75,'name','char127','','- Name','2009-10-06 13:49:46'),(541,75,'hardware_id','char15','!-','eindeutige, durch noris vergebene ID; NULL für Stromleisten etc., vgl. RT#201214','2009-10-06 13:49:46'),(542,75,'seriennr','char127','!-','SerienNummer','2009-10-06 13:49:46'),(543,75,'ivnr','char15','!-','InventarNummer (wenn das Ding uns gehört)','2009-10-06 13:49:46'),(544,75,'typ','int2','!-!hardware_typ','Typ der Hardware, z. B. \"Switch\", \"Server\" etc., vgl. RT#207798','2009-10-06 13:49:46'),(545,75,'klasse','int2','!-!hardware_klasse','Hardwareklasse, z. B. \"intern\", \"office\" etc., vgl. RT#207798','2009-10-06 13:49:46'),(546,75,'ip','int4','!-!>ipkunde','Management-IP-Adresse','2009-10-06 13:49:46'),(547,75,'enthalten_in','int4','!-!>hardware','Referenz auf andere Hardware, in der diese Hardware eingebaut ist, vgl. RT#207798-17','2009-10-06 13:49:46'),(548,75,'standort','int4','!-!>person','Standort','2009-10-06 13:49:46'),(549,75,'eigentuemer','int4','!-!>person','Eigentümer','2009-10-06 13:49:46'),(550,75,'verantwortlich','int4','!-!>person','Verantwortlicher für diese Hardware, vgl. RT#314011','2009-10-06 13:49:46'),(551,75,'kunde','int4','!^!>kunde','zugeordneter Kunde','2009-10-06 13:49:46'),(552,75,'lieferant','int2','!-!lieferant','Lieferant, bei dem wir diese Hardware gekauft haben','2009-10-06 13:49:46'),(553,75,'status','int2','!-!hardware_status','Status der Hardware, vgl. RT#215033','2009-10-06 13:49:46'),(554,75,'info','char255','!-','optionaler Info-Text','2009-10-06 13:49:46'),(555,75,'beginn','uint4','!/','Gültigkeit','2009-10-06 13:49:46'),(556,75,'ende','uint4','!-!/','Gültigkeit','2009-10-06 13:49:46'),(557,75,'rack','int2','!^^!-!>rack','Rack, in dem diese Hardware eingebaut ist','2009-10-06 13:49:46'),(558,75,'unterste_he','uint1','!-','unterste HE des Racks, in dem diese Hardware eingebaut ist','2009-10-06 13:49:46'),(559,75,'he','uint1','!-','Höhe des Geräts in HE','2009-10-06 13:49:46'),(560,75,'console','char255','!-','(symbolischer) Port und Server für Console, vgl. RT#206285','2009-10-06 13:49:46'),(561,75,'gemailt','int4','!-','Timestamp, der beim Vermailen des Datensatz gesetzt wird, vgl. RT#219877','2009-10-06 13:49:46'),(562,75,'flags','int4','!*hardwareflags','Flags','2009-10-06 13:49:46'),(563,76,'id','uint4','!?+','ID','2009-10-06 13:49:46'),(564,76,'kunde','int4','!^__!>kunde','Kunde, für den die Einstellung gilt','2009-10-06 13:49:46'),(565,76,'beginn','uint4','!/','Zeitpunkt, ab dem die Einstellung wirksam wird','2009-10-06 13:49:46'),(566,76,'timestamp','datetime','!/+','Zeitstempel, wann die Eingabe getätigt wurde','2009-10-06 13:49:46'),(567,76,'option','int2','!open_xchange','Gewählte Einstellung','2009-10-06 13:49:46'),(568,76,'log','uint4','!>open_xchange_log','Verweis auf die Daten des zugehörigen GET-Requests','2009-10-06 13:49:46'),(569,76,'request','text2','!%ctrl','Kompletter http-Request des POST-Requests zum Nachweis','2009-10-06 13:49:46'),(570,77,'id','int4','!?+','ID','2009-10-06 13:49:46'),(571,77,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(572,77,'kunde','int4','!^!>kunde','wer ist der Reseller','2009-10-06 13:49:46'),(573,77,'art','int1','!reseller','auch Tarifsuffix (domain-?)','2009-10-06 13:49:46'),(574,77,'name','char20','','- im Header','2009-10-06 13:49:46'),(575,77,'flags','int4','!*rs_flag','was darf der Reseller? Sonderfunktionen?','2009-10-06 13:49:46'),(576,77,'keyid','char10','!-','PGP-Key-ID zwecks Suche / Verifikation','2009-10-06 13:49:46'),(577,77,'email','char100','!-','Mailadresse','2009-10-06 13:49:46'),(578,78,'person','int4','!>person','','2009-10-06 13:49:46'),(579,78,'queue','int4','!^!>queue','','2009-10-06 13:49:46'),(580,78,'acls','int4','!*rt_acl','','2009-10-06 13:49:46'),(581,78,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(582,79,'id','int4','!?+','ID','2009-10-06 13:49:46'),(583,79,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(584,79,'kunde','int4','!>kunde','Kunde, für den berechnet wird','2009-10-06 13:49:46'),(585,79,'rnr','int4','!^!-!>rechnungen.rnr','Rechnung','2009-10-06 13:49:46'),(586,79,'mwst','int2','!-!%null','Mehrwertsteuer, als Promille','2009-10-06 13:49:46'),(587,79,'beginn','uint4','!/','Anfang des berechneten Zeitraums (Accounting)','2009-10-06 13:49:46'),(588,79,'ende','uint4','!/','Ende des berechneten Zeitraums (Accounting)','2009-10-06 13:49:46'),(589,79,'rbeginn','uint4','!/','Anfang des berechneten Zeitraums (R-Kopf)','2009-10-06 13:49:46'),(590,79,'rende','uint4','!/','Ende des berechneten Zeitraums (R-Kopf)','2009-10-06 13:49:46'),(591,80,'id','int4','!?+','eindeutige ID','2009-10-06 13:49:46'),(592,80,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(593,80,'kunde','int4','!^!>kunde','Kunde, auf den accountet wurde','2009-10-06 13:49:46'),(594,80,'person','int4','!^!>person','(Verweis auf den) iPass-User','2009-10-06 13:49:46'),(595,80,'transaction_id','char255','','- Transaction-ID laut iPass (keine Ahnung, wofür die gut ist)','2009-10-06 13:49:46'),(596,80,'billing_code','uint4','','- Billing Code laut iPass (gibt den Minutenpreis an, vgl. pricelist.html)','2009-10-06 13:49:46'),(597,80,'authentication_domain','char255','','- Authentication Domain, normalerweise immer \"noris.net\"','2009-10-06 13:49:46'),(598,80,'description','char255','','- Kurzbeschreibung des einschlägigen Tarifs','2009-10-06 13:49:46'),(599,80,'datum','int4','','$/ Zeitpunkt der Einwahl','2009-10-06 13:49:46'),(600,80,'session_length','uint4','','- Länge der Einwahl-Session in Sekunden','2009-10-06 13:49:46'),(601,80,'billing_rate','uint2','','- Stundenpreis in Euro-Cent','2009-10-06 13:49:46'),(602,80,'net_billing_amount','uint4','','- Gesamtpreis der Verbindung in Euro-Cent','2009-10-06 13:49:46'),(603,80,'access_type','int2','!ipass_access_type','DIAL, WIFI oder ENET','2009-10-06 13:49:46'),(604,80,'service_type','int2','!ipass_service_type','üblicherweise \"usage\", ansonsten vgl. RT#219895-1','2009-10-06 13:49:46'),(605,81,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:46'),(606,81,'name','char255','','- eindeutige Bezeichnung','2009-10-06 13:49:46'),(607,81,'ueberlauf_wert','double','!-','Der Wert, den die Anzeige gerade nicht mehr erreicht, sondern auf 0 springt','2009-10-06 13:49:46'),(608,81,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(609,82,'id','int4','!^exim!?+','ID','2009-10-06 13:49:46'),(610,82,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(611,82,'exim_id','char40','!%ascii','die ID aus dem exim-Log','2009-10-06 13:49:46'),(612,82,'data','bin2','!%ctrl','perl-Blob des Hash-Inhalts','2009-10-06 13:49:46'),(613,83,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:46'),(614,83,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(615,83,'kunde','int4','!^!>kunde','Kunde','2009-10-06 13:49:46'),(616,83,'domain','char100','!%ascii','vollständiger Domainname, punycode','2009-10-06 13:49:46'),(617,83,'beginn','uint4','!/','Zuteilung','2009-10-06 13:49:46'),(618,83,'ende','uint4','!-!/','Freigabe','2009-10-06 13:49:46'),(619,83,'expires','uint4','!-!/','Ablauf laut Registrar','2009-10-06 13:49:46'),(620,83,'status','int2','!domainstatus','Status','2009-10-06 13:49:46'),(621,83,'infotext','char255','!-','Kurzbeschreibung wieso (IP-Nr etc.)','2009-10-06 13:49:46'),(622,83,'tarifname','int4','!-!>tarifname','Name des (künftigen...) Tarifs','2009-10-06 13:49:46'),(623,83,'rechinfo','int4','!-','externe Rechnung -> erech','2009-10-06 13:49:46'),(624,83,'ktarif','int4','!-!>tarifkunde','','2009-10-06 13:49:46'),(625,83,'person','int4','!-!>person','Besitzer des Webspaces o.ä.','2009-10-06 13:49:46'),(626,83,'owner','int4','!-!>person','Firma des Domainantrags','2009-10-06 13:49:46'),(627,83,'adminc','int4','!-!>person','Admin-C des Domainantrags','2009-10-06 13:49:46'),(628,83,'techc','int4','!-!>person','Tech-C des Domainantrags','2009-10-06 13:49:46'),(629,83,'zonec','int4','!-!>person','Zone-C des Domainantrags','2009-10-06 13:49:46'),(630,83,'billc','int4','!-!>person','Bill-C des Domainantrags','2009-10-06 13:49:46'),(631,83,'nic','int2','!-!nic','Registrar für die Domain','2009-10-06 13:49:46'),(632,83,'nserver','int4','!-!>ipkunde','Name+Adresse eines kundeneigenen Primary','2009-10-06 13:49:46'),(633,83,'tsig','int2','!-!tsig','TSIG-Key für allow_update','2009-10-06 13:49:46'),(634,83,'ticket','int4','!-!%ticket','Kundenauftrag für die Domain','2009-10-06 13:49:46'),(635,83,'nachricht','int4','!-!>person','Benachrichtigung bei Updates etc.','2009-10-06 13:49:46'),(636,83,'flags','int4','!*domainflags','Flags, z. B. \"dnszone\"','2009-10-06 13:49:46'),(637,83,'mail_ip','uint1','!-','Wert des letzten Bytes der IP-Adressen, die auf mail.noris.net für E-Mails mit dieser Absenderdomain verwendet werden sollen','2009-10-06 13:49:46'),(638,84,'kunde','int4','!>kunde','ID des Kunden','2009-10-06 13:49:46'),(639,84,'dienst','int2','!dienst','Dienst','2009-10-06 13:49:46'),(640,84,'dringend','int2','','- Ordnungskriterium','2009-10-06 13:49:46'),(641,84,'person','int4','!^!>person','Person','2009-10-06 13:49:46'),(642,84,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(643,85,'id','int4','!?+','ID','2009-10-06 13:49:46'),(644,85,'typ','int4','!^!>descr_typ','Subtabelle','2009-10-06 13:49:46'),(645,85,'descr','int4','','- numerischer Wert, oder ASCII des Zeichens','2009-10-06 13:49:46'),(646,85,'bla','char30','','- textuelle Beschreibung (kurz)','2009-10-06 13:49:46'),(647,85,'idchar','char','!-!%case_sens!%utf8','Kurzzeichen für die Übersicht','2009-10-06 13:49:46'),(648,85,'gruppe','int4','!*<name>_ident','Untergruppen','2009-10-06 13:49:46'),(649,85,'infotext','char255','!-','kurze Erklärung','2009-10-06 13:49:46'),(650,85,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(651,86,'id','int4','!?+','ID','2009-10-06 13:49:46'),(652,86,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:46'),(653,86,'nic','int2','!^!nic!>nicdata.nic','Registrar','2009-10-06 13:49:46'),(654,86,'flags','int4','!*reg_flag','Zusatzinfo (signieren? nur PGP annehmen?)','2009-10-06 13:49:46'),(655,86,'keyid','char10','!-','PGP-Key-ID','2009-10-06 13:49:46'),(656,86,'email','char100','!-','Mail-Adresse','2009-10-06 13:49:46'),(657,87,'id','int4','!?+','ID des Tarifs','2009-10-06 13:49:46'),(658,87,'klasse','int4','!^!>tarifklasse','Name+Art des Tarifs','2009-10-06 13:49:46'),(659,87,'dienst','int2','!>dienst','welche Art Traffic berechnet wird','2009-10-06 13:49:46'),(660,87,'frei','int4','!$$','Freibetrag','2009-10-06 13:49:46'),(661,87,'festpreis','int4','!$$','pro Bestellung','2009-10-06 13:49:46'),(662,87,'preis','int4','!$$','pro XXX Bytes / Gebühreneinheiten, Zehntelcent','2009-10-06 13:49:46'),(663,87,'skala','uint8','!$$','das XXX im Preis-Feld','2009-10-06 13:49:46'),(664,87,'unitpreis','int4','!$$','pro Paket / Anruf','2009-10-06 13:49:46'),(665,87,'beginn','uint4','!/','ab wann der Kram so berechnet wird','2009-10-06 13:49:46'),(666,87,'mini','int4','','- wieviele Einheiten brauche ich für den Tarif','2009-10-06 13:49:46'),(667,87,'unitmini','int4','','- wieviele Pakete/Anrufe brauche ich für den Tarif','2009-10-06 13:49:46'),(668,87,'intval','char','!rechnung','Rechnungsstellung wie?','2009-10-06 13:49:47'),(669,87,'infotext','char255','!-','Kurzbeschreibung des Tarifs','2009-10-06 13:49:47'),(670,87,'festinfo','char255','!-','Kurzbeschreibung bei Festpreisen','2009-10-06 13:49:47'),(671,87,'varinfo','char255','!-','Kurzbeschreibung bei variablen Preisen','2009-10-06 13:49:47'),(672,87,'dnull','char','!jbool.n','drucke Preis auch wenn kostenlos?','2009-10-06 13:49:47'),(673,87,'fnull','char','!jbool.j','drucke Festpreis auch wenn kostenlos?','2009-10-06 13:49:47'),(674,87,'fkonto','int4','!-','Auf welches Konto buchen? (Festkosten)','2009-10-06 13:49:47'),(675,87,'vkonto','int4','!-','Auf welches Konto buchen? (variable Kosten)','2009-10-06 13:49:47'),(676,87,'freiinfo','char255','!-','für Menschen lesbare Version des Freikontingents','2009-10-06 13:49:47'),(677,87,'nonum','char','!jbool.n','Anzahl auf den Preis durchhauen lassen','2009-10-06 13:49:47'),(678,87,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(679,87,'description','text2','!-','Erläuterungen insb. für die Technik','2009-10-06 13:49:47'),(680,87,'betriebszeit','char255','!-','Betriebszeit(en) gemäß zum Tarif gehörenden SLA als (erweiterte) Time::Period-Spezifikation','2009-10-06 13:49:47'),(681,87,'servicezeit','char255','!-','Servicezeit(en) gemäß zum Tarif gehörenden SLA als (erweiterte) Time::Period-Spezifikation','2009-10-06 13:49:47'),(682,87,'wartungsfenster','char255','!-','Wartungsfenster gemäß zum Tarif gehörenden SLA als (erweiterte) Time::Period-Spezifikation','2009-10-06 13:49:47'),(683,88,'id','int4','!?+','ID','2009-10-06 13:49:47'),(684,88,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(685,88,'step','int2','','. Sequenz auf der Rechnung','2009-10-06 13:49:47'),(686,88,'kunde','int4','!-!>kunde','Spezialbehandlung für diesen Kunden?','2009-10-06 13:49:47'),(687,88,'dienst','int2','!^!>dienst','Dienst, für den dieser Datensatz gilt','2009-10-06 13:49:47'),(688,88,'flags','int4','!*acctflag','Flags (z. B.: Einzelpreis nicht drucken, Menge ohne Kommastellen, ...)','2009-10-06 13:49:47'),(689,88,'info','char100','!-','Text (für die Übersicht in kunde)','2009-10-06 13:49:47'),(690,89,'id','int2','!?+','ID','2009-10-06 13:49:47'),(691,89,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(692,89,'name','char255','','- Name des RZs','2009-10-06 13:49:47'),(693,89,'standort','int4','!>person','Standort dieses RZs, vgl. RT#207798-30','2009-10-06 13:49:47'),(694,90,'id','int4','!?+','ID','2009-10-06 13:49:47'),(695,90,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(696,90,'hardware','int4','!^!>hardware','Hardware, zu der das IP-Adressobjekt gehört','2009-10-06 13:49:47'),(697,90,'ip','int4','!>ipkunde','IP-Adressobjekt, das zur Hardware gehört','2009-10-06 13:49:47'),(698,91,'id','int2','!?+','ID','2009-10-06 13:49:47'),(699,91,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(700,91,'rz','int2','!^^!>rz','RZ, in dem das Rack steht','2009-10-06 13:49:47'),(701,91,'name','char255','','- Bezeichnung des Racks innerhalb des RZs','2009-10-06 13:49:47'),(702,91,'info','char255','!-','optionale zusätzliche Kurzbeschreibung','2009-10-06 13:49:47'),(703,91,'he','uint1','','- Anzahl der HöhenEinheiten des Racks','2009-10-06 13:49:47'),(704,91,'kunde','int4','!>kunde','Kunde, dem das Rack vermietet wurde','2009-10-06 13:49:47'),(705,91,'x','int1','','- X-Koordinate des Racks','2009-10-06 13:49:47'),(706,91,'y','int1','','- Y-Koordinate des Racks','2009-10-06 13:49:47'),(707,92,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:47'),(708,92,'mess_stelle','int4','!>mess_stelle','','2009-10-06 13:49:47'),(709,92,'rack','int2','!-!>rack','entweder hardware oder rack ist NULL','2009-10-06 13:49:47'),(710,92,'hardware','int4','!-!>hardware','entweder hardware oder rack ist NULL','2009-10-06 13:49:47'),(711,92,'beginn','uint4','!/','Zeitpunkt der Zuteilung der Adresse','2009-10-06 13:49:47'),(712,92,'ende','uint4','!-!/','Freigabezeitpunkt der Adresse','2009-10-06 13:49:47'),(713,92,'kunde','int4','!>kunde','Kunde, der das Ganze zu verantworten hat','2009-10-06 13:49:47'),(714,92,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(715,93,'id','int4','!?+','ID des Eintrags','2009-10-06 13:49:47'),(716,93,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(717,93,'kunde','int4','!^!>kunde','Kunde, zu dem die Hostgroup gehört','2009-10-06 13:49:47'),(718,93,'name','char64','','- eindeutiger Name der Hostgroup','2009-10-06 13:49:47'),(719,93,'beschreibung','char64','!-','Beschreibung (zur Anzeige in Benutzerschnittstellen)','2009-10-06 13:49:47'),(720,94,'id','int4','!?+','ID','2009-10-06 13:49:47'),(721,94,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(722,94,'person','int4','!^!>person','Bearbeiter','2009-10-06 13:49:47'),(723,94,'tabelle','char40','','- bearbeitete Tabelle','2009-10-06 13:49:47'),(724,94,'row','char40','','- bearbeitete Spalte','2009-10-06 13:49:47'),(725,94,'idx','char40','','- bearbeitete Zeile','2009-10-06 13:49:47'),(726,95,'id','int4','!^!?+','ID-Nummer des Kunden','2009-10-06 13:49:47'),(727,95,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(728,95,'kunde','int4','!-!>kunde','Übergeordneter Kunde','2009-10-06 13:49:47'),(729,95,'reseller','int4','!-!>kunde','Reseller, der für diesen Kunden aktiv sein darf','2009-10-06 13:49:47'),(730,95,'name','char32','','- Kurzname des Kunden (weitere -> uucpkunde)','2009-10-06 13:49:47'),(731,95,'beginn','uint4','!/','Zeitpunkt Vertragsabschluß (Kunde)','2009-10-06 13:49:47'),(732,95,'ende','uint4','!-!/','Kündigungstermin. Kunde:0 nie Kunde:1.','2009-10-06 13:49:47'),(733,95,'zuletzt','int4','!-!(JJJJMM)','nächster zu berechnender Monat','2009-10-06 13:49:47'),(734,95,'berechne','char','!intervall.m','wie oft wird berechnet? \'m\'onat \'q\'uartal \'j\'ahr \'x\'=manuell','2009-10-06 13:49:47'),(735,95,'kprio','char','!-!kprio','wie wichtig ist der Kunde?','2009-10-06 13:49:47'),(736,95,'geaendert','uint4','!-!/','Zeitpunkt der letzten Änderung an diesem Kunden;','2009-10-06 13:49:47'),(737,95,'flags','int4','!*kunde','Flags dieses Kunden','2009-10-06 13:49:47'),(738,95,'pwklasse','int2','!-!passwort','Hint, welches Passwort für den Kunden verwendet wurde','2009-10-06 13:49:47'),(739,95,'skip','char','!bool.n','überspringe in diesem Rechnungslauf','2009-10-06 13:49:47'),(740,95,'erloeskonto','int4','!-','Buchungs-Kontonr für Rechnung','2009-10-06 13:49:47'),(741,95,'steuernr','char20','!-','UST-ID-Nr','2009-10-06 13:49:47'),(742,95,'zahlung','int1','!-','Zahlungsziel (NULL == Default)','2009-10-06 13:49:47'),(743,95,'sprache','int2','!-!sprache','Default-Sprache, insb. für Postfächer (RT#224274)','2009-10-06 13:49:47'),(744,95,'hauptperson','int4','!-!>person','Adresse etc. des Kunden (ehemals :-0)','2009-10-06 13:49:47'),(745,95,'billc','int4','!-!>person','Rechnungsanschrift des Kunden (ehemals billc-0)','2009-10-06 13:49:47'),(746,95,'adminc','int4','!-!>person','Ansprechpartner für Domains (ehemals nic/adminc-0)','2009-10-06 13:49:47'),(747,95,'ap_vertrieb','int4','!-!>person','vertrieblicher Ansprechpartner, vgl. RT#273307','2009-10-06 13:49:47'),(748,95,'ap_technik','int4','!-!>person','technischer Hauptansprechpartner, vgl. RT#273307','2009-10-06 13:49:47'),(749,95,'mail_ip','uint1','!-','Wert des letzten Bytes der IP-Adressen, die auf mail.noris.net für E-Mails dieses Kunden verwendet werden sollen','2009-10-06 13:49:47'),(750,96,'id','int4','!?+','ID','2009-10-06 13:49:47'),(751,96,'person','int4','!^!%!>person','Mensch mit Handle','2009-10-06 13:49:47'),(752,96,'reseller','int4','!^!>kunde','Reseller, von dem der Handle kommt','2009-10-06 13:49:47'),(753,96,'handle','char120','','- Bezeichner des Handles','2009-10-06 13:49:47'),(754,96,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(755,97,'id','int4','!?+','ID','2009-10-06 13:49:47'),(756,97,'modified','datetime','','- Zeitpunkt der letzten Änderung','2009-10-06 13:49:47'),(757,97,'language','char7','','- Sprache','2009-10-06 13:49:47'),(758,97,'text','text2','!%ctrl','Zugehöriger Text','2009-10-06 13:49:47'),(759,97,'note_id','int4','!^!>releasenotes_note','Zugehöriger Hinweis','2009-10-06 13:49:47'),(760,97,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(761,98,'id','int4','!^!?+','ID','2009-10-06 13:49:47'),(762,98,'ausgabe','int2','!ausgabe','Deskriptor','2009-10-06 13:49:47'),(763,98,'befehl','char255','!-','Befehl; Argumente oder stdin','2009-10-06 13:49:47'),(764,98,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(765,99,'id','int4','!?+','eindeutige Nummer','2009-10-06 13:49:47'),(766,99,'user_id','int4','!^!>auth_user.id','für wen die Nachricht bestimmt ist.','2009-10-06 13:49:47'),(767,99,'message','text2','','- die Nachricht','2009-10-06 13:49:47'),(768,99,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(769,100,'id','int4','!?+','eindeutige ID','2009-10-06 13:49:47'),(770,100,'queue','int4','!^!>queue','','2009-10-06 13:49:47'),(771,100,'name','char50','','- ','2009-10-06 13:49:47'),(772,100,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(773,101,'kunde','int4','!^!>kunde','','2009-10-06 13:49:47'),(774,101,'blz','char10','','- Bankleitzahl','2009-10-06 13:49:47'),(775,101,'name','char40','','- Kontoinhaber (Länge entsprechend FibuNet, vgl. Ticket #10023411)','2009-10-06 13:49:47'),(776,101,'kontonr','char15','','- Kontonummer','2009-10-06 13:49:47'),(777,101,'bank','char40','','- Name der Bank','2009-10-06 13:49:47'),(778,101,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(779,102,'id','int4','','Zähler ','2009-10-06 13:49:47'),(780,102,'name','char255','','- ID','2009-10-06 13:49:47'),(781,102,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(782,103,'rnr','int4','','- Rechnungsnummer','2009-10-06 13:49:47'),(783,103,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(784,103,'datum','uint4','!/','Zeitpunkt der Rechnungserstellung','2009-10-06 13:49:47'),(785,103,'kunde','int4','!^!>kunde','','2009-10-06 13:49:47'),(786,103,'infotext','char255','','- für die Buchung','2009-10-06 13:49:47'),(787,103,'betrag','int4','!$','Cent, ohne Märchensteuer','2009-10-06 13:49:47'),(788,103,'steuer','int4','!$','Märchensteuer dazu','2009-10-06 13:49:47'),(789,103,'auftragsnr','char50','!-','Auftragsnummer','2009-10-06 13:49:47'),(790,103,'rbetrag','int4','!-!$','Cent, bezahlter Betrag','2009-10-06 13:49:47'),(791,103,'buchung','int4','!-','Buchungsnummer','2009-10-06 13:49:47'),(792,103,'auszug','int4','!-','Kontoauszugsnummer','2009-10-06 13:49:47'),(793,103,'flags','int4','!*rstatus','Gemailt/gedruckt/whatever','2009-10-06 13:49:47'),(794,103,'rtext','text3','!%ctrl!-','Text der Rechnung','2009-10-06 13:49:47'),(795,103,'fusstext','text2','!%ctrl!-','Text unter der Rechnung','2009-10-06 13:49:47'),(796,103,'konto','int3','!-','Sachkonto','2009-10-06 13:49:47'),(797,103,'storniert','uint4','!-!/','Datum zu dem die Rechnung storniert wurde','2009-10-06 13:49:47'),(798,104,'id','int4','!?+','ID','2009-10-06 13:49:47'),(799,104,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(800,104,'tag','uint4','','- Tag, an dem der Aufruf erfolgte (in Tagen seit dem fiktiven Jahr 0)','2009-10-06 13:49:47'),(801,104,'applikation','uint2','!>applikation','Applikation, aus der die Funktion aufgerufen wurde','2009-10-06 13:49:47'),(802,104,'funktion','uint2','!>funktion','aufgerufene Funktion','2009-10-06 13:49:47'),(803,104,'person','int4','!>person','Programmnutzer, für den die Funktion aufgerufen wurde','2009-10-06 13:49:47'),(804,104,'anzahl','uint4','','- Anzahl der Aufrufe','2009-10-06 13:49:47'),(805,105,'id','int4','!?+','ID','2009-10-06 13:49:47'),(806,105,'person','int4','!^!>person','wessen Flags geändert wurden','2009-10-06 13:49:47'),(807,105,'flag','int8','!*pwdomain','gesetzte oder gelöschte Bits','2009-10-06 13:49:47'),(808,105,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(809,106,'id','int4','!?+','ID des Tarifs','2009-10-06 13:49:47'),(810,106,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(811,106,'tarifname','int4','!^!>tarifname','Name des Tarifs','2009-10-06 13:49:47'),(812,106,'kunde','int4','!-!^!>kunde','Kunde, für den diese Tarifklasse gilt','2009-10-06 13:49:47'),(813,106,'klassen','int4','!*tarifklasse','','2009-10-06 13:49:47'),(814,106,'obsolet','char','!jbool.n','\"j\" => nicht in der Liste anzeigen','2009-10-06 13:49:47'),(815,106,'laufzeit','uint2','!-!%null','initial, Monate','2009-10-06 13:49:47'),(816,106,'verlaengern','uint2','!-!%null','wenn ungekündigt, Monate','2009-10-06 13:49:47'),(817,106,'kuendigung','uint2','!-!%null','Frist vor Auto-Verlängerung, Tage','2009-10-06 13:49:47'),(818,107,'id','int4','!^!?+','ID','2009-10-06 13:49:47'),(819,107,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(820,107,'dienst','int2','!^!>dienst','genutzter Dienst','2009-10-06 13:49:47'),(821,107,'berechne','int2','!-!>dienst','berechneter Dienst ','2009-10-06 13:49:47'),(822,107,'faktor','int4','','- Multiplikator*100','2009-10-06 13:49:47'),(823,107,'infotext','char255','!-','Kurzbeschreibung der Korrespondenz','2009-10-06 13:49:47'),(824,107,'isrec','char','!jbool.n','\'j\' => der Dienst wird auch als berechne-Dienst gewertet,','2009-10-06 13:49:47'),(825,108,'id','int4','!?+','ID','2009-10-06 13:49:47'),(826,108,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(827,108,'hardware','int4','!^!>hardware','zugeordnete Hardware','2009-10-06 13:49:47'),(828,108,'wartungsvertrag','int4','!^^!>wartungsvertrag','zugeordneter Wartungsvertrag','2009-10-06 13:49:47'),(829,108,'beginn','uint4','!/','Beginn der Laufzeit des Wartungsvertrags','2009-10-06 13:49:47'),(830,108,'ende','uint4','!/!-','Ende der Laufzeit des Wartungsvertrags','2009-10-06 13:49:47'),(831,109,'infotext','char255','!-','(längliche) Beschreibung','2009-10-06 13:49:47'),(832,109,'id','int4','!?+!%kpersinfo','ID-Nr des Menschen','2009-10-06 13:49:47'),(833,109,'kunde','int4','!^___!>kunde','\"Hauptkunde\" des Eintrags','2009-10-06 13:49:47'),(834,109,'name','char255','!-','Anrede/Vor/Zuname | Firmenname','2009-10-06 13:49:47'),(835,109,'abt','char255','!-','Abteilung','2009-10-06 13:49:47'),(836,109,'email','char255','!-','Mailadresse','2009-10-06 13:49:47'),(837,109,'fon','char255','!-!%Fon','Telefonnummer','2009-10-06 13:49:47'),(838,109,'fax','char255','!-!%Fon','Faxnummer','2009-10-06 13:49:47'),(839,109,'pager','char255','!-!%Fons','Pager/Handynummer','2009-10-06 13:49:47'),(840,109,'isdn','char255','!-!%Fons','ISDN-Nummern','2009-10-06 13:49:47'),(841,109,'dest','char4','!-!mailart','Ziele für Nachrichten TODO !*mailart','2009-10-06 13:49:47'),(842,109,'adresse','int4','!^^!-!>adresse','Adresse','2009-10-06 13:49:47'),(843,109,'ausweisnr','char255','!-','Personalausweisnummer','2009-10-06 13:49:47'),(844,109,'zusatzinfo','char255','!-','Sonstiges','2009-10-06 13:49:47'),(845,109,'suchbegriff','char255','!-','Suchbegriff','2009-10-06 13:49:47'),(846,109,'user','char32','!-','Username','2009-10-06 13:49:47'),(847,109,'pass','char255','!-','Paßwort','2009-10-06 13:49:47'),(848,109,'uid','int4','!-!%UID','ID des Users','2009-10-06 13:49:47'),(849,109,'homedir','char255','!-','Homeverzeichnis / WWW-Unterverzeichnis','2009-10-06 13:49:47'),(850,109,'pwuse','int8','!*pwdomain','für was das PW gilt','2009-10-06 13:49:47'),(851,109,'redirect','char255','!-','HTTP-Redirect-Ziel','2009-10-06 13:49:47'),(852,109,'radiustemplate','int2','!-!radius-templates','zu verwendendes Radius-Template, vgl. RT#200867','2009-10-06 13:49:47'),(853,109,'maxconn','int1','!-!(0-30)','max. Zahl gleichzeitiger Multilink-Verbindungen','2009-10-06 13:49:47'),(854,109,'vrf','int2','!#!-!vrf','Virtual Routing and Forwarding, vgl. RT#169889','2009-10-06 13:49:47'),(855,109,'uremip','int4','!-!>ipkunde','entfernte Adresse (Transitnetz?) für PPP etc.','2009-10-06 13:49:47'),(856,109,'prefcall','int2','!-!mailart','welcher Dienst vorrangig zur Benachrichtigung','2009-10-06 13:49:47'),(857,109,'tarifname','int4','!-!>tarifname','wie die Arbeitszeit normalerweise verrechnet wird','2009-10-06 13:49:47'),(858,109,'mperson','int4','!-!>person','übergeordneter Eintrag?','2009-10-06 13:49:47'),(859,109,'gebtag','int2','!-','wann geboren?','2009-10-06 13:49:47'),(860,109,'gebjahr','int2','!-','wann geboren?','2009-10-06 13:49:47'),(861,109,'job','char255','!-','was macht der dort?','2009-10-06 13:49:47'),(862,109,'nagiosconf','char255','!-','spezielle Konfigurationseinstellungen für Nagios (vgl. RT#259990)','2009-10-06 13:49:47'),(863,109,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(864,110,'id','char255','','- Message-ID-Inhalt','2009-10-06 13:49:47'),(865,110,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(866,110,'ticket','int4','!^!>ticket','Nummer des Tickets','2009-10-06 13:49:47'),(867,110,'person','int4','!-!>person','Absender','2009-10-06 13:49:47'),(868,110,'email','char255','!-','Absender-Mailadresse','2009-10-06 13:49:47'),(869,110,'seq','int4','!-!%max(ticket)+1','Nummer der Mail','2009-10-06 13:49:47'),(870,110,'extern','char','!bool.n','\'y\' -> dieser Text ist extern sichtbar, geht an alle','2009-10-06 13:49:47'),(871,110,'typ','int2','!tickett','RT:type','2009-10-06 13:49:47'),(872,110,'data','char255','!-','RT:trans_data','2009-10-06 13:49:47'),(873,110,'inhalt','bin3','!%ctrl','eigentlicher Text','2009-10-06 13:49:47'),(874,111,'id','int4','!^!?+','ID des Tarifs','2009-10-06 13:49:47'),(875,111,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(876,111,'name','char255','','- Name des Tarifs','2009-10-06 13:49:47'),(877,112,'id','int4','!?+','ID','2009-10-06 13:49:47'),(878,112,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(879,112,'leitung','int4','!^!>leitung','Leitung','2009-10-06 13:49:47'),(880,112,'incident','int4','!^!>ticket','Ticket','2009-10-06 13:49:47'),(881,113,'id','int4','!?ticket','eindeutige Nummer; ausnahmsweise weiterhin über DoSeq() vergeben, weil wir die Ticket-ID schon vor Anlegen des Datensatzes kennen möchten.','2009-10-06 13:49:47'),(882,113,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(883,113,'ticket','int4','!-!>ticket','Bezug (Tickets mit id!=ticket werden','2009-10-06 13:49:47'),(884,113,'kunde','int4','!^__!>kunde','Kunde, der das Problem hat','2009-10-06 13:49:47'),(885,113,'subject','char255','','- Genauere Problemkurzbeschreibung','2009-10-06 13:49:47'),(886,113,'infotext','char255','!-','Aktueller Zustand','2009-10-06 13:49:47'),(887,113,'queue','int4','!>queue','für RT, Queue','2009-10-06 13:49:47'),(888,113,'queue_area','int4','!-!>queue_areas','für RT, Area','2009-10-06 13:49:47'),(889,113,'beginn','uint4','!/','Problem bemerkt (Unix-Zeit), Ticket generiert','2009-10-06 13:49:47'),(890,113,'wichtig','int2','','- Dringlichkeit','2009-10-06 13:49:47'),(891,113,'status','int2','!tickets.0','','2009-10-06 13:49:47'),(892,113,'termin','uint4','!-!/','Wiedervorlage (RT: date_due)','2009-10-06 13:49:47'),(893,113,'endtermin','uint4','!-!/','bis wann das Teil bearbeitet sein muß','2009-10-06 13:49:47'),(894,113,'bearbeiter','int4','!-!>person','der Mensch, dem das Teil gehört','2009-10-06 13:49:47'),(895,113,'d_told','uint4','!/','date_told von RT','2009-10-06 13:49:47'),(896,113,'d_acted','uint4','!/','date_acted von RT','2009-10-06 13:49:47'),(897,113,'maxseq','int4','!%max(ticketid.seq)','nur informativ!','2009-10-06 13:49:47'),(898,113,'zeit','int4','!-','für dieses Ticket budgetierte(!) Arbeitszeit','2009-10-06 13:49:47'),(899,114,'id','int4','!^Muster!?+','ID','2009-10-06 13:49:47'),(900,114,'name','char30','','- Kurzname','2009-10-06 13:49:47'),(901,114,'inhalt','text2','!%ctrl','Mustertext','2009-10-06 13:49:47'),(902,114,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(903,115,'name','char32','','- Aliasname des Kunden','2009-10-06 13:49:47'),(904,115,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(905,115,'kunde','int4','!^!>kunde','Nummer des Kunden','2009-10-06 13:49:47'),(906,116,'id','int4','!?+','ID','2009-10-06 13:49:47'),(907,116,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(908,116,'name','char255','','- Name','2009-10-06 13:49:47'),(909,116,'sla','char255','','- z. B. \"24/7\" etc.','2009-10-06 13:49:47'),(910,116,'ansprechpartner','int4','!>person','Ansprechpartner für diesen Wartungsvertrag','2009-10-06 13:49:47'),(911,116,'beschreibung','text2','!%ctrl','weitere Details','2009-10-06 13:49:47'),(912,117,'id','int4','!^auth_user!?+','eindeutige Nummer','2009-10-06 13:49:47'),(913,117,'name','char80','','- Gruppenname','2009-10-06 13:49:47'),(914,117,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(915,118,'person','int4','!^!>person','ID der Person, für die die Einstellungen gelten','2009-10-06 13:49:47'),(916,118,'query','text2','','- Query-String fürs RT','2009-10-06 13:49:47'),(917,118,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(918,119,'kunde','int4','!^!>kunde','','2009-10-06 13:49:47'),(919,119,'seq','int3','','- Zähler','2009-10-06 13:49:47'),(920,119,'pass','bin3','!%ctrl','verschlüsselter Inhalt, ohne Transfer-Encoding','2009-10-06 13:49:47'),(921,119,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(922,120,'id','uint2','!?+','ID','2009-10-06 13:49:47'),(923,120,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(924,120,'name','char32','','- Namensraum, z. B. \"\", \"kundebunt\", \"kunde\"','2009-10-06 13:49:47'),(925,121,'id','int4','!^Muster!?+','ID','2009-10-06 13:49:47'),(926,121,'name','char30','','- Kurzname','2009-10-06 13:49:47'),(927,121,'inhalt','text2','!%ctrl','Mustertext','2009-10-06 13:49:47'),(928,121,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(929,122,'id','int4','!?+','ID','2009-10-06 13:49:47'),(930,122,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(931,122,'ticket','int4','!^!>ticket','Um welches Ticket geht es?','2009-10-06 13:49:47'),(932,122,'person','int4','!^!>person','Wer hat das abonniert?','2009-10-06 13:49:47'),(933,123,'id','int4','!?+','ID','2009-10-06 13:49:47'),(934,123,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(935,123,'wartungsvertrag','int4','!>wartungsvertrag','zugeordneter Wartungsvertrag','2009-10-06 13:49:47'),(936,123,'leitung','int4','!^!>leitung','zugeordnete Leitung','2009-10-06 13:49:47'),(937,123,'beginn','uint4','!/','Beginn der Laufzeit des Wartungsvertrags','2009-10-06 13:49:47'),(938,123,'ende','uint4','!/!-','Ende der Laufzeit des Wartungsvertrags','2009-10-06 13:49:47'),(939,124,'id','int4','!?+','ID','2009-10-06 13:49:47'),(940,124,'timestamp','datetime','!/+','Zeitstempel','2009-10-06 13:49:47'),(941,124,'kurz','char40','!-','Kurzname für diese Adresse (z.B. \"RZ2\")','2009-10-06 13:49:47'),(942,124,'land','int2','!^^!>land','','2009-10-06 13:49:47'),(943,124,'plz','char10','','- Postleitzahl','2009-10-06 13:49:47'),(944,124,'ort','char100','','- Ort','2009-10-06 13:49:47'),(945,124,'strasse','char250','','- der ganze Rest; potenziell mehrzeilig','2009-10-06 13:49:47');
/*!40000 ALTER TABLE `db_feld` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db_tabelle`
--

DROP TABLE IF EXISTS `db_tabelle`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `db_tabelle` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `text` varchar(100) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `db_tabelle`
--

LOCK TABLES `db_tabelle` WRITE;
/*!40000 ALTER TABLE `db_tabelle` DISABLE KEYS */;
INSERT INTO `db_tabelle` (`id`, `name`, `text`, `timestamp`) VALUES (1,'konfig_variable','Konfigurationsvariablen','2009-10-06 13:49:45'),(2,'backup_report_ticket','Welches RT-Ticket ist gerade für welchen fehlgeschlagenen Backup-Job offen?','2009-10-06 13:49:45'),(3,'rt_antwort','n:m-Zuordnung von Antworten auf Fragen zu RT-Tickets, vgl. RT#288117','2009-10-06 13:49:45'),(4,'stundenliste','Wann sollen wem Stundenlisten gemailt werden?','2009-10-06 13:49:45'),(5,'ticketlast','Mappt, wer welches Ticket schon gesehen hat','2009-10-06 13:49:45'),(6,'django_content_type','Von Django benutzte Liste der Tabellen für Logging','2009-10-06 13:49:45'),(7,'rt_billing','Verlinkung von RT-Tickets mit zugehörigen Accounting-Datensätzen, vgl. RT::AddOn::Billing','2009-10-06 13:49:45'),(8,'handlezustand','Zustandsübergangstabelle Handles','2009-10-06 13:49:45'),(9,'rt_incidents_confitem','n:m-Zuordnung von Conf. Items zu Störungs-RT-Tickets, vgl. RT::AddOn::Confitems','2009-10-06 13:49:45'),(10,'auth_user_user_permissions','Assoziation auth_user <-> auth_permission','2009-10-06 13:49:45'),(11,'acct','Speicherung von detaillierten Accountingrecords','2009-10-06 13:49:45'),(12,'open_xchange_log','Speichern der GET-Aufrufe der Open-XChange-Einstellseite zum Nachweis','2009-10-06 13:49:45'),(13,'fnbatch','Batch-Server für fibunet','2009-10-06 13:49:45'),(14,'db_feld','speichern der Felddefs','2009-10-06 13:49:45'),(15,'rech_fuss','Mustertexte (neu)','2009-10-06 13:49:45'),(16,'ipregion','Speichert Namen für IP-Autoallokation und','2009-10-06 13:49:45'),(17,'konfig_wert','Konfigurationswerte (Ersatz für /etc/pop.conf)','2009-10-06 13:49:45'),(18,'updatelog_spalten','Spaltenreferenz für Änderungslog','2009-10-06 13:49:45'),(19,'django_session','Sessionverwaltung','2009-10-06 13:49:45'),(20,'domainzustand','Zustandsübergangstabelle Domains','2009-10-06 13:49:45'),(21,'applikation','Speicherung von Applikationsnamen (für statistische Zwecke, vgl. Tabelle funktionsaufrufe)','2009-10-06 13:49:45'),(22,'mess_geraet','Stellt ein einzelnes manuell ablesbares Mess-Gerät dar','2009-10-06 13:49:45'),(23,'rt_eskalation','merke, für welches Ticket es welche Eskalation schon gab (vgl. RT#294123)','2009-10-06 13:49:45'),(24,'tarifacct','Welche Daten welcher Kunde wie accountet bekommt.','2009-10-06 13:49:45'),(25,'trouble_ticket','','2009-10-06 13:49:45'),(26,'auth_user','Django benutzt dies während der Authentifikation;','2009-10-06 13:49:45'),(27,'queue','Liste der RT-Queues globale Einstellungen pro Queue','2009-10-06 13:49:45'),(28,'nextrech','Speichere \"historische\" Werte für Tarif-Berechnung','2009-10-06 13:49:45'),(29,'trouble_ticket_kunde_assoc','Welcher Kunde hat welches Trouble Ticket bekommen?','2009-10-06 13:49:45'),(30,'buchung','Speichert die zu einer Rechnung gehörenden Buchungsdatensätze','2009-10-06 13:49:45'),(31,'rechlauf','Speichern von Kenndaten eines Rechnungslaufs','2009-10-06 13:49:45'),(32,'stunden_art','Mappt Arten von Stundeneinträgen auf lesbare Beschreibungen etc.','2009-10-06 13:49:45'),(33,'nic','Mapping Personen zu NIC-Handles','2009-10-06 13:49:45'),(34,'confitem','Liste von Setups pro Kunde zur Kategorisierung von incident-Tickets, vgl. RT#199848','2009-10-06 13:49:45'),(35,'leitung','(Stand-)Leitungen verwalten und zu Kunden assoziieren','2009-10-06 13:49:45'),(36,'auth_permission','Eigentlich keine, aber Django\'s Authentifizierungs-','2009-10-06 13:49:45'),(37,'startlog','Mitschreiben, wer wann welches Programm gestartet hat','2009-10-06 13:49:45'),(38,'django_site','Django baut hier eine Liste der \'Sites\' auf, für den','2009-10-06 13:49:45'),(39,'updatelog','Speichert Änderungen','2009-10-06 13:49:45'),(40,'stunden','Arbeitszeiten für Mitarbeiter speichern','2009-10-06 13:49:45'),(41,'auth_group_permissions','Assoziation auth_permission <-> auth_group','2009-10-06 13:49:45'),(42,'releasenotes_release','Eine Release, zur Anzeige der Versionshinweise in kundebunt.','2009-10-06 13:49:45'),(43,'rt_template','Mustertexte (neu)','2009-10-06 13:49:46'),(44,'django_admin_log','Django loggt hier Veränderungen über das','2009-10-06 13:49:46'),(45,'funktion','Speicherung von Funktionsnamen (für statistische Zwecke, vgl. Tabelle funktionsaufrufe)','2009-10-06 13:49:46'),(46,'startlog_kram','strings-Tabellen-Ersatz für startlog','2009-10-06 13:49:46'),(47,'acctassoc','Assoziation eines Accountingeintrags mit Infotext und/oder genau einem Tarif','2009-10-06 13:49:46'),(48,'mailassoc','Assoziation zusätzlicher Mailadressen zu einem Personen- oder Kundenrecord','2009-10-06 13:49:46'),(49,'ipkunde','Map IP-Adresse zu Kunde','2009-10-06 13:49:46'),(50,'mess_stelle','Eine Stelle z. B. in der RZ-Stromnetzverkabelung, an der gemessen werden kann','2009-10-06 13:49:46'),(51,'ipmap','Zuordnung mehrerer IP-Adressen zu einem Zugang','2009-10-06 13:49:46'),(52,'rt_formular','Mustertexte (neu)','2009-10-06 13:49:46'),(53,'land','Speichert Daten über ein Land','2009-10-06 13:49:46'),(54,'otrs_import','Zeitpunkt und letzter Artikel beim otrs-import','2009-10-06 13:49:46'),(55,'rt_incidents','zusätzliche Felder zu RT-Tickets, bei denen es um Störungen geht, vgl. RT::AddOn::Incidents','2009-10-06 13:49:46'),(56,'iptree','Parent<->Child-Beziehungen von IP-Adress-Host-Objekten für Monitoring-Konfiguration, vgl. RT#221142','2009-10-06 13:49:46'),(57,'persomonat','Speichern der Sollzeit pro Monat (und evtl. Person)','2009-10-06 13:49:46'),(58,'tarifkunde','Zuordnung eines / mehrerer Tarife zu einem Kunden','2009-10-06 13:49:46'),(59,'mess_typ','Beschreibung einer Datenart für Messungen','2009-10-06 13:49:46'),(60,'ticketadr','Speichern von Mailadressen für Tickets.','2009-10-06 13:49:46'),(61,'recheinheit','abhängige Einheiten','2009-10-06 13:49:46'),(62,'radacct','Einzel-Radius-Accounting für EVNe etc., vgl. RT#206334','2009-10-06 13:49:46'),(63,'descr_typ','Deskriptoren-Name','2009-10-06 13:49:46'),(64,'exim_cache_1','Zwischenspeichern von Accounting-Zuständen beim Mailaccounting','2009-10-06 13:49:46'),(65,'mailrules','Mail-Zustellungsregeln (vgl. RT#124007)','2009-10-06 13:49:46'),(66,'domreg','Index der Registrare','2009-10-06 13:49:46'),(67,'nicdata','Basisdaten eines Registrars','2009-10-06 13:49:46'),(68,'db_tabelle','speicher für Tabellendefs','2009-10-06 13:49:46'),(69,'mess_ablesung','Ein einzelner manueller Ablesewert','2009-10-06 13:49:46'),(70,'ip_hostgroup','Zuordnung von IP-Adressobjekten zu Hostgroups','2009-10-06 13:49:46'),(71,'dienst','Speichert die Daten zu einem Dienst (war: tarifeq-Tabelle)','2009-10-06 13:49:46'),(72,'auth_user_groups','Assoziation auth_user <-> auth_group','2009-10-06 13:49:46'),(73,'perso','Personaldatenbank','2009-10-06 13:49:46'),(74,'releasenotes_note','Versionshinweis zur Anzeige in kundebunt vor dem Einloggen.','2009-10-06 13:49:46'),(75,'hardware','Hardware (Server, Router etc.)','2009-10-06 13:49:46'),(76,'open_xchange','Einstellungen der Kunden bezüglich Open XChange','2009-10-06 13:49:46'),(77,'reseller','Reseller-Status eines Kunden','2009-10-06 13:49:46'),(78,'queue_acl','Berechtigungen für RT-Queues speichern','2009-10-06 13:49:46'),(79,'knextrech','Speichere \"historische\" Werte für Rechnungszeiträume','2009-10-06 13:49:46'),(80,'ipassacct','Einzel-iPass-Accounting für EVNe etc, vgl. RT#219895','2009-10-06 13:49:46'),(81,'mess_geraet_typ','Parameter fuer einen Typ von Mess-Geräten','2009-10-06 13:49:46'),(82,'exim_cache_2','Zwischenspeichern von Accounting-Zuständen beim Mailaccounting','2009-10-06 13:49:46'),(83,'domainkunde','Map Domainadresse zu Kunde','2009-10-06 13:49:46'),(84,'kundemail','Welche Person gehört bei welchem Kunden zu was?','2009-10-06 13:49:46'),(85,'descr','Mappt numerische Werte auf lesbare Beschreibungen.','2009-10-06 13:49:46'),(86,'registrar','Speicherung von Fakten über einen Registrar (z. B. DE-NIC)','2009-10-06 13:49:46'),(87,'tarif','Speichert die für einen Tarif relevanten Kosten','2009-10-06 13:49:46'),(88,'rechstep','Verarbeitungsschritt innerhalb der Rechnung festlegen','2009-10-06 13:49:47'),(89,'rz','RZs und andere für die Housing-Datenbank relevante Standorte','2009-10-06 13:49:47'),(90,'hardware_ip','Zuordnung zusätzlicher IP-Adressen zu einem Hardware-Objekt','2009-10-06 13:49:47'),(91,'rack','Racks für Housing-Datenbank','2009-10-06 13:49:47'),(92,'mess_verbraucher','Gibt an, welches Gerät die gemessene Größe verbraucht, und welchem Kunde das angerechnet wird','2009-10-06 13:49:47'),(93,'hostgroup','Hostgruppen, z. B. für eine Gruppierung in Nagios oder collectd, vgl. RT#437749','2009-10-06 13:49:47'),(94,'in_arbeit','Aufzeichnung, wer gerade welchen Datensatz offen hat','2009-10-06 13:49:47'),(95,'kunde','Kundendatenbank','2009-10-06 13:49:47'),(96,'resellernic','Mapping Personen zu NIC-Handles eines Resellers','2009-10-06 13:49:47'),(97,'releasenotes_notetext','Text zu einem Versionshinweis in einer bestimmten Sprache.','2009-10-06 13:49:47'),(98,'ausgabe','Befehlszeilen','2009-10-06 13:49:47'),(99,'auth_message','Nachrichten für den Benutzer','2009-10-06 13:49:47'),(100,'queue_areas','Mapping Area=>Queue','2009-10-06 13:49:47'),(101,'konten','Abbuchungsaufträge etc.','2009-10-06 13:49:47'),(102,'nextid','Speicherung des nächsten ID-Werts','2009-10-06 13:49:47'),(103,'rechnungen','speichert ab, welche Kunden welche Rechnungen bekommen haben','2009-10-06 13:49:47'),(104,'aufrufe','Logging von Funktionsaufrufen (für statistische Zwecke)','2009-10-06 13:49:47'),(105,'pwhist','speichert Änderungen im pwuse-Feld','2009-10-06 13:49:47'),(106,'tarifklasse','augmentierte Assoziation eines Tarifnames mit Kunden','2009-10-06 13:49:47'),(107,'tarifeq','Speichert eine Korrespondenz zwischen zwei Diensten','2009-10-06 13:49:47'),(108,'wartungsvertrag_hardware','Zuordnung von Wartungsverträgen zu Hardware','2009-10-06 13:49:47'),(109,'person','Speichert die für einen Mitarbeiter einer Firma','2009-10-06 13:49:47'),(110,'ticketid','Message-IDs zum Wiederfinden von Tickets, Tickettexte','2009-10-06 13:49:47'),(111,'tarifname','Namen von Tarifen','2009-10-06 13:49:47'),(112,'rt_incidents_leitung','n:m-Zuordnung von Leitungen zu Störungs-RT-Tickets, vgl. RT::AddOn::Confitems','2009-10-06 13:49:47'),(113,'ticket','RT-Tickets','2009-10-06 13:49:47'),(114,'rt_eskalation_muster','Mustertexte (neu)','2009-10-06 13:49:47'),(115,'uucpkunde','Aliasnamen für Kunden','2009-10-06 13:49:47'),(116,'wartungsvertrag','Wartungsvertragstypen, die wir mit Zulieferern haben (ITIL-Jargon: \"UPC\")','2009-10-06 13:49:47'),(117,'auth_group','Eigentlich keine, aber Django\'s Authentifizierungs-','2009-10-06 13:49:47'),(118,'rt_defaults','individuelle Default-Einstellungen fürs RT, vgl. RT#283876','2009-10-06 13:49:47'),(119,'passwort','Paßworttabelle für Kunden','2009-10-06 13:49:47'),(120,'konfig_namensraum','Namensräume für Konfigurationsvariablen','2009-10-06 13:49:47'),(121,'adress_vorlage','Mustertexte (neu)','2009-10-06 13:49:47'),(122,'ticketabo','Wer hat welches RT-Ticket abonniert, vgl. RT#120901?','2009-10-06 13:49:47'),(123,'wartungsvertrag_leitung','Zuordnung von Wartungsverträgen zu Leitungen','2009-10-06 13:49:47'),(124,'adresse','Speichert Adressdaten.','2009-10-06 13:49:47');
/*!40000 ALTER TABLE `db_tabelle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `descr`
--

DROP TABLE IF EXISTS `descr`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `descr` (
  `id` int(11) NOT NULL auto_increment,
  `typ` int(11) NOT NULL,
  `descr` int(11) NOT NULL,
  `bla` varchar(30) character set utf8 NOT NULL,
  `idchar` char(1) character set utf8 collate utf8_bin default NULL,
  `gruppe` int(11) NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `typ` (`typ`,`descr`),
  UNIQUE KEY `typ_2` (`typ`,`bla`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_descr__typ` FOREIGN KEY (`typ`) REFERENCES `descr_typ` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `descr`
--

LOCK TABLES `descr` WRITE;
/*!40000 ALTER TABLE `descr` DISABLE KEYS */;
INSERT INTO `descr` (`id`, `typ`, `descr`, `bla`, `idchar`, `gruppe`, `infotext`, `timestamp`) VALUES (1,1,1,'readonly',NULL,2,NULL,'2009-10-06 13:49:57'),(2,2,1,'passwd',NULL,0,NULL,'2009-10-06 13:49:57'),(3,1,2,'rechnung',NULL,2,NULL,'2009-10-06 13:49:57'),(4,1,3,'dialin',NULL,2,NULL,'2009-10-06 13:49:57'),(5,1,4,'ppp',NULL,2,NULL,'2009-10-06 13:49:57'),(6,1,5,'verwaltung',NULL,2,NULL,'2009-10-06 13:49:57'),(7,1,6,'perso',NULL,2,NULL,'2009-10-06 13:49:57'),(8,1,7,'service',NULL,2,NULL,'2009-10-06 13:49:57'),(9,1,8,'pop',NULL,2,NULL,'2009-10-06 13:49:57'),(10,1,200,'ipass',NULL,2,NULL,'2009-10-06 13:49:57'),(11,3,1,'dnszone',NULL,0,NULL,'2009-10-06 13:49:57'),(12,1,201,'mail',NULL,6,NULL,'2009-10-06 13:49:57'),(13,2,2,'mail',NULL,0,NULL,'2009-10-06 13:49:57'),(14,4,9,'registriert',NULL,0,NULL,'2009-10-06 13:49:57'),(15,5,1,'steuernr',NULL,0,NULL,'2009-10-06 13:49:57'),(16,5,2,'keine_ust',NULL,0,NULL,'2009-10-06 13:49:57'),(17,5,3,'vorausberechnen',NULL,0,NULL,'2009-10-06 13:49:57'),(18,5,4,'nicht_eu',NULL,0,NULL,'2009-10-06 13:49:57'),(19,6,119,'std',NULL,0,'Standard-Ziel','2009-10-06 13:49:57'),(20,7,1,'manuell',NULL,0,NULL,'2009-10-06 13:49:57'),(21,8,1,'fasel',NULL,0,'123 ein Konto-Einerlei','2009-10-06 13:49:57'),(22,9,1,'admin-c',NULL,0,NULL,'2009-10-06 13:49:57'),(23,9,2,'tech-c',NULL,0,NULL,'2009-10-06 13:49:57'),(24,9,3,'zone-c',NULL,0,NULL,'2009-10-06 13:49:57'),(25,9,4,':',NULL,2,NULL,'2009-10-06 13:49:57'),(26,10,1,'person',NULL,0,NULL,'2009-10-06 13:49:57'),(27,9,5,'contact',NULL,2,NULL,'2009-10-06 13:49:57'),(28,9,6,'standort',NULL,2,NULL,'2009-10-06 13:49:57'),(29,9,7,'nic',NULL,4,NULL,'2009-10-06 13:49:57'),(30,10,2,'domain',NULL,0,NULL,'2009-10-06 13:49:57'),(31,6,63,'unbekannt',NULL,0,NULL,'2009-10-06 13:49:57'),(32,6,116,'telekom',NULL,0,NULL,'2009-10-06 13:49:57'),(33,6,100,'deutsch',NULL,0,NULL,'2009-10-06 13:49:57'),(34,6,108,'lokal',NULL,0,NULL,'2009-10-06 13:49:57'),(35,11,1,'dead',NULL,0,NULL,'2009-10-06 13:50:03'),(36,11,2,'resolved',NULL,0,NULL,'2009-10-06 13:50:03'),(37,11,3,'stalled',NULL,0,NULL,'2009-10-06 13:50:03'),(38,11,4,'open',NULL,0,NULL,'2009-10-06 13:50:03'),(39,12,2,'create',NULL,2,NULL,'2009-10-06 13:50:03'),(40,13,1,'content',NULL,0,NULL,'2009-10-06 13:50:03'),(41,5,5,'rt_incidents',NULL,0,NULL,'2009-10-06 13:50:03'),(42,12,3,'correspond',NULL,2,NULL,'2009-10-06 13:50:03'),(43,12,4,'comments',NULL,2,NULL,'2009-10-06 13:50:03'),(44,12,5,'area',NULL,0,NULL,'2009-10-06 13:50:03'),(45,12,6,'status',NULL,0,NULL,'2009-10-06 13:50:03'),(46,12,7,'queue_id',NULL,0,NULL,'2009-10-06 13:50:03'),(47,12,8,'owner',NULL,0,NULL,'2009-10-06 13:50:03'),(48,12,9,'requestors',NULL,0,NULL,'2009-10-06 13:50:03'),(49,12,10,'priority',NULL,0,NULL,'2009-10-06 13:50:03'),(50,12,11,'final_priority',NULL,0,NULL,'2009-10-06 13:50:03'),(51,12,12,'date_due',NULL,0,NULL,'2009-10-06 13:50:03'),(52,12,13,'subject',NULL,0,NULL,'2009-10-06 13:50:03'),(53,12,14,'date_told',NULL,0,NULL,'2009-10-06 13:50:03'),(54,12,15,'effective_sn',NULL,0,NULL,'2009-10-06 13:50:03'),(55,12,16,'kunde',NULL,0,NULL,'2009-10-06 13:50:03'),(56,12,17,'queue_ptr',NULL,0,NULL,'2009-10-06 13:50:03'),(57,12,18,'remail',NULL,0,NULL,'2009-10-06 13:50:03'),(58,12,19,'work',NULL,0,NULL,'2009-10-06 13:50:03'),(59,12,20,'docushare',NULL,0,NULL,'2009-10-06 13:50:03'),(60,12,21,'info',NULL,0,NULL,'2009-10-06 13:50:03'),(61,12,22,'date_fdue',NULL,0,NULL,'2009-10-06 13:50:03'),(62,12,23,'incidents',NULL,4,NULL,'2009-10-06 13:50:03'),(63,13,2,'addon',NULL,0,NULL,'2009-10-06 13:50:03'),(64,14,1,'display',NULL,0,NULL,'2009-10-06 13:50:03'),(65,14,2,'manipulate',NULL,0,NULL,'2009-10-06 13:50:03'),(66,14,3,'admin',NULL,0,NULL,'2009-10-06 13:50:03'),(67,15,1,'m_owner_trans',NULL,0,NULL,'2009-10-06 13:50:03'),(68,15,2,'m_members_trans',NULL,0,NULL,'2009-10-06 13:50:03'),(69,15,3,'m_user_trans',NULL,0,NULL,'2009-10-06 13:50:03'),(70,15,4,'m_user_create',NULL,0,NULL,'2009-10-06 13:50:03'),(71,15,5,'m_members_correspond',NULL,0,NULL,'2009-10-06 13:50:03'),(72,15,6,'m_members_comment',NULL,0,NULL,'2009-10-06 13:50:03'),(73,15,7,'m_user_resolve',NULL,0,NULL,'2009-10-06 13:50:03'),(74,15,8,'allow_user_create',NULL,0,NULL,'2009-10-06 13:50:03'),(75,15,9,'m_mail',NULL,0,NULL,'2009-10-06 13:50:03'),(76,15,10,'m_admin_trans',NULL,0,NULL,'2009-10-06 13:50:03'),(77,15,11,'otrs',NULL,0,NULL,'2009-10-06 13:50:03'),(78,15,12,'incidents',NULL,2,NULL,'2009-10-06 13:50:03'),(79,16,1,'addon',NULL,0,NULL,'2009-10-06 13:50:03'),(80,1,202,'rt_admin',NULL,2,NULL,'2009-10-06 13:50:03'),(81,17,0,'unbekannt',NULL,2,'sollte nicht vorkommen','2009-10-06 13:50:04'),(82,18,1,'hide',NULL,0,NULL,'2009-10-06 13:50:04'),(83,17,1,'email',NULL,0,NULL,'2009-10-06 13:50:04'),(84,17,2,'fax',NULL,0,NULL,'2009-10-06 13:50:04'),(85,17,3,'sms',NULL,0,NULL,'2009-10-06 13:50:04'),(86,17,4,'telefon',NULL,0,NULL,'2009-10-06 13:50:04'),(87,11,5,'im_otrs',NULL,0,NULL,'2009-10-06 13:50:04'),(88,19,1,'autoreply',NULL,0,NULL,'2009-10-06 13:50:04'),(89,19,2,'comment',NULL,0,NULL,'2009-10-06 13:50:04'),(90,19,3,'correspondence',NULL,0,NULL,'2009-10-06 13:50:04'),(91,19,4,'error',NULL,0,NULL,'2009-10-06 13:50:04'),(92,19,5,'give',NULL,0,NULL,'2009-10-06 13:50:04'),(93,19,6,'respond',NULL,0,NULL,'2009-10-06 13:50:04'),(94,19,7,'steal',NULL,0,NULL,'2009-10-06 13:50:04'),(95,19,8,'transaction',NULL,0,NULL,'2009-10-06 13:50:04'),(96,19,9,'web_create',NULL,0,NULL,'2009-10-06 13:50:04'),(97,19,10,'form_comment',NULL,0,NULL,'2009-10-06 13:50:04'),(98,19,11,'form_reply',NULL,0,NULL,'2009-10-06 13:50:04'),(99,19,12,'remail',NULL,0,NULL,'2009-10-06 13:50:04'),(100,19,13,'docushare',NULL,0,NULL,'2009-10-06 13:50:04');
/*!40000 ALTER TABLE `descr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `descr_typ`
--

DROP TABLE IF EXISTS `descr_typ`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `descr_typ` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `info` varchar(255) character set utf8 default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `descr_typ`
--

LOCK TABLES `descr_typ` WRITE;
/*!40000 ALTER TABLE `descr_typ` DISABLE KEYS */;
INSERT INTO `descr_typ` (`id`, `name`, `info`, `timestamp`) VALUES (1,'pwdomain',NULL,'2009-10-06 13:49:57'),(2,'pwdomain_ident',NULL,'2009-10-06 13:49:57'),(3,'domainflags',NULL,'2009-10-06 13:49:57'),(4,'domainstatus_ident',NULL,'2009-10-06 13:49:57'),(5,'kunde',NULL,'2009-10-06 13:49:57'),(6,'ziel',NULL,'2009-10-06 13:49:57'),(7,'rstatus',NULL,'2009-10-06 13:49:57'),(8,'rkonto',NULL,'2009-10-06 13:49:57'),(9,'dienst',NULL,'2009-10-06 13:49:57'),(10,'dienst_ident',NULL,'2009-10-06 13:49:57'),(11,'tickets',NULL,'2009-10-06 13:50:03'),(12,'tickett',NULL,'2009-10-06 13:50:03'),(13,'tickett_ident',NULL,'2009-10-06 13:50:03'),(14,'rt_acl',NULL,'2009-10-06 13:50:03'),(15,'rt_queue',NULL,'2009-10-06 13:50:03'),(16,'rt_queue_ident',NULL,'2009-10-06 13:50:03'),(17,'mailart',NULL,'2009-10-06 13:50:04'),(18,'mailart_ident',NULL,'2009-10-06 13:50:04'),(19,'rt_template',NULL,'2009-10-06 13:50:04');
/*!40000 ALTER TABLE `descr_typ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dienst`
--

DROP TABLE IF EXISTS `dienst`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `dienst` (
  `id` smallint(6) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(15) character set utf8 NOT NULL,
  `info` varchar(100) character set utf8 default NULL,
  `rechnungstext` varchar(100) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `dienst`
--

LOCK TABLES `dienst` WRITE;
/*!40000 ALTER TABLE `dienst` DISABLE KEYS */;
INSERT INTO `dienst` (`id`, `timestamp`, `name`, `info`, `rechnungstext`) VALUES (1,'2009-10-06 13:49:57','ip','Daten! Daten! Daten!',NULL),(2,'2009-10-06 13:50:04','general','der ganze Rest',NULL);
/*!40000 ALTER TABLE `dienst` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `django_admin_log`
--

DROP TABLE IF EXISTS `django_admin_log`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `django_admin_log` (
  `id` int(11) NOT NULL auto_increment,
  `action_time` datetime NOT NULL,
  `user` int(11) NOT NULL,
  `content_type_id` int(11) default NULL,
  `object_id` text character set utf8,
  `object_repr` varchar(200) character set utf8 NOT NULL,
  `action_flag` smallint(6) NOT NULL,
  `change_message` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `r_django_admin_log__user` (`user`),
  KEY `r_django_admin_log__content_type_id` (`content_type_id`),
  CONSTRAINT `r_django_admin_log__content_type_id` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_django_admin_log__user` FOREIGN KEY (`user`) REFERENCES `auth_user` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `django_admin_log`
--

LOCK TABLES `django_admin_log` WRITE;
/*!40000 ALTER TABLE `django_admin_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_admin_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `django_content_type`
--

DROP TABLE IF EXISTS `django_content_type`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `django_content_type` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) character set utf8 NOT NULL,
  `app_label` varchar(100) character set utf8 NOT NULL,
  `model` varchar(100) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `app_label` (`app_label`,`model`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `django_content_type`
--

LOCK TABLES `django_content_type` WRITE;
/*!40000 ALTER TABLE `django_content_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_content_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `django_session`
--

DROP TABLE IF EXISTS `django_session`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `django_session` (
  `session_key` varchar(40) character set utf8 NOT NULL,
  `session_data` mediumtext character set utf8 NOT NULL,
  `expire_date` datetime NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`session_key`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `django_session`
--

LOCK TABLES `django_session` WRITE;
/*!40000 ALTER TABLE `django_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `django_site`
--

DROP TABLE IF EXISTS `django_site`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `django_site` (
  `id` int(11) NOT NULL auto_increment,
  `domain` varchar(100) character set utf8 NOT NULL,
  `name` varchar(50) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `django_site`
--

LOCK TABLES `django_site` WRITE;
/*!40000 ALTER TABLE `django_site` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_site` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domainkunde`
--

DROP TABLE IF EXISTS `domainkunde`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `domainkunde` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  `domain` varchar(100) character set ascii NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `expires` int(10) unsigned default NULL,
  `status` smallint(6) NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `tarifname` int(11) default NULL,
  `rechinfo` int(11) default NULL,
  `ktarif` int(11) default NULL,
  `person` int(11) default NULL,
  `owner` int(11) default NULL,
  `adminc` int(11) default NULL,
  `techc` int(11) default NULL,
  `zonec` int(11) default NULL,
  `billc` int(11) default NULL,
  `nic` smallint(6) default NULL,
  `nserver` int(11) default NULL,
  `tsig` smallint(6) default NULL,
  `ticket` int(11) default NULL,
  `nachricht` int(11) default NULL,
  `flags` int(11) NOT NULL,
  `mail_ip` tinyint(3) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `domain` (`domain`,`ende`),
  KEY `kunde` (`kunde`),
  KEY `ktarif` (`ktarif`),
  KEY `nserver` (`nserver`),
  KEY `ticket` (`ticket`),
  KEY `timestamp` (`timestamp`),
  KEY `person` (`person`),
  KEY `status` (`status`,`beginn`),
  KEY `r_domainkunde__tarifname` (`tarifname`),
  KEY `r_domainkunde__owner` (`owner`),
  KEY `r_domainkunde__adminc` (`adminc`),
  KEY `r_domainkunde__techc` (`techc`),
  KEY `r_domainkunde__zonec` (`zonec`),
  KEY `r_domainkunde__billc` (`billc`),
  KEY `r_domainkunde__nachricht` (`nachricht`),
  CONSTRAINT `r_domainkunde__nachricht` FOREIGN KEY (`nachricht`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__adminc` FOREIGN KEY (`adminc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__billc` FOREIGN KEY (`billc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__ktarif` FOREIGN KEY (`ktarif`) REFERENCES `tarifkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__nserver` FOREIGN KEY (`nserver`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__owner` FOREIGN KEY (`owner`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__tarifname` FOREIGN KEY (`tarifname`) REFERENCES `tarifname` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__techc` FOREIGN KEY (`techc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domainkunde__zonec` FOREIGN KEY (`zonec`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `domainkunde`
--

LOCK TABLES `domainkunde` WRITE;
/*!40000 ALTER TABLE `domainkunde` DISABLE KEYS */;
/*!40000 ALTER TABLE `domainkunde` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domainzustand`
--

DROP TABLE IF EXISTS `domainzustand`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `domainzustand` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `von` smallint(6) NOT NULL,
  `erkannt` smallint(6) NOT NULL,
  `nach` smallint(6) default NULL,
  `aktionen` int(11) NOT NULL,
  `ticketstatus` smallint(6) default NULL,
  `statusinfo` varchar(255) character set utf8 default NULL,
  `acctinfo` smallint(6) default NULL,
  `reseller` char(1) character set ascii NOT NULL default 'b',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `von` (`von`,`erkannt`,`reseller`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `domainzustand`
--

LOCK TABLES `domainzustand` WRITE;
/*!40000 ALTER TABLE `domainzustand` DISABLE KEYS */;
/*!40000 ALTER TABLE `domainzustand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domreg`
--

DROP TABLE IF EXISTS `domreg`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `domreg` (
  `id` int(11) NOT NULL auto_increment,
  `domain` varchar(255) character set utf8 NOT NULL,
  `dienst` smallint(6) NOT NULL,
  `nic` smallint(6) default NULL,
  `techc` int(11) default NULL,
  `zonec` int(11) default NULL,
  `billc` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `whoisserver` varchar(255) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `domain` (`domain`),
  KEY `timestamp` (`timestamp`),
  KEY `r_domreg__dienst` (`dienst`),
  KEY `r_domreg__nic` (`nic`),
  KEY `r_domreg__techc` (`techc`),
  KEY `r_domreg__zonec` (`zonec`),
  KEY `r_domreg__billc` (`billc`),
  CONSTRAINT `r_domreg__billc` FOREIGN KEY (`billc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domreg__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domreg__nic` FOREIGN KEY (`nic`) REFERENCES `nicdata` (`nic`) ON UPDATE CASCADE,
  CONSTRAINT `r_domreg__techc` FOREIGN KEY (`techc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_domreg__zonec` FOREIGN KEY (`zonec`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `domreg`
--

LOCK TABLES `domreg` WRITE;
/*!40000 ALTER TABLE `domreg` DISABLE KEYS */;
/*!40000 ALTER TABLE `domreg` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exim_cache_1`
--

DROP TABLE IF EXISTS `exim_cache_1`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `exim_cache_1` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `exim_id` varchar(40) character set ascii NOT NULL,
  `data` blob NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `exim_id` (`exim_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `exim_cache_1`
--

LOCK TABLES `exim_cache_1` WRITE;
/*!40000 ALTER TABLE `exim_cache_1` DISABLE KEYS */;
/*!40000 ALTER TABLE `exim_cache_1` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `exim_cache_2`
--

DROP TABLE IF EXISTS `exim_cache_2`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `exim_cache_2` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `exim_id` varchar(40) character set ascii NOT NULL,
  `data` blob NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `exim_id` (`exim_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `exim_cache_2`
--

LOCK TABLES `exim_cache_2` WRITE;
/*!40000 ALTER TABLE `exim_cache_2` DISABLE KEYS */;
/*!40000 ALTER TABLE `exim_cache_2` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fnbatch`
--

DROP TABLE IF EXISTS `fnbatch`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `fnbatch` (
  `id` tinyint(4) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `buchen` int(10) unsigned default NULL,
  `mandant` tinyint(4) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `art` varchar(100) character set utf8 NOT NULL,
  `fehler` varchar(200) character set utf8 NOT NULL,
  `daten` mediumtext character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `fnbatch`
--

LOCK TABLES `fnbatch` WRITE;
/*!40000 ALTER TABLE `fnbatch` DISABLE KEYS */;
/*!40000 ALTER TABLE `fnbatch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `funktion`
--

DROP TABLE IF EXISTS `funktion`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `funktion` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(255) character set utf8 NOT NULL,
  `flags` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `funktion`
--

LOCK TABLES `funktion` WRITE;
/*!40000 ALTER TABLE `funktion` DISABLE KEYS */;
/*!40000 ALTER TABLE `funktion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `handlezustand`
--

DROP TABLE IF EXISTS `handlezustand`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `handlezustand` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `von` smallint(6) NOT NULL,
  `erkannt` smallint(6) NOT NULL,
  `nach` smallint(6) default NULL,
  `aktionen` int(11) NOT NULL,
  `ticketstatus` smallint(6) default NULL,
  `statusinfo` varchar(255) character set utf8 default NULL,
  `acctinfo` smallint(6) default NULL,
  `reseller` char(1) character set ascii NOT NULL default 'b',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `von` (`von`,`erkannt`,`reseller`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `handlezustand`
--

LOCK TABLES `handlezustand` WRITE;
/*!40000 ALTER TABLE `handlezustand` DISABLE KEYS */;
/*!40000 ALTER TABLE `handlezustand` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hardware`
--

DROP TABLE IF EXISTS `hardware`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `hardware` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(127) character set utf8 NOT NULL,
  `hardware_id` varchar(15) character set utf8 default NULL,
  `seriennr` varchar(127) character set utf8 default NULL,
  `ivnr` varchar(15) character set utf8 default NULL,
  `typ` smallint(6) default NULL,
  `klasse` smallint(6) default NULL,
  `ip` int(11) default NULL,
  `enthalten_in` int(11) default NULL,
  `standort` int(11) default NULL,
  `eigentuemer` int(11) default NULL,
  `verantwortlich` int(11) default NULL,
  `kunde` int(11) NOT NULL,
  `lieferant` smallint(6) default NULL,
  `status` smallint(6) default NULL,
  `info` varchar(255) character set utf8 default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `rack` smallint(6) default NULL,
  `unterste_he` tinyint(3) unsigned default NULL,
  `he` tinyint(3) unsigned default NULL,
  `console` varchar(255) character set utf8 default NULL,
  `gemailt` int(11) default NULL,
  `flags` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `hardware_id` (`hardware_id`,`ende`),
  UNIQUE KEY `name` (`name`,`seriennr`,`ende`),
  UNIQUE KEY `ip` (`ip`,`ende`),
  KEY `eigentuemer` (`eigentuemer`,`gemailt`),
  KEY `timestamp` (`timestamp`),
  KEY `r_hardware__enthalten_in` (`enthalten_in`),
  KEY `r_hardware__standort` (`standort`),
  KEY `r_hardware__verantwortlich` (`verantwortlich`),
  KEY `r_hardware__kunde` (`kunde`),
  KEY `r_hardware__rack` (`rack`),
  CONSTRAINT `r_hardware__rack` FOREIGN KEY (`rack`) REFERENCES `rack` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware__eigentuemer` FOREIGN KEY (`eigentuemer`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware__enthalten_in` FOREIGN KEY (`enthalten_in`) REFERENCES `hardware` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware__ip` FOREIGN KEY (`ip`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware__standort` FOREIGN KEY (`standort`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware__verantwortlich` FOREIGN KEY (`verantwortlich`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `hardware`
--

LOCK TABLES `hardware` WRITE;
/*!40000 ALTER TABLE `hardware` DISABLE KEYS */;
/*!40000 ALTER TABLE `hardware` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hardware_ip`
--

DROP TABLE IF EXISTS `hardware_ip`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `hardware_ip` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `hardware` int(11) NOT NULL,
  `ip` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `hardware` (`hardware`,`ip`),
  KEY `ip` (`ip`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_hardware_ip__ip` FOREIGN KEY (`ip`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_hardware_ip__hardware` FOREIGN KEY (`hardware`) REFERENCES `hardware` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `hardware_ip`
--

LOCK TABLES `hardware_ip` WRITE;
/*!40000 ALTER TABLE `hardware_ip` DISABLE KEYS */;
/*!40000 ALTER TABLE `hardware_ip` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hostgroup`
--

DROP TABLE IF EXISTS `hostgroup`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `hostgroup` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  `name` varchar(64) character set utf8 NOT NULL,
  `beschreibung` varchar(64) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`),
  KEY `kunde` (`kunde`),
  CONSTRAINT `r_hostgroup__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `hostgroup`
--

LOCK TABLES `hostgroup` WRITE;
/*!40000 ALTER TABLE `hostgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `hostgroup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `in_arbeit`
--

DROP TABLE IF EXISTS `in_arbeit`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `in_arbeit` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `person` int(11) NOT NULL,
  `tabelle` varchar(40) character set utf8 NOT NULL,
  `row` varchar(40) character set utf8 NOT NULL,
  `idx` varchar(40) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `tabelle` (`tabelle`,`idx`),
  KEY `r_in_arbeit__person` (`person`),
  CONSTRAINT `r_in_arbeit__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `in_arbeit`
--

LOCK TABLES `in_arbeit` WRITE;
/*!40000 ALTER TABLE `in_arbeit` DISABLE KEYS */;
/*!40000 ALTER TABLE `in_arbeit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ip_hostgroup`
--

DROP TABLE IF EXISTS `ip_hostgroup`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ip_hostgroup` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `host` int(11) NOT NULL,
  `gruppe` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `host` (`host`,`gruppe`),
  KEY `timestamp` (`timestamp`),
  KEY `gruppe` (`gruppe`),
  CONSTRAINT `r_ip_hostgroup__gruppe` FOREIGN KEY (`gruppe`) REFERENCES `hostgroup` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ip_hostgroup__host` FOREIGN KEY (`host`) REFERENCES `ipkunde` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ip_hostgroup`
--

LOCK TABLES `ip_hostgroup` WRITE;
/*!40000 ALTER TABLE `ip_hostgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `ip_hostgroup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipassacct`
--

DROP TABLE IF EXISTS `ipassacct`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ipassacct` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  `person` int(11) NOT NULL,
  `transaction_id` varchar(255) character set utf8 NOT NULL,
  `billing_code` int(10) unsigned NOT NULL,
  `authentication_domain` varchar(255) character set utf8 NOT NULL,
  `description` varchar(255) character set utf8 NOT NULL,
  `datum` int(11) NOT NULL,
  `session_length` int(10) unsigned NOT NULL,
  `billing_rate` smallint(5) unsigned NOT NULL,
  `net_billing_amount` int(10) unsigned NOT NULL,
  `access_type` smallint(6) NOT NULL,
  `service_type` smallint(6) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `kunde` (`kunde`,`datum`),
  KEY `timestamp` (`timestamp`),
  KEY `r_ipassacct__person` (`person`),
  CONSTRAINT `r_ipassacct__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipassacct__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ipassacct`
--

LOCK TABLES `ipassacct` WRITE;
/*!40000 ALTER TABLE `ipassacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipassacct` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipkunde`
--

DROP TABLE IF EXISTS `ipkunde`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ipkunde` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  `ip6` varchar(32) character set ascii NOT NULL,
  `bits` tinyint(4) NOT NULL,
  `tarif` smallint(6) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `kiste` varchar(16) character set utf8 default NULL,
  `mac` char(12) character set ascii default NULL,
  `name` varchar(255) character set utf8 default NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `alloc` char(1) character set ascii default 'n',
  `ipregion` int(11) default NULL,
  `ticket` int(11) default NULL,
  `owner` int(11) default NULL,
  `adminc` int(11) default NULL,
  `techc` int(11) default NULL,
  `nic` smallint(6) default NULL,
  `status` tinyint(4) default NULL,
  `dest` smallint(6) NOT NULL,
  `nagiosconf` varchar(255) character set utf8 default NULL,
  `flags` int(11) NOT NULL,
  `snmp_community` varchar(255) character set utf8 default NULL,
  `mail_ip` tinyint(3) unsigned default NULL,
  `vrf` varchar(255) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ip6` (`ip6`,`bits`,`ende`),
  UNIQUE KEY `vrf` (`vrf`),
  KEY `kunde` (`kunde`),
  KEY `name` (`name`),
  KEY `mac` (`mac`,`ende`),
  KEY `ticket` (`ticket`),
  KEY `timestamp` (`timestamp`),
  KEY `r_ipkunde__tarif` (`tarif`),
  KEY `r_ipkunde__ipregion` (`ipregion`),
  KEY `r_ipkunde__owner` (`owner`),
  KEY `r_ipkunde__adminc` (`adminc`),
  KEY `r_ipkunde__techc` (`techc`),
  CONSTRAINT `r_ipkunde__techc` FOREIGN KEY (`techc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipkunde__adminc` FOREIGN KEY (`adminc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipkunde__ipregion` FOREIGN KEY (`ipregion`) REFERENCES `ipregion` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipkunde__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipkunde__owner` FOREIGN KEY (`owner`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipkunde__tarif` FOREIGN KEY (`tarif`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ipkunde`
--

LOCK TABLES `ipkunde` WRITE;
/*!40000 ALTER TABLE `ipkunde` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipkunde` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipmap`
--

DROP TABLE IF EXISTS `ipmap`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ipmap` (
  `person` int(11) NOT NULL,
  `ipkunde` int(11) NOT NULL,
  `metrik` tinyint(3) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ipkunde`,`person`),
  KEY `person` (`person`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_ipmap__ipkunde` FOREIGN KEY (`ipkunde`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipmap__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ipmap`
--

LOCK TABLES `ipmap` WRITE;
/*!40000 ALTER TABLE `ipmap` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipmap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ipregion`
--

DROP TABLE IF EXISTS `ipregion`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ipregion` (
  `id` int(11) NOT NULL auto_increment,
  `zone` varchar(50) character set utf8 NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `kunde` int(11) NOT NULL,
  `alloc` tinyint(4) NOT NULL,
  `ipkunde` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `zone` (`zone`),
  KEY `ipkunde` (`ipkunde`),
  KEY `timestamp` (`timestamp`),
  KEY `r_ipregion__kunde` (`kunde`),
  CONSTRAINT `r_ipregion__ipkunde` FOREIGN KEY (`ipkunde`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ipregion__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ipregion`
--

LOCK TABLES `ipregion` WRITE;
/*!40000 ALTER TABLE `ipregion` DISABLE KEYS */;
/*!40000 ALTER TABLE `ipregion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iptree`
--

DROP TABLE IF EXISTS `iptree`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `iptree` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `child` int(11) NOT NULL,
  `parent` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `child` (`child`,`parent`),
  UNIQUE KEY `parent` (`parent`,`child`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_iptree__parent` FOREIGN KEY (`parent`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_iptree__child` FOREIGN KEY (`child`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `iptree`
--

LOCK TABLES `iptree` WRITE;
/*!40000 ALTER TABLE `iptree` DISABLE KEYS */;
/*!40000 ALTER TABLE `iptree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `knextrech`
--

DROP TABLE IF EXISTS `knextrech`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `knextrech` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  `rnr` int(11) default NULL,
  `mwst` smallint(6) default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned NOT NULL,
  `rbeginn` int(10) unsigned NOT NULL,
  `rende` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `rnr` (`rnr`,`kunde`),
  KEY `timestamp` (`timestamp`),
  KEY `r_knextrech__kunde` (`kunde`),
  CONSTRAINT `r_knextrech__rnr` FOREIGN KEY (`rnr`) REFERENCES `rechnungen` (`rnr`) ON UPDATE CASCADE,
  CONSTRAINT `r_knextrech__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `knextrech`
--

LOCK TABLES `knextrech` WRITE;
/*!40000 ALTER TABLE `knextrech` DISABLE KEYS */;
/*!40000 ALTER TABLE `knextrech` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `konfig_namensraum`
--

DROP TABLE IF EXISTS `konfig_namensraum`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `konfig_namensraum` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(32) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `konfig_namensraum`
--

LOCK TABLES `konfig_namensraum` WRITE;
/*!40000 ALTER TABLE `konfig_namensraum` DISABLE KEYS */;
INSERT INTO `konfig_namensraum` (`id`, `timestamp`, `name`) VALUES (1,'2009-10-06 13:49:57','test');
/*!40000 ALTER TABLE `konfig_namensraum` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `konfig_variable`
--

DROP TABLE IF EXISTS `konfig_variable`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `konfig_variable` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(32) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `konfig_variable`
--

LOCK TABLES `konfig_variable` WRITE;
/*!40000 ALTER TABLE `konfig_variable` DISABLE KEYS */;
INSERT INTO `konfig_variable` (`id`, `timestamp`, `name`) VALUES (1,'2009-10-06 13:49:57','NAS_IP_ADDRESSES_IGNORE'),(2,'2009-10-06 13:49:57','FORBIDDEN_DOMAINS'),(3,'2009-10-06 13:49:57','DESCR'),(4,'2009-10-06 13:49:57','RT_MAIL_OK'),(5,'2009-10-06 13:49:57','RT_DOMAIN'),(6,'2009-10-06 13:49:57','LOGDIR'),(7,'2009-10-06 13:49:57','NAS_IP_ADDRESSES'),(8,'2009-10-06 13:49:57','NSI_KEY'),(9,'2009-10-06 13:49:57','MUSTERTEXT_TABELLEN'),(10,'2009-10-06 13:49:57','NS_EXT'),(11,'2009-10-06 13:49:57','ACCDB'),(12,'2009-10-06 13:49:57','ACCUSER'),(13,'2009-10-06 13:49:57','CACHEDIR'),(14,'2009-10-06 13:49:57','DOCUCOOKIE'),(15,'2009-10-06 13:49:57','EURO'),(16,'2009-10-06 13:49:57','DOCUHOST'),(17,'2009-10-06 13:49:57','DOCUSHARE'),(18,'2009-10-06 13:49:57','ACCHOST'),(19,'2009-10-06 13:49:57','TDSL_DOMAIN'),(20,'2009-10-06 13:49:57','RT_MAX_SIZE'),(21,'2009-10-06 13:49:57','MWST'),(22,'2009-10-06 13:49:57','URL4LANDKARTE'),(23,'2009-10-06 13:49:57','UID_MINIMUM'),(24,'2009-10-06 13:49:57','LOGSUB'),(25,'2009-10-06 13:49:57','ACCPASS'),(26,'2009-10-06 13:49:57','NSI'),(27,'2009-10-06 13:49:57','NSI_KEY_NAME');
/*!40000 ALTER TABLE `konfig_variable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `konfig_wert`
--

DROP TABLE IF EXISTS `konfig_wert`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `konfig_wert` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `namensraum` smallint(5) unsigned NOT NULL,
  `variable` smallint(5) unsigned NOT NULL,
  `wert` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `namensraum` (`namensraum`,`variable`),
  KEY `timestamp` (`timestamp`),
  KEY `r_konfig_wert__variable` (`variable`),
  CONSTRAINT `r_konfig_wert__variable` FOREIGN KEY (`variable`) REFERENCES `konfig_variable` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_konfig_wert__namensraum` FOREIGN KEY (`namensraum`) REFERENCES `konfig_namensraum` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `konfig_wert`
--

LOCK TABLES `konfig_wert` WRITE;
/*!40000 ALTER TABLE `konfig_wert` DISABLE KEYS */;
INSERT INTO `konfig_wert` (`id`, `timestamp`, `namensraum`, `variable`, `wert`) VALUES (1,'2009-10-06 13:49:57',1,1,'62.128.0.7'),(2,'2009-10-06 13:49:57',1,2,'office.test.example nms.test.example'),(3,'2009-10-06 13:49:57',1,3,'BlaFasel GbR'),(4,'2009-10-06 13:49:57',1,4,'99'),(5,'2009-10-06 13:49:57',1,5,'rt.test.example'),(6,'2009-10-06 13:49:57',1,6,'/var/log/pop'),(7,'2009-10-06 13:49:57',1,7,'62.128.0.143 62.128.0.234 62.128.1.18 62.128.1.19'),(8,'2009-10-06 13:49:57',1,8,'XXXXXXXXXXXXXXXXXXXXXX=='),(9,'2009-10-06 13:49:57',1,9,'rt_template rt_formular rech_fuss adress_vorlage rt_eskalation_muster'),(10,'2009-10-06 13:49:57',1,10,'dns.noris.ch dns.noris.de dns.noris.net dns1.noris.net dns2.noris.net dns3.noris.net'),(11,'2009-10-06 13:49:57',1,11,'single'),(12,'2009-10-06 13:49:57',1,12,'acctwriter'),(13,'2009-10-06 13:49:57',1,13,'/var/cache/pop'),(14,'2009-10-06 13:49:57',1,14,'%da%17%00%cdN................%3d'),(15,'2009-10-06 13:49:57',1,15,'1.95583'),(16,'2009-10-06 13:49:57',1,16,'docushare.fasel.test.example'),(17,'2009-10-06 13:49:57',1,17,'http://docushare.fasel.test.example'),(18,'2009-10-06 13:49:57',1,18,'somewhere.acct.example'),(19,'2009-10-06 13:49:57',1,19,'noris.net speed-dsl.eu'),(20,'2009-10-06 13:49:57',1,20,'2097152'),(21,'2009-10-06 13:49:57',1,21,'0.19'),(22,'2009-10-06 13:49:57',1,22,'http://maps.google.de/maps?q='),(23,'2009-10-06 13:49:57',1,23,'1000'),(24,'2009-10-06 13:49:57',1,24,'accouting/\\T/\\M/\\J/\\X/\\C.\\S'),(25,'2009-10-06 13:49:57',1,25,'WhatEverItIs'),(26,'2009-10-06 13:49:57',1,26,'ns.fasel.test.example'),(27,'2009-10-06 13:49:57',1,27,'dns0.test.example');
/*!40000 ALTER TABLE `konfig_wert` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `konten`
--

DROP TABLE IF EXISTS `konten`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `konten` (
  `kunde` int(11) NOT NULL,
  `blz` varchar(10) character set utf8 NOT NULL,
  `name` varchar(40) character set utf8 NOT NULL,
  `kontonr` varchar(15) character set utf8 NOT NULL,
  `bank` varchar(40) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`kunde`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_konten__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `konten`
--

LOCK TABLES `konten` WRITE;
/*!40000 ALTER TABLE `konten` DISABLE KEYS */;
/*!40000 ALTER TABLE `konten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kunde`
--

DROP TABLE IF EXISTS `kunde`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `kunde` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) default NULL,
  `reseller` int(11) default NULL,
  `name` varchar(32) character set utf8 NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `zuletzt` int(11) default NULL,
  `berechne` char(1) character set ascii NOT NULL default 'm',
  `kprio` char(1) character set ascii default NULL,
  `geaendert` int(10) unsigned default NULL,
  `flags` int(11) NOT NULL,
  `pwklasse` smallint(6) default NULL,
  `skip` char(1) character set ascii NOT NULL default 'n',
  `erloeskonto` int(11) default NULL,
  `steuernr` varchar(20) character set utf8 default NULL,
  `zahlung` tinyint(4) default NULL,
  `sprache` smallint(6) default NULL,
  `hauptperson` int(11) default NULL,
  `billc` int(11) default NULL,
  `adminc` int(11) default NULL,
  `ap_vertrieb` int(11) default NULL,
  `ap_technik` int(11) default NULL,
  `mail_ip` tinyint(3) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`),
  KEY `reseller` (`reseller`),
  KEY `kunde` (`kunde`),
  KEY `ende` (`ende`,`id`),
  KEY `r_kunde__hauptperson` (`hauptperson`),
  KEY `r_kunde__billc` (`billc`),
  KEY `r_kunde__adminc` (`adminc`),
  KEY `r_kunde__ap_vertrieb` (`ap_vertrieb`),
  KEY `r_kunde__ap_technik` (`ap_technik`),
  CONSTRAINT `r_kunde__ap_technik` FOREIGN KEY (`ap_technik`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kunde__adminc` FOREIGN KEY (`adminc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kunde__ap_vertrieb` FOREIGN KEY (`ap_vertrieb`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kunde__billc` FOREIGN KEY (`billc`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kunde__hauptperson` FOREIGN KEY (`hauptperson`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kunde__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kunde__reseller` FOREIGN KEY (`reseller`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `kunde`
--

LOCK TABLES `kunde` WRITE;
/*!40000 ALTER TABLE `kunde` DISABLE KEYS */;
INSERT INTO `kunde` (`id`, `timestamp`, `kunde`, `reseller`, `name`, `beginn`, `ende`, `zuletzt`, `berechne`, `kprio`, `geaendert`, `flags`, `pwklasse`, `skip`, `erloeskonto`, `steuernr`, `zahlung`, `sprache`, `hauptperson`, `billc`, `adminc`, `ap_vertrieb`, `ap_technik`, `mail_ip`) VALUES (1,'2009-10-06 13:49:57',NULL,NULL,'POP',0,NULL,NULL,'x',NULL,NULL,0,NULL,'n',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'2009-10-06 13:50:04',NULL,NULL,'tickettest',0,NULL,NULL,'m',NULL,NULL,0,NULL,'n',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `kunde` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kundemail`
--

DROP TABLE IF EXISTS `kundemail`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `kundemail` (
  `kunde` int(11) NOT NULL,
  `dienst` smallint(6) NOT NULL,
  `dringend` smallint(6) NOT NULL,
  `person` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`kunde`,`dienst`,`person`),
  KEY `timestamp` (`timestamp`),
  KEY `person` (`person`),
  CONSTRAINT `r_kundemail__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_kundemail__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `kundemail`
--

LOCK TABLES `kundemail` WRITE;
/*!40000 ALTER TABLE `kundemail` DISABLE KEYS */;
/*!40000 ALTER TABLE `kundemail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `land`
--

DROP TABLE IF EXISTS `land`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `land` (
  `id` smallint(6) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kfz` varchar(3) character set utf8 NOT NULL,
  `iso2` char(2) character set utf8 NOT NULL,
  `iso3` char(3) character set utf8 NOT NULL,
  `name` varchar(30) character set utf8 NOT NULL,
  `name_en` varchar(30) character set utf8 NOT NULL,
  `eu` char(1) character set ascii NOT NULL default 'n',
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `land`
--

LOCK TABLES `land` WRITE;
/*!40000 ALTER TABLE `land` DISABLE KEYS */;
/*!40000 ALTER TABLE `land` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `leitung`
--

DROP TABLE IF EXISTS `leitung`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `leitung` (
  `id` int(11) NOT NULL auto_increment,
  `kunde` int(11) NOT NULL,
  `name` varchar(255) character set utf8 NOT NULL,
  `art` smallint(6) default NULL,
  `carrier` int(11) default NULL,
  `name_carrier` varchar(255) character set utf8 default NULL,
  `name_kunde` varchar(255) character set utf8 default NULL,
  `backup` int(11) default NULL,
  `a_ende` int(11) default NULL,
  `a_hardware` int(11) default NULL,
  `b_ende` int(11) default NULL,
  `b_hardware` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `a_hardware` (`a_hardware`),
  KEY `b_hardware` (`b_hardware`),
  KEY `r_leitung__kunde` (`kunde`),
  KEY `r_leitung__carrier` (`carrier`),
  KEY `r_leitung__backup` (`backup`),
  KEY `r_leitung__a_ende` (`a_ende`),
  KEY `r_leitung__b_ende` (`b_ende`),
  CONSTRAINT `r_leitung__b_hardware` FOREIGN KEY (`b_hardware`) REFERENCES `hardware` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_leitung__a_ende` FOREIGN KEY (`a_ende`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_leitung__a_hardware` FOREIGN KEY (`a_hardware`) REFERENCES `hardware` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_leitung__backup` FOREIGN KEY (`backup`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_leitung__b_ende` FOREIGN KEY (`b_ende`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_leitung__carrier` FOREIGN KEY (`carrier`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_leitung__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `leitung`
--

LOCK TABLES `leitung` WRITE;
/*!40000 ALTER TABLE `leitung` DISABLE KEYS */;
/*!40000 ALTER TABLE `leitung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mailassoc`
--

DROP TABLE IF EXISTS `mailassoc`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mailassoc` (
  `id` int(11) NOT NULL auto_increment,
  `email` varchar(255) character set utf8 NOT NULL,
  `person` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `person` (`person`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_mailassoc__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mailassoc`
--

LOCK TABLES `mailassoc` WRITE;
/*!40000 ALTER TABLE `mailassoc` DISABLE KEYS */;
/*!40000 ALTER TABLE `mailassoc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mailrules`
--

DROP TABLE IF EXISTS `mailrules`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mailrules` (
  `id` int(11) NOT NULL auto_increment,
  `kunde` int(11) NOT NULL,
  `quelle` varchar(255) character set utf8 default NULL,
  `typ` smallint(6) NOT NULL,
  `ziel` text character set utf8,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `quelle` (`quelle`),
  KEY `kunde` (`kunde`,`typ`),
  KEY `typ` (`typ`,`ziel`(255)),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_mailrules__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mailrules`
--

LOCK TABLES `mailrules` WRITE;
/*!40000 ALTER TABLE `mailrules` DISABLE KEYS */;
/*!40000 ALTER TABLE `mailrules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mess_ablesung`
--

DROP TABLE IF EXISTS `mess_ablesung`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mess_ablesung` (
  `id` int(11) NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `mess_geraet` int(11) NOT NULL,
  `ablesezeitpunkt` int(10) unsigned NOT NULL,
  `wert` double NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `mess_geraet` (`mess_geraet`,`ablesezeitpunkt`),
  KEY `ablesezeitpunkt` (`ablesezeitpunkt`),
  KEY `timestamp` (`timestamp`),
  KEY `r_mess_ablesung__person` (`person`),
  CONSTRAINT `r_mess_ablesung__mess_geraet` FOREIGN KEY (`mess_geraet`) REFERENCES `mess_geraet` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_mess_ablesung__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mess_ablesung`
--

LOCK TABLES `mess_ablesung` WRITE;
/*!40000 ALTER TABLE `mess_ablesung` DISABLE KEYS */;
/*!40000 ALTER TABLE `mess_ablesung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mess_geraet`
--

DROP TABLE IF EXISTS `mess_geraet`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mess_geraet` (
  `id` int(11) NOT NULL auto_increment,
  `typ` int(11) NOT NULL,
  `mess_stelle` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `info` varchar(255) character set utf8 default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `mess_stelle` (`mess_stelle`,`beginn`),
  KEY `beginn` (`beginn`),
  KEY `timestamp` (`timestamp`),
  KEY `r_mess_geraet__typ` (`typ`),
  CONSTRAINT `r_mess_geraet__mess_stelle` FOREIGN KEY (`mess_stelle`) REFERENCES `mess_stelle` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_mess_geraet__typ` FOREIGN KEY (`typ`) REFERENCES `mess_geraet_typ` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mess_geraet`
--

LOCK TABLES `mess_geraet` WRITE;
/*!40000 ALTER TABLE `mess_geraet` DISABLE KEYS */;
/*!40000 ALTER TABLE `mess_geraet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mess_geraet_typ`
--

DROP TABLE IF EXISTS `mess_geraet_typ`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mess_geraet_typ` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) character set utf8 NOT NULL,
  `ueberlauf_wert` double default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mess_geraet_typ`
--

LOCK TABLES `mess_geraet_typ` WRITE;
/*!40000 ALTER TABLE `mess_geraet_typ` DISABLE KEYS */;
/*!40000 ALTER TABLE `mess_geraet_typ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mess_stelle`
--

DROP TABLE IF EXISTS `mess_stelle`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mess_stelle` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) character set utf8 NOT NULL,
  `typ` int(11) NOT NULL,
  `snmp_host` int(11) default NULL,
  `oid_suffix` varchar(255) character set ascii default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `info` varchar(255) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `snmp_host` (`snmp_host`,`oid_suffix`,`beginn`),
  UNIQUE KEY `name` (`name`,`snmp_host`,`beginn`),
  KEY `typ` (`typ`),
  KEY `oid_suffix` (`oid_suffix`),
  KEY `beginn` (`beginn`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_mess_stelle__snmp_host` FOREIGN KEY (`snmp_host`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_mess_stelle__typ` FOREIGN KEY (`typ`) REFERENCES `mess_typ` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mess_stelle`
--

LOCK TABLES `mess_stelle` WRITE;
/*!40000 ALTER TABLE `mess_stelle` DISABLE KEYS */;
/*!40000 ALTER TABLE `mess_stelle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mess_typ`
--

DROP TABLE IF EXISTS `mess_typ`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mess_typ` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) character set utf8 NOT NULL,
  `dienst` smallint(6) NOT NULL,
  `wertart` varchar(255) character set utf8 NOT NULL,
  `einheit` smallint(6) NOT NULL,
  `collectd_typ` varchar(255) character set utf8 NOT NULL,
  `collectd_intervall` int(10) unsigned NOT NULL,
  `rrd_typ` smallint(6) NOT NULL,
  `rrd_min` double default NULL,
  `rrd_max` double default NULL,
  `rrd_faktor` double NOT NULL,
  `snmp_faktor` double NOT NULL,
  `oid_praefix` varchar(255) character set ascii default NULL,
  `info` varchar(255) character set utf8 default NULL,
  `status` smallint(6) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `collectd_typ` (`collectd_typ`),
  KEY `timestamp` (`timestamp`),
  KEY `r_mess_typ__dienst` (`dienst`),
  CONSTRAINT `r_mess_typ__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mess_typ`
--

LOCK TABLES `mess_typ` WRITE;
/*!40000 ALTER TABLE `mess_typ` DISABLE KEYS */;
/*!40000 ALTER TABLE `mess_typ` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mess_verbraucher`
--

DROP TABLE IF EXISTS `mess_verbraucher`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `mess_verbraucher` (
  `id` int(11) NOT NULL auto_increment,
  `mess_stelle` int(11) NOT NULL,
  `rack` smallint(6) default NULL,
  `hardware` int(11) default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `kunde` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `rack` (`rack`,`mess_stelle`,`beginn`),
  UNIQUE KEY `hardware` (`hardware`,`mess_stelle`,`beginn`),
  KEY `kunde` (`kunde`),
  KEY `beginn` (`beginn`),
  KEY `mess_stelle` (`mess_stelle`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_mess_verbraucher__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_mess_verbraucher__hardware` FOREIGN KEY (`hardware`) REFERENCES `hardware` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_mess_verbraucher__mess_stelle` FOREIGN KEY (`mess_stelle`) REFERENCES `mess_stelle` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_mess_verbraucher__rack` FOREIGN KEY (`rack`) REFERENCES `rack` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `mess_verbraucher`
--

LOCK TABLES `mess_verbraucher` WRITE;
/*!40000 ALTER TABLE `mess_verbraucher` DISABLE KEYS */;
/*!40000 ALTER TABLE `mess_verbraucher` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nextid`
--

DROP TABLE IF EXISTS `nextid`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `nextid` (
  `id` int(11) NOT NULL,
  `name` varchar(255) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `nextid`
--

LOCK TABLES `nextid` WRITE;
/*!40000 ALTER TABLE `nextid` DISABLE KEYS */;
INSERT INTO `nextid` (`id`, `name`, `timestamp`) VALUES (3,'id_test','2009-10-06 13:49:56'),(1,'id_test2','2009-10-06 13:49:56'),(2,'id_test3','2009-10-06 13:49:56'),(2,'ticket','2009-10-06 13:50:08'),(13,'trans_test','2009-10-06 13:49:59');
/*!40000 ALTER TABLE `nextid` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nextrech`
--

DROP TABLE IF EXISTS `nextrech`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `nextrech` (
  `id` int(11) NOT NULL auto_increment,
  `tarifkunde` int(11) NOT NULL,
  `knextrech` int(11) default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned NOT NULL,
  `anzahl` mediumint(9) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `tarifkunde` (`tarifkunde`,`knextrech`),
  KEY `knextrech` (`knextrech`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_nextrech__knextrech` FOREIGN KEY (`knextrech`) REFERENCES `knextrech` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_nextrech__tarifkunde` FOREIGN KEY (`tarifkunde`) REFERENCES `tarifkunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `nextrech`
--

LOCK TABLES `nextrech` WRITE;
/*!40000 ALTER TABLE `nextrech` DISABLE KEYS */;
/*!40000 ALTER TABLE `nextrech` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nic`
--

DROP TABLE IF EXISTS `nic`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `nic` (
  `id` int(11) NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `nic` smallint(6) NOT NULL,
  `handle` varchar(128) character set utf8 default NULL,
  `username` varchar(15) character set utf8 default NULL,
  `passwort` varchar(15) character set utf8 default NULL,
  `ticket` int(11) default NULL,
  `status` tinyint(4) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `person` (`person`,`nic`),
  UNIQUE KEY `nic` (`nic`,`handle`),
  KEY `username` (`username`),
  KEY `timestamp` (`timestamp`),
  KEY `status` (`status`),
  CONSTRAINT `r_nic__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `nic`
--

LOCK TABLES `nic` WRITE;
/*!40000 ALTER TABLE `nic` DISABLE KEYS */;
/*!40000 ALTER TABLE `nic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `nicdata`
--

DROP TABLE IF EXISTS `nicdata`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `nicdata` (
  `nic` smallint(6) NOT NULL,
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `handle_re` varchar(100) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `nic` (`nic`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `nicdata`
--

LOCK TABLES `nicdata` WRITE;
/*!40000 ALTER TABLE `nicdata` DISABLE KEYS */;
/*!40000 ALTER TABLE `nicdata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `open_xchange`
--

DROP TABLE IF EXISTS `open_xchange`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `open_xchange` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `kunde` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `option` smallint(6) NOT NULL,
  `log` int(10) unsigned NOT NULL,
  `request` text character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `kunde` (`kunde`,`beginn`),
  UNIQUE KEY `kunde_2` (`kunde`,`log`),
  KEY `r_open_xchange__log` (`log`),
  CONSTRAINT `r_open_xchange__log` FOREIGN KEY (`log`) REFERENCES `open_xchange_log` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_open_xchange__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `open_xchange`
--

LOCK TABLES `open_xchange` WRITE;
/*!40000 ALTER TABLE `open_xchange` DISABLE KEYS */;
/*!40000 ALTER TABLE `open_xchange` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `open_xchange_log`
--

DROP TABLE IF EXISTS `open_xchange_log`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `open_xchange_log` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `anzeige` text character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `person` (`person`,`timestamp`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_open_xchange_log__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `open_xchange_log`
--

LOCK TABLES `open_xchange_log` WRITE;
/*!40000 ALTER TABLE `open_xchange_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `open_xchange_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `otrs_import`
--

DROP TABLE IF EXISTS `otrs_import`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `otrs_import` (
  `id` int(11) NOT NULL auto_increment,
  `rt_id` int(11) NOT NULL,
  `rt_maxseq` int(11) NOT NULL,
  `otrs_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `otrs_id` (`otrs_id`),
  KEY `timestamp` (`timestamp`),
  KEY `rt_id` (`rt_id`),
  CONSTRAINT `r_otrs_import__rt_id` FOREIGN KEY (`rt_id`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `otrs_import`
--

LOCK TABLES `otrs_import` WRITE;
/*!40000 ALTER TABLE `otrs_import` DISABLE KEYS */;
/*!40000 ALTER TABLE `otrs_import` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `passwort`
--

DROP TABLE IF EXISTS `passwort`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `passwort` (
  `kunde` int(11) NOT NULL,
  `seq` mediumint(9) NOT NULL,
  `pass` mediumblob NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`kunde`,`seq`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_passwort__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `passwort`
--

LOCK TABLES `passwort` WRITE;
/*!40000 ALTER TABLE `passwort` DISABLE KEYS */;
/*!40000 ALTER TABLE `passwort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `perso`
--

DROP TABLE IF EXISTS `perso`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `perso` (
  `person` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `abschluss` int(10) unsigned default NULL,
  `urlaub` int(11) NOT NULL,
  `resturlaub` int(11) NOT NULL,
  `ueberstunde` int(11) NOT NULL,
  `ueberstundenlimit` int(10) unsigned default NULL,
  `letzter` int(11) default NULL,
  `personr` smallint(6) NOT NULL,
  `jahresurlaub` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `vorgesetzter` int(11) default NULL,
  `tagstunden` int(11) default NULL,
  `anfangsmonat` mediumint(8) unsigned default NULL,
  `anfangsueber` mediumint(9) default NULL,
  PRIMARY KEY  (`person`),
  KEY `timestamp` (`timestamp`),
  KEY `vorgesetzter` (`vorgesetzter`),
  KEY `personr` (`personr`),
  CONSTRAINT `r_perso__vorgesetzter` FOREIGN KEY (`vorgesetzter`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_perso__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `perso`
--

LOCK TABLES `perso` WRITE;
/*!40000 ALTER TABLE `perso` DISABLE KEYS */;
/*!40000 ALTER TABLE `perso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `persomonat`
--

DROP TABLE IF EXISTS `persomonat`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `persomonat` (
  `id` int(11) NOT NULL auto_increment,
  `monat` int(11) NOT NULL,
  `person` int(11) default NULL,
  `soll` int(10) unsigned default NULL,
  `ist` int(10) unsigned default NULL,
  `urlaub` int(10) unsigned default NULL,
  `auszahl` int(10) unsigned default NULL,
  `diff` int(11) NOT NULL,
  `ueberstundenlimit` int(10) unsigned default NULL,
  `hotline` int(10) unsigned default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `monat` (`monat`,`person`),
  KEY `timestamp` (`timestamp`),
  KEY `r_persomonat__person` (`person`),
  CONSTRAINT `r_persomonat__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `persomonat`
--

LOCK TABLES `persomonat` WRITE;
/*!40000 ALTER TABLE `persomonat` DISABLE KEYS */;
/*!40000 ALTER TABLE `persomonat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `person`
--

DROP TABLE IF EXISTS `person`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `person` (
  `infotext` varchar(255) character set utf8 default NULL,
  `id` int(11) NOT NULL auto_increment,
  `kunde` int(11) NOT NULL,
  `name` varchar(255) character set utf8 default NULL,
  `abt` varchar(255) character set utf8 default NULL,
  `email` varchar(255) character set utf8 default NULL,
  `fon` varchar(255) character set utf8 default NULL,
  `fax` varchar(255) character set utf8 default NULL,
  `pager` varchar(255) character set utf8 default NULL,
  `isdn` varchar(255) character set utf8 default NULL,
  `dest` varchar(4) character set utf8 default NULL,
  `adresse` int(11) default NULL,
  `ausweisnr` varchar(255) character set utf8 default NULL,
  `zusatzinfo` varchar(255) character set utf8 default NULL,
  `suchbegriff` varchar(255) character set utf8 default NULL,
  `user` varchar(32) character set utf8 default NULL,
  `pass` varchar(255) character set utf8 default NULL,
  `uid` int(11) default NULL,
  `homedir` varchar(255) character set utf8 default NULL,
  `pwuse` bigint(20) NOT NULL,
  `redirect` varchar(255) character set utf8 default NULL,
  `radiustemplate` smallint(6) default NULL,
  `maxconn` tinyint(4) default NULL,
  `vrf` smallint(6) default NULL,
  `uremip` int(11) default NULL,
  `prefcall` smallint(6) default NULL,
  `tarifname` int(11) default NULL,
  `mperson` int(11) default NULL,
  `gebtag` smallint(6) default NULL,
  `gebjahr` smallint(6) default NULL,
  `job` varchar(255) character set utf8 default NULL,
  `nagiosconf` varchar(255) character set utf8 default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `suchbegriff` (`suchbegriff`),
  UNIQUE KEY `user` (`user`),
  KEY `uid` (`uid`),
  KEY `email` (`email`),
  KEY `mperson` (`mperson`),
  KEY `timestamp` (`timestamp`),
  KEY `name` (`name`),
  KEY `uremip` (`uremip`),
  KEY `kunde` (`kunde`),
  KEY `r_person__adresse` (`adresse`),
  KEY `r_person__tarifname` (`tarifname`),
  CONSTRAINT `r_person__mperson` FOREIGN KEY (`mperson`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_person__adresse` FOREIGN KEY (`adresse`) REFERENCES `adresse` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_person__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_person__tarifname` FOREIGN KEY (`tarifname`) REFERENCES `tarifname` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_person__uremip` FOREIGN KEY (`uremip`) REFERENCES `ipkunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `person`
--

LOCK TABLES `person` WRITE;
/*!40000 ALTER TABLE `person` DISABLE KEYS */;
INSERT INTO `person` (`infotext`, `id`, `kunde`, `name`, `abt`, `email`, `fon`, `fax`, `pager`, `isdn`, `dest`, `adresse`, `ausweisnr`, `zusatzinfo`, `suchbegriff`, `user`, `pass`, `uid`, `homedir`, `pwuse`, `redirect`, `radiustemplate`, `maxconn`, `vrf`, `uremip`, `prefcall`, `tarifname`, `mperson`, `gebtag`, `gebjahr`, `job`, `nagiosconf`, `timestamp`) VALUES (NULL,1,1,'Test-POP',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2009-10-06 13:49:57'),(NULL,2,1,'Herr Joe Tester',NULL,'tester@fubar.test.example',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'qsu',NULL,1021,NULL,260,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2009-10-06 13:50:03');
/*!40000 ALTER TABLE `person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pwhist`
--

DROP TABLE IF EXISTS `pwhist`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `pwhist` (
  `id` int(11) NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `flag` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `person` (`person`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_pwhist__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `pwhist`
--

LOCK TABLES `pwhist` WRITE;
/*!40000 ALTER TABLE `pwhist` DISABLE KEYS */;
/*!40000 ALTER TABLE `pwhist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quelle`
--

DROP TABLE IF EXISTS `quelle`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `quelle` (
  `kunde` int(11) NOT NULL default '0',
  `quelle` int(11) NOT NULL default '0',
  `datum` int(11) NOT NULL default '0',
  `ziel` tinyint(4) default NULL,
  `pakete` bigint(20) default NULL,
  `bytes` bigint(20) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  KEY `qkd` (`kunde`,`datum`),
  KEY `qqd` (`quelle`,`datum`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `quelle`
--

LOCK TABLES `quelle` WRITE;
/*!40000 ALTER TABLE `quelle` DISABLE KEYS */;
/*!40000 ALTER TABLE `quelle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `queue` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `email` varchar(255) character set utf8 NOT NULL,
  `flags` int(11) NOT NULL,
  `defprio` tinyint(4) NOT NULL,
  `defdue` smallint(6) NOT NULL,
  `deffdue` smallint(6) NOT NULL,
  `defbearb` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `email` (`email`),
  KEY `timestamp` (`timestamp`),
  KEY `r_queue__defbearb` (`defbearb`),
  CONSTRAINT `r_queue__defbearb` FOREIGN KEY (`defbearb`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `queue`
--

LOCK TABLES `queue` WRITE;
/*!40000 ALTER TABLE `queue` DISABLE KEYS */;
INSERT INTO `queue` (`id`, `name`, `email`, `flags`, `defprio`, `defdue`, `deffdue`, `defbearb`, `timestamp`) VALUES (1,'test','test@fubar.test.example',0,0,0,0,NULL,'2009-10-06 13:50:03');
/*!40000 ALTER TABLE `queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queue_acl`
--

DROP TABLE IF EXISTS `queue_acl`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `queue_acl` (
  `person` int(11) NOT NULL,
  `queue` int(11) NOT NULL,
  `acls` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`person`,`queue`),
  KEY `timestamp` (`timestamp`),
  KEY `r_queue_acl__queue` (`queue`),
  CONSTRAINT `r_queue_acl__queue` FOREIGN KEY (`queue`) REFERENCES `queue` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_queue_acl__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `queue_acl`
--

LOCK TABLES `queue_acl` WRITE;
/*!40000 ALTER TABLE `queue_acl` DISABLE KEYS */;
INSERT INTO `queue_acl` (`person`, `queue`, `acls`, `timestamp`) VALUES (2,1,14,'2009-10-06 13:50:03');
/*!40000 ALTER TABLE `queue_acl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queue_areas`
--

DROP TABLE IF EXISTS `queue_areas`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `queue_areas` (
  `id` int(11) NOT NULL auto_increment,
  `queue` int(11) NOT NULL,
  `name` varchar(50) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `queue` (`queue`,`name`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_queue_areas__queue` FOREIGN KEY (`queue`) REFERENCES `queue` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `queue_areas`
--

LOCK TABLES `queue_areas` WRITE;
/*!40000 ALTER TABLE `queue_areas` DISABLE KEYS */;
/*!40000 ALTER TABLE `queue_areas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rack`
--

DROP TABLE IF EXISTS `rack`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rack` (
  `id` smallint(6) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `rz` smallint(6) NOT NULL,
  `name` varchar(255) character set utf8 NOT NULL,
  `info` varchar(255) character set utf8 default NULL,
  `he` tinyint(3) unsigned NOT NULL,
  `kunde` int(11) NOT NULL,
  `x` tinyint(4) NOT NULL,
  `y` tinyint(4) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `rz` (`rz`,`name`),
  KEY `timestamp` (`timestamp`),
  KEY `r_rack__kunde` (`kunde`),
  CONSTRAINT `r_rack__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_rack__rz` FOREIGN KEY (`rz`) REFERENCES `rz` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rack`
--

LOCK TABLES `rack` WRITE;
/*!40000 ALTER TABLE `rack` DISABLE KEYS */;
/*!40000 ALTER TABLE `rack` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `radacct`
--

DROP TABLE IF EXISTS `radacct`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `radacct` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dienst` smallint(6) NOT NULL,
  `ziel` smallint(6) NOT NULL,
  `kunde` int(11) NOT NULL,
  `person` int(11) NOT NULL,
  `gegenstelle` varchar(255) character set utf8 default NULL,
  `zielrufnr` varchar(255) character set utf8 default NULL,
  `datum` int(10) unsigned NOT NULL,
  `dauer` int(10) unsigned NOT NULL,
  `pakete_in` int(10) unsigned NOT NULL,
  `pakete_out` int(10) unsigned NOT NULL,
  `bytes_in` bigint(20) unsigned NOT NULL,
  `bytes_out` bigint(20) unsigned NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `kunde` (`kunde`,`datum`),
  KEY `timestamp` (`timestamp`),
  KEY `r_radacct__dienst` (`dienst`),
  KEY `r_radacct__person` (`person`),
  CONSTRAINT `r_radacct__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_radacct__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_radacct__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `radacct`
--

LOCK TABLES `radacct` WRITE;
/*!40000 ALTER TABLE `radacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `radacct` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rech_fuss`
--

DROP TABLE IF EXISTS `rech_fuss`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rech_fuss` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `inhalt` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rech_fuss`
--

LOCK TABLES `rech_fuss` WRITE;
/*!40000 ALTER TABLE `rech_fuss` DISABLE KEYS */;
/*!40000 ALTER TABLE `rech_fuss` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `recheinheit`
--

DROP TABLE IF EXISTS `recheinheit`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `recheinheit` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `rechstep` int(11) NOT NULL,
  `typ` char(1) character set ascii NOT NULL,
  `start` bigint(20) NOT NULL,
  `faktor` bigint(20) NOT NULL,
  `name` varchar(10) character set utf8 NOT NULL,
  `info` varchar(30) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `rechstep` (`rechstep`,`typ`,`start`),
  CONSTRAINT `r_recheinheit__rechstep` FOREIGN KEY (`rechstep`) REFERENCES `rechstep` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `recheinheit`
--

LOCK TABLES `recheinheit` WRITE;
/*!40000 ALTER TABLE `recheinheit` DISABLE KEYS */;
/*!40000 ALTER TABLE `recheinheit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rechlauf`
--

DROP TABLE IF EXISTS `rechlauf`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rechlauf` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `anfang` int(11) NOT NULL,
  `ende` int(11) NOT NULL,
  `template` int(11) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `anfang` (`anfang`),
  KEY `timestamp` (`timestamp`),
  KEY `r_rechlauf__ende` (`ende`),
  KEY `r_rechlauf__template` (`template`),
  CONSTRAINT `r_rechlauf__template` FOREIGN KEY (`template`) REFERENCES `rech_fuss` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_rechlauf__anfang` FOREIGN KEY (`anfang`) REFERENCES `rechnungen` (`rnr`) ON UPDATE CASCADE,
  CONSTRAINT `r_rechlauf__ende` FOREIGN KEY (`ende`) REFERENCES `rechnungen` (`rnr`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rechlauf`
--

LOCK TABLES `rechlauf` WRITE;
/*!40000 ALTER TABLE `rechlauf` DISABLE KEYS */;
/*!40000 ALTER TABLE `rechlauf` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rechnungen`
--

DROP TABLE IF EXISTS `rechnungen`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rechnungen` (
  `rnr` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `datum` int(10) unsigned NOT NULL,
  `kunde` int(11) NOT NULL,
  `infotext` varchar(255) character set utf8 NOT NULL,
  `betrag` int(11) NOT NULL,
  `steuer` int(11) NOT NULL,
  `auftragsnr` varchar(50) character set utf8 default NULL,
  `rbetrag` int(11) default NULL,
  `buchung` int(11) default NULL,
  `auszug` int(11) default NULL,
  `flags` int(11) NOT NULL,
  `rtext` mediumtext character set utf8,
  `fusstext` text character set utf8,
  `konto` mediumint(9) default NULL,
  `storniert` int(10) unsigned default NULL,
  PRIMARY KEY  (`rnr`),
  KEY `kunde` (`kunde`,`datum`),
  KEY `betrag` (`betrag`),
  KEY `datum` (`datum`,`kunde`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rechnungen__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rechnungen`
--

LOCK TABLES `rechnungen` WRITE;
/*!40000 ALTER TABLE `rechnungen` DISABLE KEYS */;
/*!40000 ALTER TABLE `rechnungen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rechstep`
--

DROP TABLE IF EXISTS `rechstep`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rechstep` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `step` smallint(6) NOT NULL,
  `kunde` int(11) default NULL,
  `dienst` smallint(6) NOT NULL,
  `flags` int(11) NOT NULL,
  `info` varchar(100) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `kunde` (`kunde`,`dienst`),
  KEY `timestamp` (`timestamp`),
  KEY `r_rechstep__dienst` (`dienst`),
  CONSTRAINT `r_rechstep__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_rechstep__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rechstep`
--

LOCK TABLES `rechstep` WRITE;
/*!40000 ALTER TABLE `rechstep` DISABLE KEYS */;
/*!40000 ALTER TABLE `rechstep` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `registrar`
--

DROP TABLE IF EXISTS `registrar`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `registrar` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `nic` smallint(6) NOT NULL,
  `flags` int(11) NOT NULL,
  `keyid` varchar(10) character set utf8 default NULL,
  `email` varchar(100) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  KEY `nic` (`nic`),
  KEY `keyid` (`keyid`),
  KEY `email` (`email`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_registrar__nic` FOREIGN KEY (`nic`) REFERENCES `nicdata` (`nic`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `registrar`
--

LOCK TABLES `registrar` WRITE;
/*!40000 ALTER TABLE `registrar` DISABLE KEYS */;
/*!40000 ALTER TABLE `registrar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `releasenotes_note`
--

DROP TABLE IF EXISTS `releasenotes_note`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `releasenotes_note` (
  `id` int(11) NOT NULL auto_increment,
  `modified` datetime NOT NULL,
  `created` datetime NOT NULL,
  `ticket` int(10) unsigned NOT NULL,
  `kind` smallint(5) unsigned NOT NULL,
  `release_beginn_id` int(11) default NULL,
  `release_behoben_id` int(11) default NULL,
  `last_modified_by` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `release_beginn_id` (`release_beginn_id`),
  KEY `release_behoben_id` (`release_behoben_id`),
  CONSTRAINT `r_releasenotes_note__release_behoben_id` FOREIGN KEY (`release_behoben_id`) REFERENCES `releasenotes_release` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_releasenotes_note__release_beginn_id` FOREIGN KEY (`release_beginn_id`) REFERENCES `releasenotes_release` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `releasenotes_note`
--

LOCK TABLES `releasenotes_note` WRITE;
/*!40000 ALTER TABLE `releasenotes_note` DISABLE KEYS */;
/*!40000 ALTER TABLE `releasenotes_note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `releasenotes_notetext`
--

DROP TABLE IF EXISTS `releasenotes_notetext`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `releasenotes_notetext` (
  `id` int(11) NOT NULL auto_increment,
  `modified` datetime NOT NULL,
  `language` varchar(7) character set utf8 NOT NULL,
  `text` text character set utf8 NOT NULL,
  `note_id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `note_id` (`note_id`),
  CONSTRAINT `r_releasenotes_notetext__note_id` FOREIGN KEY (`note_id`) REFERENCES `releasenotes_note` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `releasenotes_notetext`
--

LOCK TABLES `releasenotes_notetext` WRITE;
/*!40000 ALTER TABLE `releasenotes_notetext` DISABLE KEYS */;
/*!40000 ALTER TABLE `releasenotes_notetext` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `releasenotes_release`
--

DROP TABLE IF EXISTS `releasenotes_release`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `releasenotes_release` (
  `id` int(11) NOT NULL auto_increment,
  `modified` datetime NOT NULL,
  `v1` smallint(5) unsigned NOT NULL,
  `v2` smallint(5) unsigned NOT NULL,
  `v3` smallint(5) unsigned NOT NULL,
  `v4` smallint(5) unsigned default NULL,
  `sort_value` int(10) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `sort_value` (`sort_value`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `releasenotes_release`
--

LOCK TABLES `releasenotes_release` WRITE;
/*!40000 ALTER TABLE `releasenotes_release` DISABLE KEYS */;
/*!40000 ALTER TABLE `releasenotes_release` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reseller`
--

DROP TABLE IF EXISTS `reseller`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `reseller` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  `art` tinyint(4) NOT NULL,
  `name` varchar(20) character set utf8 NOT NULL,
  `flags` int(11) NOT NULL,
  `keyid` varchar(10) character set utf8 default NULL,
  `email` varchar(100) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `kunde` (`kunde`),
  UNIQUE KEY `name` (`name`),
  KEY `keyid` (`keyid`),
  KEY `email` (`email`),
  CONSTRAINT `r_reseller__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `reseller`
--

LOCK TABLES `reseller` WRITE;
/*!40000 ALTER TABLE `reseller` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resellernic`
--

DROP TABLE IF EXISTS `resellernic`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `resellernic` (
  `id` int(11) NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `reseller` int(11) NOT NULL,
  `handle` varchar(120) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `person` (`person`,`reseller`),
  UNIQUE KEY `handle` (`handle`,`reseller`),
  KEY `timestamp` (`timestamp`),
  KEY `r_resellernic__reseller` (`reseller`),
  CONSTRAINT `r_resellernic__reseller` FOREIGN KEY (`reseller`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_resellernic__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `resellernic`
--

LOCK TABLES `resellernic` WRITE;
/*!40000 ALTER TABLE `resellernic` DISABLE KEYS */;
/*!40000 ALTER TABLE `resellernic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_antwort`
--

DROP TABLE IF EXISTS `rt_antwort`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_antwort` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ticket` int(11) NOT NULL,
  `frage` int(11) NOT NULL,
  `antwort` char(1) character set ascii NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ticket` (`ticket`,`frage`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rt_antwort__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_antwort`
--

LOCK TABLES `rt_antwort` WRITE;
/*!40000 ALTER TABLE `rt_antwort` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_antwort` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_billing`
--

DROP TABLE IF EXISTS `rt_billing`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_billing` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ticket` int(11) NOT NULL,
  `hash` int(11) NOT NULL,
  `seq` smallint(6) NOT NULL,
  `gemailt` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `hash` (`hash`,`seq`),
  KEY `ticket` (`ticket`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rt_billing__hash_seq` FOREIGN KEY (`hash`, `seq`) REFERENCES `acct` (`hash`, `seq`) ON UPDATE CASCADE,
  CONSTRAINT `r_rt_billing__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_billing`
--

LOCK TABLES `rt_billing` WRITE;
/*!40000 ALTER TABLE `rt_billing` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_billing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_defaults`
--

DROP TABLE IF EXISTS `rt_defaults`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_defaults` (
  `person` int(11) NOT NULL,
  `query` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`person`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rt_defaults__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_defaults`
--

LOCK TABLES `rt_defaults` WRITE;
/*!40000 ALTER TABLE `rt_defaults` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_defaults` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_eskalation`
--

DROP TABLE IF EXISTS `rt_eskalation`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_eskalation` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `rtticket` int(11) NOT NULL,
  `template` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `rtticket` (`rtticket`,`template`),
  KEY `timestamp` (`timestamp`),
  KEY `r_rt_eskalation__template` (`template`),
  CONSTRAINT `r_rt_eskalation__template` FOREIGN KEY (`template`) REFERENCES `rt_eskalation_muster` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_rt_eskalation__rtticket` FOREIGN KEY (`rtticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_eskalation`
--

LOCK TABLES `rt_eskalation` WRITE;
/*!40000 ALTER TABLE `rt_eskalation` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_eskalation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_eskalation_muster`
--

DROP TABLE IF EXISTS `rt_eskalation_muster`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_eskalation_muster` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `inhalt` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_eskalation_muster`
--

LOCK TABLES `rt_eskalation_muster` WRITE;
/*!40000 ALTER TABLE `rt_eskalation_muster` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_eskalation_muster` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_formular`
--

DROP TABLE IF EXISTS `rt_formular`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_formular` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `inhalt` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_formular`
--

LOCK TABLES `rt_formular` WRITE;
/*!40000 ALTER TABLE `rt_formular` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_formular` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_incidents`
--

DROP TABLE IF EXISTS `rt_incidents`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_incidents` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ticket` int(11) NOT NULL,
  `art` varchar(255) character set utf8 default NULL,
  `ursache` text character set utf8,
  `t_meldung` int(10) unsigned default NULL,
  `t_reaktion` int(10) unsigned default NULL,
  `t_entstoerung` int(10) unsigned default NULL,
  `flags` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ticket` (`ticket`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rt_incidents__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_incidents`
--

LOCK TABLES `rt_incidents` WRITE;
/*!40000 ALTER TABLE `rt_incidents` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_incidents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_incidents_confitem`
--

DROP TABLE IF EXISTS `rt_incidents_confitem`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_incidents_confitem` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `confitem` int(11) NOT NULL,
  `incident` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `confitem` (`confitem`,`incident`),
  KEY `incident` (`incident`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rt_incidents_confitem__incident` FOREIGN KEY (`incident`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_rt_incidents_confitem__confitem` FOREIGN KEY (`confitem`) REFERENCES `confitem` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_incidents_confitem`
--

LOCK TABLES `rt_incidents_confitem` WRITE;
/*!40000 ALTER TABLE `rt_incidents_confitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_incidents_confitem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_incidents_leitung`
--

DROP TABLE IF EXISTS `rt_incidents_leitung`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_incidents_leitung` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `leitung` int(11) NOT NULL,
  `incident` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `leitung` (`leitung`,`incident`),
  KEY `incident` (`incident`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_rt_incidents_leitung__incident` FOREIGN KEY (`incident`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_rt_incidents_leitung__leitung` FOREIGN KEY (`leitung`) REFERENCES `leitung` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_incidents_leitung`
--

LOCK TABLES `rt_incidents_leitung` WRITE;
/*!40000 ALTER TABLE `rt_incidents_leitung` DISABLE KEYS */;
/*!40000 ALTER TABLE `rt_incidents_leitung` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rt_template`
--

DROP TABLE IF EXISTS `rt_template`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rt_template` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `inhalt` text character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rt_template`
--

LOCK TABLES `rt_template` WRITE;
/*!40000 ALTER TABLE `rt_template` DISABLE KEYS */;
INSERT INTO `rt_template` (`id`, `name`, `inhalt`, `timestamp`) VALUES (1,'autoreply','Dies.ist die.Template fuer RT:.autoreply.','2009-10-06 13:50:04'),(2,'comment','Dies.ist die.Template fuer RT:.comment.','2009-10-06 13:50:04'),(3,'correspondence','Dies.ist die.Template fuer RT:.correspondence.','2009-10-06 13:50:04'),(4,'error','Dies.ist die.Template fuer RT:.error.','2009-10-06 13:50:04'),(5,'give','Dies.ist die.Template fuer RT:.give.','2009-10-06 13:50:04'),(6,'respond','Dies.ist die.Template fuer RT:.respond.','2009-10-06 13:50:04'),(7,'steal','Dies.ist die.Template fuer RT:.steal.','2009-10-06 13:50:04'),(8,'transaction','Dies.ist die.Template fuer RT:.transaction.','2009-10-06 13:50:04'),(9,'web_create','Dies.ist die.Template fuer RT:.web_create.','2009-10-06 13:50:04'),(10,'form_comment','Dies.ist die.Template fuer RT:.form_comment.','2009-10-06 13:50:04'),(11,'form_reply','Dies.ist die.Template fuer RT:.form_reply.','2009-10-06 13:50:04'),(12,'remail','Dies.ist die.Template fuer RT:.remail.','2009-10-06 13:50:04'),(13,'docushare','Dies.ist die.Template fuer RT:.docushare.','2009-10-06 13:50:04');
/*!40000 ALTER TABLE `rt_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rz`
--

DROP TABLE IF EXISTS `rz`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `rz` (
  `id` smallint(6) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(255) character set utf8 NOT NULL,
  `standort` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`),
  KEY `r_rz__standort` (`standort`),
  CONSTRAINT `r_rz__standort` FOREIGN KEY (`standort`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `rz`
--

LOCK TABLES `rz` WRITE;
/*!40000 ALTER TABLE `rz` DISABLE KEYS */;
/*!40000 ALTER TABLE `rz` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `startlog`
--

DROP TABLE IF EXISTS `startlog`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `startlog` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `person` int(11) default NULL,
  `programmname` int(11) NOT NULL,
  `hostname` int(11) NOT NULL,
  `verzeichnis` int(11) NOT NULL,
  `argumente` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `programmname` (`programmname`,`timestamp`),
  KEY `r_startlog__person` (`person`),
  KEY `r_startlog__hostname` (`hostname`),
  KEY `r_startlog__verzeichnis` (`verzeichnis`),
  KEY `r_startlog__argumente` (`argumente`),
  CONSTRAINT `r_startlog__argumente` FOREIGN KEY (`argumente`) REFERENCES `startlog_kram` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_startlog__hostname` FOREIGN KEY (`hostname`) REFERENCES `startlog_kram` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_startlog__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_startlog__programmname` FOREIGN KEY (`programmname`) REFERENCES `startlog_kram` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_startlog__verzeichnis` FOREIGN KEY (`verzeichnis`) REFERENCES `startlog_kram` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `startlog`
--

LOCK TABLES `startlog` WRITE;
/*!40000 ALTER TABLE `startlog` DISABLE KEYS */;
INSERT INTO `startlog` (`id`, `timestamp`, `person`, `programmname`, `hostname`, `verzeichnis`, `argumente`) VALUES (6,'2009-10-06 13:49:58',2,9,10,11,NULL),(7,'2009-10-06 13:49:58',2,12,10,11,NULL),(8,'2009-10-06 13:49:59',2,13,10,11,NULL),(9,'2009-10-06 13:50:00',2,14,10,11,NULL),(10,'2009-10-06 13:50:00',2,15,10,11,NULL),(11,'2009-10-06 13:50:02',2,16,10,11,NULL),(12,'2009-10-06 13:50:03',2,17,10,11,NULL),(13,'2009-10-06 13:50:04',2,18,10,11,NULL),(14,'2009-10-06 13:50:06',2,19,10,11,20),(15,'2009-10-06 13:50:07',2,21,10,11,NULL),(16,'2009-10-06 13:50:09',2,22,10,11,NULL),(17,'2009-10-06 13:50:10',2,23,10,11,NULL),(18,'2009-10-06 13:50:10',2,24,10,11,NULL);
/*!40000 ALTER TABLE `startlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `startlog_kram`
--

DROP TABLE IF EXISTS `startlog_kram`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `startlog_kram` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `daten` varchar(767) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `daten` (`daten`(255)),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `startlog_kram`
--

LOCK TABLES `startlog_kram` WRITE;
/*!40000 ALTER TABLE `startlog_kram` DISABLE KEYS */;
INSERT INTO `startlog_kram` (`id`, `timestamp`, `daten`) VALUES (9,'2009-10-06 13:49:58','obj/test/23_umlaut'),(10,'2009-10-06 13:49:58','qsu1.office.noris.de'),(11,'2009-10-06 13:49:58','/home/qsu/kunde'),(12,'2009-10-06 13:49:58','obj/test/24_tables'),(13,'2009-10-06 13:49:59','obj/test/25_transact'),(14,'2009-10-06 13:50:00','obj/test/28_DbFehler'),(15,'2009-10-06 13:50:00','obj/test/29_TransFehler'),(16,'2009-10-06 13:50:02','obj/test/30_IP'),(17,'2009-10-06 13:50:03','obj/test/30_queues'),(18,'2009-10-06 13:50:04','obj/test/31_rt'),(19,'2009-10-06 13:50:06','/usr/pop/rt/bin/rtmail'),(20,'2009-10-06 13:50:06','1|comment'),(21,'2009-10-06 13:50:07','obj/test/32_rtmails'),(22,'2009-10-06 13:50:09','obj/test/33_dbase_help'),(23,'2009-10-06 13:50:10','obj/test/33_globals'),(24,'2009-10-06 13:50:10','obj/test/34_save_db');
/*!40000 ALTER TABLE `startlog_kram` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stunden`
--

DROP TABLE IF EXISTS `stunden`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `stunden` (
  `id` int(11) NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `kunde` int(11) NOT NULL,
  `ticket` bigint(20) unsigned default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `dauer` int(10) unsigned NOT NULL,
  `zeit` int(10) unsigned default NULL,
  `art` smallint(6) NOT NULL,
  `infotext` text character set utf8,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `person` (`person`,`beginn`),
  KEY `kunde` (`kunde`,`beginn`),
  KEY `timestamp` (`timestamp`),
  KEY `ticket` (`ticket`,`beginn`),
  KEY `zeit` (`zeit`,`beginn`),
  KEY `r_stunden__art` (`art`),
  CONSTRAINT `r_stunden__art` FOREIGN KEY (`art`) REFERENCES `stunden_art` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_stunden__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_stunden__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `stunden`
--

LOCK TABLES `stunden` WRITE;
/*!40000 ALTER TABLE `stunden` DISABLE KEYS */;
/*!40000 ALTER TABLE `stunden` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stunden_art`
--

DROP TABLE IF EXISTS `stunden_art`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `stunden_art` (
  `id` smallint(6) NOT NULL auto_increment,
  `name` varchar(30) character set utf8 NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `faktor` smallint(6) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `flags` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `stunden_art`
--

LOCK TABLES `stunden_art` WRITE;
/*!40000 ALTER TABLE `stunden_art` DISABLE KEYS */;
/*!40000 ALTER TABLE `stunden_art` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stundenliste`
--

DROP TABLE IF EXISTS `stundenliste`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `stundenliste` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `person` int(11) NOT NULL,
  `ziel` int(11) default NULL,
  `zuletzt` int(10) unsigned NOT NULL,
  `zeitraum` smallint(6) default NULL,
  `delay` smallint(6) NOT NULL,
  `art` tinyint(4) NOT NULL,
  `kunde` int(11) default NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `person` (`person`),
  KEY `zuletzt` (`zuletzt`),
  KEY `r_stundenliste__ziel` (`ziel`),
  KEY `r_stundenliste__kunde` (`kunde`),
  CONSTRAINT `r_stundenliste__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_stundenliste__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `r_stundenliste__ziel` FOREIGN KEY (`ziel`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `stundenliste`
--

LOCK TABLES `stundenliste` WRITE;
/*!40000 ALTER TABLE `stundenliste` DISABLE KEYS */;
/*!40000 ALTER TABLE `stundenliste` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tarif`
--

DROP TABLE IF EXISTS `tarif`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tarif` (
  `id` int(11) NOT NULL auto_increment,
  `klasse` int(11) NOT NULL,
  `dienst` smallint(6) NOT NULL,
  `frei` int(11) NOT NULL,
  `festpreis` int(11) NOT NULL,
  `preis` int(11) NOT NULL,
  `skala` bigint(20) unsigned NOT NULL,
  `unitpreis` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `mini` int(11) NOT NULL,
  `unitmini` int(11) NOT NULL,
  `intval` char(1) character set ascii NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `festinfo` varchar(255) character set utf8 default NULL,
  `varinfo` varchar(255) character set utf8 default NULL,
  `dnull` char(1) character set ascii NOT NULL default 'n',
  `fnull` char(1) character set ascii NOT NULL default 'j',
  `fkonto` int(11) default NULL,
  `vkonto` int(11) default NULL,
  `freiinfo` varchar(255) character set utf8 default NULL,
  `nonum` char(1) character set ascii NOT NULL default 'n',
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `description` text character set utf8,
  `betriebszeit` varchar(255) character set utf8 default NULL,
  `servicezeit` varchar(255) character set utf8 default NULL,
  `wartungsfenster` varchar(255) character set utf8 default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `klasse` (`klasse`,`dienst`,`beginn`,`mini`,`unitmini`),
  KEY `timestamp` (`timestamp`),
  KEY `r_tarif__dienst` (`dienst`),
  CONSTRAINT `r_tarif__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarif__klasse` FOREIGN KEY (`klasse`) REFERENCES `tarifklasse` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tarif`
--

LOCK TABLES `tarif` WRITE;
/*!40000 ALTER TABLE `tarif` DISABLE KEYS */;
/*!40000 ALTER TABLE `tarif` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tarifacct`
--

DROP TABLE IF EXISTS `tarifacct`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tarifacct` (
  `real_id` int(11) NOT NULL auto_increment,
  `kunde` int(11) default NULL,
  `id` int(11) NOT NULL,
  `tarifname` int(11) default NULL,
  `dienst` smallint(6) default NULL,
  `ziel` smallint(6) default NULL,
  `quelle` smallint(6) default NULL,
  `faktor` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `ddienst` smallint(6) default NULL,
  `dkunde` int(11) default NULL,
  `direkt` char(1) character set ascii NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`real_id`),
  UNIQUE KEY `id` (`id`,`kunde`),
  KEY `timestamp` (`timestamp`),
  KEY `r_tarifacct__kunde` (`kunde`),
  KEY `r_tarifacct__tarifname` (`tarifname`),
  KEY `r_tarifacct__dienst` (`dienst`),
  KEY `r_tarifacct__ddienst` (`ddienst`),
  KEY `r_tarifacct__dkunde` (`dkunde`),
  CONSTRAINT `r_tarifacct__dkunde` FOREIGN KEY (`dkunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifacct__ddienst` FOREIGN KEY (`ddienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifacct__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifacct__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifacct__tarifname` FOREIGN KEY (`tarifname`) REFERENCES `tarifname` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tarifacct`
--

LOCK TABLES `tarifacct` WRITE;
/*!40000 ALTER TABLE `tarifacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `tarifacct` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tarifeq`
--

DROP TABLE IF EXISTS `tarifeq`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tarifeq` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `dienst` smallint(6) NOT NULL,
  `berechne` smallint(6) default NULL,
  `faktor` int(11) NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `isrec` char(1) character set ascii NOT NULL default 'n',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `dienst` (`dienst`),
  KEY `timestamp` (`timestamp`),
  KEY `r_tarifeq__berechne` (`berechne`),
  CONSTRAINT `r_tarifeq__berechne` FOREIGN KEY (`berechne`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifeq__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tarifeq`
--

LOCK TABLES `tarifeq` WRITE;
/*!40000 ALTER TABLE `tarifeq` DISABLE KEYS */;
/*!40000 ALTER TABLE `tarifeq` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tarifklasse`
--

DROP TABLE IF EXISTS `tarifklasse`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tarifklasse` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `tarifname` int(11) NOT NULL,
  `kunde` int(11) default NULL,
  `klassen` int(11) NOT NULL,
  `obsolet` char(1) character set ascii NOT NULL default 'n',
  `laufzeit` smallint(5) unsigned default NULL,
  `verlaengern` smallint(5) unsigned default NULL,
  `kuendigung` smallint(5) unsigned default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `tarifname` (`tarifname`,`kunde`),
  KEY `timestamp` (`timestamp`),
  KEY `r_tarifklasse__kunde` (`kunde`),
  CONSTRAINT `r_tarifklasse__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifklasse__tarifname` FOREIGN KEY (`tarifname`) REFERENCES `tarifname` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tarifklasse`
--

LOCK TABLES `tarifklasse` WRITE;
/*!40000 ALTER TABLE `tarifklasse` DISABLE KEYS */;
/*!40000 ALTER TABLE `tarifklasse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tarifkunde`
--

DROP TABLE IF EXISTS `tarifkunde`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tarifkunde` (
  `id` int(11) NOT NULL auto_increment,
  `kunde` int(11) NOT NULL,
  `tarifname` int(11) default NULL,
  `dienst` smallint(6) NOT NULL,
  `anzahl` smallint(6) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `ablauf` int(10) unsigned default NULL,
  `notiz` int(10) unsigned default NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `rechnung` char(1) character set ascii default NULL,
  `nextrech` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `kunde` (`kunde`,`dienst`),
  KEY `kunde_2` (`kunde`,`beginn`),
  KEY `timestamp` (`timestamp`),
  KEY `r_tarifkunde__tarifname` (`tarifname`),
  KEY `r_tarifkunde__dienst` (`dienst`),
  CONSTRAINT `r_tarifkunde__dienst` FOREIGN KEY (`dienst`) REFERENCES `dienst` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifkunde__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_tarifkunde__tarifname` FOREIGN KEY (`tarifname`) REFERENCES `tarifname` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tarifkunde`
--

LOCK TABLES `tarifkunde` WRITE;
/*!40000 ALTER TABLE `tarifkunde` DISABLE KEYS */;
/*!40000 ALTER TABLE `tarifkunde` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tarifname`
--

DROP TABLE IF EXISTS `tarifname`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tarifname` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `tarifname`
--

LOCK TABLES `tarifname` WRITE;
/*!40000 ALTER TABLE `tarifname` DISABLE KEYS */;
/*!40000 ALTER TABLE `tarifname` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticket`
--

DROP TABLE IF EXISTS `ticket`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ticket` (
  `id` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ticket` int(11) default NULL,
  `kunde` int(11) NOT NULL,
  `subject` varchar(255) character set utf8 NOT NULL,
  `infotext` varchar(255) character set utf8 default NULL,
  `queue` int(11) NOT NULL,
  `queue_area` int(11) default NULL,
  `beginn` int(10) unsigned NOT NULL,
  `wichtig` smallint(6) NOT NULL,
  `status` smallint(6) NOT NULL default '0',
  `termin` int(10) unsigned default NULL,
  `endtermin` int(10) unsigned default NULL,
  `bearbeiter` int(11) default NULL,
  `d_told` int(10) unsigned NOT NULL,
  `d_acted` int(10) unsigned NOT NULL,
  `maxseq` int(11) NOT NULL,
  `zeit` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `ticket` (`ticket`),
  KEY `kunde` (`kunde`,`queue`),
  KEY `timestamp` (`timestamp`),
  KEY `status` (`status`,`bearbeiter`),
  KEY `bearbeiter` (`bearbeiter`,`queue`),
  KEY `queue` (`queue`,`subject`),
  KEY `r_ticket__queue_area` (`queue_area`),
  CONSTRAINT `r_ticket__bearbeiter` FOREIGN KEY (`bearbeiter`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticket__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticket__queue` FOREIGN KEY (`queue`) REFERENCES `queue` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticket__queue_area` FOREIGN KEY (`queue_area`) REFERENCES `queue_areas` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticket__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ticket`
--

LOCK TABLES `ticket` WRITE;
/*!40000 ALTER TABLE `ticket` DISABLE KEYS */;
INSERT INTO `ticket` (`id`, `timestamp`, `ticket`, `kunde`, `subject`, `infotext`, `queue`, `queue_area`, `beginn`, `wichtig`, `status`, `termin`, `endtermin`, `bearbeiter`, `d_told`, `d_acted`, `maxseq`, `zeit`) VALUES (1,'2009-10-06 13:50:07',1,2,'TestFoo 123',NULL,1,NULL,1254837004,0,4,NULL,NULL,NULL,1254837004,1254837006,4,NULL),(2,'2009-10-06 13:50:08',2,2,'TEST: Mails an das RT',NULL,1,NULL,1254837008,0,4,NULL,NULL,NULL,1254837008,1254837008,1,NULL);
/*!40000 ALTER TABLE `ticket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticketabo`
--

DROP TABLE IF EXISTS `ticketabo`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ticketabo` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ticket` int(11) NOT NULL,
  `person` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ticket` (`ticket`,`person`),
  KEY `person` (`person`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_ticketabo__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticketabo__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ticketabo`
--

LOCK TABLES `ticketabo` WRITE;
/*!40000 ALTER TABLE `ticketabo` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticketabo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticketadr`
--

DROP TABLE IF EXISTS `ticketadr`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ticketadr` (
  `id` int(11) NOT NULL auto_increment,
  `ticket` int(11) NOT NULL,
  `person` int(11) default NULL,
  `email` varchar(255) character set utf8 NOT NULL,
  `marker` char(1) character set ascii NOT NULL default '0',
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `ticket` (`ticket`,`email`),
  KEY `ticket_2` (`ticket`,`person`),
  KEY `timestamp` (`timestamp`),
  KEY `r_ticketadr__person` (`person`),
  CONSTRAINT `r_ticketadr__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticketadr__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ticketadr`
--

LOCK TABLES `ticketadr` WRITE;
/*!40000 ALTER TABLE `ticketadr` DISABLE KEYS */;
INSERT INTO `ticketadr` (`id`, `ticket`, `person`, `email`, `marker`, `timestamp`) VALUES (1,1,NULL,'bla@test.fasel.test.example','x','2009-10-06 13:50:04'),(2,1,NULL,'qsu','x','2009-10-06 13:50:04'),(3,2,NULL,'bla@unbekannt.fasel.test.example','x','2009-10-06 13:50:08'),(4,2,NULL,'qsu','x','2009-10-06 13:50:08');
/*!40000 ALTER TABLE `ticketadr` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticketid`
--

DROP TABLE IF EXISTS `ticketid`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ticketid` (
  `id` varchar(255) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `ticket` int(11) NOT NULL,
  `person` int(11) default NULL,
  `email` varchar(255) character set utf8 default NULL,
  `seq` int(11) default NULL,
  `extern` char(1) character set ascii NOT NULL default 'n',
  `typ` smallint(6) NOT NULL,
  `data` varchar(255) character set utf8 default NULL,
  `inhalt` mediumblob NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `ticket` (`ticket`,`seq`),
  UNIQUE KEY `ticket_2` (`ticket`,`extern`,`seq`),
  KEY `timestamp` (`timestamp`),
  KEY `ticket_3` (`ticket`,`typ`,`data`),
  KEY `data` (`data`),
  KEY `person` (`person`),
  KEY `email` (`email`),
  CONSTRAINT `r_ticketid__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticketid__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ticketid`
--

LOCK TABLES `ticketid` WRITE;
/*!40000 ALTER TABLE `ticketid` DISABLE KEYS */;
INSERT INTO `ticketid` (`id`, `timestamp`, `ticket`, `person`, `email`, `seq`, `extern`, `typ`, `data`, `inhalt`) VALUES ('1-1@ticket.fasel.test.example','2009-10-06 13:50:05',1,2,'tester@fubar.test.example',1,'n',2,NULL,'Content-Type: text/plain\nContent-Transfer-Encoding: 8bit\n\nDies ist ein Test-Test.\n'),('1-2@ticket.fasel.test.example','2009-10-06 13:50:06',1,2,'tester@fubar.test.example',2,'n',16,'2','\n'),('1-3@ticket.fasel.test.example','2009-10-06 13:50:06',1,2,'tester@fubar.test.example',3,'n',13,'TestFoo 123','\n'),('2-1@ticket.fasel.test.example','2009-10-06 13:50:08',2,2,'tester@fubar.test.example',1,'n',2,NULL,'Content-Type: text/plain\nContent-Transfer-Encoding: 8bit\n\nDies ist ein Test-Ticket für Mails an das RT.\n\nBitte geflissentlich zu ignorieren. ;-)\n'),('@_SOME_ID_@test.example','2009-10-06 13:50:07',1,NULL,'Tester@joe.test.example',4,'n',4,NULL,'Content-Transfer-Encoding: 8bit\nContent-Type: text/plain; charset=utf-8\nFrom: Tester@joe.test.example\nMessage-Id: <@_SOME_ID_@test.example>\nDate:   Thu, 7 Dec 2000 23:29:36 +0100\n\nDies ist ein Test des rtmail-Programms.\n');
/*!40000 ALTER TABLE `ticketid` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticketlast`
--

DROP TABLE IF EXISTS `ticketlast`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `ticketlast` (
  `ticket` int(11) NOT NULL,
  `person` int(11) NOT NULL,
  `seq` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ticket`,`person`),
  KEY `timestamp` (`timestamp`),
  KEY `r_ticketlast__person` (`person`),
  CONSTRAINT `r_ticketlast__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_ticketlast__ticket` FOREIGN KEY (`ticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `ticketlast`
--

LOCK TABLES `ticketlast` WRITE;
/*!40000 ALTER TABLE `ticketlast` DISABLE KEYS */;
/*!40000 ALTER TABLE `ticketlast` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trouble_ticket`
--

DROP TABLE IF EXISTS `trouble_ticket`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `trouble_ticket` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `rtticket` int(11) default NULL,
  `subject` text character set utf8 NOT NULL,
  `type` smallint(6) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  `priority` smallint(6) NOT NULL,
  `flag_kunde` int(11) default NULL,
  `flag_person` bigint(20) default NULL,
  `text_description` text character set utf8 NOT NULL,
  `text_affected` text character set utf8,
  `text_comment` text character set utf8,
  `text_progress` text character set utf8,
  `text_resolve` text character set utf8,
  `additional_rcpt` text character set utf8 NOT NULL,
  `confirmer` int(11) default NULL,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `rtticket` (`rtticket`,`id`),
  KEY `r_trouble_ticket__confirmer` (`confirmer`),
  CONSTRAINT `r_trouble_ticket__confirmer` FOREIGN KEY (`confirmer`) REFERENCES `person` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_trouble_ticket__rtticket` FOREIGN KEY (`rtticket`) REFERENCES `ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `trouble_ticket`
--

LOCK TABLES `trouble_ticket` WRITE;
/*!40000 ALTER TABLE `trouble_ticket` DISABLE KEYS */;
/*!40000 ALTER TABLE `trouble_ticket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `trouble_ticket_kunde_assoc`
--

DROP TABLE IF EXISTS `trouble_ticket_kunde_assoc`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `trouble_ticket_kunde_assoc` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `trouble_ticket` int(11) NOT NULL,
  `kunde` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `trouble_ticket` (`trouble_ticket`,`kunde`),
  UNIQUE KEY `kunde` (`kunde`,`trouble_ticket`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_trouble_ticket_kunde_assoc__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_trouble_ticket_kunde_assoc__trouble_ticket` FOREIGN KEY (`trouble_ticket`) REFERENCES `trouble_ticket` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `trouble_ticket_kunde_assoc`
--

LOCK TABLES `trouble_ticket_kunde_assoc` WRITE;
/*!40000 ALTER TABLE `trouble_ticket_kunde_assoc` DISABLE KEYS */;
/*!40000 ALTER TABLE `trouble_ticket_kunde_assoc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `updatelog`
--

DROP TABLE IF EXISTS `updatelog`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `updatelog` (
  `id` int(11) NOT NULL auto_increment,
  `person` int(11) NOT NULL,
  `db_tabelle` int(11) NOT NULL,
  `indexspalten` int(11) NOT NULL,
  `wert` varchar(100) character set utf8 NOT NULL,
  `datenspalten` int(11) NOT NULL,
  `dwert` text character set utf8,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `db_tabelle` (`db_tabelle`,`wert`),
  KEY `r_updatelog__person` (`person`),
  KEY `r_updatelog__indexspalten` (`indexspalten`),
  KEY `r_updatelog__datenspalten` (`datenspalten`),
  CONSTRAINT `r_updatelog__datenspalten` FOREIGN KEY (`datenspalten`) REFERENCES `updatelog_spalten` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_updatelog__db_tabelle` FOREIGN KEY (`db_tabelle`) REFERENCES `db_tabelle` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_updatelog__indexspalten` FOREIGN KEY (`indexspalten`) REFERENCES `updatelog_spalten` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_updatelog__person` FOREIGN KEY (`person`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `updatelog`
--

LOCK TABLES `updatelog` WRITE;
/*!40000 ALTER TABLE `updatelog` DISABLE KEYS */;
/*!40000 ALTER TABLE `updatelog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `updatelog_spalten`
--

DROP TABLE IF EXISTS `updatelog_spalten`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `updatelog_spalten` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `namen` varchar(255) character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `namen` (`namen`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `updatelog_spalten`
--

LOCK TABLES `updatelog_spalten` WRITE;
/*!40000 ALTER TABLE `updatelog_spalten` DISABLE KEYS */;
/*!40000 ALTER TABLE `updatelog_spalten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `uucpkunde`
--

DROP TABLE IF EXISTS `uucpkunde`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `uucpkunde` (
  `name` varchar(32) character set utf8 NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `kunde` int(11) NOT NULL,
  PRIMARY KEY  (`name`),
  KEY `kunde` (`kunde`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `r_uucpkunde__kunde` FOREIGN KEY (`kunde`) REFERENCES `kunde` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `uucpkunde`
--

LOCK TABLES `uucpkunde` WRITE;
/*!40000 ALTER TABLE `uucpkunde` DISABLE KEYS */;
/*!40000 ALTER TABLE `uucpkunde` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wartungsvertrag`
--

DROP TABLE IF EXISTS `wartungsvertrag`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `wartungsvertrag` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `name` varchar(255) character set utf8 NOT NULL,
  `sla` varchar(255) character set utf8 NOT NULL,
  `ansprechpartner` int(11) NOT NULL,
  `beschreibung` text character set utf8 NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `timestamp` (`timestamp`),
  KEY `r_wartungsvertrag__ansprechpartner` (`ansprechpartner`),
  CONSTRAINT `r_wartungsvertrag__ansprechpartner` FOREIGN KEY (`ansprechpartner`) REFERENCES `person` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `wartungsvertrag`
--

LOCK TABLES `wartungsvertrag` WRITE;
/*!40000 ALTER TABLE `wartungsvertrag` DISABLE KEYS */;
/*!40000 ALTER TABLE `wartungsvertrag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wartungsvertrag_hardware`
--

DROP TABLE IF EXISTS `wartungsvertrag_hardware`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `wartungsvertrag_hardware` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `hardware` int(11) NOT NULL,
  `wartungsvertrag` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  KEY `hardware` (`hardware`,`beginn`),
  KEY `timestamp` (`timestamp`),
  KEY `r_wartungsvertrag_hardware__wartungsvertrag` (`wartungsvertrag`),
  CONSTRAINT `r_wartungsvertrag_hardware__wartungsvertrag` FOREIGN KEY (`wartungsvertrag`) REFERENCES `wartungsvertrag` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_wartungsvertrag_hardware__hardware` FOREIGN KEY (`hardware`) REFERENCES `hardware` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `wartungsvertrag_hardware`
--

LOCK TABLES `wartungsvertrag_hardware` WRITE;
/*!40000 ALTER TABLE `wartungsvertrag_hardware` DISABLE KEYS */;
/*!40000 ALTER TABLE `wartungsvertrag_hardware` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wartungsvertrag_leitung`
--

DROP TABLE IF EXISTS `wartungsvertrag_leitung`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `wartungsvertrag_leitung` (
  `id` int(11) NOT NULL auto_increment,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `wartungsvertrag` int(11) NOT NULL,
  `leitung` int(11) NOT NULL,
  `beginn` int(10) unsigned NOT NULL,
  `ende` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  KEY `leitung` (`leitung`,`beginn`),
  KEY `timestamp` (`timestamp`),
  KEY `r_wartungsvertrag_leitung__wartungsvertrag` (`wartungsvertrag`),
  CONSTRAINT `r_wartungsvertrag_leitung__leitung` FOREIGN KEY (`leitung`) REFERENCES `leitung` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `r_wartungsvertrag_leitung__wartungsvertrag` FOREIGN KEY (`wartungsvertrag`) REFERENCES `wartungsvertrag` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `wartungsvertrag_leitung`
--

LOCK TABLES `wartungsvertrag_leitung` WRITE;
/*!40000 ALTER TABLE `wartungsvertrag_leitung` DISABLE KEYS */;
/*!40000 ALTER TABLE `wartungsvertrag_leitung` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2009-10-06 13:50:11
