#!/bin/bash

GLIMPSEINDEX="/usr/bin/glimpseindex";
GLIMPSE_DIR="/www/volltextsuche/glimpse";
DUMP_BIN="/www/volltextsuche/bin/dump_tickets";
DUMP_DIR="/www/volltextsuche/dump";
WEB_DIR="/var/www/html";
SAVED_PWD=$PWD;
LOCK_FILE="/www/volltextsuche/lock";
LOG="/www/volltextsuche/log/update_glimpse-`date -I`"

echo "#####  Start dumping on $HOSTNAME `date` #####" >> $LOG

if [ -e $LOCK_FILE ]; then
	echo "Lockfile for update_glimpse.sh exists, giving up.";
	echo "Lockfile for update_glimpse.sh exists, giving up." >> $LOG
	exit 1;
fi

echo -n "`hostname` " >$LOCK_FILE;
date >>$LOCK_FILE;

if [ ! -e $DUMP_DIR ]; then
	if mkdir -p $DUMP_DIR; then
		cd $DUMP_DIR;
	else
		echo "Failed to create directory $DUMP_DIR" >&2;
		exit 1;
	fi;
else
	cd $DUMP_DIR;
fi;

$DUMP_BIN >> $LOG 2>&1

$GLIMPSEINDEX -f -H $GLIMPSE_DIR -o -n $DUMP_DIR >> $LOG 2>&1

chmod 0755 $GLIMPSE_DIR;
chmod 0644 $GLIMPSE_DIR/.??*

cd $SAVED_PWD;

rm -f $LOCK_FILE;

echo "#####  Habe fertig ;-) on $HOSTNAME `date` #####" >> $LOG
exit 0;
