#jesse@fsck.com
#
# $Header: /usr/local/cvsroot/rt/lib/rt/ui/web/forms.pm,v 1.13 1998/08/04 07:09:46 jesse Exp $
#
# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::ui::web::forms;

require Exporter;
use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use CGI qw(:standard center);
use vars qw(@ISA @EXPORT);
@ISA = qw(Exporter);
@EXPORT=qw(FormQueueOptions FormShowNum FormSetUser FormSetSubject
	FormSetKunde FormSetGive FormSetArea FormSetKill FormSetSteal
	FormSetMerge FormConfirmMerge
	FormSetQueue FormSetDateDue FormSetDateFDue FormSetPrio
	FormSetStatus FormReply FormCreate FormCreate_Step2
	FormComment FormRemail FormExec FormSetWork FormDocushare
	FormAddDocushare FormSetInfo FormSetStall
);

use constant STATES_DE => { qw(open offen stalled Wiedervorlage resolved geschlossen dead tot) };

use Cf qw($RT_DEFAULT_FIELDS $TICKET_DOMAIN $RT_DOMAIN);
use RT::support::utils qw(
  can_create_request
  can_display_queue
  can_manipulate_queue
  is_rt_system
  quote_content
  template_read
  template_replace_tokens
);
use Dbase::Help qw(DoFn DoSelect DoSeq DoT DoTime qquote);
use RT::ui::web::support qw(
	esc
	info4kunde
	req_url
	select_a_date
	select_an_int
	xstatus
  );
use RT::database qw(req_in transaction_in);
use RT::database::config qw(get_confitems);
use RT::database::manipulate qw(is_visible);
use RT::I18N qw(english_preferred);
use Encode qw();
use UTFkram qw(decode_anything);
use Dbase::OTRS qw(QueueDaten);

use vars qw(%queues %users %req);

use constant MAX_SEQUENCES => qw(5 10 25 50 100);
use constant TICKETID_MIN_MAX => (8,12); # Länge der Eingabefelder für Ticket-IDs

BEGIN {
	*queues = \%RT::queues;
	*users = \%RT::users;
	*req = \%RT::req;
}

sub enc($) {
	my($txt) = @_;
	return "&nbsp;" unless defined $txt;
	return decode_anything($txt);
}

sub otrs_queues {
	my $res = <<'_';
<script language="JavaScript">
var im_otrs = {
_
	while(my($qn,$q) = each %queues) {
		next if $qn =~ /^\d+$/;

		my($nr,$name) = QueueDaten($qn);
		next unless $nr;
		$res .= "'$qn': '$nr||$name',\n" if $q->{otrs};
	}
	$res =~ s/,\n\z/\n/;
	
	$res .= <<'_';
};
</script>
_
}

sub explain($$) {
	my ( $text, $explanation ) = @_;
	acronym( { title => $explanation }, $text );
}

sub FormQueueOptions($$) {
	my($request,$idlist) = @_;
	my $user = $request->param('auth_user');
	my $en = english_preferred;
	$idlist =~ s/,$// if defined $idlist;

	{
		no warnings 'once';
		$request->param( q_fields => $RT_DEFAULT_FIELDS ) unless $request->param('q_fields');
	}
	$request->delete('q_idlist');
	$request->param('now',$RT::time);

	# Scriptschnipsel um ENTER zu blocken, weil es die falsche
	# submit-Taste trifft. Keine besonders gute Lösung, aber besser als
	# nix.
	print <<'_';
<script language="JavaScript">
var nav = window.Event ? true : false;
if (nav) {
	   window.captureEvents(Event.KEYDOWN);
	      window.onkeydown = NetscapeEventHandler_KeyDown;
} else {
	   document.onkeydown = MicrosoftEventHandler_KeyDown;
}

function NetscapeEventHandler_KeyDown(e) {
	if ( e.which == 13 && e.target.type != 'textarea' && e.target.type != 'submit' ) {
		document.form_filter.filter_aktualisieren.click();
		return false;
	}
	return true;
}

function MicrosoftEventHandler_KeyDown() {
	if ( event.keyCode == 13 && event.srcElement.type != 'textarea' && event.srcElement.type != 'submit' ) {
		document.form_filter.filter_aktualisieren.click();
		return false;
	}
	return true;
}
</script>
_

	my( $confitem_ids, $confitem_names ) = get_confitems();

	my $autoEscape = $request->autoEscape(0); # für <acronym>-Tag im -label

    print map({enc($_)}
    	  startform(-action => req_url($request,'-noquery'=>1), -method=>"get", -name=>'form_filter'),
	  ($request->param('q_sort') ? hidden('q_sort',join(",",$request->param('q_sort'))) : ""),
	  hidden('now',$RT::time),
	  hidden('q_idlist',$idlist),

	  table( { align => 'center' }, # , border => 1 },
			Tr(
				td( {colspan=>4},
				 table(
				  Tr({valign=>"middle"},
				   td(small(
				     b($en?"State:":"Status:"),)),
				   td(small(
				    scrolling_list("q_status",["open","stalled","resolved","dead"],[$request->param('q_status')],4,1,
					  { "open"=>$en?"open":"offen",
					    "stalled"=>$en?"stalled":"Wiedervorlage",
						"resolved"=>$en?"resolved":"geschlossen",
						"dead"=>$en?"dead":"gelöscht"
					  }))),
				   td( {width=>10}, '&nbsp;' ),
				   td(small(
				    b("Queue:"),br(),
					b(checkbox("q_queue_all",$request->param("q_queue_all") ? "checked" : "", "true", $en?" all":" alle")),br(),
					b(checkbox("q_queue_not",$request->param("q_queue_not") ? "checked" : "", "true", $en?" except":" ohne")))),
				   td(small(
				    scrolling_list("queue",[ grep {$_ !~ /^\d+$/ and can_display_queue($_,$user)>0} sort { lc($a) cmp lc($b) } keys %queues ],[$request->param('queue')],4,1))),
				   td( {width=>10}, '&nbsp;' ),
				td(
					[
						small(
							b(
								'Conf.Items:' . br()
								  . checkbox(
									-name  => 'q_ci_not',
									-label => $en
									? explain(
										without =>
'no tickets with any of the selected CIs set.'
									  )
									: explain(
										ohne =>
'keine Tickets, bei denen eines der ausgew&auml;hlten CIs eingetragen ist'
									)
								  )
							)
						),
						scrolling_list(
							-name     => 'q_ci',
							-values   => $confitem_ids,
							-size     => 4,
							-multiple => 'true',
							-labels   => $confitem_names,
						)
					]
				  ),
				   td( {width=>10}, '&nbsp;' ),
				   td({nowrap=>undef},
				    small(
					  b( $en ? 'Owner:' : 'Bearbeiter:' ),br(),
					  b(checkbox("q_owner_all",$request->param("q_owner_all") ? "checked" : "", "true", $en?" all":" alle")),br(),
					  b(checkbox("q_owner_not",$request->param("q_owner_not") ? "checked" : "", "true", $en?" except":" ohne"))
					  )),
					td(
						small(
							scrolling_list(
								'q_owner',
								[
									qw(* --),
									grep !/^\d+$/
									  && !is_rt_system($_)
									  && $_ ne $users{$user}{name},
									sort { lc $a cmp lc $b } keys %users
								],
								[ $request->param('q_owner') ],
								4, 1,
								{
									'*'  => $en ? 'Me'     : 'ich selbst',
									'--' => $en ? 'nobody' : 'niemand'
								}
							)
						)
					  )
				   ))),
			)."\n",
			Tr(
				td(
					{ valign => 'top', colspan => 4 },
					small(
						map '<nobr>' . b( $_->[ $en ? 1 : 2 ] . ': ' )
						  . textfield(
							-name  => $_->[0],
							-size  => 15,
							-force => 1,
							-value => decode_anything( scalar param( $_->[0] ) ),
						  )
						  . '</nobr>',
						    [ q_subject    => 'Subject',   'Titel'      ],
						    [ q_info       => 'Info',      'Info'       ],
						    [ q_area       => 'Area',      'Bereich'    ],
						    [ q_user_other => 'Requestor', 'Antwort an' ],
						    [ q_kunde      =>
						    	explain( Customer => 
'!CUSTOMER = exclude this customer; *CUSTOMER = also tickets of joined customers; !*CUSTOMER = both'
							),
							explain( Kunde =>
'!KUNDE = diesen Kunden ausschlie&szlig;en; *KUNDE = auch verbundene Kunden; !*KUNDE = beides'
							)
						    ],
					)
				)
			),
			Tr(
				td(table(Tr(td({colspan=>2},small(
				  b(a({href=>'/rt-spalten.html', target=>'_blank'}, $en?"Columns:":"Spalten:")),
				   textfield("q_fields",$request->param("q_fields")||"",10,20)))),
				   Tr(
				   td({colspan=>2}, small(
						checkbox("rev",scalar $request->param("rev"),"1",$en?"recent texts first":"neue Texte zuerst"),br(),
						checkbox("fup",scalar $request->param("fup"),"1",$en?"linked tickets first":"verbundene Tickets zuerst"),br(),
						checkbox("nst",scalar $request->param("nst"),"1",$en?"no state changes":"ohne Statusänderungen")
						   ))))),
				td(
				 small(
				  table({cellspacing=>0,width=>"100%"},
				   Tr({valign=>"middle"},
				    td(
				     checkbox("q_updates",$request->param("q_updates")||"","true",$en?" updates only":" nur Updates"),
				     br(),
				     checkbox( q_abo => $request->param('q_abo') || '', undef, $en ? ' only tickets to which I have subscribed' : ' nur von mir abonnierte Tickets' ),
				    ),
				    $idlist ? 
				    td({align=>"right"},
				     table({cellspacing=>0,cellpadding=>0,border=>0},
					  Tr(td(small($en?"Tickets shown:":"Angezeigte Tickets"))),
					  Tr(td({align=>"right"},small(
					   submit("was",$en?"Skip":"überspringen")))),
					  Tr(td({align=>"right"},small(
					   submit("was",$en?"Ignore":"Ignorieren"))))))
				    : "" ),
				   Tr td $idlist ? {colspan=>2} : (),
				         checkbox('own_tickets', $request->param('own_tickets') || '', 'true',
					          $en ? ' my own tickets from all queues' : ' meine eigenen Tickets aus allen Queues'),
					 br,
				         checkbox('own_all_customers', $request->param('own_all_customers') || '', 'true',
					          $en ? ' my own tickets for all customers' : ' meine eigenen Tickets für alle Kunden')
				    ))),
				td({valign=>"middle",align=>"right"},
				   table
				      Tr [ td( small
				                    b 'Limit:',
				                      popup_menu( 'q_limit',
				                                  ['--',10,20,30,50,100,200,500],
				                                  defined $request->param('q_limit') ? $request->param('q_limit') : "--",
				                                  { '--' => $en ? 'all' : 'alle' } ),
				                      $en ? 'tickets' : 'Tickets' ),
				           td( small
				                   b $en?'Show':'Zeige',
				                     popup_menu( -name   => 'max_sequences',
				                                 -values => [ '-', MAX_SEQUENCES ],
				                                 -labels => $en ? { '-' => 'all',  map +($_=>"only the last $_"  ), MAX_SEQUENCES }
				                                                : { '-' => 'alle', map +($_=>"nur die letzten $_"), MAX_SEQUENCES }
				                               ),
				                     $en?'entries':'Einträge' ),
				           td( small
				                   b $en ? 'Refresh' : 'Neuanzeige',
				                     popup_menu( -name    => 'refresh',
				                                 -values  => [0,60,180,300,600,1800,3600],
				                                 -labels  => {    0 => $en ? 'never'       : 'nie',
				                                                 60 => $en ? 'every minute': 'minütlich',
				                                               map( ( $_*60, $en? "every $_ minutes " : "${_}minütlich" ),
				                                                    3, 5, 10, 30
				                                                  ),
				                                               3600 => $en ? 'every hour'  : 'stündlich',
				                                             },
				                               )
				             ),
				         ]
				),
				td({align=>"right"},
				  submit( -name => 'filter_aktualisieren', -value => $en ? 'Update Queue Filters' : 'Filter aktualisieren' ),
				  br,
				  small checkbox(
				            -name    => 'save_settings',
				            -checked => 0,
				            -force   => 1,
				            -label   => $en ? 'Store settings as default.'
					                    : 'Auswahl als Standard speichern.'
				          )
				  )
			)."\n"
	  ),
	  hidden("display","Queue"),
	  endform());

	$request->autoEscape($autoEscape);
}

sub FormShowNum($) {
	my($request) = @_;
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"get", -onSubmit=><<'_'),
	f = document.forms[0];
	if (!f.serial_num.value) {
		alert("Gib doch erstmal 'ne Ticket-ID ein!");
		return false;
	} else {
		t = f.serial_num.value.split('-');
		if ( t.length > 1 ) {
			f.serial_num.value = t[0];
			f.action = location.href + '#t-' + t[0] + '-' + t[1];
		}
		return true;
	}
_
		hidden("display","History"),
		xstatus($request),

		submit("was",$en?"Display Request #":"Zeige Ticket Nr."),
		textfield("serial_num","", TICKETID_MIN_MAX),
		endform());
}

sub FormSetUser($){
	my($request) = @_;
	my($serial) = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'user'),
		xstatus($request),

		submit("was",$en?"Set requestor to":"Sende Antworten an"),
		textfield("requestors",$req{$serial}{requestors},40,255),
		endform());
}

sub FormSetSubject($){
	my($request) = @_;
	my($serial) = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'subject'),
		xstatus($request),

		submit("was",$en?"Set subject of #$serial to":"Neuer Titel für #$serial"),
		textfield("subject",$req{$serial}{subject},60,255),
		endform());
}

sub FormSetInfo($){
	my($request) = @_;
	my($serial) = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'info'),
		xstatus($request),

		submit("was",$en?"Set info message of #$serial to":"Neuer Info-Text für #$serial"),
		textfield("info",$req{$serial}{info},60,255),
		endform());
}

sub FormExec($){
	my($request) = @_;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("display",'exec'),
		xstatus($request),

		submit("was","Execute"),
		textfield("command","",100,200),
		endform());
	if(param('command')) {
		print "<PRE>\n\n*** Command ***\n".param('command');
		my $res = eval param('command');
		if($@) {
			print "\n\n*** Error ***\n$@";
		} else {
			print "\n\n*** Result ***\n$res";
		}
		print "\n\n</PRE>\n";
	}
}

sub FormSetKunde($){
	my($request) = @_;
	my($serial) = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'kunde'),
		xstatus($request),

		submit("was",$en?"Set customer of #$serial to":"Neuer Kunde für Ticket #$serial:"),
		textfield("kunde",$req{$serial}{kunde},20,40),
		endform());
}

sub FormSetGive($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $owner = $req{$serial}{owner};
	my $en = english_preferred;
	$owner = "--" if $owner eq "";

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'give'),
		xstatus($request),

		submit("was",$en?"Give to":"Neuer Bearbeiter:"),
		popup_menu("owner",
				   [ ( "--", grep {$_ !~ /^\d+$/ and can_display_queue ($req{$serial}{queue_id},$_)>0} sort { lc($a) cmp lc($b) } keys %users ) ],
				   $owner,{"--" => $en?"nobody":"niemand"}),
	    endform());
}

sub FormSetArea($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $area = $req{$serial}{area};
	my $en = english_preferred;
	$area = "--" if not defined $area or $area eq "";
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'area'),
		xstatus($request),

		submit("was",$en?"Set area to":"Neuer Bereich:"),
		popup_menu("area",
				   filtered_areas( keys %{$queues{$req{$serial}{queue_id}}{areas}} ),
				   $area,{"--" => "None"}),
	    endform());
}

sub FormSetKill($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'kill'),
		xstatus($request),

		submit("yes_do_it",$en?"Kill #$serial":"Ticket #$serial löschen"),
		submit("dummy","Abort"),
		endform());
}

sub FormSetSteal($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'steal'),
		xstatus($request),

		submit("yes_do_it",$en?"Steal #$serial":"Ticket #$serial stehlen"),
		submit("dummy","Abort"),
		endform());
}

sub FormSetMerge($){
	my($request) = @_;
	my($serial) = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden( display => 'ConfirmMerge' ),
		xstatus($request),

		submit("was",$en?"Merge #$serial to":"Ticket #$serial verbinden mit #"),
		textfield("merge_into","", TICKETID_MIN_MAX),
		endform());
}

sub FormConfirmMerge($) {
	my ($request) = @_;
	my $serial     = $request->param('serial_num');
	my $merge_into = $request->param('merge_into');
	my $en = english_preferred();
	req_in( $merge_into, $request->param('auth_user') );
	RT::ui::web::display_summary($request, $merge_into);
	print map({enc($_)}
	      hr(),
	      startform( -action => req_url( $request, -noquery=>1 ), -method => 'post' ),
	      map( hidden($_), qw(auth_user merge_into serial_num) ),
	      xstatus($request),
	      submit( yes => $en ? "Merge ticket #$serial with the one displayed above"
	                         : "Ticket #$serial mit dem oben angezeigten verbinden" ),
	      ' ',
	      submit( no  => $en ? 'Abort' : 'Aktion abbrechen' ),
	      hidden( whatever => 'merge' ),
	      endform());
}

sub FormSetQueue($){
	my($request) = @_;
	my $user = $request->param('auth_user');
	my $serial = $request->param('serial_num');
	my $queue = $req{$serial}{queue};
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'queue'),
		xstatus($request),

		submit("was",$en?"Set queue to":"Neue Queue:"),
		popup_menu("queue",
				   [ grep {$_ !~ /^\d+$/ and can_create_request($_,$user)>0 } sort { lc($a) cmp lc($b) } keys %queues ],
				   $queue,{"--" => "None"}),
	    endform());
}

sub FormSetDateDue($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'date_due'),
		xstatus($request),

		submit("was",$en?"Set Re-Open Date to":"Wiedervorlage am:"),
		select_a_date($req{$serial}{date_due}, "due",$en),
		endform());
}  

sub FormSetStall($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'stall'),
		xstatus($request),

		submit("was",$en?"Stall ticket #$serial":"Ticket #$serial auf Wiedervorlage"),
		p(),
		$en?"Re-Open date: ":"Wiedervorlage am: ",
    	select_a_date($req{$serial}{date_due}, "due",$en),
		p(),
		$en?"New State: ":"Neuer Status: ",
		textfield("info",$req{$serial}{info},50,255),
		endform());
}

sub FormSetDateFDue($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'date_fdue'),
		xstatus($request),

		submit("was",$en?"Set Due Date to":"Fällig am:"),
		select_a_date( $req{$serial}{date_fdue} || DoTime()+7*86400, 'fdue', $en, 1 ),
		endform());
}

sub FormSetWork($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'work'),
		xstatus($request),

		submit("was",$en?"Set scheduled work time to":"Geplante Arbeitszeit:"),
		textfield("work","", TICKETID_MIN_MAX),
		$en?'hours':'Stunden',
		endform());
}  

sub FormSetPrio($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;
    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'prio'),
		xstatus($request),

		submit("was",$en?"Set #$serial's priority to":"Neue Priorität:"),
		select_an_int($req{$serial}{priority}, "prio"),
		endform());
}  

sub FormSetStatus($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;

    if ($req{$serial}{status} eq 'dead') { 
		print "You cannot reopen requests that have been killed.";
		return;
    }

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'status'),
		xstatus($request),

		submit("was",$en?"Set #$serial's status to":"Neuer Status"),
		popup_menu("status",["open","stalled","resolved","dead"],$req{$serial}{status}, $en ? () : STATES_DE),
		endform());
}

### Diese JS-Funktion modifiziert das RT-Submit-Formular, so dass es
### Antworten an die Queues, die im OTRS stehen, dort hinschickt.

sub do_queue_stuff() {
	print <<'_';
<script type="text/javascript" src="jquery/jquery.js"></script>
<script type="text/javascript" src="jquery/cookie.js"></script>
_
	print otrs_queues();
	print <<_;
<script language="JavaScript">
var TICKET_DOMAIN = "$TICKET_DOMAIN";
var RT_DOMAIN = "$RT_DOMAIN";
_
	print <<'_';
$(document).ready(function() {
	var did_it = false;

	var xmit = $('form.xmit').get(0);
	var status = $(xmit).find("select[name='status']").get(0);
	var subject = $(xmit).find("input[name='subject']").get(0);
	var adrto = $(xmit).find("input[name='to']").get(0);
	var adrcc = $(xmit).find("input[name='cc']").get(0);
	var adrbcc = $(xmit).find("input[name='bcc']").get(0);
	var info = $(xmit).find("input[name='info']").get(0);
	var action = $(xmit).find("input[name='whatever']").get(0);
	var serial = $(xmit).find("input[name='serial_num']").get(0);
	var display = $(xmit).find("input[name='display']").get(0);
	var submit = $(xmit).find("input[type='submit']").get(0);
	var content = $(xmit).find("textarea[name='content']").get(0);
	var queue = $("select[name='queue']").get(0);
	var area = $("tr#area").get(0);
	var exte = $("tr#extern").get(0);
	var wv = $("span#wv").get(0);
	var form = $("span#formular").get(0);
	var sig = "";
	var sig_otrs = "Der Text ist im OTRS editierbar.";
	var act = "";
	var subm = "";
	var subm_otrs = '⇒ OTRS';
	var oto = "";
	var nto;
	var qnname = "queue";
	var OTRSpath = "AgentTicketPhone";

	if(serial) { nto = serial.value+"@"+RT_DOMAIN; }

	if(! queue) {
		queue = $("select[name='queue_new']").get(0);
		qnname = "queue_new";
		OTRSpath = "AgentTicketEmail";
	}

	setter = function () {
		did_it = true;
		if(im_otrs[$(this).attr('value')]) {
			$(this).addClass( 'otrs' ); // debug
			xmit.action = '/otrs/index.fpl';
			// if(! $.cookie('OTRS')) {
				xmit.method='get';
			// }
			if(status) {
				status.name = 'NextState';
				$(status).find("option:eq(0)").attr('value','open');
				$(status).find("option:eq(1)").attr('value','pending reminder');
				$(status).find("option:eq(2)").attr('value','closed successfully');
				$(status).find("option:eq(3)").attr('value','removed');
			}
			if(subject) { subject.name = 'Subject'; }
			if(adrto) {
				adrto.name = 'To';
				if(serial && oto == "") {
					oto = adrto.value;
					if(oto != "") {
						adrto.value = nto+", "+oto
					} else {
						adrto.value = nto;
					}
				}
			}
			if(adrcc) { adrcc.name = 'Cc'; }
			if(adrbcc) { adrbcc.name = 'Bcc'; }
			if(queue) { queue.name = 'Dest'; }
			if(display) { display.name = 'Action'; display.value=OTRSpath; }
			if(submit) {
				if(submit.value != subm_otrs) {
					subm = submit.value;
					submit.value = subm_otrs;
				}
			}
			if(info) { info.name = 'TicketFreeText1'; }
			if(serial) { serial.disabled = "disabled"; }
			if(area) {
				$(area).css('display','none');
				$(area).filter('input').attr('disabled','disabled');
				$(area).filter('select').attr('disabled','disabled');
			}
			if(exte) {
				$(exte).css('display','none');
				$(exte).filter('input').attr('disabled','disabled');
				$(exte).filter('select').attr('disabled','disabled');
			}
			if(wv) {
				$(wv).css('display','none');
				$(wv).filter('input').attr('disabled','disabled');
				$(wv).filter('select').attr('disabled','disabled');
			}
			if(form) {
				$(form).css('display','none');
				$(form).filter('input').attr('disabled','disabled');
				$(form).filter('select').attr('disabled','disabled');
			}
			if(action && (action.name != 'Action')) {
				act = action.value;
				action.name = 'Action';
				action.value = OTRSpath;
			}
			if(content) {
				content.name = 'Body';
				if (false) { //if($.cookie('OTRS'))
					var txt = content.value;
					if(txt) {
						var ti = txt.indexOf("\n-- \n");
						if(ti > -1) {
							sig = txt.slice(ti);
							content.value = txt.slice(0,ti);
						}
					}
				} else {
					if (content.value != sig_otrs) {
						sig = content.value;
						content.value = sig_otrs;
					}
					content.disabled = "disabled";
				}
			}
		} else {
			$(this).addClass( 'rt' ); // debug
			xmit.action = '/rt';
			xmit.method='post';
			if(status) {
				status.name = 'status';
				$(status).find("option:eq(0)").attr('value','open');
				$(status).find("option:eq(1)").attr('value','stalled');
				$(status).find("option:eq(2)").attr('value','resolved');
				$(status).find("option:eq(3)").attr('value','dead');
			}
			if(subject) { subject.name = 'subject'; }
			if(adrto) {
				adrto.name = 'to';
				if(oto != "" || adrto.value == nto) {
					adrto.value = oto;
					oto = "";
				}
			}
			if(adrcc) { adrcc.name = 'cc'; }
			if(adrbcc) { adrbcc.name = 'bcc'; }
			if(queue) { queue.name = qnname; }
			if(display) { display.name = 'display'; display.value="Create_Step2"; }
			if(submit) { if(subm != "") { submit.value = subm; } }
			if(info) { info.name = 'info'; }
			if(serial) { serial.disabled = false; }
			if(area) {
				$(area).css('display',''); }
				$(area).removeAttr('disabled');
			if(wv) {
				$(wv).css('display',''); }
				$(wv).removeAttr('disabled');
			if(form) {
				$(form).css('display',''); }
				$(form).removeAttr('disabled');
			if(exte) {
				$(exte).css('display',''); }
				$(exte).removeAttr('disabled');
			if(action && (action.name == 'Action')) {
				action.name = 'whatever';
				action.value = act;
			}
			if(content) {
				content.name = 'content'; 
				if(content.disabled) {
					content.disabled = false;
					if (sig != "") {
						content.value = sig;
						sig = "";
					}
				} else {
					var txt = content.value;
					if(txt) {
						var ti = txt.indexOf("\n-- \n");
						if(ti == -1) {
							content.value = txt+sig;
						}
					}
				}
			}
		}
	};
	disabler = function () {
		if(im_otrs[this.value]) {
			$(this).css('color','#666');
			this.value = im_otrs[this.value];
			im_otrs[this.value] = 1;
		}
	};

	$(queue).find("option").each(disabler);
	$(queue).find("option:selected").each(setter);
	if (! did_it) {
		$(queue).find("option:first").each(setter);
	}
	$(queue).change(function() {
		$(this).children(':selected').each(setter);
	});
});

</script>
_

}

sub FormReply($;$){
	my($request,$gr) = @_;
	my $serial = $request->param('serial_num');
	my $user = $request->param('auth_user');
	my $transaction = $request->param('transaction');
	my $en = english_preferred;
	my $area = $req{$serial}{area};
	$area = '--' if !defined $area || $area eq '';
	$transaction=[split(/-/,$transaction)] if $transaction;

	do_queue_stuff();

    my $reply_content = "";
	my ($to,$gto,$cc,$subject);
	if($transaction) {
		($reply_content,$to,$gto,$cc,$subject) = quote_content($transaction,$user,"form_reply");
    } else {
		$reply_content = template_read("form_reply",$req{$serial}{queue});
	    $reply_content = template_replace_tokens($reply_content,$serial,[$serial,0], '', $user);
	}
	if(not $gr) { # standard reply
		$to = $req{$serial}{requestors};
		$cc = "";
		$subject = $req{$serial}{subject};
	} elsif($gr == 1) { # reply
		unless ($to) {
			$to = transaction_in($transaction, $user)->{actor};
			undef $to if $to eq '<unbekannt>';
		}
		$to = $req{$serial}{requestors} unless $to;
		$cc = "";
	} else { # group reply
		$to = $to.", ".$gto if $to and $gto;
		$to = $gto unless $to;
		$to = $req{$serial}{requestors} unless $to;
	}
    print map({enc($_)}
    		startform(-class => 'submitter', -action => req_url($request,'-noquery'=>1), -method=>"post", -class=>"xmit"),
		hidden("serial_num",$serial),
		hidden(queue=>$req{$serial}{queue}{name}),
		hidden("whatever",'respond'),
		hidden("TicketSystem",'RT'),
		xstatus($request),

		h1($gr?($gr>1)?($en?"Enter your group reply below:":"Sende eine Gruppenantwort:"):($en?"Enter your reply below:":"Sende eine Antwort:"):($en?"Enter your reply to the requestor below:":"Sende eine Antwort an den Kunden:")),
		table(
			Tr(
				td({align=>'right'},'Subject:'),
				td({id=>'f_subject'},textfield("subject","Re: $subject",50,255))
			),
			Tr(
				td({align=>'right'},'From:'),
				td(esc($users{$user}{email}))
			),
			Tr(
				td({align=>'right'},'To:'),
				td(textfield("to",$to,50,250))
			),
			Tr(
				td({align=>'right'},'Cc:'),
				td(textfield("cc",$cc,50,250))
			),
			Tr(
				td({align=>'right'},'Bcc:'),
				td(textfield("bcc","",50,250))
			),
			Tr({id => 'area'},
				td( { align => 'right' }, $en ? 'Area' : 'Bereich' ),
				td(
					popup_menu(
						'area',
						filtered_areas(
							keys %{ $queues{ $req{$serial}{queue_id} }{areas} }
						),
						$area,
						{ '--' => 'None' }
					)
				)
			  ),
			Tr(
				td({align=>'right'},'Status:'),
				td(
					popup_menu("status",["open","stalled","resolved","dead"],'open', $en ? () : STATES_DE),
					span({id=>'wv'},
					$en?'if stalled:':'falls WV:',
					select_a_date($req{$serial}{date_due}, 'due', $en))
				)
			),
			Tr(
				td({align=>'right'}, 'Info:'),
				td(textfield('info',$req{$serial}{info},60,255)),
			),
			Tr({id=>"extern"},
				td({colspan=>2},
					checkbox(-name=>'extern', -label=>$en?'make this message visible for the customer via our website':'diese Nachricht für den Kunden über unsere WebSite sichtbar machen', -checked=>is_visible($serial,$req{$serial})))),
			Tr(
				td({colspan=>2},
					textarea(-name=>"content",-wrap=>"hard",-default=>$reply_content,-columns=>80,-rows=>30),
					br,
					b($en?"Warning!":"Aufpassen!"),$gr?($en?"This text may be sent to external recipients!":"Dieser Text geht möglicherweise nach außen!"):($en?"This text is sent to our customer!":"Dieser Text geht an den Kunden!"),b($en?"Careful!":"Vorsicht!")
				)
			),
			Tr(
				td({align=>'right', colspan=>2}, submit("was","Send reply"))
			)
		),
		endform());
}

sub FormCreate($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $user = $request->param('auth_user');
	my $en = english_preferred;
	my @form;
	DoSelect {
		push(@form,$_[0]);
	} "select name from rt_formular order by name";

	do_queue_stuff();

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"get", -class=>"xmit"),
		hidden("serial_num",$serial),
		hidden("display",'Create_Step2'),
		hidden("TicketSystem",'RT'),
		xstatus($request),

		submit("was",$en?"Create request in queue":"Neues Ticket in Queue"),
		popup_menu("queue",
				   [ grep {$_ !~ /^\d+$/ and can_create_request($_,$user,1)>0 } sort { lc($a) cmp lc($b) } keys %queues ]),
		span({id => 'formular'},$en?" using the template ":", mit Formular: ",
		popup_menu("formular",
				   [ ("--", @form)],"--",{"--"=>$en?"none":"keines"})),
	    endform());
}

sub FormCreate_Step2($) {
	my($request) = @_;
	my $user = $request->param('auth_user');
    my $queue_id = $request->param('queue');
	my $en = english_preferred;

	if($queues{$queue_id}{otrs}) {
		# passiert z. B. wenn JavaScript aus ist
		my($nr,$name) = QueueDaten($queues{$queue_id}{name});
		$name = "&Dest=$nr||$name" if $name;
		print $request->redirect(-nph => !$DB::apache2, -uri => '/otrs/index.fpl?Action=AgentTicketPhone');
		return;
	}

	do_queue_stuff();

	$request->param('subject',decode_anything($request->param('subject')))
		if defined $request->param('subject');
	$request->param('info',decode_anything($request->param('info')))
		if defined $request->param('info');

    my $template=template_read("web_create",$queue_id);
    $template=template_replace_tokens($template,0,[],"", $user);
	if($request->param('formular')) {
		my $form = DoFn("select inhalt from rt_formular where name=${\qquote $request->param('formular')}");
		if($form) {
			$template=template_replace_tokens($form,0,[],"", $user).$template;
		}
	}
	# print STDERR "queue_id $queue_id users ".join(":",sort keys %users)."\n";
	my $id = $request->param('new_ticket_id') || DoSeq("ticket");

    print map({enc($_)}
    		h1("Create a new request in queue",i($queue_id)),p(),
		startform(-action => req_url($request,'-noquery'=>1), -method=>"post", -class=>"xmit"),
		hidden("whatever",'create'),
		hidden("queue",$queue_id),
		## hidden("otrs_queue",1) if $queues{$queue_id}{'otrs'}; ## brauchen wir das auch?
		hidden("new_ticket_id",$id),
		xstatus($request),

		table(
			Tr(
				td({align=>"right"},
				   "Ticket:"),
				td(b($id))),
			Tr(
				td({align=>"right"},
				   $en?"Created by:":"Angelegt von:"),
				td($user)),
			Tr(
				td({align=>"right"},
				   "Queue:"),
				td($queue_id)),"\n",
			Tr({id => 'area'},
				td({align=>"right"},
				   $en?'Area:':'Bereich:'),
				can_manipulate_queue($queue_id,$user)>0 ?
				  td(
				     popup_menu("area",
				      filtered_areas( keys %{$queues{$queue_id}{areas}} ),
				      "--",{"--" => "None"})) :
				  i("None")),"\n",
			Tr(
				td({align=>"right"},
				   $en?"Owner:":"Bearbeiter:"),
				td(popup_menu("owner",
				   [ "--", grep {$_ !~ /^\d+$/ and can_display_queue ($queue_id,$_)>0} sort { lc($a) cmp lc($b) } keys %users ],
				   "--",{"--" => $en?"nobody":"niemand"}))),"\n",
			Tr(
				td({align=>"right"},
				   $en?"Priority:":"Priorität:"),
				td(select_an_int($queues{queue_id}{default_prio},"prio"))),"\n",
			Tr(
				td({align=>"right"},
				   $en?"Re-Open Date:":"Wiedervorlage:"),
				td(select_a_date($queues{queue_id}{default_due}?$queues{queue_id}{default_due}+$RT::time:0,"due",$en,1))),"\n",
			Tr(
				td({align=>"right"},
				   $en?"Due Date:":"Termin:"),
				td(select_a_date($queues{queue_id}{default_fdue}?$queues{queue_id}{default_fdue}+$RT::time:0,"fdue",$en,1))),"\n",
			Tr(
				td({align=>"right"},
				   $en?"Requestor:":"Antworten an:"),
				td(textfield("requestors", ($user eq 'anonymous') ? "" : $users{$user}{email}, 40,255),
				   br,
				   checkbox('mail2requestors', 'checked', 'X', $en?'mail this message to the requestor(s)':'diesen Comment per Mail an den Anfragenden senden'))),
			Tr({id=>"extern"},
				td({colspan=>2},
					checkbox(-name=>'extern', -label=>$en?'make this message visible for the customer via our website':'diese Nachricht für den Kunden über unsere WebSite sichtbar machen', -checked=>$queues{$queue_id}{rtweb} ))),
			Tr(
				td({align=>"right"},
			   $en?"Subject:":"Titel:"),
				td(textfield("subject","",50,255))),"\n",
			Tr(
				td({align=>"right"},
				   'Info:'),
				td(textfield("info","",50,255))),"\n",
			Tr(
				td({align=>"right"},
				   $en?"Customer:":"Kunde:"),
				script( "info4kunde = '" . info4kunde($request) . "'" ),
				td(textfield('kunde','POP',20,40) . ' ' . a( { href => info4kunde($request), target=>'kundeninfo', -onClick =>
				# Zuweisung an this.search funktioniert leider nicht mit Thomas' Opera, vgl. RT#307070-25:
				# q(this.search = 'kunde=' + escape(document.forms[0].elements['kunde'].value))
				  q( this.href = info4kunde.replace( /<kunde>/g, escape(document.forms[0].elements['kunde'].value) ) )
				  }, 'Informationen zu diesem Kunden') )),"\n",
			Tr(
				td({align=>"right"},
				   "Cc:"),
				td(textfield("cc","",40,200))),"\n",
			Tr(
				td({align=>"right"},
				   "Bcc:"),
				td(textfield("bcc","",40,200))),"\n",
			Tr(
				td({align=>"right",valign=>"top"},
				   $en?"Content:":"Inhalt"),
				td(textarea(-name=>"content",-wrap=>"hard",-default=>$template,-columns=>80,-rows=>25))),"\n",
			Tr(
				td(),td({align=>"right"}, submit("was",$en?"Create request":"Ticket anlegen")))
		),
		endform());
}

sub FormComment($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $user = $request->param('auth_user');
	my $transaction = $request->param('transaction');
	my $req = $req{$serial};
	my $en = english_preferred;
	my $area = $req{$serial}{area};
	$area = '--' if !defined $area || $area eq '';

	do_queue_stuff();

    my ($reply_content);
	$request->param('status',"open");
	if($transaction) {
		$transaction=[split(/-/,$transaction)];
	    $reply_content= quote_content($transaction,$user,"form_comment");
	}
	else {
	    $reply_content = template_read( form_comment => $req{$serial}{queue});
	    $reply_content = template_replace_tokens($reply_content,$serial,[$serial,0], '', $user);
	}

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post", -class=>"xmit"),
		hidden("serial_num",$serial),
		hidden("whatever",'comment'),
		hidden("TicketSystem",'RT'),
		hidden("CustomerID",$req->{'kunde'}), ## für OTRS
		xstatus($request),

		h1("Enter your comments below:"),
		table(
			Tr(
				td({align=>"right"},
				   $en?'Subject:':'Titel:'),
				td(textfield("subject",$req->{subject}||"",60,255))),
			Tr(
				td({align=>"right"},
				   "To:"),
				td(textfield("to",$req->{actor},40,200))),
			Tr(
				td({align=>"right"},
				   "Cc:"),
				td(textfield("cc","",50,200))),
			Tr(
				td({align=>"right"},
				   "Bcc:"),
				td(textfield("bcc","",50,200))),
			Tr(
				td({align=>"right"},
					"in Queue:"),
				td(popup_menu("queue_new",
				   [ ("--",grep {$_ !~ /^\d+$/ and can_create_request($_,$user,1)>0 } sort { lc($a) cmp lc($b) } keys %queues )],"--",{"--" => $en?"Current Request":"aktueller Request"}))),
			Tr({id => 'area'},
				td( { align => 'right' }, $en ? 'Area' : 'Bereich' ),
				td(
					popup_menu(
						'area',
						filtered_areas(
							keys %{ $queues{ $req{$serial}{queue_id} }{areas} }
						),
						$area,
						{ '--' => 'None' }
					)
				)
			  ),
			Tr(
				td({align=>"right"},
				   "Status:"),
				td(popup_menu("status",["open","stalled","resolved","dead"],
					"open",# $req{$serial}{status},
					$en ? () : STATES_DE ),
					span({id=>'wv'},
					$en?'if stalled:':'falls WV:',
					select_a_date($req{$serial}{date_due}, 'due', $en))
				)
			),
			Tr(
				td({align=>'right'}, 'Info:'),
				td(textfield('info',$req{$serial}{info},60,255)),
			),
			Tr({id=>"extern"},
				td({colspan=>2},
					checkbox(-name=>'extern', -label=>$en?'make this comment visible for the customer via our website':'diesen Kommentar für den Kunden über unsere WebSite sichtbar machen'))),
			Tr(
				td({colspan=>2},textarea(-name=>"content",-wrap=>"hard",-default=>$reply_content,-columns=>80,-rows=>30))),
			Tr(
				td({colspan=>2,align=>"right"}, submit("was",$en?"Submit comment":"Kommentar abschicken")))),
		#submit("was","Submit comment"),
		endform());
}

sub FormRemail($){
	my($request) = @_;
	my $transaction = $request->param('transaction');
	$transaction=[split(/-/,$transaction)];
	my $serial = $transaction->[0];
	my $trans = $transaction->[1];
	my $en = english_preferred;

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("transaction","$serial-$trans"),
		hidden("whatever",'remail'),
		xstatus($request),

		submit("was",$en?"Bounce #$serial-$trans to ":"Maile #$serial-$trans an"),
		textfield("to","",50,255),
		endform());
}

sub FormDocushare($){
	my($request) = @_;
	my $serial = $request->param('serial_num');
	my $en = english_preferred;

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("serial_num",$serial),
		hidden("whatever",'docushare'),
		xstatus($request),

		submit("was",$en?"Link request #$serial to DocuShare #":"Verbinde Ticket #$serial mit DocuShare-#"),
		textfield("document","",12,12),
		endform());
}

sub FormAddDocushare($){
	my($request) = @_;
	my $en = english_preferred;

	my $doc = $request->param('document');
	$doc =~ s/^File-//i;

    print map({enc($_)}
    		startform(-action => req_url($request,'-noquery'=>1), -method=>"post"),
		hidden("document",$doc),
		hidden("whatever",'docushare'),
		xstatus($request),

		submit("was",$en?"Link request #":"Verbinde Ticket #"),
		textfield("serial_num","", TICKETID_MIN_MAX),
		$en?" to DocuShare #$doc":" mit DocuShare-#$doc",
		endform());
}

sub filtered_areas { [ '--', grep !/^(?:\||\d+$)/, sort { lc $a cmp lc $b } @_ ] };

1;
