# (c) 1999 Matthias Urlichs, smurf@noris.de

package RT::ui::web::auth;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use vars qw(@ISA @EXPORT_OK);
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(AuthCheck AuthFail AuthForceLogout AuthForceLogin);
use Cf qw($BGCOLOR);
use RT::database;
use CGI qw/:standard :html3/;
use MIME::Base64 qw/decode_base64/;


sub AuthFail($$$) {
    my ($request,$AuthRealm, $AuthError) = @_;
    print header(-nph=>!$DB::apache2, -status=>"401 Unauthorized",
				"WWW-Authenticate"=>"Basic realm=$AuthRealm"),
	        start_html( -bgcolor => $BGCOLOR, -title => 'Unauthorized' ),
                h1("Unauthorized"),
			        "You are not authorized to access these pages.", p,
			"Error: $AuthError", hr(), end_html();
#<html><head><title>Logged out</title></head><body bgcolor=\"#ffffff\"><center><TABLE WIDTH=\"80%\" border=0 cellpadding=20><TR><TD>You have been logged out of RT.  To log back in, please click <a HREF=\"$ScriptURL\"> here.</a> </TD></TR></TABLE></center></body></html>
}

sub AuthForceLogout($$) {
    my ($request,$AuthRealm) = @_;
    print header(-nph=>!$DB::apache2, -status=>"401 Unauthorized",
				"WWW-Authenticate"=>"Basic realm=$AuthRealm"),
	        start_html(-title=>"Logged out",-bgcolor=>"#ffffff"),
			center(
			table({-width=>"80%",-border=>0,-cellpadding=>20},
				Tr(
					td("You have been logged out of RT.  To log back in,
					please click",a({-href=>$request->url(-absolute=>1,-path_info=>1)},"here"),"."
				)))),hr(), end_html();

#<html><head><title>Logged out</title></head><body bgcolor=\"#ffffff\"><center><TABLE WIDTH=\"80%\" border=0 cellpadding=20><TR><TD>You have been logged out of RT.  To log back in, please click <a HREF=\"$ScriptURL\"> here.</a> </TD></TR></TABLE></center></body></html> ";

}
sub AuthForceLogin ($$) {
    my ($request,$AuthRealm) = @_;
    print header(-nph=>!$DB::apache2, -status=>"401 Unauthorized",
				"WWW-Authenticate"=>"Basic realm=$AuthRealm"),
	        start_html("Login required"),h1("Login required"),<<'END',
This RT Server requires you to log in with your RT username and password.
If you are unsure of your RT username or password, please seek out your
local RT administrator.
END
			end_html();
}

1;
