# 
#
# Request Tracker is Copyright 1997 Jesse Reed Vincent <jesse@fsck.com>
# RT is distributed under the terms of the GNU Public License
# (c) 1999-2006 Matthias Urlichs, smurf@noris.de

package RT::database;
no warnings 'redefine';

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;

use Cf qw($MAILDOM);
use Dbase::Help qw(
  Do
  DoBinary
  DoFn
  DoN
  DoSelect
  DoSeq
  DoTrans
  isotime
  qquote
  text_only
  unixtime
);
use Dbase::Globals qw( find_descr find_kunde_by_mail content
                       get_descr get_gruppen get_kunde get_person
                       kkpersinfo mpersinfo test_gruppe time4ticket );
use UTFkram qw(decode_anything);
use Loader qw(ticket_has_mail);
require Exporter;
use vars qw(@ISA @EXPORT_OK);
@ISA = qw(Exporter);
@EXPORT_OK = qw(connectdb req_in add_transaction get_queue update_each_req
		transaction_history_in add_request update_request transaction_in
		update_seq);

# #10033757: find_descr() braucht eine Datenbankverbindung,
# die wir beim Syntaxcheck nicht haben
my $pwuse_pop = $ENV{'TESTING'} ? undef : find_descr( pwdomain => pop => 1 );

sub req_in($;$);
# predeclare because of hack in support::utils

use RT::support::utils qw(
  can_display_request
  can_manipulate_request
  date_diff
  date_diff_l
  get_effective_sn
  is_owner
  is_rt_system
  list_sn
  normalize_sn
);
use RT::database::config;
use RT::support::mail qw(template_mail);
use RT::AddOns ();

use vars qw(%queues %users $time %req);

sub update_request($$$$);

BEGIN {
	*queues = \%RT::queues;
	*users = \%RT::users;
	*time = \$RT::time;
	*req = \%RT::req;
}

sub connectdb {
	### nicht benötigt
}

#
# Database routines for loading/storing transactions and requests
#

sub add_request($$$$$$$$$$$$$$) {
    my($id,$in_queue_id, $in_area, $in_requestors, $in_owner,
       $in_subject, $in_info, $in_priority, $in_status,
       $in_date_created, $in_date_told, $in_date_fdue, $in_date_due, $user) = @_;
    my($query_string, $serial);

    $in_priority = 0 unless $in_priority;
    $in_date_due = "NULL" unless $in_date_due;
    $in_date_fdue = "NULL" unless $in_date_fdue;
    $in_date_told = 0 unless $in_date_told;
    $in_date_created = 0 unless $in_date_created;
    $in_priority = 0 unless $in_priority;

	# use Data::Dumper;
	# print STDERR "in_status neu ist '$in_status'\nQueue ist '$in_queue_id'\n".Dumper(\%queues,\%users);

    $in_queue_id = $queues{$in_queue_id}{id};
    $in_owner = get_person($in_owner) || 0;
    $_ = text_only($_) for $in_info, $in_subject;
    $in_subject = substr($in_subject, 0, 244) . ' [...]' if length $in_subject > 250;
    defined( $in_status = find_descr("tickets",$in_status) )
      or $in_status = find_descr( tickets => open => 1 );

    $user = $users{$user}{user_id} if defined $user;
	$user = DoFn("select defbearb from queue where id = $in_queue_id") unless $user;
	$user = 0 unless defined $user;

    $serial = $id||DoSeq("ticket") or die "Keine SEQ ticket!\n";

	my $kunde;
	if(defined $in_requestors) {
		foreach my $req (split(/,\s*/,$in_requestors)) {
			$kunde = find_kunde_by_mail($req);
			#print STDERR "Kunde ist '$kunde' nach Check '$req'\n";
			last if $kunde;
		}
	}
	$kunde = 1 unless $kunde;
	$in_subject = "(kein Subject)" unless defined $in_subject;
	$in_date_created = $time if $in_date_created == 0;

	DoTrans {
		my $in_queue_area = (content($in_area) and $in_area ne "-" and $in_area ne "--")
			&& DoFn("select id from queue_areas where
				queue=$in_queue_id and name=${\qquote $in_area}")
			|| "NULL";
    	Do <<_;
			INSERT INTO ticket set
				id=$serial,
				queue=$in_queue_id,
				queue_area=$in_queue_area,
				subject=${\qquote $in_subject},
				infotext=${\qquote $in_info,3},
				status=$in_status,
				bearbeiter=NULL,
				wichtig=$in_priority,
				beginn=$in_date_created,
				d_told=$in_date_told,
				d_acted=$in_date_created,
				endtermin=$in_date_fdue,
				termin=$in_date_due,
				kunde=$kunde,
				maxseq=0
_
		Do "update ticket set ticket=$serial where id=$serial";
		update_request($serial,'owner',$in_owner, $user) if $in_owner;
	};

	if(defined $in_requestors and $in_requestors ne "") {
		foreach my $req (split(/,\s*/,$in_requestors)) {
			my $rep = ticket_has_mail( $serial, $req, 0, 2 | 8 | 16 );
			if(!defined $rep) { print STDERR "???    "; }
			if($rep == 0    ) { next; }
			if($rep == 1    ) { print STDERR "Update "; }
			if($rep == 2    ) { next; }
			# print STDERR ": ".mpersinfo($pp)."\n";
		}
	}
    return $serial;
}


sub add_transaction($$$$$$;$$$$) {
    my ($serial, $in_actor, $in_type, $in_data, $in_content, $user, $in_do_mail,$time_in_text,$via_mail,$in_extern) = @_;
    $in_extern = $in_extern && lc $in_extern ne 'n' ? 'y' : 'n';

    my ($transaction_num, $query_string, $queue_id, $owner, $requestors);
	my ($in_actor_person,$in_actor_email);
	$in_do_mail = 1 unless defined $in_do_mail;

    $in_content =~ s/\r//g;
	$in_content =~ s/\n*$/\n/s;
	if (   !$in_actor
		|| $in_actor eq '-'
		|| $in_actor eq '--'
		|| is_rt_system($in_actor) )
	{
    	$in_actor_person = "NULL";
	$in_actor_email =
	  defined $in_actor
	  && $in_actor =~ /\@/ ? $in_actor : undef;    # Hack für RT#380296
    	$in_actor = "NULL";
	} else {
    	$in_actor_person = get_person($in_actor);
		if(defined $in_actor_person) {
			$in_actor = $in_actor_person;
			$in_actor_email = DoFn("select email from person where id=$in_actor_person");
		} else {
    		$in_actor_person = "NULL";
    		$in_actor_email = $in_actor;
		}
	}
    $in_type = find_descr("tickett",$in_type) || 0;
    my $sub_type = find_descr("tickett","subscription") || 0;
	$in_data =~ s/\n//g if defined $in_data;
	my $msgid;
	if($in_content =~ /^Message-ID:\s+<(.+)>\s*$/mi) {
		$msgid = $1;
		$msgid = "" if DoFn("select ticket from ticketid where id=${\qquote $msgid}");
	}
    req_in($serial, '_rt_system');
    $queue_id=$req{$serial}{queue_id};
    $requestors=$req{$serial}{requestors};
    $owner=$req{$serial}{owner};
    req_in($serial, $user);

	DoTrans {
		# mysql bug workaround
		DoFn("select count(*) from ticketid where ticket = $serial for update");
		my $nextseq=DoFn("select max(seq) from ticketid where ticket = $serial for update") || 0;
		$nextseq++;
		$msgid = "$serial-$nextseq\@ticket.$MAILDOM" unless $msgid;

		# Workaround: beim Unsubscribe wird "-" als normaler Parameter verwendet
		my $dd2 = qquote($in_data, ($in_type == $sub_type) ? 2 : 3);

		Do <<_;
			insert into ticketid set
				id=${\qquote $msgid},
				ticket=$serial,
				seq=$nextseq,
				person=$in_actor_person,
				email=${\qquote $in_actor_email,1},
				typ=$in_type,
				extern=${\qquote $in_extern},
				data=$dd2;
_
		DoBinary {
			Do <<_;
				update ticketid
				set inhalt=${\qquote($in_content)}
				where ticket=$serial
			  	and seq=$nextseq;
_
		};
		$transaction_num = [$serial,$nextseq];

		Do("update ticket set maxseq = $nextseq, d_acted = $time where id = $serial");

		## das sollte eigentlich nicht mehr passieren können,
		##  aber sicherheitshalber...
		{
			my $eff=normalize_sn($serial);
			Do("update ticket set d_acted = $time where id = $eff") if $eff != $serial;
		}
		if($in_type == find_descr("tickett","subject")) {
			## ignoriere diese Änderungen

			my $oldseq = $nextseq-1;
			DoN("update writeonce ticketlast set seq=$nextseq where ticket = $serial and seq = $oldseq");
		}

	};

	if($in_actor_person ne "NULL") {
		$in_actor = kkpersinfo($in_actor_person);
	} elsif(defined $in_actor_email and $in_actor_email ne "NULL") {
		$in_actor = $in_actor_email;
	} else {
		$in_actor = "??";
	}
	# print STDERR "Q $queue_id: ".$queues{$queue_id}."\n";
	if ($in_do_mail and ($queues{$queue_id}{m_mail} or not $via_mail)) {
		if (not is_owner($serial,$user) and $owner and ($queues{$queue_id}{m_owner_trans})){
			template_mail ('transaction',$queue_id,$users{$owner}{email},"","", $serial ,$transaction_num,"Transaction ($in_actor)", $user,'');
		}
		if ($queues{$queue_id}{m_members_trans}) {
			template_mail ('transaction',$queue_id,$queues{$queue_id}{dist_list},"","", $serial, $transaction_num, "Transaction ($in_actor)", $user,'');
		} elsif ($queues{$queue_id}{m_admin_trans}) {
			template_mail ('transaction',$queue_id,$queues{$queue_id}{adist_list},"","", $serial, $transaction_num,"Transaction ($in_actor)", $user,'');
		}
		if ($queues{$queue_id}{m_user_trans}) {
			template_mail ('transaction',$queue_id,$requestors,"","", $serial ,$transaction_num, "Transaction ($in_actor)", $user,'');
		}
	}
	template_mail (subscription => $queue_id, join( ',', keys %{$req{$serial}{subscribers}} ), '', '', $serial, $transaction_num, '', $user, '')
		if keys %{$req{$serial}{subscribers}};
	my $sn = normalize_sn($serial);
	Do("delete writeonce from ticketlast where ticket = $sn and seq < 9999") if $sn != $serial;

    return $transaction_num;
}

sub update_each_req($$$) {
    my ($serial, $in_field, $in_new_value) = @_;
    my $query_string;

    # if we're not actually changing the field, just abort 
    return "$in_field: unchanged"
    	if $req{$serial}{$in_field} ? $in_new_value && $req{$serial}{$in_field} eq $in_new_value
	                              : !$in_new_value;

    #set the field in the database
	my($field, $value);

	my $in_new_val = $in_new_value; $in_new_val =~ s/\n//g;
	if($in_field eq "queue_id") {
		$field = "queue"; $value = $queues{$in_new_value}{id} || 0;
	} elsif($in_field eq "area") {
		$field = "queue_area"; $value = (defined $in_new_value) && DoFn("select id from queue_areas where name=${\qquote $in_new_value} and queue=".$req{$serial}{queue_id}) || "NULL";
	} elsif($in_field eq "work") {
		$field = 'zeit';
		if($in_new_value ne "-") {
			( $value = int($in_new_value*3600) ) <= 0 and $value = 'NULL';
		} else {
			$value = "NULL";
		}
	} elsif($in_field eq "requestors") {
		# Hmmm... na gut
		Do("update ticketadr set marker = 'q' where ticket = $serial and marker = 'x'");
		foreach my $req(split(/,\s*/,$in_new_value)) {
			ticket_has_mail( $serial, $req, 0, 1 | 2 | 8 | 16 );
		}
		Do("delete from ticketadr where ticket = $serial and marker = 'q'");
		DoSeq("rtmupdate");
		$RT::reqcache{$serial} = undef;

		return 0;
	} elsif($in_field eq "owner") {
		$field = "bearbeiter";
		if($in_new_value eq "" or $in_new_value eq "--") {
			$value = "NULL";
		} else {
			$value = get_person($in_new_value);
			return "Person '$in_new_value' unknown!" unless defined $value;
		}
	} elsif($in_field eq "subject") {
		$field = 'subject';
		$value = qquote( text_only($in_new_val) );
	} elsif($in_field eq "info") {
		$field = 'infotext';
		$value = qquote( text_only($in_new_val), 3 );
	} elsif($in_field eq "kunde") {
		$field = "kunde"; $value = get_kunde($in_new_value);
		return "Kunde '$in_new_value' unknown!" unless $value;
	} elsif($in_field eq "priority") {
		$field = "wichtig"; $value = $in_new_value;
	} elsif($in_field eq "status") {
		$field = "status"; $value = find_descr("tickets",$in_new_value);
	} elsif($in_field eq "date_created") {
		$field = "beginn"; $value = $in_new_value;
	} elsif($in_field eq "date_told") {
		$field = "d_told"; $value = $in_new_value;
	} elsif($in_field eq "date_acted") {
		$field = "d_acted"; $value = $in_new_value;
	} elsif($in_field eq "date_due") {
		$field = "termin"; $value = $in_new_value || "NULL";
	} elsif($in_field eq "date_fdue") {
		$field = "endtermin"; $value = $in_new_value || "NULL";
	} else {
		return "Update '$in_field': Unknown!";
	}
	$value = 'NULL' unless defined $value;
	Do("UPDATE ticket SET $field=$value WHERE id = $serial");
	$req{$serial}=undef; # erzwinge neues Einlesen
    return 0;
}

sub update_request($$$$) {
    my($serial, $in_variable, $in_new_value, $user) = @_;

    my $effective_sn=normalize_sn($serial);
	if (   is_rt_system($user)
		|| can_manipulate_request( $effective_sn, $user ) > 0 )
	{
		if( $in_variable eq 'effective_sn' )
		{
			update_each_req($effective_sn, 'date_acted', $time);        #make now the last acted time
			my $transaction_num=add_transaction($effective_sn, $user, $in_variable,$in_new_value,'',$user);
			return $transaction_num;
		}
		my $res = update_each_req($effective_sn, $in_variable, $in_new_value);
		return $res if $res;
		update_each_req($effective_sn, 'date_acted', $time);

		## Löschen wird nicht geloggt, weil das nie von Hand passiert
		return "Due date cleared" if $in_variable eq "date_due" && !$in_new_value;

		# make now the last acted time, ignore errors

		my $transaction_num = add_transaction($effective_sn, $user, $in_variable,$in_new_value || "--",'',$user);

		undef $req{$effective_sn}; undef $req{$serial};
		req_in($serial,"_rt_system");
		return $transaction_num;
	} else {
		return 0;
    }
}

sub update_seq($$$$) {
    my($serial, $seq, $extern, $user) = @_;
    my $effective_sn = normalize_sn($serial);
    if ( ( my $old_extern = DoFn "SELECT extern FROM ticketid WHERE ticket = $serial AND seq = $seq" ) eq $extern ) {
        return "Visibility of #$serial-$seq unchanged";
    }
    Do "UPDATE ticketid SET extern=${\qquote $extern}, timestamp=timestamp WHERE ticket=$serial AND seq=$seq"
      or return "Updating visibility of #$serial-$seq failed";
    my $transaction_num = add_transaction($effective_sn, $user, 'visibility', "$serial-$seq:$extern", '', $user);
    undef $req{$_} for $effective_sn, $serial;
    $transaction_num;
}

sub transaction_history_in($$) {
    my ($in_serial,$user) = @_;
    my $counter = 0;

#	Dbase::timer_start();
    
    #print "reading trans history\n";
    my $serial = normalize_sn($in_serial);
    my $esn = join(" or ticket = ",list_sn($serial));
	unless($esn) {
		warn "list_sn($serial)=0";
		$esn = $serial;
	}
	my @data;
	DoSelect {
		push @data, [ @_ ];
	} "SELECT ticket,seq, person,email,timestamp, typ,data, extern from ticketid WHERE ( ticket = $esn ) and seq > 0 ORDER BY timestamp,seq";

	my $res = DoBinary { DoSelect {
		my $result = parse_transaction_row($serial, $user, @_, @{shift @data});
		$req{$serial}{trans}[$counter++] = $result if ref $result;
		$req{$in_serial} = $req{$serial} if $in_serial != $serial;
	} "SELECT inhalt from ticketid WHERE ( ticket = $esn ) and seq > 0 ORDER BY timestamp,seq"; };

    # warn "Query11 had some problem: $res\n" if $res == 0 and $res ne "empty";
	# print STDERR ">>> Current: $user\n";
    # print STDERR Dumper(\%queues, \%users, \@req);

#	my($s,$t)=Dbase::timer_stop();
#	printf STDERR "%.04f sec %2.1f%% %s\n",
#		$t,100*$t/$s, "trans_hist_in $in_serial $user" if $s;

    return $counter;
}

sub transaction_in($$) {
    my ($trans, $user) = @_;
    my ($query_string);
	return undef if not $trans or not @$trans;
    my $ticket = $trans->[0]; my $seq = $trans->[1];
    my $serial = normalize_sn($ticket);

#	Dbase::timer_start();

    my $result;
	my $content = DoBinary { DoFn ("select inhalt from ticketid WHERE ticket = $ticket and seq = $seq"); };
    my $res = DoSelect {
		$result = parse_transaction_row($serial, $user, $content, @_);
    } "SELECT ticket,seq, person,email,timestamp, typ,data, extern from ticketid WHERE ticket = $ticket and seq = $seq";
	# print STDERR ">>> Current: $user, $trans, seq $seq\n";
    # print STDERR Dumper(\%queues, \%users, \@req);

#	my($s,$t)=Dbase::timer_stop();
#	printf STDERR "%.04f sec %2.1f%% %s\n",
#		$t,100*$t/$s, "trans_in $trans $user" if $s;

    return $result;
}

{
	my %flag;
	my ($grs, $grc);
	unless($ENV{TESTING}) {
		($grs, $grc) = get_gruppen tickett_ident => 'addon';
	}
	sub is_addon_flag($) {
		my($bit) = @_;
		return $flag{$bit} if exists $flag{$bit};
		$flag{$bit} = test_gruppe tickett => $bit, $grs, $grc;
	}
}

sub parse_transaction_row($$$@) {
    my ($serial, $user, $inhalt, $ticket,$seq,$pers,$email,$added,$typ,$data,$extern) = @_;
	# print STDERR ">>> Read: ".join(":",$in_id, $user, $ticket,$seq,$sender,$added,$typ,$data,"#".length($inhalt))."\n";
    my ($success,$content);
    my %trans;

    $trans{id}	  =	[$ticket,$seq];
    $trans{serial_num}  =	$ticket;
    $trans{seq}  =	$seq;
    $trans{effective_sn}=	$serial;
	my($ls,$sender);
	if(defined $pers) {
		$ls = mpersinfo($pers);
		$sender = kkpersinfo($pers);
	} elsif(defined $email) {
		$ls = $sender = $email;
	} else {
		$ls = $sender = "--";
	}

	$trans{actor}	  =	$sender || "<unbekannt>";
	$trans{actor_long}	  =	$ls || "<unbekannt>";
	$trans{type}	  =	(defined $typ) ? get_descr("tickett",$typ) || "UNKNOWN $typ" : "UNKNOWN $ticket-$seq";
	$trans{data} 	  =	$data;
	$trans{time}	  =	unixtime($added);
	$trans{text_time}= isotime($added);
	$trans{content} = $inhalt;
	if ( defined $typ && is_addon_flag $typ ) {
		$trans{text_en} =
		$trans{text   } = RT::AddOns->call( $trans{type} => transaction_text => @trans{qw(data content)} ) . " von $trans{actor}";
	} else {
		$trans{text   } = transaction_text($ticket, $seq, \%trans);
		$trans{text_en} = transaction_text_en($ticket, $seq, \%trans);
	}
	$trans{extern} = $extern;
	\%trans;
}

sub transaction_text($$$) {
    my ($serial_num,$index,$trans) = @_;
    if ($trans->{type} eq 'create'){
		"Ticket #$serial_num von $trans->{actor}";
    } elsif ($trans->{type} eq 'correspond')    {
		"Mail von $trans->{actor}";
    } elsif ($trans->{type} eq 'comments')  {
		"Kommentar von $trans->{actor}";
    } elsif ($trans->{type} eq 'area')  {
		my $to = $trans->{data};
		$to = 'none' unless $to;
		"Bereich geändert zu $to von $trans->{actor}";
    } elsif ($trans->{type} eq 'status'){
		if ($trans->{data} eq 'dead') {
	    	"Ticket gelöscht von $trans->{actor}";
		} else {
	    	"Status auf '$trans->{data}' gesetzt von $trans->{actor}";
		}
    } elsif ($trans->{type} eq 'queue_id'){
		"Queue geändert auf $trans->{data} von $trans->{actor}";
    } elsif ($trans->{type} eq 'work'){
		'Plan-Zeit ' . ( $trans->{data} ? "geändert auf $trans->{data}" : 'gelöscht' ) . " von $trans->{actor}";
    } elsif ($trans->{type} eq 'docushare'){
		"Link zu DocuShare #$trans->{data} von $trans->{actor}";
    } elsif ($trans->{type} eq 'remail'){
		"Text $trans->{content} gesendet an $trans->{data} von $trans->{actor}";
    } elsif ($trans->{type} eq 'queue_ptr'){
		my $qn = $trans->{data};
		$qn = $queues{lc $qn} if $qn ne "";
		$qn = $qn->{name} if ref $qn;
		$qn = "?? ".$trans->{data} unless defined $qn;
		if ($trans->{seq} < $trans->{content}) {
			"Ticket $trans->{content} aus Queue $qn";
		} else {
			"Ticket $trans->{content} in Queue $qn created von $trans->{actor}";
		}
    } elsif ($trans->{type} eq 'owner'){
		if ($trans->{data} eq $trans->{actor}){
	    	"Genommen von $trans->{actor}";
		} elsif ($trans->{data} eq ''){
	    	"Freigegeben von $trans->{actor}";
		} else {
	    	"Bearbeiter auf $trans->{data} geändert von $trans->{actor}";
		}
    }
    elsif ($trans->{type} eq 'requestors'){
		"Empfängerliste auf '$trans->{data}' gesetzt von $trans->{actor}";
    } elsif ($trans->{type} eq 'priority') {
		"Priorität geändert auf $trans->{data} von $trans->{actor}";
    } elsif ($trans->{type} eq 'final_priority') {
		"End-Priorität geändert auf $trans->{data} von $trans->{actor}";
    } elsif ($trans->{type} eq 'date_due') {  
		"Wiedervorlagedatum geändert auf ".isotime($trans->{data}||0)." von $trans->{actor}";
    } elsif ($trans->{type} eq 'date_fdue') {  
		'Fälligkeitsdatum '
		. ( $trans->{data} eq '--' ? 'gelöscht' : 'geändert auf '.isotime($trans->{data}) )
		." von $trans->{actor}";
    } elsif ($trans->{type} eq 'subject') {
		"Titel geändert zu '$trans->{data}' von $trans->{actor}";
    } elsif ($trans->{type} eq 'info') {
		"Status geändert zu '$trans->{data}' von $trans->{actor}";
    } elsif ($trans->{type} eq 'kunde') {
		"Kunde geändert auf '$trans->{data}' von $trans->{actor}";
    } elsif ($trans->{type} eq 'date_told') {
		"Benachrichtigung von $trans->{actor}";
    } elsif ($trans->{type} eq 'effective_sn') {
		"Ticket $trans->{serial_num} wurde mit Ticket $trans->{data} verbunden von $trans->{actor}";
    } elsif ($trans->{type} eq 'visibility' and my($ticket_seq, $extern) = $trans->{data} =~ /^(\d+-\d+):(.)$/ ) {
		"Eintrag #$ticket_seq für den Kunden ".( lc $extern ne 'y' && 'un' )."sichtbar gemacht von $trans->{actor}";
    } elsif ( $trans->{type} eq 'subscription' && $trans->{data} eq '+' ) {
		"$trans->{actor} hat das Ticket abonniert.";
    } elsif ( $trans->{type} eq 'subscription' && (not defined $trans->{data} or $trans->{data} eq '-' )) {
		"$trans->{actor} hat das Ticket-Abo beendet.";
    } else {
		"RT Typ '$trans->{type}' modifiziert ($trans->{data}). XXX internes Problem!";
    }
}

sub transaction_text_en($$$) {
    my ($serial_num,$index,$trans) = @_;
    if ($trans->{type} eq 'create'){
		"Request #$serial_num created by $trans->{actor}";
    } elsif ($trans->{type} eq 'correspond')    {
		"Mail sent by $trans->{actor}";
    } elsif ($trans->{type} eq 'comments')  {
		"Comments added by $trans->{actor}";
    } elsif ($trans->{type} eq 'area')  {
		my $to = $trans->{data};
		$to = 'none' unless $to;
		"Area changed to $to by $trans->{actor}";
    } elsif ($trans->{type} eq 'status'){
		if ($trans->{data} eq 'dead') {
	    	"Request killed by $trans->{actor}";
		} else {
	    	"Status changed to $trans->{data} by $trans->{actor}";
		}
    } elsif ($trans->{type} eq 'queue_id'){
		"Queue changed to $trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'work'){
		'Scheduled work time ' . ( $trans->{data} ? "set to $trans->{data}" : 'deleted' ) . " by $trans->{actor}";
    } elsif ($trans->{type} eq 'docushare'){
		"Linked to DocuShare #$trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'remail'){
		"Re-Mailed $trans->{content} to $trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'queue_ptr'){
		my $qn = $trans->{data};
		$qn = $queues{lc $qn} if $qn ne "";
		$qn = $qn->{name} if ref $qn;
		$qn = "?? ".$trans->{data} unless defined $qn;
		if ($trans->{seq} < $trans->{content}) {
			"Request $trans->{content} from queue $qn";
		} else {
			"Request $trans->{content} in queue $qn created by $trans->{actor}";
		}
    } elsif ($trans->{type} eq 'owner'){
		if ($trans->{data} eq $trans->{actor}){
	    	"Taken by $trans->{actor}";
		} elsif ($trans->{data} eq ''){
	    	"Untaken by $trans->{actor}";
		} else {
	    	"Owner changed to $trans->{data} by $trans->{actor}";
		}
    }
    elsif ($trans->{type} eq 'requestors'){
		"Requestor changed to $trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'priority') {
		"Priority changed to $trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'final_priority') {
		"Final Priority changed to $trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'date_due') {  
		"Re-Open Date changed to ".isotime($trans->{data}||0)." by $trans->{actor}";
    } elsif ($trans->{type} eq 'date_fdue') {  
		'Due Date '
		. ( $trans->{data} eq '--' ? 'deleted' : 'changed to '.isotime($trans->{data}) )
		." by $trans->{actor}";
    } elsif ($trans->{type} eq 'subject') {
		"Subject changed to '$trans->{data}' by $trans->{actor}";
    } elsif ($trans->{type} eq 'info') {
		"State changed to '$trans->{data}' by $trans->{actor}";
    } elsif ($trans->{type} eq 'kunde') {
		"Customer changed to '$trans->{data}' by $trans->{actor}";
    } elsif ($trans->{type} eq 'date_told') {
		"User notified by $trans->{actor}";
    } elsif ($trans->{type} eq 'effective_sn') {
		"Request $trans->{serial_num} merged into $trans->{data} by $trans->{actor}";
    } elsif ($trans->{type} eq 'visibility' and my($ticket_seq, $extern) = $trans->{data} =~ /^(\d+-\d+):(.)$/ ) {
		"Made #$ticket_seq ".( lc $extern ne 'y' && 'in' )."visible for the customer by $trans->{actor}";
    } elsif ( $trans->{type} eq 'subscription' && $trans->{data} eq '+' ) {
		"$trans->{actor} subscribed to this ticket.";
    } elsif ( $trans->{type} eq 'subscription' && (not defined $trans->{data} or $trans->{data} eq '-' )) {
		"$trans->{actor} unsubscribed from this ticket.";
    } else {
		"RT type '$trans->{type}' modified ($trans->{data}). XXX internal problem!";
    }
}

sub req_in($;$) { ## der User wird nicht gebraucht...
	my ($in_serial, $user) = @_;

	# Workaround für RT#293896:
	RT::support::utils->import('normalize_sn') unless defined &normalize_sn;
	my $serial = normalize_sn($in_serial);
	return undef unless $serial;
	if($req{$serial} and $req{$serial}{'queue_id'} and
			(not $req{$in_serial} or not $req{$serial}{'queue_id'})) {
		$req{$in_serial} = $req{$serial};
		return $req{$serial};
	}
	if($req{$serial} and $req{$serial}{'queue_id'}) {
		# print STDERR "Req 1: ",join(" ",caller(2)),"\n";
		return $req{$serial};
	}

#   Dbase::timer_start();

	my $res = DoSelect {
		parse_req_row($serial, $serial, @_, 0);
		$req{$in_serial} = $req{$serial} if $serial != $in_serial;
	} <<_;
	SELECT    MAX(ticketid.seq),
	          ticket.queue,
	          ticket.queue_area,
	          ticket.bearbeiter,
	          kunde.name,
	          ticket.subject,
	          ticket.infotext,
	          ticket.wichtig,
	          ticket.status,
	          ticket.beginn,
	          ticket.d_told,
	          ticket.d_acted,
	          IF(ticket.endtermin,ticket.endtermin,2147483647) ftermi,
	          IF(ticket.termin,   ticket.termin,   2147483647) termi,
	          kunde.kprio,
	          ticket.zeit,
	          kunde.id,
	          kunde.ap_vertrieb,
	          kunde.ap_technik
	FROM      ticket
	LEFT JOIN kunde    ON kunde.id = ticket.kunde
	LEFT JOIN ticketid ON ticketid.ticket = ticket.id
	WHERE     ticket.id = $serial
	GROUP BY  ticket.id
_
#	warn "Query12 had some problem: $res\n" if $res ne "empty" and $res == 0;

#	my($s,$t)=Dbase::timer_stop();
#	printf STDERR "%.04f sec %2.1f%% %s\n",
#		$t,100*$t/$s, "req_in $in_serial $user" if $s;
	$req{$serial};
}


sub get_queue($$;$$$) {
    my ($in_criteria,$user,$add_from,$joins,$flags) =@_;
    my %temp;
	my @temp;
	my $pos = 0;
	$add_from = "" unless defined $add_from;
	$joins    = '' unless defined $joins;
    
#	Dbase::timer_start();

    my $res = DoSelect {
		# we don't want to include reqs that have been merged.

		my $ticket = parse_req_row(0,@_);
		if($req{$ticket}{status}) {
			$temp{$ticket} = $pos;
			push(@temp,$ticket);
			$pos++;
		}
    } <<_;
	SELECT DISTINCT
	          ticket.id,
	          MAX(ticketid.seq),
	          ticket.queue,
	          ticket.queue_area,
	          ticket.bearbeiter,
	          kunde.name,
	          ticket.subject,
	          ticket.infotext,
	          ticket.wichtig,
	          ticket.status,
	          ticket.beginn,
	          ticket.d_told,
	          ticket.d_acted,
	          IF(ticket.endtermin,ticket.endtermin,2147483647) ftermi,
	          IF(ticket.termin,ticket.termin,2147483647) termi,
	          kunde.kprio,
	          ticket.zeit,kunde.id,
	          kunde.ap_vertrieb,
	          kunde.ap_technik
	FROM      ( ticket$add_from )
$joins	LEFT JOIN kunde    ON kunde.id        = ticket.kunde
	LEFT JOIN ticketid ON ticketid.ticket = ticket.id
	WHERE     ticket.id = ticket.ticket
	      AND ticket.status >= 0
	      AND $in_criteria
_

#	my($s,$t)=Dbase::timer_stop();
#	printf STDERR "%.04f sec %2.1f%% %s\n",
#		$t,100*$t/$s, "get_queue $user" if $s;

	$pos = 0;
    # warn "Query13 had some problem: $res\n" if $res ne "empty" and $res == 0;
    foreach my $ticket(keys %temp) {
	    my $esn = $req{$ticket}{effective_sn};
	    if($esn != $ticket and $esn > 0) {
	        delete $temp{$ticket};
			if(defined $temp{$esn}) {
				splice(@temp,$temp{$ticket},1);
				$pos++;
			} else {
	        	$temp{$esn} = $temp{$ticket};
	        	$temp[$temp{$esn}] = $esn;
	        	req_in($esn,$user);
			}
	    }
	}
    @temp;
}


sub parse_req_row {
    my ($serial,$id,$maxseq, $queue,$area,$bearbeiter,$kunde,$titel,$info,$wichtig,$status,$beginn,$d_told,$d_acted,$endtermin,$termin,$kprio,$tzeit,$kid,$sales,$tech) = @_;

	$serial ||= normalize_sn($id);
    $area = DoFn("select name from queue_areas where id=$area")
		if defined $area;
	$termin = 0 if $termin == 2147483647;
	$endtermin = 0 if $endtermin == 2147483647;
	$maxseq = 0 unless $maxseq;

    unless(ref $req{$id}{trans}) {
		my @foo;
		$req{$id}{trans} = \@foo;
	}
    $req{$id}{serial_num}		= $id;
    $req{$id}{seq}		= $maxseq;
    $req{$id}{kprio}		= $kprio;
    # $req{$id}{relevanz}		= $rel;
    $req{$id}{effective_sn}       	= $serial;
    $req{$id}{queue_id}	    = $queue;
    $req{$id}{queue}	    = $queues{lc $queue};

    $bearbeiter = kkpersinfo($bearbeiter);

    $RT::stdcache{$serial} = [ time4ticket($serial) ]
      unless exists $RT::stdcache{$serial};
    @{ $req{$id} }{qw(zeit_ohne_faktor zeit_mit_faktor)} =
      @{ $RT::stdcache{$serial} };

    my $requestors = $RT::reqcache{$id};
    if(defined $requestors) {
	    # print STDERR "getREQ $id $requestors\n";
	} else {
		DoSelect {
			my($person,$adr) = @_;
			$requestors .= ", " if $requestors;
			if($person) {
				$requestors .= kkpersinfo($person);
			} else {
				$requestors .= $adr;
			}
		} "select person,email from ticketadr where ticket=$id and marker='x'";
		$RT::reqcache{$id} = $requestors;
	}
	{
		my %subscribers;
		DoSelect {
			my ( $person_id, $username ) = @_;
			$subscribers{$username} = $person_id;
		} <<_;
	SELECT person.id, person.user
	FROM   person, ticketabo
	WHERE  person.id        = ticketabo.person
	   AND ticketabo.ticket = $id
	   AND person.pwuse & (1<<$pwuse_pop)
_
		$req{$id}{subscribers} = \%subscribers;
	}
    $req{$id}{t_zeit}           = $tzeit;
    $req{$id}{area}            = $area;
    $req{$id}{requestors}	= $requestors;
    $req{$id}{owner}		= $bearbeiter;
    $req{$id}{subject}	       	= $titel;
    $req{$id}{info}	       	= $info;
    $req{$id}{kunde}	       	= $kunde;
    $req{$id}{kunde_id}	       	= $kid;
	$req{$id}{tech_p} = $tech;
	$req{$id}{sales_p} = $sales;
    $req{$id}{initial_priority}= 0;
    $req{$id}{priority}        = $wichtig;
    $req{$id}{status}	       	= $status ? get_descr("tickets",$status) : "unbekannt";
    $req{$id}{date_created}	= $beginn;
    $req{$id}{date_told}      	= $d_told;
    $req{$id}{date_acted}	= $d_acted;
    $req{$id}{date_due}	= $termin;
    $req{$id}{date_fdue}	= $endtermin;
    $req{$id}{age}=date_diff($beginn, $time);
    $req{$id}{age_l}=date_diff_l($beginn, $time);
    if ($d_told > 0) {
		$req{$id}{since_told}=date_diff($d_told, $time);	
		$req{$id}{since_told_l}=date_diff_l($d_told, $time);	
    } else {
		$req{$id}{since_told}="never";
		$req{$id}{since_told_l}="never";
    }
    if ($d_acted > 0) {
		$req{$id}{since_acted}=date_diff($d_acted, $time);	
		$req{$id}{since_acted_l}=date_diff_l($d_acted, $time);	
    } else {
		$req{$id}{since_acted}="never";
		$req{$id}{since_acted_l}="never";
	}
    if ($termin > 0) {
		$req{$id}{till_due}=date_diff($time, $termin);
		$req{$id}{till_due_l}=date_diff_l($time, $termin);
    } else {
		$req{$id}{till_due}="";
		$req{$id}{till_due_l}="";
    }
    if ($endtermin > 0) {
		$req{$id}{till_fdue}=date_diff($time, $endtermin);
		$req{$id}{till_fdue_l}=date_diff_l($time, $endtermin);
    } else {
		$req{$id}{till_fdue}="";
		$req{$id}{till_fdue_l}="";
    }
    $id;
}

1;
