package RT::I18N;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;

use base 'Exporter';
our @EXPORT_OK = qw(english_preferred);

use constant DEFAULT => 1;

{
	my %known;

	sub english_preferred() {
		defined( my $al = $ENV{HTTP_ACCEPT_LANGUAGE} ) or return DEFAULT;
		return $known{$al} if exists $known{$al};
		my %q;
		for ( split /\s*,\s*/, $al ) {
			my ( $lang, $sub ) = /^(de|en)\b(-)?/ or next;
			my $q = s/\s*;\s*q=(\d+(?:\.\d{0,3}))// ? $1 : 1;
			$q{$lang} = $q unless defined $q{$lang};
		}
		$known{$al} = defined $q{de}
		              ? defined $q{en} && ( $q{en} == $q{de} ? DEFAULT : $q{en} > $q{de} )
		              : defined $q{en} ? 1 : DEFAULT;
	}
}

1;
