package RT::AddOn::Troubleticket;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use base 'RT::AddOn';

use Dbase::Help qw(DoFn);

our %all_queues = ( resolvable => 1 );

sub resolvable($$) {
	my ( $package, $req ) = @_;
	( my $rtticket = DoFn(<<_) ) or return;
	SELECT   IF(trouble_ticket.text_resolve IS NULL, trouble_ticket.rtticket, NULL)
	FROM     ticket, trouble_ticket
	WHERE    ticket.id     = trouble_ticket.rtticket
	     AND ticket.ticket = $req->{serial_num}
	ORDER BY trouble_ticket.id DESC
	LIMIT    1
_
"Das Ticket darf erst geschlossen werden, wenn das zugehörige Trouble-Ticket #$rtticket geschlossen ist.";
}

1;
