package RT::AddOn::Show_similar;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use base 'RT::AddOn';

use Dbase::Help qw(DoSelect);
use RT::ui::web::support qw(req_url);

use constant MAX_TICKETS => 3;

sub show_form {
	my ( $package, $req, $request ) = @_;
	( my $serial = $req->{serial_num} ) =~ /^\d+\z/ or die;

	my @tickets;
	DoSelect {
		push @tickets, { id => shift, beginn => shift, bearbeiter => shift };
	}
	<<_
	SELECT    aehnliches_ticket.id,
	          DATE_FORMAT(FROM_UNIXTIME(aehnliches_ticket.beginn), '%Y-%m-%d %H:%i'),
	          person.user
	FROM      ( ticket, ticket aehnliches_ticket )
	LEFT JOIN person ON person.id = aehnliches_ticket.bearbeiter
	WHERE     ticket.id             = $serial
	      AND ticket.id             > aehnliches_ticket.id
	      AND ticket.queue          = aehnliches_ticket.queue
	      AND ticket.subject        = aehnliches_ticket.subject
	      AND aehnliches_ticket.id  = aehnliches_ticket.ticket
	ORDER BY  aehnliches_ticket.beginn DESC
	LIMIT     ${\( MAX_TICKETS + 1 )}
_
	  or return;

	my $even_more;
	$even_more = pop @tickets if @tickets > MAX_TICKETS;

	require RT::CGI4AddOn;
	my $cgi = RT::CGI4AddOn->new;
	print $cgi->table(
		{
			bgcolor     => '#ccffcc',
			border      => 1,
			cellpadding => 4,
			cellspacing => 0,
		},
		$cgi->Tr(
			[
				$cgi->th(
					{ colspan => 3 },
					( $even_more ? 'n&auml;chst' : '' )
					  . '&auml;ltere'
					  . ( @tickets == 1 ? 's Ticket' : ' Tickets' )
					  . ' mit gleichem Subject in dieser Queue:'
				),
				map $cgi->td(
					$cgi->a(
						{
							href => req_url(
								$request,
								display    => 'History',
								serial_num => $_->{id},
							)
						},
						$_->{id}
					)
				  )
				  . $cgi->td( $_->{beginn} )
				  . $cgi->td( $_->{bearbeiter} || '-' ),
				@tickets
			]
		)
	  ),
	  $cgi->br;
}

1;
