use strict;
use utf8;
use warnings;

package noris::Ticket::API::SelectResult;

use Moose;
use noris::Ticket::API::OTRS::SelectResult;
use noris::Ticket::API::RT::SelectResult;

has 'results' => (
    is         => 'ro',
    isa        => 'ArrayRef',    # bei neuerem Moose evtl.: ArrayRef[Object]
    auto_deref => 1,
);

sub next {
    my ($self) = @_;
    my $results = $self->results;
    my $value;
    while (@$results) {
        defined( $value = $results->[0]->next ) and last;
        shift @$results;
    }

    noris::Ticket::API::_debug(
        result => sub {
		    return 'Ticket API found no more records.' unless defined $value;
            require Data::Dump and Data::Dump->import('pp') unless defined &pp;
            'From ' . ref( $results->[0] ) . ' backend: ' . pp($value);
        }
    );
    $value;
}

sub foreach_row {
    my ($self, $fn) = @_;
    my $row;
    while (defined($row = $self->next())) {
        $fn->(@$row);
    }
}

sub count {
    my ($self) = @_;
    my $count = 0;
    $count += $_->count() for $self->results;
    $count;
}

1;
