use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::Descr;

use Dbase::Globals qw(find_descr get_descr);
use Moose;

extends 'noris::Ticket::API::RT::Field::Standard';

has descr   => ( is => 'ro', isa => 'Str', required => 1 );


sub rt2api {
    my ( $self, $sql_value ) = @_;
    get_descr( $self->descr, $sql_value );
}

sub descr_names2ids {
    my $self  = shift;
    my $descr = $self->descr;
    map { find_descr( $descr, $_, 1 ) } @_;
}

sub where_in {
    my ( $self, @values ) = @_;
    $self->SUPER::where_in( $self->descr_names2ids(@values) );
}

sub where_not_in {
    my ( $self, @values ) = @_;
    $self->SUPER::where_not_in( $self->descr_names2ids(@values) );
}

1;
